/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features.structures;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.world.features.structures.AbstractMineshaftStructure;
import com.telepathicgrunt.repurposedstructures.world.features.structures.RSMineshaftPieces;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;

public class RSMineshaftEndStructure
extends AbstractMineshaftStructure {
    private static final List<Biome.SpawnListEntry> MONSTER_SPAWNS = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityType.field_200804_r, 10, 2, 5), new Biome.SpawnListEntry(EntityType.field_200803_q, 5, 1, 3)});

    public RSMineshaftEndStructure(Codec<NoFeatureConfig> config) {
        super(config);
    }

    @Override
    public double getProbability() {
        return RepurposedStructures.RSMineshaftsConfig.endMineshaftSpawnrate.get().intValue();
    }

    public List<Biome.SpawnListEntry> func_202279_e() {
        return MONSTER_SPAWNS;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    @Override
    protected boolean shouldStartAt(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int x, int z, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        chunkRandom.func_202425_c(seed, x, z);
        double d = this.getProbability() / 10000.0;
        int landHeight = chunkGenerator.func_222531_c(x, z, Heightmap.Type.WORLD_SURFACE_WG);
        return chunkRandom.nextDouble() < d && (RepurposedStructures.RSMineshaftsConfig.barrensIslandsEndMineshafts.get() != false || landHeight > 20);
    }

    public static class Start
    extends AbstractMineshaftStructure.AbstractStart {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        @Override
        public RSMineshaftPieces.Type getMineshaftType() {
            return RSMineshaftPieces.Type.END;
        }

        @Override
        public int getMaxHeight() {
            return RepurposedStructures.RSMineshaftsConfig.endMineshaftMaxHeight.get();
        }

        @Override
        public int getMinHeight() {
            return RepurposedStructures.RSMineshaftsConfig.endMineshaftMinHeight.get();
        }
    }
}

