/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.configs;

import me.sargunvohra.mcmods.autoconfig1u.ConfigData;
import me.sargunvohra.mcmods.autoconfig1u.annotation.Config;
import me.sargunvohra.mcmods.autoconfig1u.annotation.ConfigEntry;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.Comment;

@Config(name="Strongholds")
public class RSStrongholdsConfig
implements ConfigData {
    @ConfigEntry.Gui.Tooltip(count=4)
    @Comment(value="Size of average Stronghold as a percentage.\nNote: RS Stonghold is much larger by default.\nTo get closer to vanilla's size, enter 60 here.\n10 for supertiny and 2000 for supermassive Strongholds.")
    @ConfigEntry.BoundedDiscrete(min=10L, max=2000L)
    public double strongholdSizeSH = 100.0;
    @ConfigEntry.Gui.Tooltip(count=2)
    @Comment(value="Add Mob Spawners to rooms other than the Portal Room.\nNote: Spawners in Portal Room will always spawn.")
    public boolean allowExtraSpawnersSH = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Controls whether loot chests spawn or not in the Stronghold.")
    public boolean lootChestsSH = true;
    @ConfigEntry.Gui.CollapsibleObject
    public Stonebrick stonebrick = new Stonebrick();
    @ConfigEntry.Gui.CollapsibleObject
    public Nether nether = new Nether();

    public static class Nether {
        @ConfigEntry.Gui.Tooltip(count=3)
        @Comment(value="How rare are Nether-styled Strongholds in Nether-category biomes.\n1 for spawning in most chunks and 1001 for no spawn.\nNote: Eyes of Ender will work and show the closest Nether Stronghold too.")
        @ConfigEntry.BoundedDiscrete(min=1L, max=1001L)
        public int netherStrongholdSpawnrate = 85;
        @ConfigEntry.Gui.Tooltip(count=2)
        @Comment(value="Allow Nether-styled Stronghold to\ngenerate in modded Nether biomes.")
        public boolean addNetherStrongholdToModdedBiomes = false;
        @ConfigEntry.Gui.Tooltip(count=2)
        @Comment(value="Min Y height that the starting point can spawn at.\nDefault is 30.")
        @ConfigEntry.BoundedDiscrete(min=0L, max=255L)
        public int netherStrongholdMinHeight = 33;
        @ConfigEntry.Gui.Tooltip(count=3)
        @Comment(value="Max Y height that the starting point can spawn at.\nDefault is 35.\nIf below min height, this will be read as min.")
        @ConfigEntry.BoundedDiscrete(min=0L, max=255L)
        public int netherStrongholdMaxHeight = 36;
        @ConfigEntry.Gui.Tooltip(count=2)
        @Comment(value="How rare are Chains in this Stronghold. (Can have Soul Lantern attached)")
        @ConfigEntry.BoundedDiscrete(min=0L, max=1000L)
        public int netherStrongholdChainSpawnrate = 50;
    }

    public static class Stonebrick {
        @ConfigEntry.Gui.Tooltip(count=3)
        @Comment(value="Stonebrick-styled Stronghold replaces vanilla Strongholds\nin any biome. If off, vanilla Strongholds will generate\ninstead but Nether Strongholds will still be active.")
        public boolean allowStonebrickStronghold = true;
        @ConfigEntry.Gui.Tooltip(count=2)
        @Comment(value="Add Stonebrick-styled Stronghold to all modded non-Nether\nbiomes even if they have don't have vanilla Strongholds.")
        public boolean addStonebrickStrongholdToModdedBiomes = true;
        @ConfigEntry.Gui.Tooltip(count=3)
        @Comment(value="Percentage of Stonebrick-styled Strongholds is Silverfish Blocks.\nNote: Mossy Stone Bricks block cannot be infected by Silverfish.\n0 for no Silverfish Blocks and 100 for max spawnrate.")
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public double silverfishSpawnrateSH = 0.8;
        @ConfigEntry.Gui.Tooltip(count=2)
        @Comment(value="Min Y height that the starting point can spawn at.\nDefault is 0.")
        @ConfigEntry.BoundedDiscrete(min=0L, max=255L)
        public int stonebrickStrongholdMinHeight = 0;
        @ConfigEntry.Gui.Tooltip(count=3)
        @Comment(value="Max Y height that the starting point can spawn at.\nDefault is 50.\nIf below min height, this will be read as min.")
        @ConfigEntry.BoundedDiscrete(min=0L, max=255L)
        public int stonebrickStrongholdMaxHeight = 45;
        @ConfigEntry.Gui.Tooltip(count=2)
        @Comment(value="How rare are Stonebrick-styled Strongholds.\n1 for spawning in most chunks and 1001 for no spawn.")
        @ConfigEntry.BoundedDiscrete(min=1L, max=1001L)
        public int stonebrickStrongholdSpawnrate = 85;
        @ConfigEntry.Gui.Tooltip(count=2)
        @Comment(value="How rare are Chains in this Stronghold. (Can have Lantern attached)")
        @ConfigEntry.BoundedDiscrete(min=0L, max=1000L)
        public int stonebrickStrongholdChainSpawnrate = 35;
    }
}

