/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.utils.MobSpawnerObj;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.Level;

public class MobSpawnerManager
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private Map<class_2960, List<MobSpawnerObj>> spawnerMap = ImmutableMap.of();

    public MobSpawnerManager() {
        super(GSON, "rs_spawners");
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                List spawnerMobEntries = (List)GSON.fromJson(jsonElement.getAsJsonObject().get("mobs"), new TypeToken<List<MobSpawnerObj>>(){}.getType());
                for (MobSpawnerObj entry : spawnerMobEntries) {
                    entry.setEntityType();
                }
                builder.put(fileIdentifier, (Object)spawnerMobEntries);
            }
            catch (Exception e) {
                RepurposedStructures.LOGGER.error("Couldn't parse spawner mob list {}", fileIdentifier, (Object)e);
            }
        });
        this.spawnerMap = builder.build();
    }

    public class_1299<?> getSpawnerMob(class_2960 spawnerJsonEntry, Random random) {
        List<MobSpawnerObj> spawnerMobEntries = this.spawnerMap.get(spawnerJsonEntry);
        int totalWeight = spawnerMobEntries.stream().mapToInt(mobEntry -> mobEntry.weight).sum();
        int randomWeight = random.nextInt(totalWeight) + 1;
        int index = 0;
        while (randomWeight > 0) {
            if ((randomWeight -= spawnerMobEntries.get((int)index).weight) <= 0) {
                return (class_1299)class_2378.field_11145.method_10223(new class_2960(spawnerMobEntries.get((int)index).name));
            }
            ++index;
        }
        RepurposedStructures.LOGGER.log(Level.ERROR, "***************************************\nFailed to get mob. Please check that " + spawnerJsonEntry + ".json is correct and let Telepathicgrunt (mod author) know he broke the mob spawner code!\n***************************************");
        return class_1299.field_6093;
    }
}

