/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2541;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3443;
import net.minecraft.class_3614;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DungeonDarkForest
extends class_3031<class_3111> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_2960 CHEST_LOOT = new class_2960("repurposed_structures:chests/dungeon_dark_forest");
    private static final class_2960 SPAWNER_ID = new class_2960("repurposed_structures:dungeon_dark_forest");
    private static final class_2680 CAVE_AIR = class_2246.field_10543.method_9564();
    private static final class_2680 LEAVES = (class_2680)class_2246.field_10035.method_9564().method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(1));
    private static final class_2680 LOGS = class_2246.field_10010.method_9564();
    private static final class_2680 SIDEWAYS_LOGS = (class_2680)class_2246.field_10010.method_9564().method_11657((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11048);
    private static final class_2680 PLANKS = class_2246.field_10075.method_9564();

    public DungeonDarkForest(Codec<class_3111> configFactory) {
        super(configFactory);
    }

    public boolean generate(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_2338 position, class_3111 config) {
        int z;
        int y;
        int x;
        int randXRange = random.nextInt(2) + 2;
        int xMin = -randXRange - 1;
        int xMax = randXRange + 1;
        int randZRange = random.nextInt(2) + 2;
        int zMin = -randZRange - 1;
        int zMax = randZRange + 1;
        int validOpenings = 0;
        int ceilingOpenings = 0;
        class_2338.class_2339 blockpos$Mutable = new class_2338.class_2339().method_10101((class_2382)position);
        for (x = xMin; x <= xMax; ++x) {
            for (y = -1; y <= 4; ++y) {
                for (z = zMin; z <= zMax; ++z) {
                    blockpos$Mutable.method_10101((class_2382)position).method_10100(x, y, z);
                    class_3614 material = world.method_8320((class_2338)blockpos$Mutable).method_26207();
                    boolean flag = material.method_15799();
                    if (y == -1 && !flag) {
                        return false;
                    }
                    if (y == 4 && !flag) {
                        ++ceilingOpenings;
                    }
                    if (x != xMin && x != xMax && z != zMin && z != zMax || y != 0 || !world.method_22347((class_2338)blockpos$Mutable) || !world.method_22347(blockpos$Mutable.method_10084())) continue;
                    ++validOpenings;
                }
            }
        }
        if (validOpenings >= 1 && validOpenings <= 14 && ceilingOpenings < 14) {
            for (x = xMin; x <= xMax; ++x) {
                for (y = 4; y >= -1; --y) {
                    for (z = zMin; z <= zMax; ++z) {
                        blockpos$Mutable.method_10101((class_2382)position).method_10100(x, y, z);
                        if (y == 4) {
                            if (random.nextInt(3) == 0) {
                                world.method_8652((class_2338)blockpos$Mutable, SIDEWAYS_LOGS, 2);
                                continue;
                            }
                            world.method_8652((class_2338)blockpos$Mutable, LEAVES, 2);
                            continue;
                        }
                        if (x != xMin && y != -1 && z != zMin && x != xMax && y != 4 && z != zMax) {
                            if (world.method_8320((class_2338)blockpos$Mutable).method_26204() == class_2246.field_10034 || world.method_8320((class_2338)blockpos$Mutable).method_26204() == class_2246.field_10260) continue;
                            world.method_8652((class_2338)blockpos$Mutable, CAVE_AIR, 2);
                            continue;
                        }
                        if (blockpos$Mutable.method_10264() >= 0 && !world.method_8320(blockpos$Mutable.method_10074()).method_26207().method_15799()) {
                            world.method_8652((class_2338)blockpos$Mutable, CAVE_AIR, 2);
                            continue;
                        }
                        if (!world.method_8320((class_2338)blockpos$Mutable).method_26207().method_15799() || world.method_8320((class_2338)blockpos$Mutable).method_26204() == class_2246.field_10034 || world.method_8320((class_2338)blockpos$Mutable).method_26204() == class_2246.field_10260) continue;
                        if (y == -1 && random.nextInt(5) != 0) {
                            world.method_8652((class_2338)blockpos$Mutable, PLANKS, 2);
                            continue;
                        }
                        if (random.nextInt(3) == 0) {
                            world.method_8652((class_2338)blockpos$Mutable, LOGS, 2);
                            continue;
                        }
                        world.method_8652((class_2338)blockpos$Mutable, LEAVES, 2);
                    }
                }
            }
            blockpos$Mutable.method_10101((class_2382)position);
            for (x = xMin + 1; x <= xMax - 1; ++x) {
                for (int z2 = zMin + 1; z2 <= zMax - 1; ++z2) {
                    if (x != xMin + 1 && z2 != zMin + 1 && x != xMax - 1 && z2 != zMax - 1) continue;
                    for (int y2 = 3; y2 >= 0; --y2) {
                        class_2350 face = null;
                        for (class_2350 facing : class_2350.class_2353.field_11062) {
                            class_3614 wallMaterial = world.method_8320(blockpos$Mutable.method_10069(x, y2, z2).method_10093(facing)).method_26207();
                            if (wallMaterial != class_3614.field_15923 && wallMaterial != class_3614.field_15932) continue;
                            face = facing;
                            break;
                        }
                        if (face == null || random.nextInt(6) != 0) continue;
                        world.method_8652(blockpos$Mutable.method_10069(x, y2, z2), (class_2680)class_2246.field_10597.method_9564().method_11657((class_2769)class_2541.field_11697.get(face), (Comparable)Boolean.valueOf(true)), 2);
                    }
                }
            }
            block10: for (int l3 = 0; l3 < 2; ++l3) {
                for (int j4 = 0; j4 < 3; ++j4) {
                    int x2 = position.method_10263() + random.nextInt(randXRange * 2 + 1) - randXRange;
                    int y3 = position.method_10264();
                    int z3 = position.method_10260() + random.nextInt(randZRange * 2 + 1) - randZRange;
                    blockpos$Mutable.method_10103(x2, y3, z3);
                    if (!world.method_22347((class_2338)blockpos$Mutable)) continue;
                    int j3 = 0;
                    for (class_2350 Direction : class_2350.class_2353.field_11062) {
                        if (!world.method_8320(blockpos$Mutable.method_10093(Direction)).method_26207().method_15799()) continue;
                        ++j3;
                    }
                    if (j3 != true) continue;
                    world.method_8652((class_2338)blockpos$Mutable, class_3443.method_14916((class_1922)world, (class_2338)blockpos$Mutable, (class_2680)class_2246.field_10034.method_9564()), 2);
                    class_2621.method_11287((class_1922)world, (Random)random, (class_2338)blockpos$Mutable, (class_2960)CHEST_LOOT);
                    continue block10;
                }
            }
            world.method_8652(position, class_2246.field_10124.method_9564(), 2);
            world.method_8652(position, class_2246.field_10260.method_9564(), 2);
            class_2586 tileentity = world.method_8321(position);
            if (tileentity instanceof class_2636) {
                ((class_2636)tileentity).method_11390().method_8274(RepurposedStructures.mobSpawnerManager.getSpawnerMob(SPAWNER_ID, random));
            } else {
                LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{position.method_10263(), position.method_10264(), position.method_10260()});
            }
            return true;
        }
        return false;
    }
}

