/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2510;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3443;
import net.minecraft.class_3614;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DungeonOcean
extends class_3031<class_3111> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_2680 WATER = class_2246.field_10382.method_9564();
    private static final class_2680 PRISMARINE = class_2246.field_10135.method_9564();
    private static final class_2680 PRISMARINE_BRICKS = class_2246.field_10006.method_9564();
    private static final class_2680 PRISMARINE_WALL = class_2246.field_10530.method_9564();
    private static final class_2680 DARK_PRISMARINE_STAIRS = class_2246.field_10130.method_9564();
    private static final class_2680 DARK_PRISMARINE = class_2246.field_10297.method_9564();
    private static final class_2680 MAGMA_BLOCK = class_2246.field_10092.method_9564();
    private static final class_2960 CHEST_LOOT = new class_2960("repurposed_structures:chests/dungeon_ocean");
    private static final class_2960 FROZEN_SPAWNER_ID = new class_2960("repurposed_structures:dungeon_ocean_frozen");
    private static final class_2960 COLD_SPAWNER_ID = new class_2960("repurposed_structures:dungeon_ocean_cold");
    private static final class_2960 NEUTRAL_SPAWNER_ID = new class_2960("repurposed_structures:dungeon_ocean_neutral");
    private static final class_2960 LUKEWARM_SPAWNER_ID = new class_2960("repurposed_structures:dungeon_ocean_lukewarm");
    private static final class_2960 WARM_SPAWNER_ID = new class_2960("repurposed_structures:dungeon_ocean_warm");
    private static final class_2960 MISC_SPAWNER_ID = new class_2960("repurposed_structures:dungeon_ocean_misc");

    public DungeonOcean(Codec<class_3111> configFactory) {
        super(configFactory);
    }

    public boolean generate(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_2338 position, class_3111 config) {
        int z;
        int randXRange = random.nextInt(2) + 2;
        int xMin = -randXRange - 1;
        int xMax = randXRange + 1;
        int randZRange = random.nextInt(2) + 2;
        int zMin = -randZRange - 1;
        int zMax = randZRange + 1;
        int validOpenings = 0;
        int ceilingOpenings = 0;
        boolean validSpot = false;
        boolean oceanFloor = false;
        class_2338.class_2339 blockpos$Mutable = new class_2338.class_2339().method_10101((class_2382)position);
        int terrainHeight = world.method_8624(class_2902.class_2903.field_13195, blockpos$Mutable.method_10263(), blockpos$Mutable.method_10260());
        if (terrainHeight - blockpos$Mutable.method_10264() > 1 && terrainHeight - blockpos$Mutable.method_10264() < 5) {
            oceanFloor = true;
        }
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = -1; y <= 4; ++y) {
                for (z = zMin; z <= zMax; ++z) {
                    boolean flag;
                    blockpos$Mutable.method_10101((class_2382)position).method_10100(x, y, z);
                    class_3614 material = world.method_8320((class_2338)blockpos$Mutable).method_26207();
                    boolean bl = flag = material.method_15799() || material == class_3614.field_15920;
                    if (y == -1 && !flag) {
                        return false;
                    }
                    if (y == 4 && !flag) {
                        ++ceilingOpenings;
                    }
                    if (x != xMin && x != xMax && z != zMin && z != zMax || y != 0 || world.method_8320((class_2338)blockpos$Mutable).method_26207() != class_3614.field_15920 || world.method_8320(blockpos$Mutable.method_10084()).method_26207() != class_3614.field_15920) continue;
                    ++validOpenings;
                }
            }
        }
        boolean bl = oceanFloor ? random.nextFloat() < 0.1f : (validSpot = validOpenings >= 2 && validOpenings <= 6 && ceilingOpenings < 2);
        if (validSpot) {
            int x;
            for (x = xMin; x <= xMax; ++x) {
                for (int y = 4; y >= -1; --y) {
                    for (int z2 = zMin; z2 <= zMax; ++z2) {
                        blockpos$Mutable.method_10101((class_2382)position).method_10100(x, y, z2);
                        class_2680 currentBlock = world.method_8320((class_2338)blockpos$Mutable);
                        if (x != xMin && y != -1 && z2 != zMin && x != xMax && y != 5 && z2 != zMax) {
                            if (y == 4) {
                                if (!currentBlock.method_26225()) continue;
                                if (random.nextInt(3) < 2) {
                                    world.method_8652((class_2338)blockpos$Mutable, PRISMARINE, 2);
                                    continue;
                                }
                                world.method_8652((class_2338)blockpos$Mutable, PRISMARINE_BRICKS, 2);
                                continue;
                            }
                            if (currentBlock.method_26204() != class_2246.field_10034 && currentBlock.method_26204() != class_2246.field_10260 && currentBlock.method_26204() != class_2246.field_10297 && currentBlock.method_26204() != class_2246.field_10130) {
                                if (blockpos$Mutable.method_10264() < world.method_8615()) {
                                    world.method_8652((class_2338)blockpos$Mutable, WATER, 2);
                                } else {
                                    world.method_8652((class_2338)blockpos$Mutable, class_2246.field_10124.method_9564(), 2);
                                }
                            }
                            if ((currentBlock = world.method_8320(blockpos$Mutable.method_10084())).method_26207() != class_3614.field_15947) continue;
                            if (blockpos$Mutable.method_10264() + 1 < world.method_8615()) {
                                world.method_8652((class_2338)blockpos$Mutable, WATER, 2);
                                continue;
                            }
                            world.method_8652((class_2338)blockpos$Mutable, class_2246.field_10124.method_9564(), 2);
                            continue;
                        }
                        if (blockpos$Mutable.method_10264() >= 0 && !world.method_8320(blockpos$Mutable.method_10074()).method_26207().method_15799()) {
                            if (currentBlock.method_26204() == class_2246.field_10034 || currentBlock.method_26204() == class_2246.field_10260 || currentBlock.method_26204() == class_2246.field_10297 || currentBlock.method_26204() == class_2246.field_10130) continue;
                            if (blockpos$Mutable.method_10264() < world.method_8615()) {
                                world.method_8652((class_2338)blockpos$Mutable, WATER, 2);
                                continue;
                            }
                            world.method_8652((class_2338)blockpos$Mutable, class_2246.field_10124.method_9564(), 2);
                            continue;
                        }
                        if (!currentBlock.method_26207().method_15799() || currentBlock.method_26204() == class_2246.field_10034 || currentBlock.method_26204() == class_2246.field_10260) continue;
                        if (y == -1) {
                            if (random.nextInt(10) == 0) {
                                world.method_8652((class_2338)blockpos$Mutable, MAGMA_BLOCK, 2);
                                continue;
                            }
                            if (random.nextInt(2) == 0) {
                                world.method_8652((class_2338)blockpos$Mutable, PRISMARINE, 2);
                                continue;
                            }
                            world.method_8652((class_2338)blockpos$Mutable, PRISMARINE_BRICKS, 2);
                            continue;
                        }
                        if (random.nextInt(3) <= 1) {
                            world.method_8652((class_2338)blockpos$Mutable, PRISMARINE, 2);
                            continue;
                        }
                        currentBlock = world.method_8320((class_2338)blockpos$Mutable);
                        world.method_8652((class_2338)blockpos$Mutable, (class_2680)PRISMARINE_WALL.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(blockpos$Mutable.method_10264() < world.method_8615())), 3);
                    }
                }
            }
            block6: for (int l3 = 0; l3 < 2; ++l3) {
                for (int j4 = 0; j4 < 3; ++j4) {
                    int x2 = position.method_10263() + random.nextInt(randXRange * 2 + 1) - randXRange;
                    int y = position.method_10264();
                    int z3 = position.method_10260() + random.nextInt(randZRange * 2 + 1) - randZRange;
                    blockpos$Mutable.method_10103(x2, y, z3);
                    class_2680 currentBlock = world.method_8320((class_2338)blockpos$Mutable);
                    if (currentBlock.method_26207() != class_3614.field_15920 && currentBlock.method_26207() != class_3614.field_15959) continue;
                    int j3 = 0;
                    for (class_2350 direction : class_2350.class_2353.field_11062) {
                        class_3614 neighboringMaterial = world.method_8320(blockpos$Mutable.method_10093(direction)).method_26207();
                        if (!neighboringMaterial.method_15799()) continue;
                        ++j3;
                    }
                    if (j3 != true) continue;
                    world.method_8652((class_2338)blockpos$Mutable, class_3443.method_14916((class_1922)world, (class_2338)blockpos$Mutable, (class_2680)((class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(blockpos$Mutable.method_10264() < world.method_8615())))), 3);
                    class_2621.method_11287((class_1922)world, (Random)random, (class_2338)blockpos$Mutable, (class_2960)CHEST_LOOT);
                    continue block6;
                }
            }
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    blockpos$Mutable.method_10101((class_2382)position).method_10100(x, -1, z);
                    class_2680 currentBlock = world.method_8320((class_2338)blockpos$Mutable);
                    if (currentBlock.method_26204() != class_2246.field_10034 && currentBlock.method_26204() != class_2246.field_10260) {
                        world.method_8652((class_2338)blockpos$Mutable, DARK_PRISMARINE, 2);
                    }
                    blockpos$Mutable.method_10098(class_2350.field_11033);
                    currentBlock = world.method_8320((class_2338)blockpos$Mutable);
                    if (currentBlock.method_26204() == class_2246.field_10034 || currentBlock.method_26204() == class_2246.field_10260) continue;
                    world.method_8652((class_2338)blockpos$Mutable, DARK_PRISMARINE, 2);
                }
            }
            blockpos$Mutable.method_10101((class_2382)position).method_10098(class_2350.field_11033);
            if (blockpos$Mutable.method_10264() < world.method_8615()) {
                world.method_8652((class_2338)blockpos$Mutable, WATER, 2);
            }
            world.method_8652((class_2338)blockpos$Mutable, class_2246.field_10124.method_9564(), 2);
            world.method_8652((class_2338)blockpos$Mutable, class_2246.field_10260.method_9564(), 2);
            class_2586 tileentity = world.method_8321((class_2338)blockpos$Mutable);
            if (tileentity instanceof class_2636) {
                ((class_2636)tileentity).method_11390().method_8274(DungeonOcean.pickMobSpawner(world, random, (class_2338)blockpos$Mutable));
            } else {
                LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{blockpos$Mutable.method_10263(), blockpos$Mutable.method_10264(), blockpos$Mutable.method_10260()});
            }
            class_2680 currentBlock = world.method_8320((class_2338)blockpos$Mutable.method_10098(class_2350.field_11036));
            if (currentBlock.method_26204() != class_2246.field_10034 && currentBlock.method_26204() != class_2246.field_10260) {
                world.method_8652((class_2338)blockpos$Mutable, (class_2680)PRISMARINE_WALL.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(blockpos$Mutable.method_10264() < world.method_8615())), 2);
            }
            if ((currentBlock = world.method_8320((class_2338)blockpos$Mutable.method_10098(class_2350.field_11036))).method_26204() != class_2246.field_10034 && currentBlock.method_26204() != class_2246.field_10260) {
                world.method_8652((class_2338)blockpos$Mutable, (class_2680)PRISMARINE_WALL.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(blockpos$Mutable.method_10264() < world.method_8615())), 2);
            }
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                blockpos$Mutable.method_10101((class_2382)position).method_10098(direction);
                currentBlock = world.method_8320((class_2338)blockpos$Mutable);
                if (currentBlock.method_26204() == class_2246.field_10034 || currentBlock.method_26204() == class_2246.field_10260) continue;
                world.method_8652((class_2338)blockpos$Mutable, (class_2680)((class_2680)DARK_PRISMARINE_STAIRS.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(blockpos$Mutable.method_10264() < world.method_8615()))).method_11657((class_2769)class_2510.field_11571, (Comparable)direction.method_10153()), 2);
            }
            return true;
        }
        return false;
    }

    private static class_1299<?> pickMobSpawner(class_5281 world, Random random, class_2338 position) {
        class_1959 biome = world.method_23753(position);
        if (biome.method_8688() == class_1959.class_1961.field_9367) {
            String biomeName = class_2378.field_11153.method_10221((Object)biome).method_12832();
            float biomeTemp = biome.method_8712();
            if ((double)biomeTemp < 0.0 || biomeName.contains("frozen") || biomeName.contains("snow") || biomeName.contains("ice")) {
                return RepurposedStructures.mobSpawnerManager.getSpawnerMob(FROZEN_SPAWNER_ID, random);
            }
            if ((double)biomeTemp < 0.5 || biomeName.contains("cold")) {
                return RepurposedStructures.mobSpawnerManager.getSpawnerMob(COLD_SPAWNER_ID, random);
            }
            if ((double)biomeTemp > 0.5 || biomeName.equals("ocean") || biomeName.equals("deep_ocean")) {
                return RepurposedStructures.mobSpawnerManager.getSpawnerMob(NEUTRAL_SPAWNER_ID, random);
            }
            if ((double)biomeTemp >= 0.9 || biomeName.contains("lukewarm")) {
                return RepurposedStructures.mobSpawnerManager.getSpawnerMob(LUKEWARM_SPAWNER_ID, random);
            }
            if ((double)biomeTemp >= 1.5 || biomeName.contains("warm") || biomeName.contains("hot") || biomeName.contains("tropic")) {
                return RepurposedStructures.mobSpawnerManager.getSpawnerMob(WARM_SPAWNER_ID, random);
            }
        }
        return RepurposedStructures.mobSpawnerManager.getSpawnerMob(MISC_SPAWNER_ID, random);
    }
}

