/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_244;
import net.minecraft.class_251;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3499;
import net.minecraft.class_3614;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_5138;
import net.minecraft.class_5281;

public class TreeSwampHorned
extends class_3031<class_4643> {
    private static final class_2680 TRUNK = class_2246.field_10431.method_9564();
    private static final class_2680 LEAF = (class_2680)class_2246.field_10503.method_9564().method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(1));

    public TreeSwampHorned(Codec<class_4643> config) {
        super(config);
    }

    public boolean generate(class_5281 serverWorldAccess, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_2338 blockPos, class_4643 treeFeatureConfig) {
        HashSet set = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        class_3341 blockBox = class_3341.method_14665();
        boolean bl = this.generate(serverWorldAccess, random, blockPos, set, set2);
        if (blockBox.field_14381 <= blockBox.field_14378 && bl && !set.isEmpty()) {
            if (!treeFeatureConfig.field_21290.isEmpty()) {
                ArrayList list = Lists.newArrayList((Iterable)set);
                ArrayList list2 = Lists.newArrayList((Iterable)set2);
                list.sort(Comparator.comparingInt(class_2382::method_10264));
                list2.sort(Comparator.comparingInt(class_2382::method_10264));
                treeFeatureConfig.field_21290.forEach(decorator -> decorator.method_23469((class_1936)serverWorldAccess, random, list, list2, set3, blockBox));
            }
            class_251 voxelSet = this.placeLogsAndLeaves((class_1936)serverWorldAccess, blockBox, set, set3);
            class_3499.method_20532((class_1936)serverWorldAccess, (int)3, (class_251)voxelSet, (int)blockBox.field_14381, (int)blockBox.field_14380, (int)blockBox.field_14379);
            return true;
        }
        return false;
    }

    private boolean generate(class_5281 world, Random random, class_2338 position, Set<class_2338> logPositions, Set<class_2338> leavesPositions) {
        int height = random.nextInt(4) + 6;
        if (!this.isSpaceAt(world, position, height)) {
            return false;
        }
        while (world.method_8320(position.method_10074()).method_26207() == class_3614.field_15920) {
            position = position.method_10074();
        }
        boolean flag = true;
        if (position.method_10264() >= 1 && position.method_10264() + height + 1 <= 256) {
            int x;
            for (int y = position.method_10264(); y <= position.method_10264() + 1 + height; ++y) {
                int radius = 1;
                if (y == position.method_10264()) {
                    radius = 0;
                }
                if (y >= position.method_10264() + 1 + height - 2) {
                    radius = 3;
                }
                class_2338.class_2339 blockpos$Mutable = new class_2338.class_2339();
                for (x = position.method_10263() - radius; x <= position.method_10263() + radius && flag; ++x) {
                    for (int z = position.method_10260() - radius; z <= position.method_10260() + radius && flag; ++z) {
                        if (y >= 0 && y < 256) {
                            blockpos$Mutable.method_10103(x, y, z);
                            if (TreeSwampHorned.isAirOrLeaves((class_3746)world, (class_2338)blockpos$Mutable)) continue;
                            if (TreeSwampHorned.isWater((class_3746)world, (class_2338)blockpos$Mutable)) {
                                flag = false;
                                continue;
                            }
                            if (y <= position.method_10264()) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (TreeSwampHorned.isDirtOrGrass((class_3746)world, position.method_10074()) && position.method_10264() < world.method_8322() - height - 1) {
                int z;
                int heightDiff;
                int currentHeight;
                for (currentHeight = position.method_10264() - 4 + height; currentHeight <= position.method_10264() + height; ++currentHeight) {
                    heightDiff = currentHeight - (position.method_10264() + height);
                    int l2 = 2 - heightDiff / 2;
                    for (x = position.method_10263() - l2 - 1; x <= position.method_10263() + l2; ++x) {
                        int xPos = x - position.method_10263();
                        for (z = position.method_10260() - l2 - 1; z <= position.method_10260() + l2; ++z) {
                            class_2338 blockpos;
                            int zPos = z - position.method_10260();
                            int isCornerIfThisIsTwo = 0;
                            if (xPos == l2) {
                                ++isCornerIfThisIsTwo;
                            }
                            if (zPos == l2) {
                                ++isCornerIfThisIsTwo;
                            }
                            if (xPos == -l2 - 1) {
                                ++isCornerIfThisIsTwo;
                            }
                            if (zPos == -l2 - 1) {
                                ++isCornerIfThisIsTwo;
                            }
                            if (isCornerIfThisIsTwo != 2 && (random.nextInt(3) >= 2 || heightDiff == 0) || !TreeSwampHorned.isAirOrLeaves((class_3746)world, blockpos = new class_2338(x, currentHeight, z)) && !TreeSwampHorned.isReplaceablePlant((class_3746)world, blockpos)) continue;
                            this.method_13153((class_1945)world, blockpos, LEAF);
                            leavesPositions.add(blockpos);
                        }
                    }
                }
                this.genTrunk(world, position, height);
                this.genTrunk(world, position.method_10067(), height);
                this.genTrunk(world, position.method_10095(), height);
                this.genTrunk(world, position.method_10067().method_10095(), height);
                logPositions.add(position);
                for (currentHeight = position.method_10264() - 3 + height; currentHeight <= position.method_10264() + height; ++currentHeight) {
                    heightDiff = currentHeight - (position.method_10264() + height);
                    int i3 = 2 - heightDiff / 2;
                    class_2338.class_2339 blockpos$Mutable1 = new class_2338.class_2339();
                    for (int x2 = position.method_10263() - i3 - 1; x2 <= position.method_10263() + i3; ++x2) {
                        for (z = position.method_10260() - i3 - 1; z <= position.method_10260() + i3; ++z) {
                            blockpos$Mutable1.method_10103(x2, currentHeight, z);
                            if (world.method_8320((class_2338)blockpos$Mutable1).method_26207() != class_3614.field_15923) continue;
                            class_2338 blockpos3 = blockpos$Mutable1.method_10067();
                            class_2338 blockpos4 = blockpos$Mutable1.method_10078();
                            class_2338 blockpos1 = blockpos$Mutable1.method_10095();
                            class_2338 blockpos2 = blockpos$Mutable1.method_10072();
                            if (random.nextInt(4) == 0 && world.method_22347(blockpos3)) {
                                this.addVine(world, blockpos3, class_2541.field_11702);
                            }
                            if (random.nextInt(4) == 0 && world.method_22347(blockpos4)) {
                                this.addVine(world, blockpos4, class_2541.field_11696);
                            }
                            if (random.nextInt(4) == 0 && world.method_22347(blockpos1)) {
                                this.addVine(world, blockpos1, class_2541.field_11699);
                            }
                            if (random.nextInt(4) != 0 || !world.method_22347(blockpos2)) continue;
                            this.addVine(world, blockpos2, class_2541.field_11706);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void addVine(class_5281 world, class_2338 pos, class_2746 prop) {
        class_2680 iblockstate = (class_2680)class_2246.field_10597.method_9564().method_11657((class_2769)prop, (Comparable)Boolean.TRUE);
        this.method_13153((class_1945)world, pos, iblockstate);
        class_2338 blockpos = pos.method_10074();
        for (int i = 4; world.method_22347(blockpos) && i > 0; --i) {
            this.method_13153((class_1945)world, blockpos, iblockstate);
            blockpos = blockpos.method_10074();
        }
    }

    private void genTrunk(class_5281 world, class_2338 position, int height) {
        this.method_13153((class_1945)world, position.method_10074(), class_2246.field_10566.method_9564());
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10101((class_2382)position);
        for (int currentHeight = 0; currentHeight < height; ++currentHeight) {
            class_2680 iblockstate1 = world.method_8320((class_2338)mutable);
            if (world.method_22347((class_2338)mutable) || iblockstate1.method_26164((class_3494)class_3481.field_15503) || iblockstate1.method_26207() == class_3614.field_15935 || iblockstate1.method_26207() == class_3614.field_15947 || iblockstate1.method_26207() == class_3614.field_15920) {
                if (currentHeight != height - 1) {
                    this.method_13153((class_1945)world, (class_2338)mutable, TRUNK);
                } else if (currentHeight == height - 1) {
                    this.method_13153((class_1945)world, (class_2338)mutable, LEAF);
                }
            }
            mutable.method_10098(class_2350.field_11036);
        }
    }

    private boolean isSpaceAt(class_5281 world, class_2338 leavesPos, int height) {
        boolean spaceFound = true;
        if (leavesPos.method_10264() >= 1 && leavesPos.method_10264() + height + 1 <= world.method_8322()) {
            for (int y = 0; y <= 1 + height; ++y) {
                int radius = 2;
                if (y == 0) {
                    radius = 1;
                }
                for (int x = -radius; x <= radius && spaceFound; ++x) {
                    for (int z = -radius; z <= radius && spaceFound; ++z) {
                        if (leavesPos.method_10264() + y >= 0 && leavesPos.method_10264() + y < world.method_8322() && TreeSwampHorned.canTreeReplace((class_3746)world, leavesPos.method_10069(x, y, z))) continue;
                        spaceFound = false;
                    }
                }
            }
            return spaceFound;
        }
        return false;
    }

    public static boolean canTreeReplace(class_3746 world, class_2338 pos) {
        return TreeSwampHorned.canReplace(world, pos) || world.method_16358(pos, state -> state.method_26164((class_3494)class_3481.field_15475));
    }

    private static boolean isWater(class_3746 world, class_2338 pos) {
        return world.method_16358(pos, state -> state.method_27852(class_2246.field_10382));
    }

    public static boolean isAirOrLeaves(class_3746 world, class_2338 pos) {
        return world.method_16358(pos, state -> state.method_26215() || state.method_26164((class_3494)class_3481.field_15503));
    }

    private static boolean isDirtOrGrass(class_3746 world, class_2338 pos) {
        return world.method_16358(pos, state -> TreeSwampHorned.method_23396((class_2248)state.method_26204()) || state.method_27852(class_2246.field_10362));
    }

    private static boolean isReplaceablePlant(class_3746 world, class_2338 pos) {
        return world.method_16358(pos, state -> {
            class_3614 material = state.method_26207();
            return material == class_3614.field_15956;
        });
    }

    public static void setBlockStateWithoutUpdatingNeighbors(class_1945 world, class_2338 pos, class_2680 state) {
        world.method_8652(pos, state, 19);
    }

    public static boolean canReplace(class_3746 testableWorld, class_2338 pos) {
        return TreeSwampHorned.isAirOrLeaves(testableWorld, pos) || TreeSwampHorned.isReplaceablePlant(testableWorld, pos) || TreeSwampHorned.isWater(testableWorld, pos);
    }

    private class_251 placeLogsAndLeaves(class_1936 world, class_3341 box, Set<class_2338> logs, Set<class_2338> leaves) {
        ArrayList list = Lists.newArrayList();
        class_244 voxelSet = new class_244(box.method_14660(), box.method_14663(), box.method_14664());
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2338 blockPos2 : Lists.newArrayList(leaves)) {
            if (!box.method_14662((class_2382)blockPos2)) continue;
            voxelSet.method_1049(blockPos2.method_10263() - box.field_14381, blockPos2.method_10264() - box.field_14380, blockPos2.method_10260() - box.field_14379, true, true);
        }
        for (class_2338 blockPos2 : Lists.newArrayList(logs)) {
            class_2350[] var11;
            if (box.method_14662((class_2382)blockPos2)) {
                voxelSet.method_1049(blockPos2.method_10263() - box.field_14381, blockPos2.method_10264() - box.field_14380, blockPos2.method_10260() - box.field_14379, true, true);
            }
            for (class_2350 direction : var11 = class_2350.values()) {
                class_2680 blockState;
                mutable.method_25505((class_2382)blockPos2, direction);
                if (logs.contains(mutable) || !(blockState = world.method_8320((class_2338)mutable)).method_28498((class_2769)class_2741.field_12541)) continue;
                ((Set)list.get(0)).add(mutable.method_10062());
                TreeSwampHorned.setBlockStateWithoutUpdatingNeighbors((class_1945)world, (class_2338)mutable, (class_2680)blockState.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(1)));
                if (!box.method_14662((class_2382)mutable)) continue;
                voxelSet.method_1049(mutable.method_10263() - box.field_14381, mutable.method_10264() - box.field_14380, mutable.method_10260() - box.field_14379, true, true);
            }
        }
        for (int k = 1; k < 6; ++k) {
            Set set = (Set)list.get(k - 1);
            Set set2 = (Set)list.get(k);
            for (class_2338 blockPos3 : set) {
                class_2350[] var27;
                if (box.method_14662((class_2382)blockPos3)) {
                    voxelSet.method_1049(blockPos3.method_10263() - box.field_14381, blockPos3.method_10264() - box.field_14380, blockPos3.method_10260() - box.field_14379, true, true);
                }
                for (class_2350 direction2 : var27 = class_2350.values()) {
                    int l;
                    class_2680 blockState2;
                    mutable.method_25505((class_2382)blockPos3, direction2);
                    if (set.contains(mutable) || set2.contains(mutable) || !(blockState2 = world.method_8320((class_2338)mutable)).method_28498((class_2769)class_2741.field_12541) || (l = ((Integer)blockState2.method_11654((class_2769)class_2741.field_12541)).intValue()) <= k + 1) continue;
                    class_2680 blockState3 = (class_2680)blockState2.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(k + 1));
                    TreeSwampHorned.setBlockStateWithoutUpdatingNeighbors((class_1945)world, (class_2338)mutable, blockState3);
                    if (box.method_14662((class_2382)mutable)) {
                        voxelSet.method_1049(mutable.method_10263() - box.field_14381, mutable.method_10264() - box.field_14380, mutable.method_10260() - box.field_14379, true, true);
                    }
                    set2.add(mutable.method_10062());
                }
            }
        }
        return voxelSet;
    }
}

