/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features.structures;

import com.google.common.collect.Lists;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.world.features.structures.StructurePieces;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1694;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2279;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2389;
import net.minecraft.class_2421;
import net.minecraft.class_2429;
import net.minecraft.class_2443;
import net.minecraft.class_2465;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2541;
import net.minecraft.class_2555;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3614;
import net.minecraft.class_3773;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_5281;

public class RSMineshaftPieces {
    private static final class_2960 ICY_CHEST_ID = new class_2960("repurposed_structures:chests/mineshaft_icy");
    private static final class_2960 JUNGLE_CHEST_ID = new class_2960("repurposed_structures:chests/mineshaft_jungle");
    private static final class_2960 TAIGA_CHEST_ID = new class_2960("repurposed_structures:chests/mineshaft_taiga");
    private static final class_2960 DESERT_CHEST_ID = new class_2960("repurposed_structures:chests/mineshaft_desert");
    private static final class_2960 END_CHEST_ID = new class_2960("repurposed_structures:chests/mineshaft_end");
    private static final class_2960 NETHER_CHEST_ID = new class_2960("repurposed_structures:chests/mineshaft_nether");
    private static final class_2960 OCEAN_CHEST_ID = new class_2960("repurposed_structures:chests/mineshaft_ocean");
    private static final class_2960 STONE_CHEST_ID = new class_2960("repurposed_structures:chests/mineshaft_stone");
    private static final class_2960 SAVANNA_CHEST_ID = new class_2960("repurposed_structures:chests/mineshaft_savanna");
    private static final class_2960 SWAMP_OR_DARK_FOREST_CHEST_ID = new class_2960("repurposed_structures:chests/mineshaft_swamp_dark_forest");
    private static final class_2960 BIRCH_CHEST_ID = new class_2960("repurposed_structures:chests/mineshaft_birch");
    private static final class_2960 ICY_SPAWNER_ID = new class_2960("repurposed_structures:mineshaft_icy");
    private static final class_2960 BIRCH_SPAWNER_ID = new class_2960("repurposed_structures:mineshaft_birch");
    private static final class_2960 JUNGLE_SPAWNER_ID = new class_2960("repurposed_structures:mineshaft_jungle");
    private static final class_2960 TAIGA_SPAWNER_ID = new class_2960("repurposed_structures:mineshaft_taiga");
    private static final class_2960 DESERT_SPAWNER_ID = new class_2960("repurposed_structures:mineshaft_desert");
    private static final class_2960 STONE_SPAWNER_ID = new class_2960("repurposed_structures:mineshaft_stone");
    private static final class_2960 SAVANNA_SPAWNER_ID = new class_2960("repurposed_structures:mineshaft_savanna");
    private static final class_2960 SWAMPORDARKFOREST_SPAWNER_ID = new class_2960("repurposed_structures:mineshaft_swamp_or_dark_forest");
    private static final class_2960 END_SPAWNER_ID = new class_2960("repurposed_structures:mineshaft_end");
    private static final class_2960 NETHER_SPAWNER_ID = new class_2960("repurposed_structures:mineshaft_nether");
    private static final class_2960 OCEAN_SPAWNER_ID = new class_2960("repurposed_structures:mineshaft_ocean");

    private static Piece createRandomShaftPiece(List<class_3443> p_189940_0_, Random p_189940_1_, int p_189940_2_, int p_189940_3_, int p_189940_4_, class_2350 p_189940_5_, int p_189940_6_, Type type) {
        int i = p_189940_1_.nextInt(100);
        if (i >= 80) {
            class_3341 MutableBoundingBox = Cross.findCrossing(p_189940_0_, p_189940_1_, p_189940_2_, p_189940_3_, p_189940_4_, p_189940_5_);
            if (MutableBoundingBox != null) {
                return new Cross(p_189940_6_, MutableBoundingBox, p_189940_5_, type);
            }
        } else if (i >= 70) {
            class_3341 MutableBoundingBox1 = Stairs.findStairs(p_189940_0_, p_189940_1_, p_189940_2_, p_189940_3_, p_189940_4_, p_189940_5_);
            if (MutableBoundingBox1 != null) {
                return new Stairs(p_189940_6_, MutableBoundingBox1, p_189940_5_, type);
            }
        } else {
            class_3341 MutableBoundingBox2 = Corridor.findCorridorSize(p_189940_0_, p_189940_1_, p_189940_2_, p_189940_3_, p_189940_4_, p_189940_5_);
            if (MutableBoundingBox2 != null) {
                return new Corridor(p_189940_6_, p_189940_1_, MutableBoundingBox2, p_189940_5_, type);
            }
        }
        return null;
    }

    private static Piece generateAndAddPiece(class_3443 p_189938_0_, List<class_3443> p_189938_1_, Random p_189938_2_, int p_189938_3_, int p_189938_4_, int p_189938_5_, class_2350 p_189938_6_, int p_189938_7_) {
        if (p_189938_7_ > 8) {
            return null;
        }
        if (Math.abs(p_189938_3_ - p_189938_0_.method_14935().field_14381) <= 80 && Math.abs(p_189938_5_ - p_189938_0_.method_14935().field_14379) <= 80) {
            Type mapgenmineshaft$type = ((Piece)p_189938_0_).mineShaftType;
            Piece structuremineshaftpieces$peice = RSMineshaftPieces.createRandomShaftPiece(p_189938_1_, p_189938_2_, p_189938_3_, p_189938_4_, p_189938_5_, p_189938_6_, p_189938_7_ + 1, mapgenmineshaft$type);
            if (structuremineshaftpieces$peice != null) {
                p_189938_1_.add(structuremineshaftpieces$peice);
                structuremineshaftpieces$peice.method_14918(p_189938_0_, p_189938_1_, p_189938_2_);
            }
            return structuremineshaftpieces$peice;
        }
        return null;
    }

    static abstract class Piece
    extends class_3443 {
        protected Type mineShaftType;

        public Piece(class_3773 piece, int componentType, Type mineshaftType) {
            super(piece, componentType);
            this.mineShaftType = mineshaftType;
        }

        public Piece(class_3773 piece, class_2487 data) {
            super(piece, data);
            this.mineShaftType = Type.byId(data.method_10550("MST"));
        }

        protected void method_14943(class_2487 data) {
            data.method_10569("MST", this.mineShaftType.ordinal());
        }

        protected boolean isAirInStructureBoundingBox(class_1922 worldIn, class_3341 boundingboxIn) {
            int y;
            int x;
            int xMin = Math.max(this.field_15315.field_14381 - 1, boundingboxIn.field_14381);
            int yMin = Math.max(this.field_15315.field_14380 - 1, boundingboxIn.field_14380);
            int zMin = Math.max(this.field_15315.field_14379 - 1, boundingboxIn.field_14379);
            int xMax = Math.min(this.field_15315.field_14378 + 1, boundingboxIn.field_14378);
            int yMax = Math.min(this.field_15315.field_14377 + 1, boundingboxIn.field_14377);
            int zMax = Math.min(this.field_15315.field_14376 + 1, boundingboxIn.field_14376);
            class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();
            for (x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    if (worldIn.method_8320((class_2338)blockpos$mutable.method_10103(x, yMin, z)).method_26207() == class_3614.field_15959) {
                        return true;
                    }
                    if (worldIn.method_8320((class_2338)blockpos$mutable.method_10103(x, yMax, z)).method_26207() != class_3614.field_15959) continue;
                    return true;
                }
            }
            for (x = xMin; x <= xMax; ++x) {
                for (y = yMin; y <= yMax; ++y) {
                    if (worldIn.method_8320((class_2338)blockpos$mutable.method_10103(x, y, zMin)).method_26207() == class_3614.field_15959) {
                        return true;
                    }
                    if (worldIn.method_8320((class_2338)blockpos$mutable.method_10103(x, y, zMax)).method_26207() != class_3614.field_15959) continue;
                    return true;
                }
            }
            for (int z = zMin; z <= zMax; ++z) {
                for (y = yMin; y <= yMax; ++y) {
                    if (worldIn.method_8320((class_2338)blockpos$mutable.method_10103(xMin, y, z)).method_26207() == class_3614.field_15959) {
                        return true;
                    }
                    if (worldIn.method_8320((class_2338)blockpos$mutable.method_10103(xMax, y, z)).method_26207() != class_3614.field_15959) continue;
                    return true;
                }
            }
            return false;
        }

        protected void fillWithVines(class_5281 world, Random random, class_3341 boundingbox, int rarity, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
            for (int x = xMin; x <= xMax; ++x) {
                block1: for (int z = zMin; z <= zMax && random.nextInt(rarity) != 0; ++z) {
                    class_2680 vineBlock = (class_2680)class_2246.field_10597.method_9564().method_11657((class_2769)class_2541.field_11697.get(class_2350.class_2353.field_11062.method_10183(random)), (Comparable)Boolean.valueOf(true));
                    int vineLength = 0;
                    for (int y = yMax; y >= yMin; --y) {
                        class_2680 aboveBlockState = this.method_14929((class_1922)world, x, y + 1, z, boundingbox);
                        if (this.method_14929((class_1922)world, x, y, z, boundingbox).method_26215()) {
                            if (aboveBlockState.method_26225() || aboveBlockState.method_27852(class_2246.field_10597)) {
                                ++vineLength;
                                if (aboveBlockState.method_26225()) {
                                    this.setVineBlockState(world, (class_2680)vineBlock.method_11657((class_2769)class_2541.field_11703, (Comparable)Boolean.valueOf(true)), x, y, z, boundingbox);
                                } else {
                                    this.setVineBlockState(world, vineBlock, x, y, z, boundingbox);
                                }
                            } else if (class_2246.field_10597.method_9558(vineBlock, (class_4538)world, new class_2338(this.method_14928(x, z), this.method_14924(y), this.method_14941(x, z)))) {
                                this.setVineBlockState(world, vineBlock, x, y, z, boundingbox);
                            }
                        }
                        if (random.nextInt(3) == 0 || vineLength == 4) continue block1;
                    }
                }
            }
        }

        protected void setVineBlockState(class_5281 worldIn, class_2680 blockstateIn, int x, int y, int z, class_3341 boundingboxIn) {
            class_2338 blockpos = new class_2338(this.method_14928(x, z), this.method_14924(y), this.method_14941(x, z));
            if (boundingboxIn.method_14662((class_2382)blockpos)) {
                worldIn.method_8652(blockpos, blockstateIn, 2);
            }
        }

        protected class_2680 getArchTopBlock() {
            switch (this.mineShaftType) {
                case ICY: {
                    return class_2246.field_10225.method_9564();
                }
                case JUNGLE: {
                    return (class_2680)class_2246.field_10306.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048);
                }
                case TAIGA: {
                    return (class_2680)class_2246.field_10436.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048);
                }
                case DESERT: {
                    return class_2246.field_10292.method_9564();
                }
                case END: {
                    return (class_2680)class_2246.field_10505.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11051);
                }
                case NETHER: {
                    return class_2246.field_10266.method_9564();
                }
                case OCEAN: {
                    return class_2246.field_10297.method_9564();
                }
                case STONE: {
                    return class_2246.field_10340.method_9564();
                }
                case SAVANNA: {
                    return (class_2680)class_2246.field_10533.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048);
                }
                case SWAMPORDARKFOREST: {
                    return class_2246.field_10075.method_9564();
                }
            }
            return (class_2680)class_2246.field_10366.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048);
        }

        protected class_2960 getChestLoot() {
            switch (this.mineShaftType) {
                case ICY: {
                    return ICY_CHEST_ID;
                }
                case JUNGLE: {
                    return JUNGLE_CHEST_ID;
                }
                case TAIGA: {
                    return TAIGA_CHEST_ID;
                }
                case DESERT: {
                    return DESERT_CHEST_ID;
                }
                case END: {
                    return END_CHEST_ID;
                }
                case NETHER: {
                    return NETHER_CHEST_ID;
                }
                case OCEAN: {
                    return OCEAN_CHEST_ID;
                }
                case STONE: {
                    return STONE_CHEST_ID;
                }
                case SAVANNA: {
                    return SAVANNA_CHEST_ID;
                }
                case SWAMPORDARKFOREST: {
                    return SWAMP_OR_DARK_FOREST_CHEST_ID;
                }
            }
            return BIRCH_CHEST_ID;
        }

        protected class_2680 getFloorBlock() {
            switch (this.mineShaftType) {
                case ICY: {
                    return class_2246.field_10295.method_9564();
                }
                case JUNGLE: {
                    return class_2246.field_10334.method_9564();
                }
                case TAIGA: {
                    return class_2246.field_9975.method_9564();
                }
                case DESERT: {
                    return class_2246.field_10467.method_9564();
                }
                case END: {
                    return class_2246.field_10286.method_9564();
                }
                case NETHER: {
                    return class_2246.field_10266.method_9564();
                }
                case OCEAN: {
                    return class_2246.field_10006.method_9564();
                }
                case STONE: {
                    return class_2246.field_10115.method_9564();
                }
                case SAVANNA: {
                    return class_2246.field_10218.method_9564();
                }
                case SWAMPORDARKFOREST: {
                    return class_2246.field_10219.method_9564();
                }
            }
            return class_2246.field_10148.method_9564();
        }

        protected class_2680 getArchSupportBlock(Random random) {
            switch (this.mineShaftType) {
                case ICY: {
                    return class_2246.field_10295.method_9564();
                }
                case JUNGLE: {
                    return class_2246.field_10319.method_9564();
                }
                case TAIGA: {
                    return class_2246.field_10020.method_9564();
                }
                case DESERT: {
                    return class_2246.field_10630.method_9564();
                }
                case END: {
                    return (class_2680)class_2246.field_10505.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11052);
                }
                case NETHER: {
                    return class_2246.field_10127.method_9564();
                }
                case OCEAN: {
                    return (class_2680)class_2246.field_10530.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
                }
                case STONE: {
                    return random.nextInt(10) < 3 ? class_2246.field_9990.method_9564() : class_2246.field_10625.method_9564();
                }
                case SAVANNA: {
                    return class_2246.field_10144.method_9564();
                }
                case SWAMPORDARKFOREST: {
                    return (class_2680)class_2246.field_10010.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11052);
                }
            }
            return class_2246.field_10299.method_9564();
        }

        protected class_2680 getFillingBlock() {
            if (this.mineShaftType == Type.OCEAN) {
                return class_2246.field_10382.method_9564();
            }
            return class_2246.field_10543.method_9564();
        }

        protected class_2680 getRailBlock() {
            if (this.mineShaftType == Type.OCEAN) {
                return (class_2680)class_2246.field_10137.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
            }
            return (class_2680)class_2246.field_10167.method_9564().method_11657((class_2769)class_2443.field_11369, (Comparable)class_2768.field_12665);
        }

        protected class_1299<?> getSpawnerMob(Random random) {
            switch (this.mineShaftType) {
                case ICY: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(ICY_SPAWNER_ID, random);
                }
                case JUNGLE: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(JUNGLE_SPAWNER_ID, random);
                }
                case TAIGA: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(TAIGA_SPAWNER_ID, random);
                }
                case DESERT: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(DESERT_SPAWNER_ID, random);
                }
                case END: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(END_SPAWNER_ID, random);
                }
                case NETHER: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(NETHER_SPAWNER_ID, random);
                }
                case OCEAN: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(OCEAN_SPAWNER_ID, random);
                }
                case STONE: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(STONE_SPAWNER_ID, random);
                }
                case SAVANNA: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(SAVANNA_SPAWNER_ID, random);
                }
                case SWAMPORDARKFOREST: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(SWAMPORDARKFOREST_SPAWNER_ID, random);
                }
            }
            return RepurposedStructures.mobSpawnerManager.getSpawnerMob(BIRCH_SPAWNER_ID, random);
        }

        protected class_2680 getDecorativeBlock(Random random) {
            switch (this.mineShaftType) {
                case OCEAN: {
                    return random.nextBoolean() ? class_2246.field_10376.method_9564() : class_2246.field_10238.method_9564();
                }
                case ICY: {
                    return class_2246.field_10295.method_9564();
                }
                case NETHER: {
                    return class_2246.field_10036.method_9564();
                }
                case END: {
                    return (class_2680)class_2246.field_10528.method_9564().method_11657((class_2769)class_2279.field_10762, (Comparable)Integer.valueOf(5));
                }
            }
            return class_2246.field_10343.method_9564();
        }
    }

    public static class Stairs
    extends Piece {
        public Stairs(int p_i50449_1_, class_3341 p_i50449_2_, class_2350 p_i50449_3_, Type p_i50449_4_) {
            super(StructurePieces.MINESHAFT_STAIRS_RS, p_i50449_1_, p_i50449_4_);
            this.method_14926(p_i50449_3_);
            this.field_15315 = p_i50449_2_;
        }

        public Stairs(class_3485 p_i50450_1_, class_2487 p_i50450_2_) {
            super(StructurePieces.MINESHAFT_STAIRS_RS, p_i50450_2_);
        }

        public static class_3341 findStairs(List<class_3443> listIn, Random rand, int x, int y, int z, class_2350 facing) {
            class_3341 MutableBoundingBox = new class_3341(x, y - 5, z, x, y + 2, z);
            switch (facing) {
                default: {
                    MutableBoundingBox.field_14378 = x + 2;
                    MutableBoundingBox.field_14379 = z - 8;
                    break;
                }
                case field_11035: {
                    MutableBoundingBox.field_14378 = x + 2;
                    MutableBoundingBox.field_14376 = z + 8;
                    break;
                }
                case field_11039: {
                    MutableBoundingBox.field_14381 = x - 8;
                    MutableBoundingBox.field_14376 = z + 2;
                    break;
                }
                case field_11034: {
                    MutableBoundingBox.field_14378 = x + 8;
                    MutableBoundingBox.field_14376 = z + 2;
                }
            }
            return class_3443.method_14932(listIn, (class_3341)MutableBoundingBox) != null ? null : MutableBoundingBox;
        }

        public void method_14918(class_3443 componentIn, List<class_3443> listIn, Random rand) {
            int i = this.method_14923();
            class_2350 enumfacing = this.method_14934();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381, this.field_15315.field_14380, this.field_15315.field_14379 - 1, class_2350.field_11043, i);
                        break;
                    }
                    case field_11035: {
                        RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381, this.field_15315.field_14380, this.field_15315.field_14376 + 1, class_2350.field_11035, i);
                        break;
                    }
                    case field_11039: {
                        RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 - 1, this.field_15315.field_14380, this.field_15315.field_14379, class_2350.field_11039, i);
                        break;
                    }
                    case field_11034: {
                        RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14378 + 1, this.field_15315.field_14380, this.field_15315.field_14379, class_2350.field_11034, i);
                    }
                }
            }
        }

        public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
            boolean isOceanType;
            boolean bl = isOceanType = this.mineShaftType == Type.OCEAN;
            if (isOceanType ? this.isAirInStructureBoundingBox((class_1922)world, box) : this.method_14937((class_1922)world, box)) {
                return false;
            }
            this.method_14940((class_1936)world, box, 0, 5, 0, 2, 7, 1, this.getFillingBlock(), this.getFillingBlock(), false);
            this.method_14940((class_1936)world, box, 0, 0, 7, 2, 2, 8, this.getFillingBlock(), this.getFillingBlock(), false);
            for (int i = 0; i < 5; ++i) {
                this.method_14940((class_1936)world, box, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, this.getFillingBlock(), this.getFillingBlock(), false);
            }
            if (this.mineShaftType == Type.JUNGLE) {
                this.fillWithVines(world, random, box, 5, 0, 0, 0, 2, 7, 8);
            } else if (this.mineShaftType == Type.SWAMPORDARKFOREST) {
                this.fillWithVines(world, random, box, 2, 0, 0, 0, 2, 7, 8);
            }
            return true;
        }
    }

    public static class Room
    extends Piece {
        private final List<class_3341> roomsLinkedToTheRoom = Lists.newLinkedList();

        public Room(int p_i47137_1_, Random p_i47137_2_, int p_i47137_3_, int p_i47137_4_, Type p_i47137_5_) {
            super(StructurePieces.MINESHAFT_ROOM_RS, p_i47137_1_, p_i47137_5_);
            this.mineShaftType = p_i47137_5_;
            this.field_15315 = new class_3341(p_i47137_3_, 50, p_i47137_4_, p_i47137_3_ + 7 + p_i47137_2_.nextInt(6), 54 + p_i47137_2_.nextInt(6), p_i47137_4_ + 7 + p_i47137_2_.nextInt(6));
        }

        public Room(class_3485 p_i50451_1_, class_2487 p_i50451_2_) {
            super(StructurePieces.MINESHAFT_ROOM_RS, p_i50451_2_);
            class_2499 listnbt = p_i50451_2_.method_10554("Entrances", 11);
            for (int i = 0; i < listnbt.size(); ++i) {
                this.roomsLinkedToTheRoom.add(new class_3341(listnbt.method_10610(i)));
            }
        }

        @Override
        protected void method_14943(class_2487 tagCompound) {
            super.method_14943(tagCompound);
            class_2499 listnbt = new class_2499();
            for (class_3341 mutableboundingbox : this.roomsLinkedToTheRoom) {
                listnbt.add((Object)mutableboundingbox.method_14658());
            }
            tagCompound.method_10566("Entrances", (class_2520)listnbt);
        }

        public void method_14918(class_3443 componentIn, List<class_3443> listIn, Random rand) {
            int l;
            int i = this.method_14923();
            int k = this.field_15315.method_14663() - 3 - 1;
            if (k <= 0) {
                k = 1;
            }
            int j = 0;
            while (j < this.field_15315.method_14660() && (l = j + rand.nextInt(this.field_15315.method_14660())) + 3 <= this.field_15315.method_14660()) {
                Piece structuremineshaftpieces$peice = RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 + l, this.field_15315.field_14380 + rand.nextInt(k) + 1, this.field_15315.field_14379 - 1, class_2350.field_11043, i);
                if (structuremineshaftpieces$peice != null) {
                    class_3341 MutableBoundingBox = structuremineshaftpieces$peice.method_14935();
                    this.roomsLinkedToTheRoom.add(new class_3341(MutableBoundingBox.field_14381, MutableBoundingBox.field_14380, this.field_15315.field_14379, MutableBoundingBox.field_14378, MutableBoundingBox.field_14377, this.field_15315.field_14379 + 1));
                }
                j = l + 4;
            }
            int i1 = 0;
            while (i1 < this.field_15315.method_14660() && (l = i1 + rand.nextInt(this.field_15315.method_14660())) + 3 <= this.field_15315.method_14660()) {
                Piece structuremineshaftpieces$peice1 = RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 + l, this.field_15315.field_14380 + rand.nextInt(k) + 1, this.field_15315.field_14376 + 1, class_2350.field_11035, i);
                if (structuremineshaftpieces$peice1 != null) {
                    class_3341 MutableBoundingBox1 = structuremineshaftpieces$peice1.method_14935();
                    this.roomsLinkedToTheRoom.add(new class_3341(MutableBoundingBox1.field_14381, MutableBoundingBox1.field_14380, this.field_15315.field_14376 - 1, MutableBoundingBox1.field_14378, MutableBoundingBox1.field_14377, this.field_15315.field_14376));
                }
                i1 = l + 4;
            }
            int j1 = 0;
            while (j1 < this.field_15315.method_14664() && (l = j1 + rand.nextInt(this.field_15315.method_14664())) + 3 <= this.field_15315.method_14664()) {
                Piece structuremineshaftpieces$peice2 = RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 - 1, this.field_15315.field_14380 + rand.nextInt(k) + 1, this.field_15315.field_14379 + l, class_2350.field_11039, i);
                if (structuremineshaftpieces$peice2 != null) {
                    class_3341 MutableBoundingBox2 = structuremineshaftpieces$peice2.method_14935();
                    this.roomsLinkedToTheRoom.add(new class_3341(this.field_15315.field_14381, MutableBoundingBox2.field_14380, MutableBoundingBox2.field_14379, this.field_15315.field_14381 + 1, MutableBoundingBox2.field_14377, MutableBoundingBox2.field_14376));
                }
                j1 = l + 4;
            }
            int k1 = 0;
            while (k1 < this.field_15315.method_14664() && (l = k1 + rand.nextInt(this.field_15315.method_14664())) + 3 <= this.field_15315.method_14664()) {
                Piece StructurePiece = RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14378 + 1, this.field_15315.field_14380 + rand.nextInt(k) + 1, this.field_15315.field_14379 + l, class_2350.field_11034, i);
                if (StructurePiece != null) {
                    class_3341 MutableBoundingBox3 = StructurePiece.method_14935();
                    this.roomsLinkedToTheRoom.add(new class_3341(this.field_15315.field_14378 - 1, MutableBoundingBox3.field_14380, MutableBoundingBox3.field_14379, this.field_15315.field_14378, MutableBoundingBox3.field_14377, MutableBoundingBox3.field_14376));
                }
                k1 = l + 4;
            }
        }

        public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
            class_2680 flooring = this.mineShaftType == Type.NETHER ? class_2246.field_10114.method_9564() : (this.mineShaftType == Type.END ? class_2246.field_10462.method_9564() : (this.mineShaftType == Type.OCEAN ? class_2246.field_10460.method_9564() : (this.getFloorBlock().method_26207() == class_3614.field_15932 ? class_2246.field_10253.method_9564() : this.getFloorBlock())));
            this.method_14940((class_1936)world, box, this.field_15315.field_14381, this.field_15315.field_14380, this.field_15315.field_14379, this.field_15315.field_14378, this.field_15315.field_14380, this.field_15315.field_14376, flooring, this.getFillingBlock(), false);
            this.method_14940((class_1936)world, box, this.field_15315.field_14381, this.field_15315.field_14380 + 1, this.field_15315.field_14379, this.field_15315.field_14378, Math.min(this.field_15315.field_14380 + 3, this.field_15315.field_14377), this.field_15315.field_14376, this.getFillingBlock(), this.getFillingBlock(), false);
            if (this.mineShaftType == Type.NETHER) {
                this.method_14933((class_1936)world, box, world.method_8409(), 0.3f, this.field_15315.field_14381, this.field_15315.field_14380 + 1, this.field_15315.field_14379, this.field_15315.field_14378, this.field_15315.field_14380 + 1, this.field_15315.field_14376, (class_2680)class_2246.field_9974.method_9564().method_11657((class_2769)class_2421.field_11306, (Comparable)Integer.valueOf(2)), (class_2680)class_2246.field_9974.method_9564().method_11657((class_2769)class_2421.field_11306, (Comparable)Integer.valueOf(2)), false, false);
            }
            for (class_3341 MutableBoundingBox : this.roomsLinkedToTheRoom) {
                this.method_14940((class_1936)world, box, MutableBoundingBox.field_14381, MutableBoundingBox.field_14377 - 2, MutableBoundingBox.field_14379, MutableBoundingBox.field_14378, MutableBoundingBox.field_14377, MutableBoundingBox.field_14376, this.getFillingBlock(), this.getFillingBlock(), false);
            }
            this.method_14919((class_1936)world, box, this.field_15315.field_14381, this.field_15315.field_14380 + 4, this.field_15315.field_14379, this.field_15315.field_14378, this.field_15315.field_14377, this.field_15315.field_14376, this.getFillingBlock(), false);
            if (this.mineShaftType == Type.JUNGLE) {
                this.fillWithVines(world, random, box, 5, this.field_15315.field_14381, this.field_15315.field_14380, this.field_15315.field_14379, this.field_15315.field_14378, this.field_15315.field_14377 + 4, this.field_15315.field_14376);
            } else if (this.mineShaftType == Type.SWAMPORDARKFOREST) {
                this.fillWithVines(world, random, box, 2, this.field_15315.field_14381, this.field_15315.field_14380, this.field_15315.field_14379, this.field_15315.field_14378, this.field_15315.field_14377 + 4, this.field_15315.field_14376);
            }
            return true;
        }

        public void method_14922(int x, int y, int z) {
            super.method_14922(x, y, z);
            for (class_3341 MutableBoundingBox : this.roomsLinkedToTheRoom) {
                MutableBoundingBox.method_14661(x, y, z);
            }
        }
    }

    public static class Cross
    extends Piece {
        private final class_2350 corridorDirection;
        private final boolean isMultipleFloors;

        public Cross(class_3485 p_i50454_1_, class_2487 p_i50454_2_) {
            super(StructurePieces.MINESHAFT_CROSSING_RS, p_i50454_2_);
            this.isMultipleFloors = p_i50454_2_.method_10577("tf");
            this.corridorDirection = class_2350.method_10139((int)p_i50454_2_.method_10550("D"));
        }

        @Override
        protected void method_14943(class_2487 tagCompound) {
            super.method_14943(tagCompound);
            tagCompound.method_10556("tf", this.isMultipleFloors);
            tagCompound.method_10569("D", this.corridorDirection.method_10161());
        }

        public Cross(int p_i50455_1_, class_3341 p_i50455_2_, class_2350 p_i50455_3_, Type p_i50455_4_) {
            super(StructurePieces.MINESHAFT_CROSSING_RS, p_i50455_1_, p_i50455_4_);
            this.corridorDirection = p_i50455_3_;
            this.field_15315 = p_i50455_2_;
            this.isMultipleFloors = p_i50455_2_.method_14663() > 3;
        }

        public static class_3341 findCrossing(List<class_3443> listIn, Random rand, int x, int y, int z, class_2350 facing) {
            class_3341 MutableBoundingBox = new class_3341(x, y, z, x, y + 2, z);
            if (rand.nextInt(4) == 0) {
                MutableBoundingBox.field_14377 += 4;
            }
            switch (facing) {
                default: {
                    MutableBoundingBox.field_14381 = x - 1;
                    MutableBoundingBox.field_14378 = x + 3;
                    MutableBoundingBox.field_14379 = z - 4;
                    break;
                }
                case field_11035: {
                    MutableBoundingBox.field_14381 = x - 1;
                    MutableBoundingBox.field_14378 = x + 3;
                    MutableBoundingBox.field_14376 = z + 3 + 1;
                    break;
                }
                case field_11039: {
                    MutableBoundingBox.field_14381 = x - 4;
                    MutableBoundingBox.field_14379 = z - 1;
                    MutableBoundingBox.field_14376 = z + 3;
                    break;
                }
                case field_11034: {
                    MutableBoundingBox.field_14378 = x + 3 + 1;
                    MutableBoundingBox.field_14379 = z - 1;
                    MutableBoundingBox.field_14376 = z + 3;
                }
            }
            return class_3443.method_14932(listIn, (class_3341)MutableBoundingBox) != null ? null : MutableBoundingBox;
        }

        public void method_14918(class_3443 componentIn, List<class_3443> listIn, Random rand) {
            int i = this.method_14923();
            switch (this.corridorDirection) {
                default: {
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 + 1, this.field_15315.field_14380, this.field_15315.field_14379 - 1, class_2350.field_11043, i);
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 - 1, this.field_15315.field_14380, this.field_15315.field_14379 + 1, class_2350.field_11039, i);
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14378 + 1, this.field_15315.field_14380, this.field_15315.field_14379 + 1, class_2350.field_11034, i);
                    break;
                }
                case field_11035: {
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 + 1, this.field_15315.field_14380, this.field_15315.field_14376 + 1, class_2350.field_11035, i);
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 - 1, this.field_15315.field_14380, this.field_15315.field_14379 + 1, class_2350.field_11039, i);
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14378 + 1, this.field_15315.field_14380, this.field_15315.field_14379 + 1, class_2350.field_11034, i);
                    break;
                }
                case field_11039: {
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 + 1, this.field_15315.field_14380, this.field_15315.field_14379 - 1, class_2350.field_11043, i);
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 + 1, this.field_15315.field_14380, this.field_15315.field_14376 + 1, class_2350.field_11035, i);
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 - 1, this.field_15315.field_14380, this.field_15315.field_14379 + 1, class_2350.field_11039, i);
                    break;
                }
                case field_11034: {
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 + 1, this.field_15315.field_14380, this.field_15315.field_14379 - 1, class_2350.field_11043, i);
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 + 1, this.field_15315.field_14380, this.field_15315.field_14376 + 1, class_2350.field_11035, i);
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14378 + 1, this.field_15315.field_14380, this.field_15315.field_14379 + 1, class_2350.field_11034, i);
                }
            }
            if (this.isMultipleFloors) {
                if (rand.nextBoolean()) {
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 + 1, this.field_15315.field_14380 + 3 + 1, this.field_15315.field_14379 - 1, class_2350.field_11043, i);
                }
                if (rand.nextBoolean()) {
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 - 1, this.field_15315.field_14380 + 3 + 1, this.field_15315.field_14379 + 1, class_2350.field_11039, i);
                }
                if (rand.nextBoolean()) {
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14378 + 1, this.field_15315.field_14380 + 3 + 1, this.field_15315.field_14379 + 1, class_2350.field_11034, i);
                }
                if (rand.nextBoolean()) {
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 + 1, this.field_15315.field_14380 + 3 + 1, this.field_15315.field_14376 + 1, class_2350.field_11035, i);
                }
            }
        }

        public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
            boolean isOceanType;
            boolean bl = isOceanType = this.mineShaftType == Type.OCEAN;
            if (isOceanType ? this.isAirInStructureBoundingBox((class_1922)world, box) : this.method_14937((class_1922)world, box)) {
                return false;
            }
            class_2680 iblockstate = this.getFloorBlock();
            if (this.isMultipleFloors) {
                this.method_14940((class_1936)world, box, this.field_15315.field_14381 + 1, this.field_15315.field_14380, this.field_15315.field_14379, this.field_15315.field_14378 - 1, this.field_15315.field_14380 + 3 - 1, this.field_15315.field_14376, this.getFillingBlock(), this.getFillingBlock(), false);
                this.method_14940((class_1936)world, box, this.field_15315.field_14381, this.field_15315.field_14380, this.field_15315.field_14379 + 1, this.field_15315.field_14378, this.field_15315.field_14380 + 3 - 1, this.field_15315.field_14376 - 1, this.getFillingBlock(), this.getFillingBlock(), false);
                this.method_14940((class_1936)world, box, this.field_15315.field_14381 + 1, this.field_15315.field_14377 - 2, this.field_15315.field_14379, this.field_15315.field_14378 - 1, this.field_15315.field_14377, this.field_15315.field_14376, this.getFillingBlock(), this.getFillingBlock(), false);
                this.method_14940((class_1936)world, box, this.field_15315.field_14381, this.field_15315.field_14377 - 2, this.field_15315.field_14379 + 1, this.field_15315.field_14378, this.field_15315.field_14377, this.field_15315.field_14376 - 1, this.getFillingBlock(), this.getFillingBlock(), false);
                this.method_14940((class_1936)world, box, this.field_15315.field_14381 + 1, this.field_15315.field_14380 + 3, this.field_15315.field_14379 + 1, this.field_15315.field_14378 - 1, this.field_15315.field_14380 + 3, this.field_15315.field_14376 - 1, this.getFillingBlock(), this.getFillingBlock(), false);
            } else {
                this.method_14940((class_1936)world, box, this.field_15315.field_14381 + 1, this.field_15315.field_14380, this.field_15315.field_14379, this.field_15315.field_14378 - 1, this.field_15315.field_14377, this.field_15315.field_14376, this.getFillingBlock(), this.getFillingBlock(), false);
                this.method_14940((class_1936)world, box, this.field_15315.field_14381, this.field_15315.field_14380, this.field_15315.field_14379 + 1, this.field_15315.field_14378, this.field_15315.field_14377, this.field_15315.field_14376 - 1, this.getFillingBlock(), this.getFillingBlock(), false);
            }
            this.placeSupportPillar(world, box, this.field_15315.field_14381 + 1, this.field_15315.field_14380, this.field_15315.field_14379 + 1, this.field_15315.field_14377, isOceanType);
            this.placeSupportPillar(world, box, this.field_15315.field_14381 + 1, this.field_15315.field_14380, this.field_15315.field_14376 - 1, this.field_15315.field_14377, isOceanType);
            this.placeSupportPillar(world, box, this.field_15315.field_14378 - 1, this.field_15315.field_14380, this.field_15315.field_14379 + 1, this.field_15315.field_14377, isOceanType);
            this.placeSupportPillar(world, box, this.field_15315.field_14378 - 1, this.field_15315.field_14380, this.field_15315.field_14376 - 1, this.field_15315.field_14377, isOceanType);
            for (int i = this.field_15315.field_14381; i <= this.field_15315.field_14378; ++i) {
                for (int j = this.field_15315.field_14379; j <= this.field_15315.field_14376; ++j) {
                    if (this.method_14929((class_1922)world, i, this.field_15315.field_14380 - 1, j, box).method_26207() != (isOceanType ? class_3614.field_15920 : class_3614.field_15959) || !this.method_14939((class_4538)world, i, this.field_15315.field_14380 - 1, j, box)) continue;
                    this.method_14917((class_1936)world, iblockstate, i, this.field_15315.field_14380 - 1, j, box);
                }
            }
            if (this.mineShaftType == Type.JUNGLE) {
                this.fillWithVines(world, random, box, 5, this.field_15315.field_14381, this.field_15315.field_14380, this.field_15315.field_14379, this.field_15315.field_14378, this.field_15315.field_14377, this.field_15315.field_14376);
            } else if (this.mineShaftType == Type.SWAMPORDARKFOREST) {
                this.fillWithVines(world, random, box, 2, this.field_15315.field_14381, this.field_15315.field_14380, this.field_15315.field_14379, this.field_15315.field_14378, this.field_15315.field_14377, this.field_15315.field_14376);
            }
            return true;
        }

        private void placeSupportPillar(class_5281 world, class_3341 box, int x, int miny, int z, int maxy, boolean isOceanType) {
            if (this.method_14929((class_1922)world, x, maxy + 1, z, box).method_26207() != (isOceanType ? class_3614.field_15920 : class_3614.field_15959)) {
                this.method_14940((class_1936)world, box, x, miny, z, x, maxy, z, this.getFloorBlock().method_27852(class_2246.field_10219) ? class_2246.field_10065.method_9564() : this.getFloorBlock(), this.getFillingBlock(), false);
            }
        }
    }

    public static class Corridor
    extends Piece {
        private final boolean hasRails;
        private final boolean attemptSpawnerCreation;
        private boolean spawnerPlaced;
        private final int sectionCount;

        public Corridor(class_3485 p_i50456_1_, class_2487 p_i50456_2_) {
            super(StructurePieces.MINESHAFT_CORRIDOR_RS, p_i50456_2_);
            this.hasRails = p_i50456_2_.method_10577("hr");
            this.attemptSpawnerCreation = p_i50456_2_.method_10577("sc");
            this.spawnerPlaced = p_i50456_2_.method_10577("hps");
            this.sectionCount = p_i50456_2_.method_10550("Num");
        }

        @Override
        protected void method_14943(class_2487 tagCompound) {
            super.method_14943(tagCompound);
            tagCompound.method_10556("hr", this.hasRails);
            tagCompound.method_10556("sc", this.attemptSpawnerCreation);
            tagCompound.method_10556("hps", this.spawnerPlaced);
            tagCompound.method_10569("Num", this.sectionCount);
        }

        public Corridor(int p_i47140_1_, Random p_i47140_2_, class_3341 p_i47140_3_, class_2350 p_i47140_4_, Type p_i47140_5_) {
            super(StructurePieces.MINESHAFT_CORRIDOR_RS, p_i47140_1_, p_i47140_5_);
            this.method_14926(p_i47140_4_);
            this.field_15315 = p_i47140_3_;
            boolean bl = this.hasRails = p_i47140_2_.nextInt(3) == 0;
            this.attemptSpawnerCreation = this.mineShaftType == Type.END ? !this.hasRails && p_i47140_2_.nextInt(5) == 0 : !this.hasRails && p_i47140_2_.nextInt(20) == 0;
            this.sectionCount = Objects.requireNonNull(this.method_14934()).method_10166() == class_2350.class_2351.field_11051 ? p_i47140_3_.method_14664() / 5 : p_i47140_3_.method_14660() / 5;
        }

        public static class_3341 findCorridorSize(List<class_3443> p_175814_0_, Random rand, int x, int y, int z, class_2350 facing) {
            int i;
            class_3341 MutableBoundingBox = new class_3341(x, y, z, x, y + 2, z);
            for (i = rand.nextInt(3) + 2; i > 0; --i) {
                int j = i * 5;
                switch (facing) {
                    default: {
                        MutableBoundingBox.field_14378 = x + 2;
                        MutableBoundingBox.field_14379 = z - (j - 1);
                        break;
                    }
                    case field_11035: {
                        MutableBoundingBox.field_14378 = x + 2;
                        MutableBoundingBox.field_14376 = z + (j - 1);
                        break;
                    }
                    case field_11039: {
                        MutableBoundingBox.field_14381 = x - (j - 1);
                        MutableBoundingBox.field_14376 = z + 2;
                        break;
                    }
                    case field_11034: {
                        MutableBoundingBox.field_14378 = x + (j - 1);
                        MutableBoundingBox.field_14376 = z + 2;
                    }
                }
                if (class_3443.method_14932(p_175814_0_, (class_3341)MutableBoundingBox) == null) break;
            }
            return i > 0 ? MutableBoundingBox : null;
        }

        public void method_14918(class_3443 componentIn, List<class_3443> listIn, Random rand) {
            block24: {
                int i = this.method_14923();
                int j = rand.nextInt(4);
                class_2350 enumfacing = this.method_14934();
                if (enumfacing != null) {
                    switch (enumfacing) {
                        default: {
                            if (j <= 1) {
                                RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381, this.field_15315.field_14380 - 1 + rand.nextInt(3), this.field_15315.field_14379 - 1, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 - 1, this.field_15315.field_14380 - 1 + rand.nextInt(3), this.field_15315.field_14379, class_2350.field_11039, i);
                                break;
                            }
                            RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14378 + 1, this.field_15315.field_14380 - 1 + rand.nextInt(3), this.field_15315.field_14379, class_2350.field_11034, i);
                            break;
                        }
                        case field_11035: {
                            if (j <= 1) {
                                RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381, this.field_15315.field_14380 - 1 + rand.nextInt(3), this.field_15315.field_14376 + 1, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 - 1, this.field_15315.field_14380 - 1 + rand.nextInt(3), this.field_15315.field_14376 - 3, class_2350.field_11039, i);
                                break;
                            }
                            RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14378 + 1, this.field_15315.field_14380 - 1 + rand.nextInt(3), this.field_15315.field_14376 - 3, class_2350.field_11034, i);
                            break;
                        }
                        case field_11039: {
                            if (j <= 1) {
                                RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 - 1, this.field_15315.field_14380 - 1 + rand.nextInt(3), this.field_15315.field_14379, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381, this.field_15315.field_14380 - 1 + rand.nextInt(3), this.field_15315.field_14379 - 1, class_2350.field_11043, i);
                                break;
                            }
                            RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381, this.field_15315.field_14380 - 1 + rand.nextInt(3), this.field_15315.field_14376 + 1, class_2350.field_11035, i);
                            break;
                        }
                        case field_11034: {
                            if (j <= 1) {
                                RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14378 + 1, this.field_15315.field_14380 - 1 + rand.nextInt(3), this.field_15315.field_14379, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14378 - 3, this.field_15315.field_14380 - 1 + rand.nextInt(3), this.field_15315.field_14379 - 1, class_2350.field_11043, i);
                                break;
                            }
                            RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14378 - 3, this.field_15315.field_14380 - 1 + rand.nextInt(3), this.field_15315.field_14376 + 1, class_2350.field_11035, i);
                        }
                    }
                }
                if (i >= 8) break block24;
                if (enumfacing != class_2350.field_11043 && enumfacing != class_2350.field_11035) {
                    int i1 = this.field_15315.field_14381 + 3;
                    while (i1 + 3 <= this.field_15315.field_14378) {
                        int j1 = rand.nextInt(5);
                        if (j1 == 0) {
                            RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, i1, this.field_15315.field_14380, this.field_15315.field_14379 - 1, class_2350.field_11043, i + 1);
                        } else if (j1 == 1) {
                            RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, i1, this.field_15315.field_14380, this.field_15315.field_14376 + 1, class_2350.field_11035, i + 1);
                        }
                        i1 += 5;
                    }
                } else {
                    int k = this.field_15315.field_14379 + 3;
                    while (k + 3 <= this.field_15315.field_14376) {
                        int l = rand.nextInt(5);
                        if (l == 0) {
                            RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14381 - 1, this.field_15315.field_14380, k, class_2350.field_11039, i + 1);
                        } else if (l == 1) {
                            RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_15315.field_14378 + 1, this.field_15315.field_14380, k, class_2350.field_11034, i + 1);
                        }
                        k += 5;
                    }
                }
            }
        }

        protected boolean method_14915(class_1936 world, class_3341 boundingBox, Random random, int x, int y, int z, class_2960 lootTableId) {
            class_2338 blockpos = new class_2338(this.method_14928(x, z), this.method_14924(y), this.method_14941(x, z));
            class_3614 currentMaterial = world.method_8320(blockpos).method_26207();
            if (boundingBox.method_14662((class_2382)blockpos) && (currentMaterial == class_3614.field_15959 || currentMaterial == class_3614.field_15920)) {
                class_2680 blockstate = currentMaterial == class_3614.field_15959 ? (class_2680)class_2246.field_10167.method_9564().method_11657((class_2769)class_2443.field_11369, (Comparable)(random.nextBoolean() ? class_2768.field_12665 : class_2768.field_12674)) : (class_2680)class_2246.field_10137.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
                this.method_14917(world, blockstate, x, y, z, boundingBox);
                class_1694 entityminecartchest = new class_1694(world.method_8410(), (double)((float)blockpos.method_10263() + 0.5f), (double)((float)blockpos.method_10264() + 0.5f), (double)((float)blockpos.method_10260() + 0.5f));
                entityminecartchest.method_7562(lootTableId, random.nextLong());
                world.method_8649((class_1297)entityminecartchest);
                return true;
            }
            return false;
        }

        public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
            int z;
            int x;
            boolean isOceanType;
            boolean bl = isOceanType = this.mineShaftType == Type.OCEAN;
            if (isOceanType ? this.isAirInStructureBoundingBox((class_1922)world, box) : this.method_14937((class_1922)world, box)) {
                return false;
            }
            int offsetInSection = this.sectionCount * 5 - 1;
            class_2680 iblockstate = this.getFloorBlock();
            this.method_14940((class_1936)world, box, 0, 0, 0, 2, 1, offsetInSection, this.getFillingBlock(), this.getFillingBlock(), false);
            this.method_14933((class_1936)world, box, random, 0.8f, 0, 2, 0, 2, 2, offsetInSection, this.getFillingBlock(), this.getFillingBlock(), false, false);
            if (this.attemptSpawnerCreation) {
                if (isOceanType || this.mineShaftType == Type.NETHER || this.mineShaftType == Type.END) {
                    this.method_14933((class_1936)world, box, random, 0.6f, 0, 0, 0, 2, 0, offsetInSection, this.getDecorativeBlock(random), this.getDecorativeBlock(random), false, true);
                    for (x = 0; x <= 2; ++x) {
                        for (z = 0; z <= offsetInSection; ++z) {
                            if (!this.method_14929((class_1922)world, x, 0, z, box).method_27852(class_2246.field_10528)) continue;
                            this.method_14917((class_1936)world, class_2246.field_10471.method_9564(), x, -1, z, box);
                        }
                    }
                } else {
                    this.method_14933((class_1936)world, box, random, 0.6f, 0, 0, 0, 2, 1, offsetInSection, this.getDecorativeBlock(random), this.getFillingBlock(), false, true);
                }
            }
            for (int j1 = 0; j1 < this.sectionCount; ++j1) {
                int k1 = 2 + j1 * 5;
                this.placeSupport(world, box, 0, 0, k1, 2, 2, random);
                this.placeDecoration(world, box, random, 0.1f, 0, 2, k1 - 1);
                this.placeDecoration(world, box, random, 0.1f, 2, 2, k1 - 1);
                this.placeDecoration(world, box, random, 0.1f, 0, 2, k1 + 1);
                this.placeDecoration(world, box, random, 0.1f, 2, 2, k1 + 1);
                this.placeDecoration(world, box, random, 0.05f, 0, 2, k1 - 2);
                this.placeDecoration(world, box, random, 0.05f, 2, 2, k1 - 2);
                this.placeDecoration(world, box, random, 0.05f, 0, 2, k1 + 2);
                this.placeDecoration(world, box, random, 0.05f, 2, 2, k1 + 2);
                if (RepurposedStructures.RSAllConfig.RSMineshaftsConfig.lootChestsMS) {
                    if (random.nextInt(50) == 0) {
                        this.method_14915((class_1936)world, box, random, 2, 0, k1 - 1, this.getChestLoot());
                    }
                    if (random.nextInt(50) == 0) {
                        this.method_14915((class_1936)world, box, random, 0, 0, k1 + 1, this.getChestLoot());
                    }
                }
                if (this.attemptSpawnerCreation && (!this.spawnerPlaced || this.mineShaftType == Type.END && random.nextBoolean())) {
                    int k2;
                    int l1 = this.method_14924(0);
                    int i2 = k1 - 1 + random.nextInt(3);
                    int j2 = this.method_14928(1, i2);
                    class_2338 blockpos = new class_2338(j2, l1, k2 = this.method_14941(1, i2));
                    if (box.method_14662((class_2382)blockpos) && this.method_14939((class_4538)world, 1, 0, i2, box)) {
                        this.spawnerPlaced = true;
                        world.method_8652(blockpos, class_2246.field_10260.method_9564(), 2);
                        class_2586 tileentity = world.method_8321(blockpos);
                        if (tileentity instanceof class_2636) {
                            ((class_2636)tileentity).method_11390().method_8274(this.getSpawnerMob(random));
                        }
                    }
                }
                if (this.mineShaftType != Type.END || !(random.nextFloat() < 0.3f)) continue;
                this.method_14940((class_1936)world, box, 0, 0, 0, 2, 2, 0, (class_2680)((class_2680)class_2246.field_10152.method_9564().method_11657((class_2769)class_2389.field_10907, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2389.field_10903, (Comparable)Boolean.valueOf(true)), (class_2680)((class_2680)class_2246.field_10152.method_9564().method_11657((class_2769)class_2389.field_10905, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2389.field_10904, (Comparable)Boolean.valueOf(true)), false);
            }
            for (x = 0; x <= 2; ++x) {
                for (z = 0; z <= offsetInSection; ++z) {
                    class_2680 spaceForFloor = this.method_14929((class_1922)world, x, -1, z, box);
                    if (!(isOceanType ? spaceForFloor.method_26207() == class_3614.field_15920 : spaceForFloor.method_26207() == class_3614.field_15959)) continue;
                    this.method_14917((class_1936)world, iblockstate, x, -1, z, box);
                }
            }
            if (this.hasRails) {
                class_2680 blockstate = this.getRailBlock();
                for (int j3 = 0; j3 <= offsetInSection; ++j3) {
                    class_2680 spaceForRails = this.method_14929((class_1922)world, 1, -1, j3, box);
                    if (!(isOceanType ? spaceForRails.method_26207() != class_3614.field_15920 : spaceForRails.method_26207() != class_3614.field_15959)) continue;
                    float f = this.method_14939((class_4538)world, 1, 0, j3, box) ? 0.7f : 0.9f;
                    this.method_14945((class_1936)world, box, random, f, 1, 0, j3, blockstate);
                }
            }
            if (this.mineShaftType == Type.JUNGLE) {
                this.fillWithVines(world, random, box, 5, 0, 0, 0, 2, 2, offsetInSection);
            } else if (this.mineShaftType == Type.SWAMPORDARKFOREST) {
                this.fillWithVines(world, random, box, 2, 0, 0, 0, 2, 2, offsetInSection);
            }
            return true;
        }

        private void placeSupport(class_5281 world, class_3341 boundingBox, int x, int y2, int z, int y, int x2, Random random) {
            class_2680 iblockstate = this.getArchTopBlock();
            class_2680 iblockstate2 = this.getFillingBlock();
            this.method_14940((class_1936)world, boundingBox, x, y2, z, x, y - 1, z, this.getArchSupportBlock(random), iblockstate2, false);
            this.method_14940((class_1936)world, boundingBox, x2, y2, z, x2, y - 1, z, this.getArchSupportBlock(random), iblockstate2, false);
            this.method_14940((class_1936)world, boundingBox, x, y, z, x2, y, z, iblockstate, iblockstate2, false);
            if (this.mineShaftType == Type.END) {
                if (random.nextFloat() < 0.08f) {
                    this.method_14945((class_1936)world, boundingBox, random, 1.0f, x, y, z - 1, (class_2680)class_2246.field_10455.method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11035));
                    this.method_14945((class_1936)world, boundingBox, random, 1.0f, x, y, z + 1, (class_2680)class_2246.field_10455.method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11043));
                }
                if (random.nextFloat() < 0.08f) {
                    this.method_14945((class_1936)world, boundingBox, random, 1.0f, x + 2, y, z - 1, (class_2680)class_2246.field_10455.method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11035));
                    this.method_14945((class_1936)world, boundingBox, random, 1.0f, x + 2, y, z + 1, (class_2680)class_2246.field_10455.method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11043));
                }
            } else if (this.mineShaftType == Type.NETHER) {
                if (random.nextFloat() < 0.3f) {
                    this.method_14945((class_1936)world, boundingBox, random, 0.45f, x + 1, y, z, class_2246.field_22122.method_9564());
                } else {
                    this.method_14945((class_1936)world, boundingBox, random, 0.1f, x + 1, y, z - 1, (class_2680)class_2246.field_22093.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)class_2350.field_11035));
                    this.method_14945((class_1936)world, boundingBox, random, 0.1f, x + 1, y, z + 1, (class_2680)class_2246.field_22093.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)class_2350.field_11043));
                }
            } else if (this.mineShaftType == Type.OCEAN) {
                this.method_14945((class_1936)world, boundingBox, random, 0.2f, x + 1, y, z, class_2246.field_10174.method_9564());
            } else if (this.mineShaftType == Type.ICY) {
                this.method_14945((class_1936)world, boundingBox, random, 0.08f, x + 1, y, z - 1, (class_2680)class_2246.field_10301.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)class_2350.field_11035));
                this.method_14945((class_1936)world, boundingBox, random, 0.08f, x + 1, y, z + 1, (class_2680)class_2246.field_10301.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)class_2350.field_11043));
            } else {
                this.method_14945((class_1936)world, boundingBox, random, 0.08f, x + 1, y, z - 1, (class_2680)class_2246.field_10099.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)class_2350.field_11035));
                this.method_14945((class_1936)world, boundingBox, random, 0.08f, x + 1, y, z + 1, (class_2680)class_2246.field_10099.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)class_2350.field_11043));
            }
        }

        private void placeDecoration(class_5281 world, class_3341 box, Random random, float probability, int x, int y, int z) {
            if (world.method_8597() != class_2874.method_29563() || this.method_14939((class_4538)world, x, y, z, box)) {
                class_2680 decorativeBlock = this.getDecorativeBlock(random);
                if (!decorativeBlock.method_27852(class_2246.field_10343)) {
                    y = 0;
                }
                this.method_14945((class_1936)world, box, random, probability, x, y, z, decorativeBlock);
                if (this.method_14929((class_1922)world, x, y, z, box).method_27852(class_2246.field_10528)) {
                    this.method_14917((class_1936)world, class_2246.field_10471.method_9564(), x, -1, z, box);
                    this.method_14917((class_1936)world, (class_2680)((class_2680)class_2246.field_10021.method_9564().method_11657((class_2769)class_2429.field_11327, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2429.field_11330, (Comparable)Boolean.valueOf(true)), x, 0, z, box);
                    this.method_14917((class_1936)world, (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)class_2246.field_10021.method_9564().method_11657((class_2769)class_2429.field_11331, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2429.field_11332, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2429.field_11335, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2429.field_11328, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2429.field_11330, (Comparable)Boolean.valueOf(true)), x, 1, z, box);
                    if (random.nextBoolean()) {
                        if (this.method_14929((class_1922)world, x - 1, 1, z, box).method_26215()) {
                            this.method_14917((class_1936)world, (class_2680)class_2246.field_10528.method_9564().method_11657((class_2769)class_2279.field_10762, (Comparable)Integer.valueOf(5)), x - 1, 1, z, box);
                        } else {
                            this.method_14917((class_1936)world, (class_2680)class_2246.field_10528.method_9564().method_11657((class_2769)class_2279.field_10762, (Comparable)Integer.valueOf(5)), x, 1, z, box);
                        }
                    } else if (this.method_14929((class_1922)world, x + 1, 1, z, box).method_26215()) {
                        this.method_14917((class_1936)world, (class_2680)class_2246.field_10528.method_9564().method_11657((class_2769)class_2279.field_10762, (Comparable)Integer.valueOf(5)), x + 1, 1, z, box);
                    } else {
                        this.method_14917((class_1936)world, (class_2680)class_2246.field_10528.method_9564().method_11657((class_2769)class_2279.field_10762, (Comparable)Integer.valueOf(5)), x, 1, z, box);
                    }
                }
            }
        }
    }

    public static enum Type {
        ICY,
        BIRCH,
        JUNGLE,
        TAIGA,
        DESERT,
        STONE,
        SAVANNA,
        SWAMPORDARKFOREST,
        END,
        NETHER,
        OCEAN;


        public static Type byId(int id) {
            return id >= 0 && id < Type.values().length ? Type.values()[id] : BIRCH;
        }
    }
}

