/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features.structures;

import com.google.common.collect.Lists;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.mixin.StrongholdGeneratorAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.StructurePieceAccessor;
import com.telepathicgrunt.repurposedstructures.world.features.structures.StructurePieces;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2310;
import net.minecraft.class_2323;
import net.minecraft.class_2333;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2399;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2510;
import net.minecraft.class_2555;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3421;
import net.minecraft.class_3443;
import net.minecraft.class_3481;
import net.minecraft.class_3485;
import net.minecraft.class_3494;
import net.minecraft.class_3610;
import net.minecraft.class_3773;
import net.minecraft.class_39;
import net.minecraft.class_5138;
import net.minecraft.class_5281;

public class RSStrongholdPieces {
    private static final class_2960 NETHER_STRONGHOLD_BOOKSHELF_RL = new class_2960("repurposed_structures:nether_stronghold_bookshelves");
    private static final class_2960 STONEBRICK_SPAWNER_ID = new class_2960("repurposed_structures:stronghold_stonebrick");
    private static final class_2960 STONEBRICK_PORTAL_SPAWNER_ID = new class_2960("repurposed_structures:stronghold_stonebrick_portal_room");
    private static final class_2960 NETHER_SPAWNER_ID = new class_2960("repurposed_structures:stronghold_nether");
    private static final class_2960 NETHER_PORTAL_SPAWNER_ID = new class_2960("repurposed_structures:stronghold_nether_portal_room");
    private static final List<PieceWeight> PIECE_WEIGHTS = new ArrayList<PieceWeight>();
    private static List<PieceWeight> structurePieceList;
    private static Class<? extends Stronghold> strongComponentType;
    static int totalWeight;
    private static final Map<class_2248, class_2248> NETHER_BLOCK_MAP;

    public static void prepareStructurePieces() {
        structurePieceList = Lists.newArrayList();
        for (PieceWeight structurestrongholdpieces$pieceweight : PIECE_WEIGHTS) {
            structurestrongholdpieces$pieceweight.instancesSpawned = 0;
            structurePieceList.add(structurestrongholdpieces$pieceweight);
        }
        strongComponentType = null;
    }

    private static boolean canAddStructurePieces() {
        boolean flag = false;
        totalWeight = 0;
        for (PieceWeight structurestrongholdpieces$pieceweight : structurePieceList) {
            if (structurestrongholdpieces$pieceweight.instancesLimit > 0) {
                String name = structurestrongholdpieces$pieceweight.pieceClass.getSimpleName();
                if (name.equals("PortalRoom")) {
                    if (structurestrongholdpieces$pieceweight.instancesSpawned < 1) {
                        flag = true;
                    }
                } else {
                    int maxLimit = (int)((double)structurestrongholdpieces$pieceweight.instancesLimit * (RepurposedStructures.RSAllConfig.RSStrongholdsConfig.strongholdSizeSH * 0.01));
                    if (structurestrongholdpieces$pieceweight.instancesSpawned <= maxLimit) {
                        flag = true;
                    }
                }
            }
            totalWeight += structurestrongholdpieces$pieceweight.pieceWeight;
        }
        return flag;
    }

    private static Stronghold findAndCreatePieceFactory(Class<? extends class_3421.class_3437> pieceClass, List<class_3443> piecesList, Random random, int xStart, int yStart, int zStart, class_2350 direction, int distanceFromStart, Type stronghold$type) {
        Stronghold structurestrongholdpieces$stronghold = null;
        if (pieceClass == Straight.class) {
            structurestrongholdpieces$stronghold = Straight.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == Prison.class) {
            structurestrongholdpieces$stronghold = Prison.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == LeftTurn.class) {
            structurestrongholdpieces$stronghold = LeftTurn.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == RightTurn.class) {
            structurestrongholdpieces$stronghold = RightTurn.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == RoomCrossing.class) {
            structurestrongholdpieces$stronghold = RoomCrossing.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == StairsStraight.class) {
            structurestrongholdpieces$stronghold = StairsStraight.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == Stairs.class) {
            structurestrongholdpieces$stronghold = Stairs.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == Crossing.class) {
            structurestrongholdpieces$stronghold = Crossing.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == ChestCorridor.class) {
            structurestrongholdpieces$stronghold = ChestCorridor.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == Library.class) {
            structurestrongholdpieces$stronghold = Library.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == PortalRoom.class) {
            structurestrongholdpieces$stronghold = PortalRoom.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        }
        return structurestrongholdpieces$stronghold;
    }

    private static Stronghold generatePieceFromSmallDoor(EntranceStairs p_175955_0_, List<class_3443> p_175955_1_, Random random, int x, int y, int z, class_2350 p_175955_6_, int componentType) {
        Type stronghold$type = p_175955_0_.strongholdType;
        if (!RSStrongholdPieces.canAddStructurePieces()) {
            return null;
        }
        if (strongComponentType != null) {
            Stronghold structurestrongholdpieces$stronghold = RSStrongholdPieces.findAndCreatePieceFactory(strongComponentType, p_175955_1_, random, x, y, z, p_175955_6_, componentType, stronghold$type);
            strongComponentType = null;
            if (structurestrongholdpieces$stronghold != null) {
                return structurestrongholdpieces$stronghold;
            }
        }
        int j = 0;
        block0: while (j < 5) {
            ++j;
            int randomWeight = random.nextInt(totalWeight);
            for (PieceWeight structurestrongholdpieces$pieceweight : structurePieceList) {
                if ((randomWeight -= structurestrongholdpieces$pieceweight.pieceWeight) >= 0) continue;
                if (!structurestrongholdpieces$pieceweight.canSpawnMoreStructures(componentType) || structurestrongholdpieces$pieceweight == p_175955_0_.strongholdPieceWeight) continue block0;
                Stronghold structurestrongholdpieces$stronghold1 = RSStrongholdPieces.findAndCreatePieceFactory(structurestrongholdpieces$pieceweight.pieceClass, p_175955_1_, random, x, y, z, p_175955_6_, componentType, stronghold$type);
                if (structurestrongholdpieces$stronghold1 == null) continue;
                ++structurestrongholdpieces$pieceweight.instancesSpawned;
                p_175955_0_.strongholdPieceWeight = structurestrongholdpieces$pieceweight;
                if (!structurestrongholdpieces$pieceweight.canSpawnMoreStructures()) {
                    structurePieceList.remove(structurestrongholdpieces$pieceweight);
                }
                return structurestrongholdpieces$stronghold1;
            }
        }
        class_3341 mutableboundingbox = Corridor.findPieceBox(p_175955_1_, random, x, y, z, p_175955_6_);
        if (mutableboundingbox != null && mutableboundingbox.field_14380 > 1) {
            return new Corridor(componentType, mutableboundingbox, p_175955_6_, stronghold$type);
        }
        return null;
    }

    private static class_3443 generateAndAddPiece(EntranceStairs p_175953_0_, List<class_3443> p_175953_1_, Random p_175953_2_, int p_175953_3_, int p_175953_4_, int p_175953_5_, class_2350 p_175953_6_, int distanceFromStart) {
        int maxComponents = (int)(50.0 * (RepurposedStructures.RSAllConfig.RSStrongholdsConfig.strongholdSizeSH * 0.01));
        if (distanceFromStart > maxComponents) {
            return null;
        }
        if (Math.abs(p_175953_3_ - p_175953_0_.method_14935().field_14381) <= 112 && Math.abs(p_175953_5_ - p_175953_0_.method_14935().field_14379) <= 112) {
            Stronghold StructurePiece = RSStrongholdPieces.generatePieceFromSmallDoor(p_175953_0_, p_175953_1_, p_175953_2_, p_175953_3_, p_175953_4_, p_175953_5_, p_175953_6_, distanceFromStart + 1);
            if (StructurePiece != null) {
                p_175953_1_.add((class_3443)StructurePiece);
                p_175953_0_.pendingChildren.add((class_3443)StructurePiece);
            }
            return StructurePiece;
        }
        return null;
    }

    static {
        NETHER_BLOCK_MAP = new HashMap<class_2248, class_2248>();
        NETHER_BLOCK_MAP.put(class_2246.field_10056, class_2246.field_10266);
        NETHER_BLOCK_MAP.put(class_2246.field_10131, class_2246.field_10390);
        NETHER_BLOCK_MAP.put(class_2246.field_10392, class_2246.field_10159);
        NETHER_BLOCK_MAP.put(class_2246.field_10445, class_2246.field_10114);
        NETHER_BLOCK_MAP.put(class_2246.field_10596, class_2246.field_10497);
        NETHER_BLOCK_MAP.put(class_2246.field_10351, class_2246.field_10478);
        NETHER_BLOCK_MAP.put(class_2246.field_10454, class_2246.field_10478);
        NETHER_BLOCK_MAP.put(class_2246.field_10576, class_2246.field_10364);
        NETHER_BLOCK_MAP.put(class_2246.field_10161, class_2246.field_22505);
        NETHER_BLOCK_MAP.put(class_2246.field_10620, class_2246.field_22132);
        NETHER_BLOCK_MAP.put(class_2246.field_10382, class_2246.field_10164);
        NETHER_BLOCK_MAP.put(class_2246.field_10099, class_2246.field_22093);
        NETHER_BLOCK_MAP.put(class_2246.field_10336, class_2246.field_22092);
        NETHER_BLOCK_MAP.put(class_2246.field_10494, class_2246.field_23864);
        NETHER_BLOCK_MAP.put(class_2246.field_9973, class_2246.field_22102);
        PIECE_WEIGHTS.add(new PieceWeight(Straight.class, 40, 0));
        PIECE_WEIGHTS.add(new PieceWeight(Prison.class, 5, 8));
        PIECE_WEIGHTS.add(new PieceWeight(LeftTurn.class, 20, 0));
        PIECE_WEIGHTS.add(new PieceWeight(RightTurn.class, 20, 0));
        PIECE_WEIGHTS.add(new PieceWeight(RoomCrossing.class, 10, 9));
        PIECE_WEIGHTS.add(new PieceWeight(StairsStraight.class, 5, 7));
        PIECE_WEIGHTS.add(new PieceWeight(Stairs.class, 5, 7));
        PIECE_WEIGHTS.add(new PieceWeight(Crossing.class, 5, 7));
        PIECE_WEIGHTS.add(new PieceWeight(ChestCorridor.class, 5, 16));
        PIECE_WEIGHTS.add(new PieceWeight(Library.class, 10, 6){

            @Override
            public boolean canSpawnMoreStructures(int distanceFromStart) {
                return super.canSpawnMoreStructures(distanceFromStart) && distanceFromStart > 4;
            }
        });
        PIECE_WEIGHTS.add(new PieceWeight(PortalRoom.class, 20, 1){

            @Override
            public boolean canSpawnMoreStructures(int distanceFromStart) {
                return this.instancesSpawned < 1 && distanceFromStart > 5;
            }

            @Override
            public boolean canSpawnMoreStructures() {
                return this.instancesSpawned < 1;
            }
        });
        for (class_3421.class_3427 piece : StrongholdGeneratorAccessor.getALL_PIECE_SETTINGS()) {
            try {
                if (piece.field_15276.getEnclosingClass().getName().contains(class_3421.class.getName())) continue;
                PIECE_WEIGHTS.add(new PieceWeight(piece.field_15276, piece.field_15278, piece.field_15275));
            }
            catch (Exception e) {
                PIECE_WEIGHTS.add(new PieceWeight(piece.field_15276, piece.field_15278, piece.field_15275));
            }
        }
    }

    public static abstract class Turn
    extends Stronghold {
        protected Turn(class_3773 pieceType, int componentType, Type strongholdType) {
            super(pieceType, componentType, strongholdType);
        }

        public Turn(class_3773 pieceType, class_2487 data) {
            super(pieceType, data);
        }
    }

    static abstract class Stronghold
    extends class_3421.class_3437 {
        protected Door entryDoor = Door.OPENING;
        protected Type strongholdType;

        protected Stronghold(class_3773 pieceType, int componentType, Type strongholdType) {
            super(pieceType, componentType);
            this.strongholdType = strongholdType;
        }

        public Stronghold(class_3773 pieceType, class_2487 data) {
            super(pieceType, data);
            this.entryDoor = Door.valueOf(data.method_10558("EntryDoor"));
            this.strongholdType = Type.byId(data.method_10550("SHT"));
        }

        protected void method_14943(class_2487 data) {
            data.method_10582("EntryDoor", this.entryDoor.name());
            data.method_10569("SHT", this.strongholdType.ordinal());
        }

        protected void placeDoor(class_5281 world, Random random, class_3341 mutableBox, Door spawnDoor, int xStart, int yStart, int zStart) {
            switch (spawnDoor) {
                case OPENING: {
                    this.method_14940((class_1936)world, mutableBox, xStart, yStart, zStart, xStart + 3 - 1, yStart + 3 - 1, zStart, class_2246.field_10124.method_9564(), class_2246.field_10124.method_9564(), false);
                    break;
                }
                case WOOD_DOOR: {
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), xStart, yStart, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), xStart, yStart + 1, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), xStart, yStart + 2, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), xStart + 1, yStart + 2, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), xStart + 2, yStart + 2, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), xStart + 2, yStart + 1, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), xStart + 2, yStart, zStart, mutableBox);
                    if (this.strongholdType == Type.NETHER) {
                        this.method_14917((class_1936)world, class_2246.field_10364.method_9564(), xStart + 1, yStart, zStart, mutableBox);
                        this.method_14917((class_1936)world, class_2246.field_10364.method_9564(), xStart + 1, yStart + 1, zStart, mutableBox);
                        break;
                    }
                    this.method_14917((class_1936)world, class_2246.field_10149.method_9564(), xStart + 1, yStart, zStart, mutableBox);
                    this.method_14917((class_1936)world, (class_2680)class_2246.field_10149.method_9564().method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12609), xStart + 1, yStart + 1, zStart, mutableBox);
                    break;
                }
                case GRATES: {
                    this.method_14917((class_1936)world, class_2246.field_10124.method_9564(), xStart + 1, yStart, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10124.method_9564(), xStart + 1, yStart + 1, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10576.method_9564(), xStart, yStart, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10576.method_9564(), xStart, yStart + 1, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10576.method_9564(), xStart, yStart + 2, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10576.method_9564(), xStart + 1, yStart + 2, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10576.method_9564(), xStart + 2, yStart + 2, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10576.method_9564(), xStart + 2, yStart + 1, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10576.method_9564(), xStart + 2, yStart, zStart, mutableBox);
                    break;
                }
                case IRON_DOOR: {
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), xStart, yStart, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), xStart, yStart + 1, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), xStart, yStart + 2, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), xStart + 1, yStart + 2, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), xStart + 2, yStart + 2, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), xStart + 2, yStart + 1, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), xStart + 2, yStart, zStart, mutableBox);
                    this.method_14917((class_1936)world, class_2246.field_9973.method_9564(), xStart + 1, yStart, zStart, mutableBox);
                    this.method_14917((class_1936)world, (class_2680)class_2246.field_9973.method_9564().method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12609), xStart + 1, yStart + 1, zStart, mutableBox);
                    this.method_14917((class_1936)world, (class_2680)class_2246.field_10494.method_9564().method_11657((class_2769)class_2383.field_11177, (Comparable)class_2350.field_11043), xStart + 2, yStart + 1, zStart + 1, mutableBox);
                    this.method_14917((class_1936)world, (class_2680)class_2246.field_10494.method_9564().method_11657((class_2769)class_2383.field_11177, (Comparable)class_2350.field_11035), xStart + 2, yStart + 1, zStart - 1, mutableBox);
                }
            }
        }

        protected Door getRandomDoor(Random random) {
            int i = random.nextInt(5);
            switch (i) {
                default: {
                    return Door.OPENING;
                }
                case 2: {
                    return Door.WOOD_DOOR;
                }
                case 3: {
                    return Door.GRATES;
                }
                case 4: 
            }
            return Door.IRON_DOOR;
        }

        protected class_2680 getBlockOfCorrectType(class_2680 blockstate) {
            if (this.strongholdType == Type.NETHER && NETHER_BLOCK_MAP.containsKey(blockstate.method_26204())) {
                class_2680 newBlockstate = ((class_2248)NETHER_BLOCK_MAP.get(blockstate.method_26204())).method_9564();
                for (class_2769 property : blockstate.method_28501()) {
                    if (!newBlockstate.method_28498(property)) continue;
                    newBlockstate = Stronghold.syncBlockProperties(newBlockstate, blockstate, property);
                }
                return newBlockstate;
            }
            return blockstate;
        }

        private static <T extends Comparable<T>> class_2680 syncBlockProperties(class_2680 newBlock, class_2680 oldBlock, class_2769<T> property) {
            return (class_2680)newBlock.method_11657(property, oldBlock.method_11654(property));
        }

        protected void method_14917(class_1936 world, class_2680 block, int x, int y, int z, class_3341 blockBox) {
            block = this.getBlockOfCorrectType(block);
            class_2338 blockPos = new class_2338(this.method_14928(x, z), this.method_14924(y), this.method_14941(x, z));
            if (blockBox.method_14662((class_2382)blockPos)) {
                if (((StructurePieceAccessor)((Object)this)).getMirror() != class_2415.field_11302) {
                    block = block.method_26185(((StructurePieceAccessor)((Object)this)).getMirror());
                }
                if (((StructurePieceAccessor)((Object)this)).getRotation() != class_2470.field_11467) {
                    block = block.method_26186(((StructurePieceAccessor)((Object)this)).getRotation());
                }
                world.method_8652(blockPos, block, 2);
                class_3610 fluidState = world.method_8316(blockPos);
                if (!fluidState.method_15769()) {
                    world.method_8405().method_8676(blockPos, (Object)fluidState.method_15772(), 0);
                }
                if (((StructurePieceAccessor)((Object)this)).getBLOCKS_NEEDING_POST_PROCESSING().contains(block.method_26204())) {
                    world.method_22350(blockPos).method_12039(blockPos);
                }
            }
        }

        protected class_1299<?> getSpawnerEntity(Random random, boolean isPortalRoom) {
            if (this.strongholdType == Type.NETHER) {
                if (isPortalRoom) {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(NETHER_PORTAL_SPAWNER_ID, random);
                }
                return RepurposedStructures.mobSpawnerManager.getSpawnerMob(NETHER_SPAWNER_ID, random);
            }
            if (isPortalRoom) {
                return RepurposedStructures.mobSpawnerManager.getSpawnerMob(STONEBRICK_PORTAL_SPAWNER_ID, random);
            }
            return RepurposedStructures.mobSpawnerManager.getSpawnerMob(STONEBRICK_SPAWNER_ID, random);
        }

        protected class_2960 getHallwayChestLoot() {
            if (this.strongholdType == Type.NETHER) {
                return new class_2960("repurposed_structures:chests/stronghold_nether_hallway");
            }
            return class_39.field_842;
        }

        protected class_2960 getStorageChestLoot() {
            if (this.strongholdType == Type.NETHER) {
                return new class_2960("repurposed_structures:chests/stronghold_nether_storage_room");
            }
            return class_39.field_842;
        }

        protected class_3443 getNextComponentNormal(EntranceStairs p_74986_1_, List<class_3443> p_74986_2_, Random p_74986_3_, int p_74986_4_, int p_74986_5_) {
            class_2350 enumfacing = this.method_14934();
            if (enumfacing != null) {
                switch (enumfacing) {
                    case field_11043: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74986_1_, p_74986_2_, p_74986_3_, this.field_15315.field_14381 + p_74986_4_, this.field_15315.field_14380 + p_74986_5_, this.field_15315.field_14379 - 1, enumfacing, this.method_14923());
                    }
                    case field_11035: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74986_1_, p_74986_2_, p_74986_3_, this.field_15315.field_14381 + p_74986_4_, this.field_15315.field_14380 + p_74986_5_, this.field_15315.field_14376 + 1, enumfacing, this.method_14923());
                    }
                    case field_11039: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74986_1_, p_74986_2_, p_74986_3_, this.field_15315.field_14381 - 1, this.field_15315.field_14380 + p_74986_5_, this.field_15315.field_14379 + p_74986_4_, enumfacing, this.method_14923());
                    }
                    case field_11034: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74986_1_, p_74986_2_, p_74986_3_, this.field_15315.field_14378 + 1, this.field_15315.field_14380 + p_74986_5_, this.field_15315.field_14379 + p_74986_4_, enumfacing, this.method_14923());
                    }
                }
            }
            return null;
        }

        protected class_3443 getNextComponentX(EntranceStairs p_74989_1_, List<class_3443> p_74989_2_, Random p_74989_3_, int p_74989_4_, int p_74989_5_) {
            class_2350 enumfacing = this.method_14934();
            if (enumfacing != null) {
                switch (enumfacing) {
                    case field_11043: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74989_1_, p_74989_2_, p_74989_3_, this.field_15315.field_14381 - 1, this.field_15315.field_14380 + p_74989_4_, this.field_15315.field_14379 + p_74989_5_, class_2350.field_11039, this.method_14923());
                    }
                    case field_11035: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74989_1_, p_74989_2_, p_74989_3_, this.field_15315.field_14381 - 1, this.field_15315.field_14380 + p_74989_4_, this.field_15315.field_14379 + p_74989_5_, class_2350.field_11039, this.method_14923());
                    }
                    case field_11039: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74989_1_, p_74989_2_, p_74989_3_, this.field_15315.field_14381 + p_74989_5_, this.field_15315.field_14380 + p_74989_4_, this.field_15315.field_14379 - 1, class_2350.field_11043, this.method_14923());
                    }
                    case field_11034: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74989_1_, p_74989_2_, p_74989_3_, this.field_15315.field_14381 + p_74989_5_, this.field_15315.field_14380 + p_74989_4_, this.field_15315.field_14379 - 1, class_2350.field_11043, this.method_14923());
                    }
                }
            }
            return null;
        }

        protected class_3443 getNextComponentZ(EntranceStairs p_74987_1_, List<class_3443> p_74987_2_, Random p_74987_3_, int p_74987_4_, int p_74987_5_) {
            class_2350 enumfacing = this.method_14934();
            if (enumfacing != null) {
                switch (enumfacing) {
                    case field_11043: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74987_1_, p_74987_2_, p_74987_3_, this.field_15315.field_14378 + 1, this.field_15315.field_14380 + p_74987_4_, this.field_15315.field_14379 + p_74987_5_, class_2350.field_11034, this.method_14923());
                    }
                    case field_11035: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74987_1_, p_74987_2_, p_74987_3_, this.field_15315.field_14378 + 1, this.field_15315.field_14380 + p_74987_4_, this.field_15315.field_14379 + p_74987_5_, class_2350.field_11034, this.method_14923());
                    }
                    case field_11039: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74987_1_, p_74987_2_, p_74987_3_, this.field_15315.field_14381 + p_74987_5_, this.field_15315.field_14380 + p_74987_4_, this.field_15315.field_14376 + 1, class_2350.field_11035, this.method_14923());
                    }
                    case field_11034: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74987_1_, p_74987_2_, p_74987_3_, this.field_15315.field_14381 + p_74987_5_, this.field_15315.field_14380 + p_74987_4_, this.field_15315.field_14376 + 1, class_2350.field_11035, this.method_14923());
                    }
                }
            }
            return null;
        }

        protected static boolean canStrongholdGoDeeper(class_3341 box) {
            return box != null && box.field_14380 > 10;
        }

        public static enum Door {
            OPENING,
            WOOD_DOOR,
            GRATES,
            IRON_DOOR;

        }
    }

    public static class Straight
    extends Stronghold {
        private boolean expandsX;
        private boolean expandsZ;

        public Straight(int conponentType_, Random random, class_3341 box, class_2350 direction, Type strongholdType) {
            super(StructurePieces.STRONGHOLD_STRAIGHT, conponentType_, strongholdType);
            this.method_14926(direction);
            this.entryDoor = this.getRandomDoor(random);
            this.field_15315 = box;
            this.expandsX = random.nextInt(2) == 0;
            this.expandsZ = random.nextInt(2) == 0;
        }

        public Straight(class_3485 template, class_2487 data) {
            super(StructurePieces.STRONGHOLD_STRAIGHT, data);
            this.expandsX = data.method_10577("Left");
            this.expandsZ = data.method_10577("Right");
        }

        @Override
        protected void method_14943(class_2487 tagCompound) {
            super.method_14943(tagCompound);
            tagCompound.method_10556("Left", this.expandsX);
            tagCompound.method_10556("Right", this.expandsZ);
        }

        public void method_14918(class_3443 component, List<class_3443> piecesList, Random rand) {
            this.getNextComponentNormal((EntranceStairs)component, piecesList, rand, 1, 1);
            if (this.expandsX) {
                this.getNextComponentX((EntranceStairs)component, piecesList, rand, 1, 2);
            }
            if (this.expandsZ) {
                this.getNextComponentZ((EntranceStairs)component, piecesList, rand, 1, 2);
            }
        }

        public static Straight createPiece(List<class_3443> piecesList, Random random, int xStart, int yStart, int zStart, class_2350 direction, int distanceFromStart, Type strongholdType) {
            class_3341 mutableboundingbox = class_3341.method_14667((int)xStart, (int)yStart, (int)zStart, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)7, (class_2350)direction);
            return Straight.canStrongholdGoDeeper(mutableboundingbox) && class_3443.method_14932(piecesList, (class_3341)mutableboundingbox) == null ? new Straight(distanceFromStart, random, mutableboundingbox, direction, strongholdType) : null;
        }

        public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 structureBoundingBoxIn, class_1923 chunkPos, class_2338 blockPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 0, 0, 0, 4, 4, 6, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 1, 1, 0);
            this.placeDoor(world, random, structureBoundingBoxIn, Stronghold.Door.OPENING, 1, 1, 6);
            class_2680 iblockstate = (class_2680)class_2246.field_10099.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)class_2350.field_11034);
            class_2680 iblockstate1 = (class_2680)class_2246.field_10099.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)class_2350.field_11039);
            this.method_14945((class_1936)world, structureBoundingBoxIn, random, 0.1f, 1, 2, 1, iblockstate);
            this.method_14945((class_1936)world, structureBoundingBoxIn, random, 0.1f, 3, 2, 1, iblockstate1);
            this.method_14945((class_1936)world, structureBoundingBoxIn, random, 0.1f, 1, 2, 5, iblockstate);
            this.method_14945((class_1936)world, structureBoundingBoxIn, random, 0.1f, 3, 2, 5, iblockstate1);
            if (this.expandsX) {
                this.method_14940((class_1936)world, structureBoundingBoxIn, 0, 1, 2, 0, 3, 4, class_2246.field_10124.method_9564(), class_2246.field_10124.method_9564(), false);
            }
            if (this.expandsZ) {
                this.method_14940((class_1936)world, structureBoundingBoxIn, 4, 1, 2, 4, 3, 4, class_2246.field_10124.method_9564(), class_2246.field_10124.method_9564(), false);
            }
            return true;
        }
    }

    static class Stones
    extends class_3443.class_3444 {
        private static final Map<class_2680, class_2680> INFESTED_STONE_LOOKUP = new HashMap<class_2680, class_2680>();
        private Type type = null;

        private Stones(Type type) {
            this.type = type;
        }

        public void method_14948(Random rand, int x, int y, int z, boolean notAir) {
            if (notAir) {
                if (this.type == Type.NETHER) {
                    float chance = rand.nextFloat();
                    this.field_15317 = chance < 0.025f ? class_2246.field_10092.method_9564() : (chance < 0.07f ? class_2246.field_9986.method_9564() : (chance < 0.09f ? class_2246.field_23867.method_9564() : (chance < 0.15f ? class_2246.field_10266.method_9564() : (chance < 0.32f ? class_2246.field_23869.method_9564() : (chance < 0.35f ? class_2246.field_23876.method_9564() : (chance < 0.47f ? class_2246.field_23873.method_9564() : (chance < 0.471f ? class_2246.field_23880.method_9564() : (chance < 0.57f ? class_2246.field_23875.method_9564() : class_2246.field_23874.method_9564()))))))));
                } else {
                    float silverfishThreshold;
                    float chance = rand.nextFloat();
                    this.field_15317 = chance < 0.2f ? class_2246.field_10065.method_9564() : (chance < 0.5f ? class_2246.field_10416.method_9564() : class_2246.field_10056.method_9564());
                    chance = rand.nextFloat();
                    if (chance < (silverfishThreshold = (float)(RepurposedStructures.RSAllConfig.RSStrongholdsConfig.stonebrick.silverfishSpawnrateSH / 100.0))) {
                        this.field_15317 = INFESTED_STONE_LOOKUP.get(this.field_15317);
                    }
                }
            } else {
                this.field_15317 = class_2246.field_10543.method_9564();
            }
        }

        static {
            INFESTED_STONE_LOOKUP.put(class_2246.field_10056.method_9564(), class_2246.field_10387.method_9564());
            INFESTED_STONE_LOOKUP.put(class_2246.field_10340.method_9564(), class_2246.field_10277.method_9564());
            INFESTED_STONE_LOOKUP.put(class_2246.field_9989.method_9564(), class_2246.field_10480.method_9564());
            INFESTED_STONE_LOOKUP.put(class_2246.field_10416.method_9564(), class_2246.field_10100.method_9564());
            INFESTED_STONE_LOOKUP.put(class_2246.field_10445.method_9564(), class_2246.field_10492.method_9564());
            INFESTED_STONE_LOOKUP.put(class_2246.field_10552.method_9564(), class_2246.field_10176.method_9564());
            INFESTED_STONE_LOOKUP.put(class_2246.field_10065.method_9564(), class_2246.field_10065.method_9564());
        }
    }

    public static class StairsStraight
    extends Stronghold {
        public StairsStraight(int componentType, Random random, class_3341 box, class_2350 direction, Type strongholdType) {
            super(StructurePieces.STRONGHOLD_STAIRS_STRAIGHT, componentType, strongholdType);
            this.method_14926(direction);
            this.entryDoor = this.getRandomDoor(random);
            this.field_15315 = box;
        }

        public StairsStraight(class_3485 tmeplateManager, class_2487 data) {
            super(StructurePieces.STRONGHOLD_STAIRS_STRAIGHT, data);
        }

        public void method_14918(class_3443 piece, List<class_3443> piecesList, Random random) {
            this.getNextComponentNormal((EntranceStairs)piece, piecesList, random, 1, 1);
        }

        public static StairsStraight createPiece(List<class_3443> piecesList, Random random, int x, int y, int z, class_2350 direction, int componentType, Type strongholdType) {
            class_3341 mutableboundingbox = class_3341.method_14667((int)x, (int)y, (int)z, (int)-1, (int)-7, (int)0, (int)5, (int)11, (int)8, (class_2350)direction);
            return StairsStraight.canStrongholdGoDeeper(mutableboundingbox) && class_3443.method_14932(piecesList, (class_3341)mutableboundingbox) == null ? new StairsStraight(componentType, random, mutableboundingbox, direction, strongholdType) : null;
        }

        public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 structureBoundingBoxIn, class_1923 chunkPos, class_2338 blockPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 0, 0, 0, 4, 10, 7, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 1, 7, 0);
            this.placeDoor(world, random, structureBoundingBoxIn, Stronghold.Door.OPENING, 1, 1, 7);
            class_2680 iblockstate = (class_2680)class_2246.field_10392.method_9564().method_11657((class_2769)class_2510.field_11571, (Comparable)class_2350.field_11035);
            for (int i = 0; i < 6; ++i) {
                this.method_14917((class_1936)world, iblockstate, 1, 6 - i, 1 + i, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate, 2, 6 - i, 1 + i, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate, 3, 6 - i, 1 + i, structureBoundingBoxIn);
                if (i >= 5) continue;
                this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 1, 5 - i, 1 + i, structureBoundingBoxIn);
                this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 2, 5 - i, 1 + i, structureBoundingBoxIn);
                this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 3, 5 - i, 1 + i, structureBoundingBoxIn);
            }
            return true;
        }
    }

    public static class EntranceStairs
    extends Stairs {
        public PieceWeight strongholdPieceWeight;
        public PortalRoom strongholdPortalRoom;
        public List<class_3443> pendingChildren = Lists.newArrayList();

        public EntranceStairs(Random p_i50117_1_, int x, int z, Type strongholdType) {
            super(StructurePieces.STRONGHOLD_ENTRANCE_STAIRS, 0, p_i50117_1_, x, z, strongholdType);
        }

        public EntranceStairs(class_3485 p_i50118_1_, class_2487 p_i50118_2_) {
            super(StructurePieces.STRONGHOLD_ENTRANCE_STAIRS, p_i50118_2_);
        }
    }

    public static class Stairs
    extends Stronghold {
        private boolean source;

        public Stairs(class_3773 p_i50120_1_, int componentType, Random p_i50120_3_, int x, int z, Type strongholdType) {
            super(p_i50120_1_, componentType, strongholdType);
            this.source = true;
            this.method_14926(class_2350.class_2353.field_11062.method_10183(p_i50120_3_));
            this.entryDoor = Stronghold.Door.OPENING;
            this.field_15315 = this.method_14934().method_10166() == class_2350.class_2351.field_11051 ? new class_3341(x, 64, z, x + 5 - 1, 74, z + 5 - 1) : new class_3341(x, 64, z, x + 5 - 1, 74, z + 5 - 1);
        }

        public Stairs(int componentType, Random p_i45574_2_, class_3341 p_i45574_3_, class_2350 p_i45574_4_, Type strongholdType) {
            super(StructurePieces.STRONGHOLD_STAIRS, componentType, strongholdType);
            this.source = false;
            this.method_14926(p_i45574_4_);
            this.entryDoor = this.getRandomDoor(p_i45574_2_);
            this.field_15315 = p_i45574_3_;
        }

        public Stairs(class_3773 p_i50121_1_, class_2487 p_i50121_2_) {
            super(p_i50121_1_, p_i50121_2_);
            this.source = p_i50121_2_.method_10577("Source");
        }

        public Stairs(class_3485 templateManager, class_2487 data) {
            this(StructurePieces.STRONGHOLD_STAIRS, data);
        }

        @Override
        protected void method_14943(class_2487 tagCompound) {
            super.method_14943(tagCompound);
            tagCompound.method_10556("Source", this.source);
        }

        public void method_14918(class_3443 component, List<class_3443> piecesList, Random rand) {
            if (this.source) {
                strongComponentType = Crossing.class;
            }
            this.getNextComponentNormal((EntranceStairs)component, piecesList, rand, 1, 1);
        }

        public static Stairs createPiece(List<class_3443> p_175863_0_, Random p_175863_1_, int x, int y, int z, class_2350 p_175863_5_, int componentType, Type strongholdType) {
            class_3341 mutableboundingbox = class_3341.method_14667((int)x, (int)y, (int)z, (int)-1, (int)-7, (int)0, (int)5, (int)11, (int)5, (class_2350)p_175863_5_);
            return Stairs.canStrongholdGoDeeper(mutableboundingbox) && class_3443.method_14932(p_175863_0_, (class_3341)mutableboundingbox) == null ? new Stairs(componentType, p_175863_1_, mutableboundingbox, p_175863_5_, strongholdType) : null;
        }

        public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 structureBoundingBoxIn, class_1923 chunkPos, class_2338 blockPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 0, 0, 0, 4, 10, 4, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 1, 7, 0);
            this.placeDoor(world, random, structureBoundingBoxIn, Stronghold.Door.OPENING, 1, 1, 4);
            this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 2, 6, 1, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 1, 5, 1, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10454.method_9564(), 1, 6, 1, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 1, 5, 2, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 1, 4, 3, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10454.method_9564(), 1, 5, 3, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 2, 4, 3, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 3, 3, 3, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10454.method_9564(), 3, 4, 3, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 3, 3, 2, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 3, 2, 1, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10454.method_9564(), 3, 3, 1, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 2, 2, 1, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 1, 1, 1, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10454.method_9564(), 1, 2, 1, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 1, 1, 2, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10454.method_9564(), 1, 1, 3, structureBoundingBoxIn);
            return true;
        }
    }

    public static class RoomCrossing
    extends Stronghold {
        protected int roomType;

        public RoomCrossing(int componentType, Random p_i45575_2_, class_3341 p_i45575_3_, class_2350 p_i45575_4_, Type strongholdType) {
            super(StructurePieces.STRONGHOLD_ROOM_CROSSING, componentType, strongholdType);
            this.method_14926(p_i45575_4_);
            this.entryDoor = this.getRandomDoor(p_i45575_2_);
            this.field_15315 = p_i45575_3_;
            this.roomType = p_i45575_2_.nextInt(5);
        }

        public RoomCrossing(class_3485 p_i50125_1_, class_2487 p_i50125_2_) {
            super(StructurePieces.STRONGHOLD_ROOM_CROSSING, p_i50125_2_);
            this.roomType = p_i50125_2_.method_10550("Type");
        }

        @Override
        protected void method_14943(class_2487 tagCompound) {
            super.method_14943(tagCompound);
            tagCompound.method_10569("Type", this.roomType);
        }

        public void method_14918(class_3443 component, List<class_3443> piecesList, Random rand) {
            this.getNextComponentNormal((EntranceStairs)component, piecesList, rand, 4, 1);
            this.getNextComponentX((EntranceStairs)component, piecesList, rand, 1, 4);
            this.getNextComponentZ((EntranceStairs)component, piecesList, rand, 1, 4);
        }

        public static RoomCrossing createPiece(List<class_3443> p_175859_0_, Random p_175859_1_, int x, int y, int z, class_2350 p_175859_5_, int componentType, Type strongholdType) {
            class_3341 mutableboundingbox = class_3341.method_14667((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)11, (int)7, (int)11, (class_2350)p_175859_5_);
            return RoomCrossing.canStrongholdGoDeeper(mutableboundingbox) && class_3443.method_14932(p_175859_0_, (class_3341)mutableboundingbox) == null ? new RoomCrossing(componentType, p_175859_1_, mutableboundingbox, p_175859_5_, strongholdType) : null;
        }

        public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 structureBoundingBoxIn, class_1923 chunkPos, class_2338 blockPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 0, 0, 0, 10, 6, 10, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 4, 1, 0);
            this.method_14940((class_1936)world, structureBoundingBoxIn, 4, 1, 10, 6, 3, 10, class_2246.field_10124.method_9564(), class_2246.field_10124.method_9564(), false);
            this.method_14940((class_1936)world, structureBoundingBoxIn, 0, 1, 4, 0, 3, 6, class_2246.field_10124.method_9564(), class_2246.field_10124.method_9564(), false);
            this.method_14940((class_1936)world, structureBoundingBoxIn, 10, 1, 4, 10, 3, 6, class_2246.field_10124.method_9564(), class_2246.field_10124.method_9564(), false);
            switch (this.roomType) {
                case 0: {
                    class_2338 blockpos = new class_2338(this.method_14928(5, 5), this.method_14924(1), this.method_14941(5, 5));
                    if (structureBoundingBoxIn.method_14662((class_2382)blockpos)) {
                        if (RepurposedStructures.RSAllConfig.RSStrongholdsConfig.allowExtraSpawnersSH) {
                            world.method_8652(blockpos, class_2246.field_10260.method_9564(), 2);
                            class_2586 tileentity = world.method_8321(blockpos);
                            if (tileentity instanceof class_2636) {
                                ((class_2636)tileentity).method_11390().method_8274(this.getSpawnerEntity(random, false));
                            }
                        } else {
                            world.method_8652(blockpos, class_2246.field_10056.method_9564(), 2);
                        }
                    }
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 5, 2, 5, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 5, 3, 5, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, (class_2680)class_2246.field_10099.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)class_2350.field_11039), 4, 3, 5, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, (class_2680)class_2246.field_10099.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)class_2350.field_11034), 6, 3, 5, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, (class_2680)class_2246.field_10099.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)class_2350.field_11035), 5, 3, 4, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, (class_2680)class_2246.field_10099.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)class_2350.field_11043), 5, 3, 6, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10454.method_9564(), 4, 1, 4, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10454.method_9564(), 4, 1, 5, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10454.method_9564(), 4, 1, 6, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10454.method_9564(), 6, 1, 4, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10454.method_9564(), 6, 1, 5, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10454.method_9564(), 6, 1, 6, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10454.method_9564(), 5, 1, 4, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10454.method_9564(), 5, 1, 6, structureBoundingBoxIn);
                    break;
                }
                case 1: {
                    for (int i1 = 0; i1 < 5; ++i1) {
                        this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 3, 1, 3 + i1, structureBoundingBoxIn);
                        this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 7, 1, 3 + i1, structureBoundingBoxIn);
                        this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 3 + i1, 1, 3, structureBoundingBoxIn);
                        this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 3 + i1, 1, 7, structureBoundingBoxIn);
                    }
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 5, 2, 5, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 5, 3, 5, structureBoundingBoxIn);
                    class_2338 blockpos = new class_2338(this.method_14928(5, 5), this.method_14924(1), this.method_14941(5, 5));
                    if (structureBoundingBoxIn.method_14662((class_2382)blockpos)) {
                        if (RepurposedStructures.RSAllConfig.RSStrongholdsConfig.allowExtraSpawnersSH) {
                            world.method_8652(blockpos, class_2246.field_10260.method_9564(), 2);
                            class_2586 tileentity = world.method_8321(blockpos);
                            if (tileentity instanceof class_2636) {
                                ((class_2636)tileentity).method_11390().method_8274(this.getSpawnerEntity(random, false));
                            }
                        } else {
                            world.method_8652(blockpos, class_2246.field_10056.method_9564(), 2);
                        }
                    }
                    this.method_14917((class_1936)world, class_2246.field_10382.method_9564(), 5, 4, 5, structureBoundingBoxIn);
                    break;
                }
                case 2: 
                case 3: {
                    for (int i = 1; i <= 9; ++i) {
                        this.method_14917((class_1936)world, class_2246.field_10445.method_9564(), 1, 3, i, structureBoundingBoxIn);
                        this.method_14917((class_1936)world, class_2246.field_10445.method_9564(), 9, 3, i, structureBoundingBoxIn);
                    }
                    for (int j = 1; j <= 9; ++j) {
                        this.method_14917((class_1936)world, class_2246.field_10445.method_9564(), j, 3, 1, structureBoundingBoxIn);
                        this.method_14917((class_1936)world, class_2246.field_10445.method_9564(), j, 3, 9, structureBoundingBoxIn);
                    }
                    this.method_14917((class_1936)world, class_2246.field_10445.method_9564(), 5, 1, 4, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10445.method_9564(), 5, 1, 6, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10445.method_9564(), 5, 3, 4, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10445.method_9564(), 5, 3, 6, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10445.method_9564(), 4, 1, 5, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10445.method_9564(), 6, 1, 5, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10445.method_9564(), 4, 3, 5, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10445.method_9564(), 6, 3, 5, structureBoundingBoxIn);
                    for (int k = 1; k <= 3; ++k) {
                        this.method_14917((class_1936)world, class_2246.field_10445.method_9564(), 4, k, 4, structureBoundingBoxIn);
                        this.method_14917((class_1936)world, class_2246.field_10445.method_9564(), 6, k, 4, structureBoundingBoxIn);
                        this.method_14917((class_1936)world, class_2246.field_10445.method_9564(), 4, k, 6, structureBoundingBoxIn);
                        this.method_14917((class_1936)world, class_2246.field_10445.method_9564(), 6, k, 6, structureBoundingBoxIn);
                    }
                    class_2338 blockpos = new class_2338(this.method_14928(5, 5), this.method_14924(1), this.method_14941(5, 5));
                    if (structureBoundingBoxIn.method_14662((class_2382)blockpos)) {
                        if (RepurposedStructures.RSAllConfig.RSStrongholdsConfig.allowExtraSpawnersSH) {
                            world.method_8652(blockpos, class_2246.field_10260.method_9564(), 2);
                            class_2586 tileentity = world.method_8321(blockpos);
                            if (tileentity instanceof class_2636) {
                                ((class_2636)tileentity).method_11390().method_8274(this.getSpawnerEntity(random, false));
                            }
                            this.method_14917((class_1936)world, class_2246.field_10336.method_9564(), 5, 2, 5, structureBoundingBoxIn);
                        } else {
                            this.method_14917((class_1936)world, class_2246.field_10336.method_9564(), 5, 1, 5, structureBoundingBoxIn);
                        }
                    }
                    for (int l = 2; l <= 8; ++l) {
                        this.method_14917((class_1936)world, class_2246.field_10161.method_9564(), 2, 3, l, structureBoundingBoxIn);
                        this.method_14917((class_1936)world, class_2246.field_10161.method_9564(), 3, 3, l, structureBoundingBoxIn);
                        if (l <= 3 || l >= 7) {
                            this.method_14917((class_1936)world, class_2246.field_10161.method_9564(), 4, 3, l, structureBoundingBoxIn);
                            this.method_14917((class_1936)world, class_2246.field_10161.method_9564(), 5, 3, l, structureBoundingBoxIn);
                            this.method_14917((class_1936)world, class_2246.field_10161.method_9564(), 6, 3, l, structureBoundingBoxIn);
                        }
                        this.method_14917((class_1936)world, class_2246.field_10161.method_9564(), 7, 3, l, structureBoundingBoxIn);
                        this.method_14917((class_1936)world, class_2246.field_10161.method_9564(), 8, 3, l, structureBoundingBoxIn);
                    }
                    class_2680 iblockstate = (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11039);
                    this.method_14917((class_1936)world, iblockstate, 9, 1, 3, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, iblockstate, 9, 2, 3, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, iblockstate, 9, 3, 3, structureBoundingBoxIn);
                    if (!RepurposedStructures.RSAllConfig.RSStrongholdsConfig.lootChestsSH) break;
                    this.method_14915((class_1936)world, structureBoundingBoxIn, random, 3, 4, 8, this.getStorageChestLoot());
                    this.method_14915((class_1936)world, structureBoundingBoxIn, random, 5, 4, 2, this.getStorageChestLoot());
                    this.method_14915((class_1936)world, structureBoundingBoxIn, random, 6, 4, 8, this.getStorageChestLoot());
                    this.method_14915((class_1936)world, structureBoundingBoxIn, random, 8, 4, 4, this.getStorageChestLoot());
                }
            }
            return true;
        }
    }

    public static class RightTurn
    extends Turn {
        public RightTurn(int componentType, Random p_i50127_2_, class_3341 p_i50127_3_, class_2350 p_i50127_4_, Type strongholdType) {
            super(StructurePieces.STRONGHOLD_RIGHT_TURN, componentType, strongholdType);
            this.method_14926(p_i50127_4_);
            this.entryDoor = this.getRandomDoor(p_i50127_2_);
            this.field_15315 = p_i50127_3_;
        }

        public RightTurn(class_3485 p_i50128_1_, class_2487 p_i50128_2_) {
            super(StructurePieces.STRONGHOLD_RIGHT_TURN, p_i50128_2_);
        }

        public void method_14918(class_3443 component, List<class_3443> piecesList, Random rand) {
            class_2350 enumfacing = this.method_14934();
            if (enumfacing != class_2350.field_11043 && enumfacing != class_2350.field_11034) {
                this.getNextComponentX((EntranceStairs)component, piecesList, rand, 1, 1);
            } else {
                this.getNextComponentZ((EntranceStairs)component, piecesList, rand, 1, 1);
            }
        }

        public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 structureBoundingBoxIn, class_1923 chunkPos, class_2338 blockPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 0, 0, 0, 4, 4, 4, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 1, 1, 0);
            class_2350 enumfacing = this.method_14934();
            if (enumfacing != class_2350.field_11043 && enumfacing != class_2350.field_11034) {
                this.method_14940((class_1936)world, structureBoundingBoxIn, 0, 1, 1, 0, 3, 3, class_2246.field_10124.method_9564(), class_2246.field_10124.method_9564(), false);
            } else {
                this.method_14940((class_1936)world, structureBoundingBoxIn, 4, 1, 1, 4, 3, 3, class_2246.field_10124.method_9564(), class_2246.field_10124.method_9564(), false);
            }
            return true;
        }

        public static RightTurn createPiece(List<class_3443> p_214824_0_, Random p_214824_1_, int x, int y, int z, class_2350 p_214824_5_, int componentType, Type strongholdType) {
            class_3341 mutableboundingbox = class_3341.method_14667((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)5, (class_2350)p_214824_5_);
            return RightTurn.canStrongholdGoDeeper(mutableboundingbox) && class_3443.method_14932(p_214824_0_, (class_3341)mutableboundingbox) == null ? new RightTurn(componentType, p_214824_1_, mutableboundingbox, p_214824_5_, strongholdType) : null;
        }
    }

    public static class Prison
    extends Stronghold {
        public Prison(int componentType, Random p_i45576_2_, class_3341 p_i45576_3_, class_2350 p_i45576_4_, Type strongholdType) {
            super(StructurePieces.STRONGHOLD_PRISON, componentType, strongholdType);
            this.method_14926(p_i45576_4_);
            this.entryDoor = this.getRandomDoor(p_i45576_2_);
            this.field_15315 = p_i45576_3_;
        }

        public Prison(class_3485 p_i50133_1_, class_2487 p_i50130_2_) {
            super(StructurePieces.STRONGHOLD_PRISON, p_i50130_2_);
        }

        public void method_14918(class_3443 component, List<class_3443> piecesList, Random rand) {
            this.getNextComponentNormal((EntranceStairs)component, piecesList, rand, 1, 1);
        }

        public static Prison createPiece(List<class_3443> p_175860_0_, Random p_175860_1_, int x, int y, int z, class_2350 p_175860_5_, int componentType, Type strongholdType) {
            class_3341 mutableboundingbox = class_3341.method_14667((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)9, (int)5, (int)11, (class_2350)p_175860_5_);
            return Prison.canStrongholdGoDeeper(mutableboundingbox) && class_3443.method_14932(p_175860_0_, (class_3341)mutableboundingbox) == null ? new Prison(componentType, p_175860_1_, mutableboundingbox, p_175860_5_, strongholdType) : null;
        }

        public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 structureBoundingBoxIn, class_1923 chunkPos, class_2338 blockPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 0, 0, 0, 8, 4, 10, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 1, 1, 0);
            this.method_14940((class_1936)world, structureBoundingBoxIn, 1, 1, 10, 3, 3, 10, class_2246.field_10124.method_9564(), class_2246.field_10124.method_9564(), false);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 4, 1, 1, 4, 3, 1, false, random, randomStrongholdBlocks);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 4, 1, 3, 4, 3, 3, false, random, randomStrongholdBlocks);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 4, 1, 7, 4, 3, 7, false, random, randomStrongholdBlocks);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 4, 1, 9, 4, 3, 9, false, random, randomStrongholdBlocks);
            this.method_14940((class_1936)world, structureBoundingBoxIn, 4, 1, 4, 4, 3, 6, class_2246.field_10576.method_9564(), class_2246.field_10576.method_9564(), false);
            this.method_14940((class_1936)world, structureBoundingBoxIn, 5, 1, 5, 7, 3, 5, class_2246.field_10576.method_9564(), class_2246.field_10576.method_9564(), false);
            this.method_14917((class_1936)world, class_2246.field_10576.method_9564(), 4, 3, 2, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10576.method_9564(), 4, 3, 8, structureBoundingBoxIn);
            class_2680 iblockstate = (class_2680)class_2246.field_9973.method_9564().method_11657((class_2769)class_2323.field_10938, (Comparable)class_2350.field_11039);
            class_2680 iblockstate1 = (class_2680)((class_2680)class_2246.field_9973.method_9564().method_11657((class_2769)class_2323.field_10938, (Comparable)class_2350.field_11039)).method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12609);
            this.method_14917((class_1936)world, iblockstate, 4, 1, 2, structureBoundingBoxIn);
            this.method_14917((class_1936)world, iblockstate1, 4, 2, 2, structureBoundingBoxIn);
            this.method_14917((class_1936)world, iblockstate, 4, 1, 8, structureBoundingBoxIn);
            this.method_14917((class_1936)world, iblockstate1, 4, 2, 8, structureBoundingBoxIn);
            return true;
        }
    }

    public static class PortalRoom
    extends Stronghold {
        public PortalRoom(int componentType, class_3341 p_i50131_2_, class_2350 p_i50131_3_, Type strongholdType) {
            super(StructurePieces.STRONGHOLD_PORTAL_ROOM, componentType, strongholdType);
            this.method_14926(p_i50131_3_);
            this.field_15315 = p_i50131_2_;
        }

        public PortalRoom(class_3485 p_i50133_1_, class_2487 p_i50132_2_) {
            super(StructurePieces.STRONGHOLD_PORTAL_ROOM, p_i50132_2_);
        }

        @Override
        protected void method_14943(class_2487 tagCompound) {
            super.method_14943(tagCompound);
        }

        public void method_14918(class_3443 component, List<class_3443> piecesList, Random rand) {
            if (component != null) {
                ((EntranceStairs)component).strongholdPortalRoom = this;
            }
        }

        public static PortalRoom createPiece(List<class_3443> p_175865_0_, Random random, int x, int y, int z, class_2350 p_175865_5_, int componentType, Type strongholdType) {
            class_3341 mutableboundingbox = class_3341.method_14667((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)11, (int)8, (int)16, (class_2350)p_175865_5_);
            return PortalRoom.canStrongholdGoDeeper(mutableboundingbox) && class_3443.method_14932(p_175865_0_, (class_3341)mutableboundingbox) == null ? new PortalRoom(componentType, mutableboundingbox, p_175865_5_, strongholdType) : null;
        }

        public static PortalRoom createPiece(List<class_3443> p_175865_0_, Random p_175865_1_, int x, int y, int z, class_2350 p_175865_5_, Type strongholdType) {
            class_3341 mutableboundingbox = class_3341.method_14667((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)11, (int)8, (int)16, (class_2350)p_175865_5_);
            return new PortalRoom(1, mutableboundingbox, p_175865_5_, strongholdType);
        }

        public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 structureBoundingBoxIn, class_1923 chunkPos, class_2338 blockPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 0, 0, 0, 10, 7, 15, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, Stronghold.Door.GRATES, 4, 1, 0);
            int i = 6;
            this.method_14938((class_1936)world, structureBoundingBoxIn, 1, i, 1, 1, i, 14, false, random, randomStrongholdBlocks);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 9, i, 1, 9, i, 14, false, random, randomStrongholdBlocks);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 2, i, 1, 8, i, 2, false, random, randomStrongholdBlocks);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 2, i, 14, 8, i, 14, false, random, randomStrongholdBlocks);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 1, 1, 1, 2, 1, 4, false, random, randomStrongholdBlocks);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 8, 1, 1, 9, 1, 4, false, random, randomStrongholdBlocks);
            this.method_14940((class_1936)world, structureBoundingBoxIn, 1, 1, 1, 1, 1, 3, class_2246.field_10164.method_9564(), class_2246.field_10164.method_9564(), false);
            this.method_14940((class_1936)world, structureBoundingBoxIn, 9, 1, 1, 9, 1, 3, class_2246.field_10164.method_9564(), class_2246.field_10164.method_9564(), false);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 3, 1, 8, 7, 1, 12, false, random, randomStrongholdBlocks);
            this.method_14940((class_1936)world, structureBoundingBoxIn, 4, 1, 9, 6, 1, 11, class_2246.field_10164.method_9564(), class_2246.field_10164.method_9564(), false);
            for (int j = 3; j < 14; j += 2) {
                this.method_14940((class_1936)world, structureBoundingBoxIn, 0, 3, j, 0, 4, j, class_2246.field_10576.method_9564(), class_2246.field_10576.method_9564(), false);
                this.method_14940((class_1936)world, structureBoundingBoxIn, 10, 3, j, 10, 4, j, class_2246.field_10576.method_9564(), class_2246.field_10576.method_9564(), false);
            }
            for (int i1 = 2; i1 < 9; i1 += 2) {
                this.method_14940((class_1936)world, structureBoundingBoxIn, i1, 3, 15, i1, 4, 15, class_2246.field_10576.method_9564(), class_2246.field_10576.method_9564(), false);
            }
            class_2680 iblockstate3 = (class_2680)class_2246.field_10392.method_9564().method_11657((class_2769)class_2510.field_11571, (Comparable)class_2350.field_11043);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 4, 1, 5, 6, 1, 7, false, random, randomStrongholdBlocks);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 4, 2, 6, 6, 2, 7, false, random, randomStrongholdBlocks);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 4, 3, 7, 6, 3, 7, false, random, randomStrongholdBlocks);
            for (int k = 4; k <= 6; ++k) {
                this.method_14917((class_1936)world, iblockstate3, k, 1, 4, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate3, k, 2, 5, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate3, k, 3, 6, structureBoundingBoxIn);
            }
            class_2680 iblockstate4 = (class_2680)class_2246.field_10398.method_9564().method_11657((class_2769)class_2333.field_10954, (Comparable)class_2350.field_11043);
            class_2680 iblockstate = (class_2680)class_2246.field_10398.method_9564().method_11657((class_2769)class_2333.field_10954, (Comparable)class_2350.field_11035);
            class_2680 iblockstate1 = (class_2680)class_2246.field_10398.method_9564().method_11657((class_2769)class_2333.field_10954, (Comparable)class_2350.field_11034);
            class_2680 iblockstate2 = (class_2680)class_2246.field_10398.method_9564().method_11657((class_2769)class_2333.field_10954, (Comparable)class_2350.field_11039);
            boolean flag = true;
            boolean[] eyesPlaced = new boolean[12];
            for (int l = 0; l < eyesPlaced.length; ++l) {
                eyesPlaced[l] = random.nextFloat() > 0.9f;
                flag &= eyesPlaced[l];
            }
            this.method_14917((class_1936)world, (class_2680)iblockstate4.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(eyesPlaced[0])), 4, 3, 8, structureBoundingBoxIn);
            this.method_14917((class_1936)world, (class_2680)iblockstate4.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(eyesPlaced[1])), 5, 3, 8, structureBoundingBoxIn);
            this.method_14917((class_1936)world, (class_2680)iblockstate4.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(eyesPlaced[2])), 6, 3, 8, structureBoundingBoxIn);
            this.method_14917((class_1936)world, (class_2680)iblockstate.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(eyesPlaced[3])), 4, 3, 12, structureBoundingBoxIn);
            this.method_14917((class_1936)world, (class_2680)iblockstate.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(eyesPlaced[4])), 5, 3, 12, structureBoundingBoxIn);
            this.method_14917((class_1936)world, (class_2680)iblockstate.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(eyesPlaced[5])), 6, 3, 12, structureBoundingBoxIn);
            this.method_14917((class_1936)world, (class_2680)iblockstate1.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(eyesPlaced[6])), 3, 3, 9, structureBoundingBoxIn);
            this.method_14917((class_1936)world, (class_2680)iblockstate1.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(eyesPlaced[7])), 3, 3, 10, structureBoundingBoxIn);
            this.method_14917((class_1936)world, (class_2680)iblockstate1.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(eyesPlaced[8])), 3, 3, 11, structureBoundingBoxIn);
            this.method_14917((class_1936)world, (class_2680)iblockstate2.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(eyesPlaced[9])), 7, 3, 9, structureBoundingBoxIn);
            this.method_14917((class_1936)world, (class_2680)iblockstate2.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(eyesPlaced[10])), 7, 3, 10, structureBoundingBoxIn);
            this.method_14917((class_1936)world, (class_2680)iblockstate2.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(eyesPlaced[11])), 7, 3, 11, structureBoundingBoxIn);
            if (flag) {
                class_2680 iblockstate5 = class_2246.field_10027.method_9564();
                this.method_14917((class_1936)world, iblockstate5, 4, 3, 9, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate5, 5, 3, 9, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate5, 6, 3, 9, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate5, 4, 3, 10, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate5, 5, 3, 10, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate5, 6, 3, 10, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate5, 4, 3, 11, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate5, 5, 3, 11, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate5, 6, 3, 11, structureBoundingBoxIn);
            }
            i = this.method_14924(3);
            class_2338 blockpos = new class_2338(this.method_14928(5, 6), i, this.method_14941(5, 6));
            if (structureBoundingBoxIn.method_14662((class_2382)blockpos)) {
                world.method_8652(blockpos, class_2246.field_10260.method_9564(), 2);
                class_2586 tileentity = world.method_8321(blockpos);
                if (tileentity instanceof class_2636) {
                    ((class_2636)tileentity).method_11390().method_8274(this.getSpawnerEntity(random, true));
                }
            }
            return true;
        }
    }

    static class PieceWeight {
        public Class<? extends class_3421.class_3437> pieceClass;
        public final int pieceWeight;
        public int instancesSpawned;
        public int instancesLimit;

        public PieceWeight(Class<? extends class_3421.class_3437> p_i2076_1_, int p_i2076_2_, int p_i2076_3_) {
            this.pieceClass = p_i2076_1_;
            this.pieceWeight = p_i2076_2_;
            this.instancesLimit = p_i2076_3_;
        }

        public boolean canSpawnMoreStructures(int distanceFromStart) {
            int maxLimit = (int)((double)this.instancesLimit * (RepurposedStructures.RSAllConfig.RSStrongholdsConfig.strongholdSizeSH * 0.01));
            return this.instancesLimit == 0 || this.instancesSpawned < maxLimit;
        }

        public boolean canSpawnMoreStructures() {
            int maxLimit = (int)((double)this.instancesLimit * (RepurposedStructures.RSAllConfig.RSStrongholdsConfig.strongholdSizeSH * 0.01));
            return this.instancesLimit == 0 || this.instancesSpawned < maxLimit;
        }
    }

    public static class Library
    extends Stronghold {
        private boolean isLargeRoom;

        public Library(int componentType, Random p_i45578_2_, class_3341 p_i45578_3_, class_2350 p_i45578_4_, Type strongholdType) {
            super(StructurePieces.STRONGHOLD_LIBRARY, componentType, strongholdType);
            this.method_14926(p_i45578_4_);
            this.entryDoor = this.getRandomDoor(p_i45578_2_);
            this.field_15315 = p_i45578_3_;
            this.isLargeRoom = p_i45578_3_.method_14663() > 6;
        }

        public Library(class_3485 p_i50133_1_, class_2487 p_i50133_2_) {
            super(StructurePieces.STRONGHOLD_LIBRARY, p_i50133_2_);
            this.isLargeRoom = p_i50133_2_.method_10577("Tall");
        }

        @Override
        protected void method_14943(class_2487 tagCompound) {
            super.method_14943(tagCompound);
            tagCompound.method_10556("Tall", this.isLargeRoom);
        }

        public static Library createPiece(List<class_3443> p_175864_0_, Random p_175864_1_, int x, int y, int z, class_2350 p_175864_5_, int componentType, Type strongholdType) {
            class_3341 mutableboundingbox = class_3341.method_14667((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)14, (int)11, (int)15, (class_2350)p_175864_5_);
            if (!(Library.canStrongholdGoDeeper(mutableboundingbox) && class_3443.method_14932(p_175864_0_, (class_3341)mutableboundingbox) == null || Library.canStrongholdGoDeeper(mutableboundingbox = class_3341.method_14667((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)14, (int)6, (int)15, (class_2350)p_175864_5_)) && class_3443.method_14932(p_175864_0_, (class_3341)mutableboundingbox) == null)) {
                return null;
            }
            return new Library(componentType, p_175864_1_, mutableboundingbox, p_175864_5_, strongholdType);
        }

        private class_2680 pickBookshelfBlock(Random random) {
            class_3494 BOOKSHELF_TAG;
            List allBookshelfBlocks;
            class_2680 bookshelfBlock = class_2246.field_10504.method_9564();
            if (this.strongholdType == Type.NETHER && !(allBookshelfBlocks = (BOOKSHELF_TAG = class_3481.method_15073().method_15188(NETHER_STRONGHOLD_BOOKSHELF_RL)).method_15138()).isEmpty()) {
                bookshelfBlock = ((class_2248)allBookshelfBlocks.toArray()[random.nextInt(allBookshelfBlocks.size())]).method_9564();
            }
            return bookshelfBlock;
        }

        public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 structureBoundingBoxIn, class_1923 chunkPos, class_2338 blockPos) {
            int i = 11;
            if (!this.isLargeRoom) {
                i = 6;
            }
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 0, 0, 0, 13, i - 1, 14, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 4, 1, 0);
            this.method_14933((class_1936)world, structureBoundingBoxIn, random, 0.07f, 2, 1, 1, 11, 4, 13, class_2246.field_10343.method_9564(), class_2246.field_10343.method_9564(), false, false);
            for (int l = 1; l <= 13; ++l) {
                if ((l - 1) % 4 == 0) {
                    this.method_14940((class_1936)world, structureBoundingBoxIn, 1, 1, l, 1, 4, l, class_2246.field_10161.method_9564(), class_2246.field_10161.method_9564(), false);
                    this.method_14940((class_1936)world, structureBoundingBoxIn, 12, 1, l, 12, 4, l, class_2246.field_10161.method_9564(), class_2246.field_10161.method_9564(), false);
                    this.method_14917((class_1936)world, (class_2680)class_2246.field_10099.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)class_2350.field_11034), 2, 3, l, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, (class_2680)class_2246.field_10099.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)class_2350.field_11039), 11, 3, l, structureBoundingBoxIn);
                    if (!this.isLargeRoom) continue;
                    this.method_14940((class_1936)world, structureBoundingBoxIn, 1, 6, l, 1, 9, l, class_2246.field_10161.method_9564(), class_2246.field_10161.method_9564(), false);
                    this.method_14940((class_1936)world, structureBoundingBoxIn, 12, 6, l, 12, 9, l, class_2246.field_10161.method_9564(), class_2246.field_10161.method_9564(), false);
                    continue;
                }
                this.method_14940((class_1936)world, structureBoundingBoxIn, 1, 1, l, 1, 4, l, this.pickBookshelfBlock(random), this.pickBookshelfBlock(random), false);
                this.method_14940((class_1936)world, structureBoundingBoxIn, 12, 1, l, 12, 4, l, this.pickBookshelfBlock(random), this.pickBookshelfBlock(random), false);
                if (!this.isLargeRoom) continue;
                this.method_14940((class_1936)world, structureBoundingBoxIn, 1, 6, l, 1, 9, l, this.pickBookshelfBlock(random), this.pickBookshelfBlock(random), false);
                this.method_14940((class_1936)world, structureBoundingBoxIn, 12, 6, l, 12, 9, l, this.pickBookshelfBlock(random), this.pickBookshelfBlock(random), false);
            }
            for (int l1 = 3; l1 < 12; l1 += 2) {
                this.method_14940((class_1936)world, structureBoundingBoxIn, 3, 1, l1, 4, 3, l1, this.pickBookshelfBlock(random), this.pickBookshelfBlock(random), false);
                this.method_14940((class_1936)world, structureBoundingBoxIn, 6, 1, l1, 7, 3, l1, this.pickBookshelfBlock(random), this.pickBookshelfBlock(random), false);
                this.method_14940((class_1936)world, structureBoundingBoxIn, 9, 1, l1, 10, 3, l1, this.pickBookshelfBlock(random), this.pickBookshelfBlock(random), false);
            }
            if (this.isLargeRoom) {
                this.method_14940((class_1936)world, structureBoundingBoxIn, 1, 5, 1, 3, 5, 13, class_2246.field_10161.method_9564(), class_2246.field_10161.method_9564(), false);
                this.method_14940((class_1936)world, structureBoundingBoxIn, 10, 5, 1, 12, 5, 13, class_2246.field_10161.method_9564(), class_2246.field_10161.method_9564(), false);
                this.method_14940((class_1936)world, structureBoundingBoxIn, 4, 5, 1, 9, 5, 2, class_2246.field_10161.method_9564(), class_2246.field_10161.method_9564(), false);
                this.method_14940((class_1936)world, structureBoundingBoxIn, 4, 5, 12, 9, 5, 13, class_2246.field_10161.method_9564(), class_2246.field_10161.method_9564(), false);
                this.method_14917((class_1936)world, class_2246.field_10161.method_9564(), 9, 5, 11, structureBoundingBoxIn);
                this.method_14917((class_1936)world, class_2246.field_10161.method_9564(), 8, 5, 11, structureBoundingBoxIn);
                this.method_14917((class_1936)world, class_2246.field_10161.method_9564(), 9, 5, 10, structureBoundingBoxIn);
                class_2680 iblockstate5 = (class_2680)((class_2680)class_2246.field_10620.method_9564().method_11657((class_2769)class_2310.field_10903, (Comparable)Boolean.TRUE)).method_11657((class_2769)class_2310.field_10907, (Comparable)Boolean.TRUE);
                class_2680 iblockstate = (class_2680)((class_2680)class_2246.field_10620.method_9564().method_11657((class_2769)class_2310.field_10905, (Comparable)Boolean.TRUE)).method_11657((class_2769)class_2310.field_10904, (Comparable)Boolean.TRUE);
                this.method_14940((class_1936)world, structureBoundingBoxIn, 3, 6, 3, 3, 6, 11, iblockstate, iblockstate, false);
                this.method_14940((class_1936)world, structureBoundingBoxIn, 10, 6, 3, 10, 6, 9, iblockstate, iblockstate, false);
                this.method_14940((class_1936)world, structureBoundingBoxIn, 4, 6, 2, 9, 6, 2, iblockstate5, iblockstate5, false);
                this.method_14940((class_1936)world, structureBoundingBoxIn, 4, 6, 12, 7, 6, 12, iblockstate5, iblockstate5, false);
                this.method_14917((class_1936)world, (class_2680)((class_2680)class_2246.field_10620.method_9564().method_11657((class_2769)class_2310.field_10905, (Comparable)Boolean.TRUE)).method_11657((class_2769)class_2310.field_10907, (Comparable)Boolean.TRUE), 3, 6, 2, structureBoundingBoxIn);
                this.method_14917((class_1936)world, (class_2680)((class_2680)class_2246.field_10620.method_9564().method_11657((class_2769)class_2310.field_10904, (Comparable)Boolean.TRUE)).method_11657((class_2769)class_2310.field_10907, (Comparable)Boolean.TRUE), 3, 6, 12, structureBoundingBoxIn);
                this.method_14917((class_1936)world, (class_2680)((class_2680)class_2246.field_10620.method_9564().method_11657((class_2769)class_2310.field_10905, (Comparable)Boolean.TRUE)).method_11657((class_2769)class_2310.field_10903, (Comparable)Boolean.TRUE), 10, 6, 2, structureBoundingBoxIn);
                for (int i1 = 0; i1 <= 2; ++i1) {
                    this.method_14917((class_1936)world, (class_2680)((class_2680)class_2246.field_10620.method_9564().method_11657((class_2769)class_2310.field_10904, (Comparable)Boolean.TRUE)).method_11657((class_2769)class_2310.field_10903, (Comparable)Boolean.TRUE), 8 + i1, 6, 12 - i1, structureBoundingBoxIn);
                    if (i1 == 2) continue;
                    this.method_14917((class_1936)world, (class_2680)((class_2680)class_2246.field_10620.method_9564().method_11657((class_2769)class_2310.field_10905, (Comparable)Boolean.TRUE)).method_11657((class_2769)class_2310.field_10907, (Comparable)Boolean.TRUE), 8 + i1, 6, 11 - i1, structureBoundingBoxIn);
                }
                class_2680 iblockstate6 = (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11035);
                this.method_14917((class_1936)world, iblockstate6, 10, 1, 13, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate6, 10, 2, 13, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate6, 10, 3, 13, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate6, 10, 4, 13, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate6, 10, 5, 13, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate6, 10, 6, 13, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate6, 10, 7, 13, structureBoundingBoxIn);
                class_2680 iblockstate1 = (class_2680)class_2246.field_10620.method_9564().method_11657((class_2769)class_2310.field_10907, (Comparable)Boolean.TRUE);
                this.method_14917((class_1936)world, iblockstate1, 6, 9, 7, structureBoundingBoxIn);
                class_2680 iblockstate2 = (class_2680)class_2246.field_10620.method_9564().method_11657((class_2769)class_2310.field_10903, (Comparable)Boolean.TRUE);
                this.method_14917((class_1936)world, iblockstate2, 7, 9, 7, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate1, 6, 8, 7, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate2, 7, 8, 7, structureBoundingBoxIn);
                class_2680 iblockstate3 = (class_2680)((class_2680)iblockstate.method_11657((class_2769)class_2310.field_10903, (Comparable)Boolean.TRUE)).method_11657((class_2769)class_2310.field_10907, (Comparable)Boolean.TRUE);
                this.method_14917((class_1936)world, iblockstate3, 6, 7, 7, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate3, 7, 7, 7, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate1, 5, 7, 7, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate2, 8, 7, 7, structureBoundingBoxIn);
                this.method_14917((class_1936)world, (class_2680)iblockstate1.method_11657((class_2769)class_2310.field_10905, (Comparable)Boolean.TRUE), 6, 7, 6, structureBoundingBoxIn);
                this.method_14917((class_1936)world, (class_2680)iblockstate1.method_11657((class_2769)class_2310.field_10904, (Comparable)Boolean.TRUE), 6, 7, 8, structureBoundingBoxIn);
                this.method_14917((class_1936)world, (class_2680)iblockstate2.method_11657((class_2769)class_2310.field_10905, (Comparable)Boolean.TRUE), 7, 7, 6, structureBoundingBoxIn);
                this.method_14917((class_1936)world, (class_2680)iblockstate2.method_11657((class_2769)class_2310.field_10904, (Comparable)Boolean.TRUE), 7, 7, 8, structureBoundingBoxIn);
                class_2680 iblockstate4 = class_2246.field_10336.method_9564();
                this.method_14917((class_1936)world, iblockstate4, 5, 8, 7, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate4, 8, 8, 7, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate4, 6, 8, 6, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate4, 6, 8, 8, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate4, 7, 8, 6, structureBoundingBoxIn);
                this.method_14917((class_1936)world, iblockstate4, 7, 8, 8, structureBoundingBoxIn);
            }
            if (RepurposedStructures.RSAllConfig.RSStrongholdsConfig.lootChestsSH) {
                this.method_14915((class_1936)world, structureBoundingBoxIn, random, 3, 3, 5, class_39.field_683);
            }
            if (this.isLargeRoom) {
                this.method_14917((class_1936)world, class_2246.field_10124.method_9564(), 12, 9, 1, structureBoundingBoxIn);
                if (RepurposedStructures.RSAllConfig.RSStrongholdsConfig.lootChestsSH) {
                    this.method_14915((class_1936)world, structureBoundingBoxIn, random, 12, 8, 1, class_39.field_683);
                }
            }
            return true;
        }
    }

    public static class LeftTurn
    extends Turn {
        public LeftTurn(int componentType, Random p_i45579_2_, class_3341 p_i45579_3_, class_2350 p_i45579_4_, Type strongholdType) {
            super(StructurePieces.STRONGHOLD_LEFT_TURN, componentType, strongholdType);
            this.method_14926(p_i45579_4_);
            this.entryDoor = this.getRandomDoor(p_i45579_2_);
            this.field_15315 = p_i45579_3_;
        }

        public LeftTurn(class_3485 p_i50134_1_, class_2487 p_i50134_2_) {
            super(StructurePieces.STRONGHOLD_LEFT_TURN, p_i50134_2_);
        }

        public void method_14918(class_3443 component, List<class_3443> piecesList, Random rand) {
            class_2350 enumfacing = this.method_14934();
            if (enumfacing != class_2350.field_11043 && enumfacing != class_2350.field_11034) {
                this.getNextComponentZ((EntranceStairs)component, piecesList, rand, 1, 1);
            } else {
                this.getNextComponentX((EntranceStairs)component, piecesList, rand, 1, 1);
            }
        }

        public static LeftTurn createPiece(List<class_3443> p_175867_0_, Random p_175867_1_, int x, int y, int z, class_2350 p_175867_5_, int componentType, Type strongholdType) {
            class_3341 mutableboundingbox = class_3341.method_14667((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)5, (class_2350)p_175867_5_);
            return LeftTurn.canStrongholdGoDeeper(mutableboundingbox) && class_3443.method_14932(p_175867_0_, (class_3341)mutableboundingbox) == null ? new LeftTurn(componentType, p_175867_1_, mutableboundingbox, p_175867_5_, strongholdType) : null;
        }

        public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 structureBoundingBoxIn, class_1923 chunkPos, class_2338 blockPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 0, 0, 0, 4, 4, 4, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 1, 1, 0);
            class_2350 enumfacing = this.method_14934();
            if (enumfacing != class_2350.field_11043 && enumfacing != class_2350.field_11034) {
                this.method_14940((class_1936)world, structureBoundingBoxIn, 4, 1, 1, 4, 3, 3, class_2246.field_10124.method_9564(), class_2246.field_10124.method_9564(), false);
            } else {
                this.method_14940((class_1936)world, structureBoundingBoxIn, 0, 1, 1, 0, 3, 3, class_2246.field_10124.method_9564(), class_2246.field_10124.method_9564(), false);
            }
            return true;
        }
    }

    public static class Crossing
    extends Stronghold {
        private boolean leftLow;
        private boolean leftHigh;
        private boolean rightLow;
        private boolean rightHigh;

        public Crossing(int componentType, Random p_i45580_2_, class_3341 p_i45580_3_, class_2350 p_i45580_4_, Type strongholdType) {
            super(StructurePieces.STRONGHOLD_CROSSING, componentType, strongholdType);
            this.method_14926(p_i45580_4_);
            this.entryDoor = this.getRandomDoor(p_i45580_2_);
            this.field_15315 = p_i45580_3_;
            this.leftLow = p_i45580_2_.nextBoolean();
            this.leftHigh = p_i45580_2_.nextBoolean();
            this.rightLow = p_i45580_2_.nextBoolean();
            this.rightHigh = p_i45580_2_.nextInt(3) > 0;
        }

        public Crossing(class_3485 p_i50136_1_, class_2487 p_i50136_2_) {
            super(StructurePieces.STRONGHOLD_CROSSING, p_i50136_2_);
            this.leftLow = p_i50136_2_.method_10577("leftLow");
            this.leftHigh = p_i50136_2_.method_10577("leftHigh");
            this.rightLow = p_i50136_2_.method_10577("rightLow");
            this.rightHigh = p_i50136_2_.method_10577("rightHigh");
        }

        @Override
        protected void method_14943(class_2487 tagCompound) {
            super.method_14943(tagCompound);
            tagCompound.method_10556("leftLow", this.leftLow);
            tagCompound.method_10556("leftHigh", this.leftHigh);
            tagCompound.method_10556("rightLow", this.rightLow);
            tagCompound.method_10556("rightHigh", this.rightHigh);
        }

        public void method_14918(class_3443 component, List<class_3443> piecesList, Random rand) {
            int i = 3;
            int j = 5;
            class_2350 enumfacing = this.method_14934();
            if (enumfacing == class_2350.field_11039 || enumfacing == class_2350.field_11043) {
                i = 8 - i;
                j = 8 - j;
            }
            this.getNextComponentNormal((EntranceStairs)component, piecesList, rand, 5, 1);
            if (this.leftLow) {
                this.getNextComponentX((EntranceStairs)component, piecesList, rand, i, 1);
            }
            if (this.leftHigh) {
                this.getNextComponentX((EntranceStairs)component, piecesList, rand, j, 7);
            }
            if (this.rightLow) {
                this.getNextComponentZ((EntranceStairs)component, piecesList, rand, i, 1);
            }
            if (this.rightHigh) {
                this.getNextComponentZ((EntranceStairs)component, piecesList, rand, j, 7);
            }
        }

        public static Crossing createPiece(List<class_3443> p_175866_0_, Random p_175866_1_, int x, int y, int z, class_2350 p_175866_5_, int componentType, Type strongholdType) {
            class_3341 mutableboundingbox = class_3341.method_14667((int)x, (int)y, (int)z, (int)-4, (int)-3, (int)0, (int)10, (int)9, (int)11, (class_2350)p_175866_5_);
            return Crossing.canStrongholdGoDeeper(mutableboundingbox) && class_3443.method_14932(p_175866_0_, (class_3341)mutableboundingbox) == null ? new Crossing(componentType, p_175866_1_, mutableboundingbox, p_175866_5_, strongholdType) : null;
        }

        public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 structureBoundingBoxIn, class_1923 chunkPos, class_2338 blockPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 0, 0, 0, 9, 8, 10, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 4, 3, 0);
            if (this.leftLow) {
                this.method_14940((class_1936)world, structureBoundingBoxIn, 0, 3, 1, 0, 5, 3, class_2246.field_10124.method_9564(), class_2246.field_10124.method_9564(), false);
            }
            if (this.rightLow) {
                this.method_14940((class_1936)world, structureBoundingBoxIn, 9, 3, 1, 9, 5, 3, class_2246.field_10124.method_9564(), class_2246.field_10124.method_9564(), false);
            }
            if (this.leftHigh) {
                this.method_14940((class_1936)world, structureBoundingBoxIn, 0, 5, 7, 0, 7, 9, class_2246.field_10124.method_9564(), class_2246.field_10124.method_9564(), false);
            }
            if (this.rightHigh) {
                this.method_14940((class_1936)world, structureBoundingBoxIn, 9, 5, 7, 9, 7, 9, class_2246.field_10124.method_9564(), class_2246.field_10124.method_9564(), false);
            }
            this.method_14940((class_1936)world, structureBoundingBoxIn, 5, 1, 10, 7, 3, 10, class_2246.field_10124.method_9564(), class_2246.field_10124.method_9564(), false);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 1, 2, 1, 8, 2, 6, false, random, randomStrongholdBlocks);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 4, 1, 5, 4, 4, 9, false, random, randomStrongholdBlocks);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 8, 1, 5, 8, 4, 9, false, random, randomStrongholdBlocks);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 1, 4, 7, 3, 4, 9, false, random, randomStrongholdBlocks);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 1, 3, 5, 3, 3, 6, false, random, randomStrongholdBlocks);
            this.method_14940((class_1936)world, structureBoundingBoxIn, 1, 3, 4, 3, 3, 4, class_2246.field_10454.method_9564(), class_2246.field_10454.method_9564(), false);
            this.method_14940((class_1936)world, structureBoundingBoxIn, 1, 4, 6, 3, 4, 6, class_2246.field_10454.method_9564(), class_2246.field_10454.method_9564(), false);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 5, 1, 7, 7, 1, 8, false, random, randomStrongholdBlocks);
            this.method_14940((class_1936)world, structureBoundingBoxIn, 5, 1, 9, 7, 1, 9, class_2246.field_10454.method_9564(), class_2246.field_10454.method_9564(), false);
            this.method_14940((class_1936)world, structureBoundingBoxIn, 5, 2, 7, 7, 2, 7, class_2246.field_10454.method_9564(), class_2246.field_10454.method_9564(), false);
            this.method_14940((class_1936)world, structureBoundingBoxIn, 4, 5, 7, 4, 5, 9, class_2246.field_10454.method_9564(), class_2246.field_10454.method_9564(), false);
            this.method_14940((class_1936)world, structureBoundingBoxIn, 8, 5, 7, 8, 5, 9, class_2246.field_10454.method_9564(), class_2246.field_10454.method_9564(), false);
            this.method_14940((class_1936)world, structureBoundingBoxIn, 5, 5, 7, 7, 5, 9, (class_2680)class_2246.field_10454.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682), (class_2680)class_2246.field_10454.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682), false);
            this.method_14917((class_1936)world, (class_2680)class_2246.field_10099.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)class_2350.field_11035), 6, 5, 6, structureBoundingBoxIn);
            return true;
        }
    }

    public static class Corridor
    extends Stronghold {
        private int steps;

        public Corridor(int componentType, class_3341 p_i50137_2_, class_2350 p_i50137_3_, Type strongholdType) {
            super(StructurePieces.STRONGHOLD_CORRIDOR, componentType, strongholdType);
            this.method_14926(p_i50137_3_);
            this.field_15315 = p_i50137_2_;
            this.steps = p_i50137_3_ != class_2350.field_11043 && p_i50137_3_ != class_2350.field_11035 ? p_i50137_2_.method_14660() : p_i50137_2_.method_14664();
        }

        public Corridor(class_3485 p_i50138_1_, class_2487 p_i50138_2_) {
            super(StructurePieces.STRONGHOLD_CORRIDOR, p_i50138_2_);
            this.steps = p_i50138_2_.method_10550("Steps");
        }

        @Override
        protected void method_14943(class_2487 tagCompound) {
            super.method_14943(tagCompound);
            tagCompound.method_10569("Steps", this.steps);
        }

        public static class_3341 findPieceBox(List<class_3443> p_175869_0_, Random p_175869_1_, int p_175869_2_, int p_175869_3_, int p_175869_4_, class_2350 p_175869_5_) {
            class_3341 mutableboundingbox = class_3341.method_14667((int)p_175869_2_, (int)p_175869_3_, (int)p_175869_4_, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)4, (class_2350)p_175869_5_);
            class_3443 structurePiece = class_3443.method_14932(p_175869_0_, (class_3341)mutableboundingbox);
            if (structurePiece == null) {
                return null;
            }
            if (structurePiece.method_14935().field_14380 == mutableboundingbox.field_14380) {
                for (int j = 3; j >= 1; --j) {
                    mutableboundingbox = class_3341.method_14667((int)p_175869_2_, (int)p_175869_3_, (int)p_175869_4_, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)(j - 1), (class_2350)p_175869_5_);
                    if (structurePiece.method_14935().method_14657(mutableboundingbox)) continue;
                    return class_3341.method_14667((int)p_175869_2_, (int)p_175869_3_, (int)p_175869_4_, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)j, (class_2350)p_175869_5_);
                }
            }
            return null;
        }

        public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 structureBoundingBoxIn, class_1923 chunkPos, class_2338 blockPos) {
            for (int i = 0; i < this.steps; ++i) {
                this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 0, 0, i, structureBoundingBoxIn);
                this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 1, 0, i, structureBoundingBoxIn);
                this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 2, 0, i, structureBoundingBoxIn);
                this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 3, 0, i, structureBoundingBoxIn);
                this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 4, 0, i, structureBoundingBoxIn);
                for (int j = 1; j <= 3; ++j) {
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 0, j, i, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10124.method_9564(), 1, j, i, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10124.method_9564(), 2, j, i, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10124.method_9564(), 3, j, i, structureBoundingBoxIn);
                    this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 4, j, i, structureBoundingBoxIn);
                }
                this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 0, 4, i, structureBoundingBoxIn);
                this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 1, 4, i, structureBoundingBoxIn);
                this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 2, 4, i, structureBoundingBoxIn);
                this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 3, 4, i, structureBoundingBoxIn);
                this.method_14917((class_1936)world, class_2246.field_10056.method_9564(), 4, 4, i, structureBoundingBoxIn);
            }
            return true;
        }
    }

    public static class ChestCorridor
    extends Stronghold {
        public ChestCorridor(int componentType, Random p_i45582_2_, class_3341 p_i45582_3_, class_2350 p_i45582_4_, Type strongholdType) {
            super(StructurePieces.STRONGHOLD_CHEST_CORRIDOR, componentType, strongholdType);
            this.method_14926(p_i45582_4_);
            this.entryDoor = this.getRandomDoor(p_i45582_2_);
            this.field_15315 = p_i45582_3_;
        }

        public ChestCorridor(class_3485 p_i50140_1_, class_2487 p_i50140_2_) {
            super(StructurePieces.STRONGHOLD_CHEST_CORRIDOR, p_i50140_2_);
        }

        @Override
        protected void method_14943(class_2487 tagCompound) {
            super.method_14943(tagCompound);
        }

        public void method_14918(class_3443 component, List<class_3443> piecesList, Random rand) {
            this.getNextComponentNormal((EntranceStairs)component, piecesList, rand, 1, 1);
        }

        public static ChestCorridor createPiece(List<class_3443> p_175868_0_, Random p_175868_1_, int x, int y, int z, class_2350 p_175868_5_, int componentType, Type strongholdType) {
            class_3341 mutableboundingbox = class_3341.method_14667((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)7, (class_2350)p_175868_5_);
            return ChestCorridor.canStrongholdGoDeeper(mutableboundingbox) && class_3443.method_14932(p_175868_0_, (class_3341)mutableboundingbox) == null ? new ChestCorridor(componentType, p_175868_1_, mutableboundingbox, p_175868_5_, strongholdType) : null;
        }

        public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 structureBoundingBoxIn, class_1923 chunkPos, class_2338 blockPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.method_14938((class_1936)world, structureBoundingBoxIn, 0, 0, 0, 4, 4, 6, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 1, 1, 0);
            this.placeDoor(world, random, structureBoundingBoxIn, Stronghold.Door.OPENING, 1, 1, 6);
            this.method_14940((class_1936)world, structureBoundingBoxIn, 3, 1, 2, 3, 1, 4, class_2246.field_10056.method_9564(), class_2246.field_10056.method_9564(), false);
            this.method_14917((class_1936)world, class_2246.field_10131.method_9564(), 3, 1, 1, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10131.method_9564(), 3, 1, 5, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10131.method_9564(), 3, 2, 2, structureBoundingBoxIn);
            this.method_14917((class_1936)world, class_2246.field_10131.method_9564(), 3, 2, 4, structureBoundingBoxIn);
            for (int i = 2; i <= 4; ++i) {
                this.method_14917((class_1936)world, class_2246.field_10131.method_9564(), 2, 1, i, structureBoundingBoxIn);
            }
            if (structureBoundingBoxIn.method_14662((class_2382)new class_2338(this.method_14928(3, 3), this.method_14924(2), this.method_14941(3, 3))) && RepurposedStructures.RSAllConfig.RSStrongholdsConfig.lootChestsSH && random.nextInt(3) == 0) {
                this.method_14915((class_1936)world, structureBoundingBoxIn, random, 3, 2, 3, this.getHallwayChestLoot());
            }
            return true;
        }
    }

    public static enum Type {
        NORMAL,
        NETHER;


        public static Type byId(int id) {
            return id >= 0 && id < Type.values().length ? Type.values()[id] : NORMAL;
        }
    }
}

