/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures;

import com.mojang.datafixers.types.DynamicOps;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.world.features.RSFeatures;
import com.telepathicgrunt.repurposedstructures.world.placements.RSPlacements;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BlockBlobConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.ChanceRangeConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;

public class RSAddFeatures {
    private static final ConfiguredFeature<?, ?> VANILLA_SWAMP_TREE = Feature.field_202301_A.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226814_i_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1)));
    private static final ConfiguredFeature<?, ?> VANILLA_BOULDER = Feature.field_202283_ac.func_225566_b_((IFeatureConfig)new BlockBlobConfig(Blocks.field_150341_Y.func_176223_P(), 0)).func_227228_a_(Placement.field_215040_z.func_227446_a_((IPlacementConfig)new FrequencyConfig(3)));

    public static void addMineshafts(Biome biome, String biomeNamespace, String biomePath) {
        RSAddFeatures.addRSMineshafts(biome);
        if (RepurposedStructures.RSMineshaftsConfig.birchMineshaftSpawnrate.get() != 0 && biomePath.contains("birch") && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (biome.func_201858_a(Feature.field_202329_g) || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue()) {
                biome.field_201874_aj.remove(Feature.field_202329_g);
                biome.func_226711_a_(RSFeatures.BIRCH_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSMineshaftsConfig.jungleMineshaftSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.JUNGLE && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (biome.func_201858_a(Feature.field_202329_g) || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue()) {
                biome.field_201874_aj.remove(Feature.field_202329_g);
                biome.func_226711_a_(RSFeatures.JUNGLE_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSMineshaftsConfig.desertMineshaftSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.DESERT && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (biome.func_201858_a(Feature.field_202329_g) || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue()) {
                biome.field_201874_aj.remove(Feature.field_202329_g);
                biome.func_226711_a_(RSFeatures.DESERT_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSMineshaftsConfig.birchMineshaftSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.EXTREME_HILLS && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (biome.func_201858_a(Feature.field_202329_g) || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue()) {
                biome.field_201874_aj.remove(Feature.field_202329_g);
                biome.func_226711_a_(RSFeatures.STONE_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSMineshaftsConfig.savannaMineshaftSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.SAVANNA && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (biome.func_201858_a(Feature.field_202329_g) || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue()) {
                biome.field_201874_aj.remove(Feature.field_202329_g);
                biome.func_226711_a_(RSFeatures.SAVANNA_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSMineshaftsConfig.icyMineshaftSpawnrate.get() != 0 && (biome.func_201856_r() == Biome.Category.ICY || biomePath.contains("snowy")) && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (biome.func_201858_a(Feature.field_202329_g) || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue()) {
                biome.field_201874_aj.remove(Feature.field_202329_g);
                biome.func_226711_a_(RSFeatures.ICY_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSMineshaftsConfig.oceanMineshaftSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.OCEAN && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (biome.func_201858_a(Feature.field_202329_g) || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue()) {
                biome.field_201874_aj.remove(Feature.field_202329_g);
                biome.func_226711_a_(RSFeatures.OCEAN_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSMineshaftsConfig.taigaMineshaftSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.TAIGA && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (biome.func_201858_a(Feature.field_202329_g) || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue()) {
                biome.field_201874_aj.remove(Feature.field_202329_g);
                biome.func_226711_a_(RSFeatures.TAIGA_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSMineshaftsConfig.swampAndDarkForestMineshaftSpawnrate.get() != 0 && (biome.func_201856_r() == Biome.Category.SWAMP || biomePath.contains("dark_forest") || biomePath.contains("dark_oak")) && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (biome.func_201858_a(Feature.field_202329_g) || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue()) {
                biome.field_201874_aj.remove(Feature.field_202329_g);
                biome.func_226711_a_(RSFeatures.SWAMP_OR_DARK_FOREST_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSMineshaftsConfig.endMineshaftSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.THEEND && biome != Biomes.field_76779_k && biome != Biomes.field_201936_P && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            biome.func_226711_a_(RSFeatures.END_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        } else if (RepurposedStructures.RSMineshaftsConfig.netherMineshaftSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.NETHER && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            biome.func_226711_a_(RSFeatures.HELL_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
    }

    public static void addRSMineshafts(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.BIRCH_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.DESERT_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.END_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.HELL_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.ICY_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.JUNGLE_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.OCEAN_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.SAVANNA_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.STONE_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.SWAMP_OR_DARK_FOREST_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.TAIGA_MINESHAFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
    }

    public static void addJungleFortress(Biome biome, String biomeNamespace, String biomePath) {
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, RSFeatures.JUNGLE_FORTRESS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        if (RepurposedStructures.RSMainConfig.jungleFortressSpawnrate.get() == 1001) {
            return;
        }
        if (biome.func_201856_r() == Biome.Category.JUNGLE && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMainConfig.addJungleFortressToModdedBiomes.get().booleanValue())) {
            biome.func_226711_a_(RSFeatures.JUNGLE_FORTRESS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
    }

    public static void addDungeons(Biome biome, String biomeNamespace, String biomePath) {
        if (RepurposedStructures.RSDungeonsConfig.jungleDungeonSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.JUNGLE && RSAddFeatures.dungeonAllowedByNamespaceAndConfigUA(biomeNamespace)) {
            biome.func_203607_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES).removeIf(configuredFeature -> configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_202282_ab);
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.JUNGLE_DUNGEONS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(RSPlacements.RS_DUNGEON_PLACEMENT.func_227446_a_((IPlacementConfig)new CountRangeConfig(RepurposedStructures.RSDungeonsConfig.jungleDungeonSpawnrate.get().intValue(), RepurposedStructures.RSDungeonsConfig.jungleDungeonMinHeight.get().intValue(), 0, RepurposedStructures.RSDungeonsConfig.jungleDungeonMaxHeight.get().intValue()))));
        } else if (RepurposedStructures.RSDungeonsConfig.badlandsDungeonSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.MESA && RSAddFeatures.dungeonAllowedByNamespaceAndConfigUA(biomeNamespace)) {
            biome.func_203607_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES).removeIf(configuredFeature -> configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_202282_ab);
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.BADLANDS_DUNGEONS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(RSPlacements.RS_DUNGEON_PLACEMENT.func_227446_a_((IPlacementConfig)new CountRangeConfig(RepurposedStructures.RSDungeonsConfig.badlandsDungeonSpawnrate.get().intValue(), RepurposedStructures.RSDungeonsConfig.badlandsDungeonMinHeight.get().intValue(), 0, RepurposedStructures.RSDungeonsConfig.badlandsDungeonMaxHeight.get().intValue()))));
        } else if (RepurposedStructures.RSDungeonsConfig.darkForestDungeonSpawnrate.get() != 0 && biomePath.contains("dark_forest") && RSAddFeatures.dungeonAllowedByNamespaceAndConfigUA(biomeNamespace)) {
            biome.func_203607_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES).removeIf(configuredFeature -> configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_202282_ab);
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.DARK_FOREST_DUNGEONS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(RSPlacements.RS_DUNGEON_PLACEMENT.func_227446_a_((IPlacementConfig)new CountRangeConfig(RepurposedStructures.RSDungeonsConfig.darkForestDungeonSpawnrate.get().intValue(), RepurposedStructures.RSDungeonsConfig.darkForestDungeonMinHeight.get().intValue(), 0, RepurposedStructures.RSDungeonsConfig.darkForestDungeonMaxHeight.get().intValue()))));
        } else if (RepurposedStructures.RSDungeonsConfig.desertDungeonSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.DESERT && RSAddFeatures.dungeonAllowedByNamespaceAndConfigUA(biomeNamespace)) {
            biome.func_203607_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES).removeIf(configuredFeature -> configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_202282_ab);
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.DESERT_DUNGEONS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(RSPlacements.RS_DUNGEON_PLACEMENT.func_227446_a_((IPlacementConfig)new CountRangeConfig(RepurposedStructures.RSDungeonsConfig.desertDungeonSpawnrate.get().intValue(), RepurposedStructures.RSDungeonsConfig.desertDungeonMinHeight.get().intValue(), 0, RepurposedStructures.RSDungeonsConfig.desertDungeonMaxHeight.get().intValue()))));
        } else if (RepurposedStructures.RSDungeonsConfig.mushroomDungeonSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.MUSHROOM && RSAddFeatures.dungeonAllowedByNamespaceAndConfigUA(biomeNamespace)) {
            biome.func_203607_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES).removeIf(configuredFeature -> configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_202282_ab);
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.MUSHROOM_DUNGEONS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(RSPlacements.RS_DUNGEON_PLACEMENT.func_227446_a_((IPlacementConfig)new CountRangeConfig(RepurposedStructures.RSDungeonsConfig.mushroomDungeonSpawnrate.get().intValue(), RepurposedStructures.RSDungeonsConfig.mushroomDungeonMinHeight.get().intValue(), 0, RepurposedStructures.RSDungeonsConfig.mushroomDungeonMaxHeight.get().intValue()))));
        } else if (RepurposedStructures.RSDungeonsConfig.swampDungeonSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.SWAMP && RSAddFeatures.dungeonAllowedByNamespaceAndConfigUA(biomeNamespace)) {
            biome.func_203607_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES).removeIf(configuredFeature -> configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_202282_ab);
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.SWAMP_DUNGEONS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(RSPlacements.RS_DUNGEON_PLACEMENT.func_227446_a_((IPlacementConfig)new CountRangeConfig(RepurposedStructures.RSDungeonsConfig.swampDungeonSpawnrate.get().intValue(), RepurposedStructures.RSDungeonsConfig.swampDungeonMinHeight.get().intValue(), 0, RepurposedStructures.RSDungeonsConfig.swampDungeonMaxHeight.get().intValue()))));
        } else if (RepurposedStructures.RSDungeonsConfig.snowDungeonSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.ICY && RSAddFeatures.dungeonAllowedByNamespaceAndConfigUA(biomeNamespace)) {
            biome.func_203607_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES).removeIf(configuredFeature -> configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_202282_ab);
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.SNOW_DUNGEONS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(RSPlacements.RS_DUNGEON_PLACEMENT.func_227446_a_((IPlacementConfig)new CountRangeConfig(RepurposedStructures.RSDungeonsConfig.snowDungeonSpawnrate.get().intValue(), RepurposedStructures.RSDungeonsConfig.snowDungeonMinHeight.get().intValue(), 0, RepurposedStructures.RSDungeonsConfig.snowDungeonMaxHeight.get().intValue()))));
        } else if (RepurposedStructures.RSDungeonsConfig.netherDungeonSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.NETHER && RSAddFeatures.dungeonAllowedByNamespaceAndConfigUA(biomeNamespace)) {
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.NETHER_DUNGEONS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(RSPlacements.RS_DUNGEON_PLACEMENT.func_227446_a_((IPlacementConfig)new CountRangeConfig(RepurposedStructures.RSDungeonsConfig.netherDungeonSpawnrate.get().intValue(), RepurposedStructures.RSDungeonsConfig.netherDungeonMinHeight.get().intValue(), 0, RepurposedStructures.RSDungeonsConfig.netherDungeonMaxHeight.get().intValue()))));
        } else if (RepurposedStructures.RSDungeonsConfig.endDungeonSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.THEEND && biome != Biomes.field_76779_k && biome != Biomes.field_201936_P && RSAddFeatures.dungeonAllowedByNamespaceAndConfigUA(biomeNamespace)) {
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.END_DUNGEONS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(RSPlacements.RS_DUNGEON_PLACEMENT.func_227446_a_((IPlacementConfig)new CountRangeConfig(RepurposedStructures.RSDungeonsConfig.endDungeonSpawnrate.get().intValue(), RepurposedStructures.RSDungeonsConfig.endDungeonMinHeight.get().intValue(), 0, RepurposedStructures.RSDungeonsConfig.endDungeonMaxHeight.get().intValue()))));
        } else if (RepurposedStructures.RSDungeonsConfig.oceanDungeonSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.OCEAN && RSAddFeatures.dungeonAllowedByNamespaceAndConfig(biomeNamespace)) {
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.OCEAN_DUNGEONS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(RSPlacements.RS_DUNGEON_PLACEMENT.func_227446_a_((IPlacementConfig)new CountRangeConfig(RepurposedStructures.RSDungeonsConfig.oceanDungeonSpawnrate.get().intValue(), RepurposedStructures.RSDungeonsConfig.oceanDungeonMinHeight.get().intValue(), 0, RepurposedStructures.RSDungeonsConfig.oceanDungeonMaxHeight.get().intValue()))));
        }
    }

    private static boolean dungeonAllowedByNamespaceAndConfigUA(String biomeNamespace) {
        if (!biomeNamespace.equals("ultra_amplified_dimension")) {
            return RSAddFeatures.dungeonAllowedByNamespaceAndConfig(biomeNamespace);
        }
        return false;
    }

    private static boolean dungeonAllowedByNamespaceAndConfig(String biomeNamespace) {
        return biomeNamespace.equals("minecraft") || RepurposedStructures.RSDungeonsConfig.addDungeonsToModdedBiomes.get() != false;
    }

    public static void addWells(Biome biome, String biomeNamespace, String biomePath) {
        if (RepurposedStructures.RSWellsConfig.badlandsWellSpawnrate.get() != 10000 && biome.func_201856_r() == Biome.Category.MESA && RSAddFeatures.wellAllowedByNamespaceAndConfig(biomeNamespace)) {
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, RSFeatures.BADLANDS_WELL.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215023_i.func_227446_a_((IPlacementConfig)new ChanceConfig(RepurposedStructures.RSWellsConfig.badlandsWellSpawnrate.get().intValue()))));
        } else if (RepurposedStructures.RSWellsConfig.netherWellSpawnrate.get() != 10000 && biome.func_201856_r() == Biome.Category.NETHER && RSAddFeatures.wellAllowedByNamespaceAndConfig(biomeNamespace)) {
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, RSFeatures.NETHER_WELL.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215032_r.func_227446_a_((IPlacementConfig)new ChanceRangeConfig(1.0f / (float)RepurposedStructures.RSWellsConfig.netherWellSpawnrate.get().intValue(), 30, 0, 98))));
        } else if (RepurposedStructures.RSWellsConfig.snowWellSpawnrate.get() != 10000 && (biome.func_201856_r() == Biome.Category.ICY || biomePath.contains("snow")) && RSAddFeatures.wellAllowedByNamespaceAndConfig(biomeNamespace)) {
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, RSFeatures.SNOW_WELL.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215023_i.func_227446_a_((IPlacementConfig)new ChanceConfig(RepurposedStructures.RSWellsConfig.snowWellSpawnrate.get().intValue()))));
        } else if (RepurposedStructures.RSWellsConfig.mossyStoneWellSpawnrate.get() != 10000 && (biome.func_201856_r() == Biome.Category.JUNGLE || biome.func_201856_r() == Biome.Category.SWAMP || biomePath.contains("dark_forest") || biomePath.contains("dark_oak")) && RSAddFeatures.wellAllowedByNamespaceAndConfig(biomeNamespace)) {
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, RSFeatures.MOSSY_STONE_WELL.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215023_i.func_227446_a_((IPlacementConfig)new ChanceConfig(RepurposedStructures.RSWellsConfig.mossyStoneWellSpawnrate.get().intValue()))));
        } else if (RepurposedStructures.RSWellsConfig.forestWellSpawnrate.get() != 10000 && biome.func_201856_r() == Biome.Category.FOREST && !biomePath.contains("dark_forest") && !biomePath.contains("dark_oak") && RSAddFeatures.wellAllowedByNamespaceAndConfig(biomeNamespace)) {
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, RSFeatures.FOREST_WELL.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215023_i.func_227446_a_((IPlacementConfig)new ChanceConfig(RepurposedStructures.RSWellsConfig.forestWellSpawnrate.get().intValue()))));
        }
    }

    private static boolean wellAllowedByNamespaceAndConfig(String biomeNamespace) {
        return biomeNamespace.equals("minecraft") || RepurposedStructures.RSWellsConfig.addWellsToModdedBiomes.get() != false;
    }

    public static void addMiscFeatures(Biome biome, String biomeNamespace, String biomePath) {
        if (RepurposedStructures.RSMainConfig.hornedSwampTree.get().booleanValue() && !biomeNamespace.equals("ultra_amplified_dimension") && biome == Biomes.field_76780_h && biomeNamespace.equals("minecraft")) {
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, RSFeatures.HORNED_SWAMP_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226814_i_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.7f, 1))));
        } else if (RepurposedStructures.RSMainConfig.hornedSwampTree.get().booleanValue() && !biomeNamespace.equals("ultra_amplified_dimension") && (biome == Biomes.field_150599_m && biomeNamespace.equals("minecraft") || RepurposedStructures.RSMainConfig.addMiscToModdedBiomes.get().booleanValue() && !biomeNamespace.equals("minecraft") && biomePath.contains("swamp") && biome != Biomes.field_76780_h)) {
            biome.func_203607_a(GenerationStage.Decoration.VEGETAL_DECORATION).removeIf(configuredFeature -> configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && RSAddFeatures.serializeAndCompareFeature(configuredFeature, VANILLA_SWAMP_TREE));
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, RSFeatures.HORNED_SWAMP_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226814_i_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.8f, 1))));
        } else if (RepurposedStructures.RSMainConfig.boulderTiny.get().booleanValue() && !biomeNamespace.equals("ultra_amplified_dimension") && ((biome == Biomes.field_150590_f || biome == Biomes.field_185431_ac) && biomeNamespace.equals("minecraft") || RepurposedStructures.RSMainConfig.addMiscToModdedBiomes.get().booleanValue() && !biomeNamespace.equals("minecraft") && biomePath.contains("taiga"))) {
            biome.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, RSFeatures.BOULDER_TINY.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215040_z.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        } else if (RepurposedStructures.RSMainConfig.boulderGiant.get().booleanValue() && !biomeNamespace.equals("ultra_amplified_dimension") && ((biome == Biomes.field_185433_ae || biome == Biomes.field_150581_V) && biomeNamespace.equals("minecraft") || RepurposedStructures.RSMainConfig.addMiscToModdedBiomes.get().booleanValue() && !biomeNamespace.equals("minecraft") && (biomePath.contains("giant") && biomePath.contains("taiga") || biomePath.contains("redwood")))) {
            biome.func_203607_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS).removeIf(configuredFeature -> configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && RSAddFeatures.serializeAndCompareFeature(configuredFeature, VANILLA_BOULDER));
            biome.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, RSFeatures.BOULDER_GIANT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215040_z.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        }
    }

    public static void addStronghold(Biome biome, String biomeNamespace, String biomePath) {
        if (!RepurposedStructures.RSStrongholdsConfig.useVanillaStronghold.get().booleanValue() && biome.func_201856_r() == Biome.Category.NETHER && RepurposedStructures.RSStrongholdsConfig.allowNetherStronghold.get().booleanValue()) {
            if (RepurposedStructures.RSStrongholdsConfig.strongholdSpawnrate.get() != 1001) {
                biome.func_226711_a_(RSFeatures.STRONGHOLD.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (biome.field_201874_aj.containsKey(Feature.field_202335_m)) {
            if (!RepurposedStructures.RSStrongholdsConfig.useVanillaStronghold.get().booleanValue()) {
                biome.field_201874_aj.remove(Feature.field_202335_m);
            }
            ((List)biome.field_201872_ah.get(GenerationStage.Decoration.UNDERGROUND_STRUCTURES)).removeIf(configuredFeature -> configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && RSAddFeatures.serializeAndCompareFeature(configuredFeature, Feature.field_202335_m.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e))));
            if (RepurposedStructures.RSStrongholdsConfig.strongholdSpawnrate.get() != 1001) {
                biome.func_226711_a_(RSFeatures.STRONGHOLD.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        }
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.STRONGHOLD.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
    }

    public static void addNetherTemple(Biome biome, String biomeNamespace, String biomePath) {
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, RSFeatures.NETHER_TEMPLE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        if (RepurposedStructures.RSMainConfig.netherTempleSpawnrate.get() == 1001) {
            return;
        }
        if (biome.func_201856_r() == Biome.Category.NETHER && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMainConfig.addNetherTempleToModdedBiomes.get().booleanValue())) {
            biome.func_226711_a_(RSFeatures.NETHER_TEMPLE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
    }

    public static void addBadlandsTemple(Biome biome, String biomeNamespace, String biomePath) {
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, RSFeatures.BADLANDS_TEMPLE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        if (RepurposedStructures.RSMainConfig.badlandsTempleSpawnrate.get() == 1001) {
            return;
        }
        if (biome.func_201856_r() == Biome.Category.MESA && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMainConfig.addBadlandsTempleToModdedBiomes.get().booleanValue())) {
            biome.func_226711_a_(RSFeatures.BADLANDS_TEMPLE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
    }

    public static void addIgloos(Biome biome, String biomeNamespace, String biomePath) {
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, RSFeatures.GRASSY_IGLOO.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, RSFeatures.STONE_IGLOO.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        if (RepurposedStructures.RSMainConfig.grassyIglooSpawnrate.get() != 1001 && (biome.func_201856_r() == Biome.Category.PLAINS || biome.func_201856_r() == Biome.Category.FOREST) && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMainConfig.addGrassyIglooToModdedBiomes.get().booleanValue())) {
            biome.func_226711_a_(RSFeatures.GRASSY_IGLOO.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
        if (RepurposedStructures.RSMainConfig.stoneIglooSpawnrate.get() != 1001) {
            String BiomeName = biome.getRegistryName().func_110623_a().toString();
            if (biome.func_201856_r() == Biome.Category.TAIGA && BiomeName.contains("giant") && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMainConfig.addStoneIglooToModdedBiomes.get().booleanValue())) {
                biome.func_226711_a_(RSFeatures.STONE_IGLOO.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        }
    }

    public static void addVillages(Biome biome, String biomeNamespace, String biomePath) {
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, RSFeatures.BADLANDS_VILLAGE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        if (RepurposedStructures.RSVillagesConfig.badlandsVillageSpawnrate.get() != 1001) {
            String BiomeName = biome.getRegistryName().func_110623_a().toString();
            if (biome.func_201856_r() == Biome.Category.MESA && !BiomeName.contains("plateau") && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue())) {
                biome.func_226711_a_(RSFeatures.BADLANDS_VILLAGE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        }
    }

    private static boolean serializeAndCompareFeature(ConfiguredFeature<?, ?> feature1, ConfiguredFeature<?, ?> feature2) {
        block3: {
            try {
                Map feature1Map = (Map)feature1.func_222735_a((DynamicOps)NBTDynamicOps.field_210820_a).getMapValues().get();
                Map feature2Map = (Map)feature2.func_222735_a((DynamicOps)NBTDynamicOps.field_210820_a).getMapValues().get();
                if (feature1Map != null && feature2Map != null) {
                    return feature1Map.equals(feature2Map);
                }
            }
            catch (Exception e) {
                if (!(feature1.field_222738_b instanceof DecoratedFeatureConfig) || !(feature2.field_222738_b instanceof DecoratedFeatureConfig) || ((DecoratedFeatureConfig)feature1.field_222738_b).field_214689_a.field_222737_a != ((DecoratedFeatureConfig)feature2.field_222738_b).field_214689_a.field_222737_a) break block3;
                return true;
            }
        }
        return false;
    }
}

