/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures;

import com.telepathicgrunt.repurposedstructures.RSAddFeatures;
import com.telepathicgrunt.repurposedstructures.configs.RSDungeonsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSMainConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSMineshaftsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSStrongholdsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSVillagesConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSWellsConfig;
import com.telepathicgrunt.repurposedstructures.utils.ConfigHelper;
import com.telepathicgrunt.repurposedstructures.world.features.RSFeatures;
import com.telepathicgrunt.repurposedstructures.world.features.structures.VillageBadlandsPools;
import com.telepathicgrunt.repurposedstructures.world.placements.RSPlacements;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="repurposed_structures")
public class RepurposedStructures {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "repurposed_structures";
    public static RSMainConfig.RSConfigValues RSMainConfig = null;
    public static RSDungeonsConfig.RSDungeonsConfigValues RSDungeonsConfig = null;
    public static RSMineshaftsConfig.RSMineshaftsConfigValues RSMineshaftsConfig = null;
    public static RSStrongholdsConfig.RSStrongholdsConfigValues RSStrongholdsConfig = null;
    public static RSWellsConfig.RSWellsConfigValues RSWellsConfig = null;
    public static RSVillagesConfig.RSVillagesConfigValues RSVillagesConfig = null;

    public RepurposedStructures() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        RSMainConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSMainConfig.RSConfigValues::new, "repurposed_structures-common.toml");
        RSDungeonsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSDungeonsConfig.RSDungeonsConfigValues::new, "repurposed_structures-dungeons.toml");
        RSMineshaftsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSMineshaftsConfig.RSMineshaftsConfigValues::new, "repurposed_structures-mineshafts.toml");
        RSStrongholdsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSStrongholdsConfig.RSStrongholdsConfigValues::new, "repurposed_structures-strongholds.toml");
        RSWellsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSWellsConfig.RSWellsConfigValues::new, "repurposed_structures-wells.toml");
        RSVillagesConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSVillagesConfig.RSVillagesConfigValues::new, "repurposed_structures-villages.toml");
    }

    public void setup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(RepurposedStructures::addFeaturesAndStructuresToBiomes);
    }

    private static void addFeaturesAndStructuresToBiomes() {
        VillageBadlandsPools.init();
        for (Biome biome : ForgeRegistries.BIOMES) {
            String biomeNamespace = biome.getRegistryName().func_110624_b();
            String biomePath = biome.getRegistryName().func_110623_a();
            RSAddFeatures.addMineshafts(biome, biomeNamespace, biomePath);
            RSAddFeatures.addJungleFortress(biome, biomeNamespace, biomePath);
            RSAddFeatures.addDungeons(biome, biomeNamespace, biomePath);
            RSAddFeatures.addWells(biome, biomeNamespace, biomePath);
            RSAddFeatures.addMiscFeatures(biome, biomeNamespace, biomePath);
            RSAddFeatures.addStronghold(biome, biomeNamespace, biomePath);
            RSAddFeatures.addNetherTemple(biome, biomeNamespace, biomePath);
            RSAddFeatures.addBadlandsTemple(biome, biomeNamespace, biomePath);
            RSAddFeatures.addIgloos(biome, biomeNamespace, biomePath);
            RSAddFeatures.addVillages(biome, biomeNamespace, biomePath);
            biome.func_226711_a_(RSFeatures.DUMMY_MINESHAFT_STRUCTURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSFeatures.DUMMY_MINESHAFT_STRUCTURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onRegisterFeatures(RegistryEvent.Register<Feature<?>> event) {
            RSFeatures.registerFeatures(event);
        }

        @SubscribeEvent
        public static void onRegisterPlacements(RegistryEvent.Register<Placement<?>> event) {
            RSPlacements.registerPlacements(event);
        }
    }
}

