/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.configs;

import com.telepathicgrunt.repurposedstructures.utils.ConfigHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RSStrongholdsConfig {

    public static class RSStrongholdsConfigValues {
        public ConfigHelper.ConfigValueListener<Boolean> useVanillaStronghold;
        public ConfigHelper.ConfigValueListener<Boolean> allowStonebrickStronghold;
        public ConfigHelper.ConfigValueListener<Boolean> allowNetherStronghold;
        public ConfigHelper.ConfigValueListener<Integer> strongholdSpawnrate;
        public ConfigHelper.ConfigValueListener<Double> silverfishSpawnrateSH;
        public ConfigHelper.ConfigValueListener<Boolean> allowExtraSpawnersSH;
        public ConfigHelper.ConfigValueListener<Double> strongholdSizeSH;
        public ConfigHelper.ConfigValueListener<Boolean> lootChestsSH;
        public ConfigHelper.ConfigValueListener<Integer> normalStrongholdMinHeight;
        public ConfigHelper.ConfigValueListener<Integer> normalStrongholdMaxHeight;
        public ConfigHelper.ConfigValueListener<Integer> netherStrongholdMinHeight;
        public ConfigHelper.ConfigValueListener<Integer> netherStrongholdMaxHeight;

        public RSStrongholdsConfigValues(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber) {
            builder.push("Stronghold");
            this.useVanillaStronghold = subscriber.subscribe(builder.comment("\r\n Use vanilla Stronghold instead of using this mod's modded version.\r\n Note: The other Stronghold configs here will have no effect on vanilla Strongholds. \r\n WARNING: Nether Strongholds will be turned off too when this option is on.").translation("repurposedstructures.config.structure.stronghold.usevanillastronghold").define("useVanillaStronghold", false));
            this.allowStonebrickStronghold = subscriber.subscribe(builder.comment("\r\n Allow Stonebrick styled Stronghold to generate in non-Nether biomes.").translation("repurposedstructures.config.structure.stronghold.allowstonebrickstronghold").define("allowStonebrickStronghold", true));
            this.allowNetherStronghold = subscriber.subscribe(builder.comment("\r\n Allow Nether-styled Strongholds to spawn in Nether category biomes.\r\n Note: Eyes of Ender will work and show the closest Nether Stronghold too.").translation("repurposedstructures.config.structure.stronghold.allownetherstronghold").define("allowNetherStronghold", true));
            this.strongholdSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Strongholds.\n 1 for spawning in most chunks and 1001 for no spawn.").translation("repurposedstructures.config.structure.stronghold.strongholdspawnrate").defineInRange("strongholdSpawnrate", 85, 1, 1001));
            this.silverfishSpawnrateSH = subscriber.subscribe(builder.comment("\r\n How often Silverfish Blocks will generate in Strongholds as a percentage.\r\n Note: Mossy Stone Bricks block cannot be infected by Silverfish\n 0 for no Silverfish Blocks and 100 for max spawnrate.").translation("repurposedstructures.config.structure.stronghold.silverfishspawnratesh").defineInRange("silverfishSpawnrateSH", 0.8, 0.0, 100.0));
            this.allowExtraSpawnersSH = subscriber.subscribe(builder.comment("\r\n Make Mob Spawners generate in rooms other than the Portal Room in Strongholds.\r\n Note: Spawners in Portal Room will always remain.").translation("repurposedstructures.config.structure.stronghold.allowextraspawnerssh").define("allowExtraSpawnersSH", true));
            this.strongholdSizeSH = subscriber.subscribe(builder.comment("\r\n How large the Stronghold is on average as a percentage.\r\n Note: The Stonghold is much larger by default. To get something \r\n closer to vanilla stronghold size, use the value of 60.\n 10 for supertiny Strongholds and 2000 for supermassive Strongholds.").translation("repurposedstructures.config.structure.stronghold.strongholdsizesh").defineInRange("strongholdSizeSH", 100.0, 10.0, 2000.0));
            this.normalStrongholdMinHeight = subscriber.subscribe(builder.comment("\r\n Minimum Y height that normal stronghold's starting point can spawn at. \r\nDefault is 0.\r\n Note: Strongholds will spawn between min and max y height set in config.\r\n").translation("repurposedstructures.config.feature.stronghold.normalstrongholdminheight").defineInRange("normalStrongholdMinHeight", 0, 0, 255));
            this.normalStrongholdMaxHeight = subscriber.subscribe(builder.comment("\r\n Minimum Y height that normal stronghold's starting point can spawn at.\r\n Default is 50.\r\n Note: Strongholds will spawn between min and max y height set in config.\r\n Setting this to below min height config will make strongholds spawn only at min height.").translation("repurposedstructures.config.feature.stronghold.normalstrongholdmaxheight").defineInRange("normalStrongholdMaxHeight", 50, 0, 255));
            this.netherStrongholdMinHeight = subscriber.subscribe(builder.comment("\r\n Minimum Y height that Nether stronghold's starting point can spawn at. \r\nDefault is 35.\r\n Note: Strongholds will spawn between min and max y height set in config.\r\n").translation("repurposedstructures.config.feature.stronghold.netherstrongholdminheight").defineInRange("netherStrongholdMinHeight", 35, 0, 255));
            this.netherStrongholdMaxHeight = subscriber.subscribe(builder.comment("\r\n Minimum Y height that Nether stronghold's starting point can spawn at. \r\nDefault is 40.\r\n Note: Strongholds will spawn between min and max y height set in config.\r\n Setting this to below min height config will make strongholds spawn only at min height.").translation("repurposedstructures.config.feature.stronghold.netherstrongholdmaxheight").defineInRange("netherStrongholdMaxHeight", 40, 0, 255));
            this.lootChestsSH = subscriber.subscribe(builder.comment("\r\n Controls whether loot chests spawn or not in the Stronghold.").translation("repurposedstructures.config.structure.stronghold.lootchestssh").define("lootChestsSH", true));
            builder.pop();
        }
    }
}

