/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.configs;

import com.telepathicgrunt.repurposedstructures.utils.ConfigHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RSWellsConfig {

    public static class RSWellsConfigValues {
        public ConfigHelper.ConfigValueListener<Boolean> addWellsToModdedBiomes;
        public ConfigHelper.ConfigValueListener<Boolean> canHaveBells;
        public ConfigHelper.ConfigValueListener<Integer> badlandsWellSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> netherWellSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> snowWellSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> mossyStoneWellSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> forestWellSpawnrate;

        public RSWellsConfigValues(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber) {
            builder.push("Small Wells");
            this.addWellsToModdedBiomes = subscriber.subscribe(builder.comment("\r\n Add the custom wells to modded biomes of the same categories/type.").translation("repurposedstructures.config.feature.smallwells.addwellstomoddedbiomes").define("addWellsToModdedBiomes", false));
            this.canHaveBells = subscriber.subscribe(builder.comment("\r\n Determines if Wells can have a chance of spawning a Bell.").translation("repurposedstructures.config.feature.smallwells.canhavebells").define("canHaveBells", true));
            builder.push("Spawnrate");
            this.badlandsWellSpawnrate = subscriber.subscribe(builder.comment("\r\n Adds Badlands themed wells to Badlands biomes.\r\n This effects how often wells will attempt to spawn per chunk.\r\n The chance of a well generating at a chunk is 1/spawnrate.\r\n 1 for wells spawning in every chunk and 10000 for no wells.").translation("repurposedstructures.config.feature.smallwells.badlandswellspawnrate").defineInRange("badlandsWellSpawnrate", 350, 1, 10000));
            this.netherWellSpawnrate = subscriber.subscribe(builder.comment("\r\n Adds Nether themed wells to Nether biomes.\r\n This effects how often wells will attempt to spawn per chunk.\r\n The chance of a well generating at a chunk is 1/spawnrate.\r\n 1 for wells spawning in every chunk and 10000 for no wells.").translation("repurposedstructures.config.feature.smallwells.netherwellspawnrate").defineInRange("netherWellSpawnrate", 350, 1, 10000));
            this.snowWellSpawnrate = subscriber.subscribe(builder.comment("\r\n Adds Snow themed wells to snowy and icy biomes.\r\n This effects how often wells will attempt to spawn per chunk.\r\n The chance of a well generating at a chunk is 1/spawnrate.\r\n 1 for wells spawning in every chunk and 10000 for no wells.").translation("repurposedstructures.config.feature.smallwells.snowwellspawnrate").defineInRange("snowWellSpawnrate", 350, 1, 10000));
            this.mossyStoneWellSpawnrate = subscriber.subscribe(builder.comment("\r\n Adds mossy stone themed wells to Jungles, Dark Oak, and Swamp biomes.\r\n This effects how often wells will attempt to spawn per chunk.\r\n The chance of a well generating at a chunk is 1/spawnrate.\r\n 1 for wells spawning in every chunk and 10000 for no wells.").translation("repurposedstructures.config.feature.smallwells.mossystonewellspawnrate").defineInRange("mossyStoneWellSpawnrate", 350, 1, 10000));
            this.forestWellSpawnrate = subscriber.subscribe(builder.comment("\r\n Adds a wood themed wells to Forest and Birch Forest biomes.\r\n This effects how often wells will attempt to spawn per chunk.\r\n The chance of a well generating at a chunk is 1/spawnrate.\r\n 1 for wells spawning in every chunk and 10000 for no wells.").translation("repurposedstructures.config.feature.smallwells.forestwellspawnrate").defineInRange("forestWellSpawnrate", 350, 1, 10000));
            builder.pop();
            builder.pop();
        }
    }
}

