/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class BoulderGiant
extends Feature<NoFeatureConfig> {
    private static final BlockState MOSSY_COBBLESTONE = Blocks.field_150341_Y.func_176223_P();
    private static final BlockState COBBLESTONE = Blocks.field_150347_e.func_176223_P();
    private static final BlockState ANDESITE = Blocks.field_196656_g.func_176223_P();
    private static final BlockState COAL_ORE = Blocks.field_150365_q.func_176223_P();
    private static final BlockState IRON_ORE = Blocks.field_150366_p.func_176223_P();
    private static final BlockState DIAMOND_ORE = Blocks.field_150482_ag.func_176223_P();
    private static final int START_RADIUS = 4;

    public BoulderGiant(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, BlockPos position, NoFeatureConfig config) {
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position);
        BlockState blockState = world.func_180495_p((BlockPos)blockpos$Mutable);
        while (blockpos$Mutable.func_177956_o() >= 6) {
            if (blockState.func_185904_a() == Material.field_151579_a || blockState.func_177230_c() != Blocks.field_196658_i && !BoulderGiant.func_227250_b_((Block)blockState.func_177230_c())) {
                blockpos$Mutable.func_189536_c(Direction.DOWN);
                blockState = world.func_180495_p((BlockPos)blockpos$Mutable);
                continue;
            }
            blockpos$Mutable.func_189534_c(Direction.UP, 2);
            break;
        }
        if (blockpos$Mutable.func_177956_o() <= 10 || blockpos$Mutable.func_177956_o() >= 250) {
            return false;
        }
        for (int currentCount = 0; currentCount < 3; ++currentCount) {
            int x = 4 + random.nextInt(2);
            int y = 4 + random.nextInt(2);
            int z = 4 + random.nextInt(2);
            float calculatedDistance = (float)(x + y + z) * 0.333f + 0.5f;
            for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)blockpos$Mutable.func_177982_a(-x, -y, -z), (BlockPos)blockpos$Mutable.func_177982_a(x, y, z))) {
                if (!(blockpos.func_177951_i((Vec3i)blockpos$Mutable) <= (double)(calculatedDistance * calculatedDistance))) continue;
                int randomChance = random.nextInt(3000);
                if (randomChance == 0) {
                    world.func_180501_a(blockpos, DIAMOND_ORE, 4);
                    continue;
                }
                if (randomChance <= 75) {
                    world.func_180501_a(blockpos, IRON_ORE, 4);
                    continue;
                }
                if (randomChance <= 255) {
                    world.func_180501_a(blockpos, COAL_ORE, 4);
                    continue;
                }
                if (randomChance <= 1025) {
                    world.func_180501_a(blockpos, ANDESITE, 4);
                    continue;
                }
                if (randomChance <= 1725) {
                    world.func_180501_a(blockpos, COBBLESTONE, 4);
                    continue;
                }
                world.func_180501_a(blockpos, MOSSY_COBBLESTONE, 4);
            }
            blockpos$Mutable.func_196234_d(-5 + random.nextInt(10), 0 - random.nextInt(2), -5 + random.nextInt(10));
        }
        return true;
    }
}

