/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class BoulderTiny
extends Feature<NoFeatureConfig> {
    private static final BlockState MOSSY_COBBLESTONE = Blocks.field_150341_Y.func_176223_P();
    private static final BlockState COBBLESTONE = Blocks.field_150347_e.func_176223_P();
    private static final BlockState ANDESITE = Blocks.field_196656_g.func_176223_P();
    private static final BlockState COAL_ORE = Blocks.field_150365_q.func_176223_P();
    private static final BlockState IRON_ORE = Blocks.field_150366_p.func_176223_P();
    private static final int START_RADIUS = 0;

    public BoulderTiny(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, BlockPos position, NoFeatureConfig config) {
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position.func_177977_b());
        Block block = world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c();
        if (block != Blocks.field_196658_i && block != Blocks.field_196661_l && !BoulderTiny.func_227250_b_((Block)block)) {
            return false;
        }
        for (int currentCount = 0; currentCount < 3; ++currentCount) {
            int x = 0 + random.nextInt(2);
            int y = 0 + random.nextInt(2);
            int z = 0 + random.nextInt(2);
            float calculatedDistance = (float)(x + y + z) * 0.333f + 0.5f;
            for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)blockpos$Mutable.func_177982_a(-x, -y, -z), (BlockPos)blockpos$Mutable.func_177982_a(x, y, z))) {
                if (!(blockpos.func_177951_i((Vec3i)blockpos$Mutable) <= (double)(calculatedDistance * calculatedDistance))) continue;
                int randomChance = random.nextInt(1000);
                if (randomChance <= 35) {
                    world.func_180501_a(blockpos.func_177984_a(), IRON_ORE, 4);
                    continue;
                }
                if (randomChance <= 100) {
                    world.func_180501_a(blockpos.func_177984_a(), COAL_ORE, 4);
                    continue;
                }
                if (randomChance <= 350) {
                    world.func_180501_a(blockpos.func_177984_a(), ANDESITE, 4);
                    continue;
                }
                if (randomChance <= 600) {
                    world.func_180501_a(blockpos.func_177984_a(), COBBLESTONE, 4);
                    continue;
                }
                world.func_180501_a(blockpos.func_177984_a(), MOSSY_COBBLESTONE, 4);
            }
            blockpos$Mutable.func_196234_d(-1 + random.nextInt(2), -random.nextInt(2), -1 + random.nextInt(2));
        }
        return true;
    }
}

