/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DungeonEnd
extends Feature<NoFeatureConfig> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();
    private static final ResourceLocation CHEST_LOOT = new ResourceLocation("repurposed_structures:chests/dungeon_end");

    public DungeonEnd(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, NoFeatureConfig p_212245_5_) {
        int z;
        int y;
        int x;
        int randXRange = rand.nextInt(2) + 2;
        int xMin = -randXRange - 1;
        int xMax = randXRange + 1;
        int randZRange = rand.nextInt(2) + 2;
        int zMin = -randZRange - 1;
        int zMax = randZRange + 1;
        int validOpeneings = 0;
        int ceilingOpenings = 0;
        BlockPos newPosition = new BlockPos(position.func_177958_n(), rand.nextInt(world.func_201676_a(Heightmap.Type.WORLD_SURFACE, position.func_177958_n(), position.func_177952_p()) + 5), position.func_177952_p());
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(newPosition);
        for (x = xMin; x <= xMax; ++x) {
            for (y = -1; y <= 4; ++y) {
                for (z = zMin; z <= zMax; ++z) {
                    blockpos$Mutable.func_189533_g((Vec3i)newPosition).func_196234_d(x, y, z);
                    Material material = world.func_180495_p((BlockPos)blockpos$Mutable).func_185904_a();
                    boolean flag = material.func_76220_a();
                    if (y == -1 && !flag) {
                        return false;
                    }
                    if (y == 4 && !flag) {
                        ++ceilingOpenings;
                    }
                    if (x != xMin && x != xMax && z != zMin && z != zMax || y != 0 || !world.func_175623_d((BlockPos)blockpos$Mutable) || !world.func_175623_d(blockpos$Mutable.func_177984_a())) continue;
                    ++validOpeneings;
                }
            }
        }
        if (validOpeneings >= 1 && validOpeneings <= 14 && ceilingOpenings < 14) {
            for (x = xMin; x <= xMax; ++x) {
                for (y = 3; y >= -1; --y) {
                    for (z = zMin; z <= zMax; ++z) {
                        blockpos$Mutable.func_189533_g((Vec3i)newPosition).func_196234_d(x, y, z);
                        if (x != xMin && y != -1 && z != zMin && x != xMax && y != 4 && z != zMax) {
                            if (world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150486_ae || world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150474_ac) continue;
                            world.func_180501_a((BlockPos)blockpos$Mutable, CAVE_AIR, 2);
                            continue;
                        }
                        if (blockpos$Mutable.func_177956_o() >= 0 && !world.func_180495_p(blockpos$Mutable.func_177977_b()).func_185904_a().func_76220_a()) {
                            world.func_180501_a((BlockPos)blockpos$Mutable, CAVE_AIR, 2);
                            continue;
                        }
                        if (!world.func_180495_p((BlockPos)blockpos$Mutable).func_185904_a().func_76220_a() || world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150486_ae || world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150474_ac) continue;
                        world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_196806_hJ.func_176223_P(), 2);
                    }
                }
            }
            for (int j4 = 0; j4 < rand.nextInt(4); ++j4) {
                int x2 = newPosition.func_177958_n() + rand.nextInt(randXRange * 2 + 1) - randXRange;
                int y2 = newPosition.func_177956_o();
                int z2 = newPosition.func_177952_p() + rand.nextInt(randZRange * 2 + 1) - randZRange;
                blockpos$Mutable.func_181079_c(x2, y2, z2);
                if (!world.func_175623_d((BlockPos)blockpos$Mutable)) continue;
                int j3 = 0;
                for (Direction Direction2 : Direction.Plane.HORIZONTAL) {
                    if (!world.func_180495_p(blockpos$Mutable.func_177972_a(Direction2)).func_185904_a().func_76220_a()) continue;
                    ++j3;
                }
                if (j3 != true) continue;
                world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_204409_il.func_176223_P(), 2);
                LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)blockpos$Mutable, (ResourceLocation)CHEST_LOOT);
                break;
            }
            world.func_180501_a(newPosition, (BlockState)Blocks.field_150378_br.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208182_i, (Comparable)Boolean.valueOf(true)), 2);
            world.func_180501_a(position.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 2);
            world.func_180501_a(newPosition.func_177977_b(), Blocks.field_150474_ac.func_176223_P(), 2);
            TileEntity tileentity = world.func_175625_s(newPosition.func_177977_b());
            if (tileentity instanceof MobSpawnerTileEntity) {
                ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(DungeonEnd.pickMobSpawner(world, rand));
            } else {
                LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{newPosition.func_177958_n(), newPosition.func_177977_b().func_177956_o(), newPosition.func_177952_p()});
            }
            return true;
        }
        return false;
    }

    private static EntityType<?> pickMobSpawner(IWorld world, Random rand) {
        int roll = rand.nextInt(100);
        if (roll < 86) {
            return EntityType.field_200804_r;
        }
        if (roll < 98) {
            return EntityType.field_200803_q;
        }
        return EntityType.field_203097_aH;
    }
}

