/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class TreeSwampHorned
extends AbstractTreeFeature<TreeFeatureConfig> {
    private static final BlockState TRUNK = Blocks.field_196617_K.func_176223_P();
    private static final BlockState LEAF = (BlockState)Blocks.field_196642_W.func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));

    public TreeSwampHorned(Function<Dynamic<?>, ? extends TreeFeatureConfig> config) {
        super(config);
    }

    public boolean place(IWorldGenerationReader worldReader, Random rand, BlockPos position, Set<BlockPos> leaveSet, Set<BlockPos> trunkSet, MutableBoundingBox boundingBox, TreeFeatureConfig config) {
        IWorld world = (IWorld)worldReader;
        int height = rand.nextInt(4) + 6;
        if (!this.isSpaceAt((IWorldGenerationBaseReader)world, position, height)) {
            return false;
        }
        while (world.func_180495_p(position.func_177977_b()).func_185904_a() == Material.field_151586_h) {
            position = position.func_177977_b();
        }
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            int x;
            for (int y = position.func_177956_o(); y <= position.func_177956_o() + 1 + height; ++y) {
                int radius = 1;
                if (y == position.func_177956_o()) {
                    radius = 0;
                }
                if (y >= position.func_177956_o() + 1 + height - 2) {
                    radius = 3;
                }
                BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
                for (x = position.func_177958_n() - radius; x <= position.func_177958_n() + radius && flag; ++x) {
                    for (int z = position.func_177952_p() - radius; z <= position.func_177952_p() + radius && flag; ++z) {
                        if (y >= 0 && y < 256) {
                            blockpos$Mutable.func_181079_c(x, y, z);
                            if (TreeSwampHorned.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)blockpos$Mutable)) continue;
                            if (TreeSwampHorned.func_214571_e((IWorldGenerationBaseReader)world, (BlockPos)blockpos$Mutable)) {
                                flag = false;
                                continue;
                            }
                            if (y <= position.func_177956_o()) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (TreeSwampHorned.isSoil((IWorldGenerationBaseReader)world, (BlockPos)position.func_177977_b(), (IPlantable)config.getSapling()) && position.func_177956_o() < world.getMaxHeight() - height - 1) {
                int z;
                int heightDiff;
                int currentHeight;
                this.setDirtAt((IWorldGenerationReader)world, position.func_177977_b(), position);
                for (currentHeight = position.func_177956_o() - 4 + height; currentHeight <= position.func_177956_o() + height; ++currentHeight) {
                    heightDiff = currentHeight - (position.func_177956_o() + height);
                    int l2 = 2 - heightDiff / 2;
                    for (x = position.func_177958_n() - l2 - 1; x <= position.func_177958_n() + l2; ++x) {
                        int xPos = x - position.func_177958_n();
                        for (z = position.func_177952_p() - l2 - 1; z <= position.func_177952_p() + l2; ++z) {
                            BlockPos blockpos;
                            int zPos = z - position.func_177952_p();
                            int isCornerIfThisIsTwo = 0;
                            if (xPos == l2) {
                                ++isCornerIfThisIsTwo;
                            }
                            if (zPos == l2) {
                                ++isCornerIfThisIsTwo;
                            }
                            if (xPos == -l2 - 1) {
                                ++isCornerIfThisIsTwo;
                            }
                            if (zPos == -l2 - 1) {
                                ++isCornerIfThisIsTwo;
                            }
                            if (isCornerIfThisIsTwo != 2 && (rand.nextInt(3) >= 2 || heightDiff == 0) || !TreeSwampHorned.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)(blockpos = new BlockPos(x, currentHeight, z))) && !TreeSwampHorned.func_214576_j((IWorldGenerationBaseReader)world, (BlockPos)blockpos)) continue;
                            this.func_202278_a((IWorldWriter)world, blockpos, LEAF);
                        }
                    }
                }
                this.genTrunk(world, position, height);
                this.genTrunk(world, position.func_177976_e(), height);
                this.genTrunk(world, position.func_177978_c(), height);
                this.genTrunk(world, position.func_177976_e().func_177978_c(), height);
                for (currentHeight = position.func_177956_o() - 3 + height; currentHeight <= position.func_177956_o() + height; ++currentHeight) {
                    heightDiff = currentHeight - (position.func_177956_o() + height);
                    int i3 = 2 - heightDiff / 2;
                    BlockPos.Mutable blockpos$Mutable1 = new BlockPos.Mutable();
                    for (int x2 = position.func_177958_n() - i3 - 1; x2 <= position.func_177958_n() + i3; ++x2) {
                        for (z = position.func_177952_p() - i3 - 1; z <= position.func_177952_p() + i3; ++z) {
                            blockpos$Mutable1.func_181079_c(x2, currentHeight, z);
                            if (world.func_180495_p((BlockPos)blockpos$Mutable1).func_185904_a() != Material.field_151584_j) continue;
                            BlockPos blockpos3 = blockpos$Mutable1.func_177976_e();
                            BlockPos blockpos4 = blockpos$Mutable1.func_177974_f();
                            BlockPos blockpos1 = blockpos$Mutable1.func_177978_c();
                            BlockPos blockpos2 = blockpos$Mutable1.func_177968_d();
                            if (rand.nextInt(4) == 0 && world.func_175623_d(blockpos3)) {
                                this.addVine(world, blockpos3, VineBlock.field_176278_M);
                            }
                            if (rand.nextInt(4) == 0 && world.func_175623_d(blockpos4)) {
                                this.addVine(world, blockpos4, VineBlock.field_176280_O);
                            }
                            if (rand.nextInt(4) == 0 && world.func_175623_d(blockpos1)) {
                                this.addVine(world, blockpos1, VineBlock.field_176279_N);
                            }
                            if (rand.nextInt(4) != 0 || !world.func_175623_d(blockpos2)) continue;
                            this.addVine(world, blockpos2, VineBlock.field_176273_b);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void addVine(IWorld world, BlockPos pos, BooleanProperty prop) {
        BlockState iblockstate = (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)prop, (Comparable)Boolean.valueOf(true));
        this.func_202278_a((IWorldWriter)world, pos, iblockstate);
        BlockPos blockpos = pos.func_177977_b();
        for (int i = 4; world.func_175623_d(blockpos) && i > 0; --i) {
            this.func_202278_a((IWorldWriter)world, blockpos, iblockstate);
            blockpos = blockpos.func_177977_b();
        }
    }

    private void genTrunk(IWorld world, BlockPos position, int height) {
        this.func_202278_a((IWorldWriter)world, position.func_177977_b(), Blocks.field_150346_d.func_176223_P());
        for (int currentHeight = 0; currentHeight < height; ++currentHeight) {
            BlockPos upN = position.func_177981_b(currentHeight);
            BlockState iblockstate1 = world.func_180495_p(upN);
            Block block2 = iblockstate1.func_177230_c();
            if (currentHeight != height - 1 && (block2.isAir(iblockstate1, (IBlockReader)world, upN) || iblockstate1.func_203425_a(BlockTags.field_206952_E) || block2 == Blocks.field_150355_j || block2 == Blocks.field_196651_dG)) {
                this.func_202278_a((IWorldWriter)world, upN, TRUNK);
                continue;
            }
            this.func_202278_a((IWorldWriter)world, upN, LEAF);
        }
    }

    private boolean isSpaceAt(IWorldGenerationBaseReader world, BlockPos leavesPos, int height) {
        boolean spaceFound = true;
        if (leavesPos.func_177956_o() >= 1 && leavesPos.func_177956_o() + height + 1 <= world.getMaxHeight()) {
            for (int y = 0; y <= 1 + height; ++y) {
                int radius = 2;
                if (y == 0) {
                    radius = 1;
                } else if (y >= 1 + height - 2) {
                    radius = 2;
                }
                for (int x = -radius; x <= radius && spaceFound; ++x) {
                    for (int z = -radius; z <= radius && spaceFound; ++z) {
                        if (leavesPos.func_177956_o() + y >= 0 && leavesPos.func_177956_o() + y < world.getMaxHeight() && TreeSwampHorned.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)leavesPos.func_177982_a(x, y, z))) continue;
                        spaceFound = false;
                    }
                }
            }
            return spaceFound;
        }
        return false;
    }
}

