/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.datafixers.Dynamic;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import java.util.Collection;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.Tags;

public class WellMossyStone
extends Feature<NoFeatureConfig> {
    private static final BlockState MOSSY_STONE_BRICK_SLAB = Blocks.field_222448_ll.func_176223_P();
    private static final BlockState STONE_BRICK_SLAB = Blocks.field_196573_bB.func_176223_P();
    private static final BlockState MOSSY_STONE_BRICKS = Blocks.field_196698_dj.func_176223_P();
    private static final BlockState STONE_BRICKS = Blocks.field_196696_di.func_176223_P();
    private static final BlockState MOSSY_STONE_BRICK_WALL = Blocks.field_222462_lz.func_176223_P();
    private static final BlockState STONE_BRICK_WALL = Blocks.field_222413_lB.func_176223_P();
    private static final BlockState MOSSY_COBBLESTONE = Blocks.field_150341_Y.func_176223_P();
    private static final BlockState COBBLESTONE = Blocks.field_150347_e.func_176223_P();
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    private static final BlockState BELL = Blocks.field_222431_lT.func_176223_P();
    private static final float ORE_CHANCE = 0.12f;
    private static final ResourceLocation MOSSY_WELL_ORE_RL = new ResourceLocation("repurposed_structures:mossy_well_ores");

    public WellMossyStone(Function<Dynamic<?>, ? extends NoFeatureConfig> config) {
        super(config);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, BlockPos position, NoFeatureConfig config) {
        position = position.func_177984_a();
        while ((world.func_175623_d(position) || world.func_180495_p(position).func_185904_a() == Material.field_151586_h) && position.func_177956_o() > 2) {
            position = position.func_177977_b();
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable(position);
        boolean isWithinWaterArea = false;
        boolean isBelowSealevel = false;
        BlockState state1 = null;
        BlockState state2 = null;
        Block block = world.func_180495_p((BlockPos)mutable).func_177230_c();
        if (Tags.Blocks.SAND.func_199685_a_((Object)block) || block == Blocks.field_150435_aG || Tags.Blocks.DIRT.func_199685_a_((Object)block)) {
            int x;
            for (int x2 = -2; x2 <= 2; ++x2) {
                for (int z = -2; z <= 2; ++z) {
                    if (!world.func_175623_d(mutable.func_177977_b()) || !world.func_175623_d(mutable.func_177979_c(2))) continue;
                    return false;
                }
            }
            for (int y = -1; y <= 0; ++y) {
                for (int x3 = -2; x3 <= 2; ++x3) {
                    for (int z = -2; z <= 2; ++z) {
                        world.func_180501_a(mutable.func_177982_a(x3, y, z), WellMossyStone.pickRandomBlock(MOSSY_STONE_BRICKS, STONE_BRICKS, random, 0.6f), 2);
                    }
                }
            }
            Tag ORE_TAG = BlockTags.func_199896_a().func_199915_b(MOSSY_WELL_ORE_RL);
            Collection allOreBlocks = ORE_TAG.func_199885_a();
            isWithinWaterArea = world.func_180495_p(mutable.func_177984_a()).func_185904_a() == Material.field_151586_h;
            isBelowSealevel = isWithinWaterArea && mutable.func_177984_a().func_177956_o() < world.func_181545_F();
            world.func_180501_a(mutable.func_177984_a(), isBelowSealevel ? WATER : AIR, 2);
            world.func_180501_a((BlockPos)mutable, WATER, 2);
            if (!allOreBlocks.isEmpty() && random.nextFloat() < 0.12f) {
                world.func_180501_a(mutable.func_177977_b(), ((Block)allOreBlocks.toArray()[random.nextInt(allOreBlocks.size())]).func_176223_P(), 2);
            } else {
                world.func_180501_a(mutable.func_177977_b(), WellMossyStone.pickRandomBlock(MOSSY_COBBLESTONE, COBBLESTONE, random, 0.5f), 2);
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                mutable.func_189533_g((Vec3i)position).func_189536_c(direction);
                world.func_180501_a(mutable.func_177984_a(), isBelowSealevel ? WATER : AIR, 2);
                world.func_180501_a((BlockPos)mutable, WATER, 2);
                mutable.func_189536_c(Direction.DOWN);
                if (!allOreBlocks.isEmpty() && random.nextFloat() < 0.12f) {
                    world.func_180501_a((BlockPos)mutable, ((Block)allOreBlocks.toArray()[random.nextInt(allOreBlocks.size())]).func_176223_P(), 2);
                    continue;
                }
                world.func_180501_a((BlockPos)mutable, WellMossyStone.pickRandomBlock(MOSSY_COBBLESTONE, COBBLESTONE, random, 0.5f), 2);
            }
            mutable.func_189533_g((Vec3i)position);
            for (x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    if (x != -2 && x != 2 && z != -2 && z != 2 || x == 0 || z == 0) continue;
                    world.func_180501_a(mutable.func_177982_a(x, 1, z), WellMossyStone.pickRandomBlock(MOSSY_STONE_BRICKS, STONE_BRICKS, random, 0.6f), 2);
                }
            }
            state1 = isBelowSealevel ? (BlockState)MOSSY_STONE_BRICK_SLAB.func_206870_a((IProperty)SlabBlock.field_204512_b, (Comparable)Boolean.valueOf(true)) : MOSSY_STONE_BRICK_SLAB;
            state2 = isBelowSealevel ? (BlockState)STONE_BRICK_SLAB.func_206870_a((IProperty)SlabBlock.field_204512_b, (Comparable)Boolean.valueOf(true)) : STONE_BRICK_SLAB;
            world.func_180501_a(mutable.func_177982_a(2, 1, 0), WellMossyStone.pickRandomBlock(state1, state2, random, 0.6f), 2);
            state1 = isBelowSealevel ? (BlockState)MOSSY_STONE_BRICK_SLAB.func_206870_a((IProperty)SlabBlock.field_204512_b, (Comparable)Boolean.valueOf(true)) : MOSSY_STONE_BRICK_SLAB;
            state2 = isBelowSealevel ? (BlockState)STONE_BRICK_SLAB.func_206870_a((IProperty)SlabBlock.field_204512_b, (Comparable)Boolean.valueOf(true)) : STONE_BRICK_SLAB;
            world.func_180501_a(mutable.func_177982_a(-2, 1, 0), WellMossyStone.pickRandomBlock(state1, state2, random, 0.6f), 2);
            state1 = isBelowSealevel ? (BlockState)MOSSY_STONE_BRICK_SLAB.func_206870_a((IProperty)SlabBlock.field_204512_b, (Comparable)Boolean.valueOf(true)) : MOSSY_STONE_BRICK_SLAB;
            state2 = isBelowSealevel ? (BlockState)STONE_BRICK_SLAB.func_206870_a((IProperty)SlabBlock.field_204512_b, (Comparable)Boolean.valueOf(true)) : STONE_BRICK_SLAB;
            world.func_180501_a(mutable.func_177982_a(0, 1, 2), WellMossyStone.pickRandomBlock(state1, state2, random, 0.6f), 2);
            state1 = isBelowSealevel ? (BlockState)MOSSY_STONE_BRICK_SLAB.func_206870_a((IProperty)SlabBlock.field_204512_b, (Comparable)Boolean.valueOf(true)) : MOSSY_STONE_BRICK_SLAB;
            state2 = isBelowSealevel ? (BlockState)STONE_BRICK_SLAB.func_206870_a((IProperty)SlabBlock.field_204512_b, (Comparable)Boolean.valueOf(true)) : STONE_BRICK_SLAB;
            world.func_180501_a(mutable.func_177982_a(0, 1, -2), WellMossyStone.pickRandomBlock(state1, state2, random, 0.6f), 2);
            for (x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && z == 0) {
                        world.func_180501_a(mutable.func_177982_a(x, 4, z), WellMossyStone.pickRandomBlock(MOSSY_STONE_BRICKS, STONE_BRICKS, random, 0.6f), 2);
                        if (!RepurposedStructures.RSWellsConfig.canHaveBells.get().booleanValue() || random.nextInt(100) != 0) continue;
                        world.func_180501_a(mutable.func_177982_a(x, 3, z), BELL, 2);
                        continue;
                    }
                    isBelowSealevel = isWithinWaterArea && mutable.func_177981_b(4).func_177956_o() < world.func_181545_F();
                    state1 = isBelowSealevel ? (BlockState)MOSSY_STONE_BRICK_SLAB.func_206870_a((IProperty)SlabBlock.field_204512_b, (Comparable)Boolean.valueOf(true)) : MOSSY_STONE_BRICK_SLAB;
                    state2 = isBelowSealevel ? (BlockState)STONE_BRICK_SLAB.func_206870_a((IProperty)SlabBlock.field_204512_b, (Comparable)Boolean.valueOf(true)) : STONE_BRICK_SLAB;
                    world.func_180501_a(mutable.func_177982_a(x, 4, z), WellMossyStone.pickRandomBlock(state1, state2, random, 0.6f), 2);
                }
            }
            for (int y = 1; y <= 3; ++y) {
                isBelowSealevel = isWithinWaterArea && mutable.func_177981_b(y).func_177956_o() < world.func_181545_F();
                state1 = isBelowSealevel ? (BlockState)MOSSY_STONE_BRICK_WALL.func_206870_a((IProperty)SlabBlock.field_204512_b, (Comparable)Boolean.valueOf(true)) : MOSSY_STONE_BRICK_WALL;
                state2 = isBelowSealevel ? (BlockState)STONE_BRICK_WALL.func_206870_a((IProperty)SlabBlock.field_204512_b, (Comparable)Boolean.valueOf(true)) : STONE_BRICK_WALL;
                world.func_180501_a(mutable.func_177982_a(-1, y, -1), WellMossyStone.pickRandomBlock(state1, state2, random, 0.6f), 2);
                state1 = isBelowSealevel ? (BlockState)MOSSY_STONE_BRICK_WALL.func_206870_a((IProperty)SlabBlock.field_204512_b, (Comparable)Boolean.valueOf(true)) : MOSSY_STONE_BRICK_WALL;
                state2 = isBelowSealevel ? (BlockState)STONE_BRICK_WALL.func_206870_a((IProperty)SlabBlock.field_204512_b, (Comparable)Boolean.valueOf(true)) : STONE_BRICK_WALL;
                world.func_180501_a(mutable.func_177982_a(-1, y, 1), WellMossyStone.pickRandomBlock(state1, state2, random, 0.6f), 2);
                state1 = isBelowSealevel ? (BlockState)MOSSY_STONE_BRICK_WALL.func_206870_a((IProperty)SlabBlock.field_204512_b, (Comparable)Boolean.valueOf(true)) : MOSSY_STONE_BRICK_WALL;
                state2 = isBelowSealevel ? (BlockState)STONE_BRICK_WALL.func_206870_a((IProperty)SlabBlock.field_204512_b, (Comparable)Boolean.valueOf(true)) : STONE_BRICK_WALL;
                world.func_180501_a(mutable.func_177982_a(1, y, -1), WellMossyStone.pickRandomBlock(state1, state2, random, 0.6f), 2);
                state1 = isBelowSealevel ? (BlockState)MOSSY_STONE_BRICK_WALL.func_206870_a((IProperty)SlabBlock.field_204512_b, (Comparable)Boolean.valueOf(true)) : MOSSY_STONE_BRICK_WALL;
                state2 = isBelowSealevel ? (BlockState)STONE_BRICK_WALL.func_206870_a((IProperty)SlabBlock.field_204512_b, (Comparable)Boolean.valueOf(true)) : STONE_BRICK_WALL;
                world.func_180501_a(mutable.func_177982_a(1, y, 1), WellMossyStone.pickRandomBlock(state1, state2, random, 0.6f), 2);
            }
            return true;
        }
        return false;
    }

    private static BlockState pickRandomBlock(BlockState block1, BlockState block2, Random random, float firstBlockChance) {
        return random.nextFloat() < firstBlockChance ? block1 : block2;
    }
}

