/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.datafixers.Dynamic;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import java.util.Collection;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.Tags;

public class WellNether
extends Feature<NoFeatureConfig> {
    private static final BlockState NETHER_BRICK_SLAB = Blocks.field_196575_bC.func_176223_P();
    private static final BlockState NETHER_BRICKS = Blocks.field_196653_dH.func_176223_P();
    private static final BlockState NETHER_BRICK_FENCE = Blocks.field_150386_bk.func_176223_P();
    private static final BlockState GLOWSTONE = Blocks.field_150426_aN.func_176223_P();
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final BlockState LAVA = Blocks.field_150353_l.func_176223_P();
    private static final BlockState BELL = Blocks.field_222431_lT.func_176223_P();
    private static final float COMMON_ORE_CHANCE = 0.5f;
    private static final float RARE_ORE_CHANCE = 0.08f;
    private static final ResourceLocation NETHER_WELL_ORE_RL = new ResourceLocation("repurposed_structures:nether_well_ores");

    public WellNether(Function<Dynamic<?>, ? extends NoFeatureConfig> config) {
        super(config);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, BlockPos position, NoFeatureConfig config) {
        if (!world.func_175623_d(position.func_177984_a())) {
            return false;
        }
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                for (int up = 2; up < 4; ++up) {
                    if (world.func_175623_d(position.func_177982_a(x, up, z))) continue;
                    return false;
                }
            }
        }
        position = position.func_177984_a();
        while (world.func_175623_d(position) && position.func_177956_o() > 2) {
            position = position.func_177977_b();
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable(position);
        Block block = world.func_180495_p((BlockPos)mutable).func_177230_c();
        if (Tags.Blocks.NETHERRACK.func_199685_a_((Object)block) || block == Blocks.field_150425_aM || block == Blocks.field_150351_n || block == world.func_226691_t_((BlockPos)mutable).func_203944_q().func_204108_a().func_177230_c()) {
            int x;
            for (int x2 = -2; x2 <= 2; ++x2) {
                for (int z = -2; z <= 2; ++z) {
                    if (!world.func_175623_d(mutable.func_177977_b()) || !world.func_175623_d(mutable.func_177979_c(2))) continue;
                    return false;
                }
            }
            for (int y = -1; y <= 0; ++y) {
                for (int x3 = -2; x3 <= 2; ++x3) {
                    for (int z = -2; z <= 2; ++z) {
                        world.func_180501_a(mutable.func_177982_a(x3, y, z), NETHER_BRICKS, 2);
                    }
                }
            }
            Tag ORE_TAG = BlockTags.func_199896_a().func_199915_b(NETHER_WELL_ORE_RL);
            Collection allOreBlocks = ORE_TAG.func_199885_a();
            world.func_180501_a(mutable.func_177984_a(), AIR, 2);
            world.func_180501_a((BlockPos)mutable, LAVA, 2);
            float chance = random.nextFloat();
            if (!allOreBlocks.isEmpty() && chance < 0.08f) {
                world.func_180501_a(mutable.func_177977_b(), ((Block)allOreBlocks.toArray()[0]).func_176223_P(), 2);
            } else if (allOreBlocks.size() > 1 && chance - 0.08f < 0.5f) {
                world.func_180501_a(mutable.func_177977_b(), ((Block)allOreBlocks.toArray()[random.nextInt(allOreBlocks.size() - 1) + 1]).func_176223_P(), 2);
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                chance = random.nextFloat();
                mutable.func_189533_g((Vec3i)position).func_189536_c(direction);
                world.func_180501_a(mutable.func_177984_a(), AIR, 2);
                world.func_180501_a((BlockPos)mutable, LAVA, 2);
                mutable.func_189536_c(Direction.DOWN);
                if (!allOreBlocks.isEmpty() && chance < 0.08f) {
                    world.func_180501_a((BlockPos)mutable, ((Block)allOreBlocks.toArray()[0]).func_176223_P(), 2);
                    continue;
                }
                if (allOreBlocks.size() <= 1 || !(chance - 0.08f < 0.5f)) continue;
                world.func_180501_a((BlockPos)mutable, ((Block)allOreBlocks.toArray()[random.nextInt(allOreBlocks.size() - 1) + 1]).func_176223_P(), 2);
            }
            mutable.func_189533_g((Vec3i)position);
            for (x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    if (x != -2 && x != 2 && z != -2 && z != 2) continue;
                    world.func_180501_a(mutable.func_177982_a(x, 1, z), NETHER_BRICKS, 2);
                }
            }
            world.func_180501_a(mutable.func_177982_a(2, 1, 0), NETHER_BRICK_SLAB, 2);
            world.func_180501_a(mutable.func_177982_a(-2, 1, 0), NETHER_BRICK_SLAB, 2);
            world.func_180501_a(mutable.func_177982_a(0, 1, 2), NETHER_BRICK_SLAB, 2);
            world.func_180501_a(mutable.func_177982_a(0, 1, -2), NETHER_BRICK_SLAB, 2);
            for (x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && z == 0) {
                        world.func_180501_a(mutable.func_177982_a(x, 4, z), GLOWSTONE, 2);
                        world.func_180501_a(mutable.func_177982_a(x, 5, z), NETHER_BRICK_SLAB, 2);
                        if (!RepurposedStructures.RSWellsConfig.canHaveBells.get().booleanValue() || random.nextInt(100) != 0) continue;
                        world.func_180501_a(mutable.func_177982_a(x, 3, z), BELL, 2);
                        continue;
                    }
                    if (x == 0 || z == 0) {
                        world.func_180501_a(mutable.func_177982_a(x, 4, z), NETHER_BRICKS, 2);
                        continue;
                    }
                    world.func_180501_a(mutable.func_177982_a(x, 4, z), NETHER_BRICK_SLAB, 2);
                }
            }
            for (int y = 1; y <= 3; ++y) {
                world.func_180501_a(mutable.func_177982_a(-1, y, -1), NETHER_BRICK_FENCE, 2);
                world.func_180501_a(mutable.func_177982_a(-1, y, 1), NETHER_BRICK_FENCE, 2);
                world.func_180501_a(mutable.func_177982_a(1, y, -1), NETHER_BRICK_FENCE, 2);
                world.func_180501_a(mutable.func_177982_a(1, y, 1), NETHER_BRICK_FENCE, 2);
            }
            return true;
        }
        return false;
    }
}

