/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.datafixers.Dynamic;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import java.util.Collection;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.Tags;

public class WellSnow
extends Feature<NoFeatureConfig> {
    private static final BlockState SNOW = (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((IProperty)SnowBlock.field_176315_a, (Comparable)Integer.valueOf(5));
    private static final BlockState SNOW_BLOCK = Blocks.field_196604_cC.func_176223_P();
    private static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    private static final BlockState ICE = Blocks.field_150432_aD.func_176223_P();
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final BlockState BELL = Blocks.field_222431_lT.func_176223_P();
    private static final float ORE_CHANCE = 0.3f;
    private static final ResourceLocation SNOW_WELL_ORE_RL = new ResourceLocation("repurposed_structures:snow_well_ores");

    public WellSnow(Function<Dynamic<?>, ? extends NoFeatureConfig> config) {
        super(config);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, BlockPos position, NoFeatureConfig config) {
        position = position.func_177984_a();
        while ((world.func_175623_d(position) || world.func_180495_p(position).func_177230_c() == Blocks.field_150433_aE) && position.func_177956_o() > 2) {
            position = position.func_177977_b();
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable(position);
        Block block = world.func_180495_p((BlockPos)mutable).func_177230_c();
        if (block == Blocks.field_196604_cC || Tags.Blocks.DIRT.func_199685_a_((Object)block) || block == world.func_226691_t_((BlockPos)mutable).func_203944_q().func_204108_a().func_177230_c()) {
            int x;
            for (int x2 = -2; x2 <= 2; ++x2) {
                for (int z = -2; z <= 2; ++z) {
                    if (!world.func_175623_d(mutable.func_177977_b()) || !world.func_175623_d(mutable.func_177979_c(2))) continue;
                    return false;
                }
            }
            for (int y = -1; y <= 0; ++y) {
                for (int x3 = -2; x3 <= 2; ++x3) {
                    for (int z = -2; z <= 2; ++z) {
                        world.func_180501_a(mutable.func_177982_a(x3, y, z), SNOW_BLOCK, 2);
                    }
                }
            }
            Tag ORE_TAG = BlockTags.func_199896_a().func_199915_b(SNOW_WELL_ORE_RL);
            Collection allOreBlocks = ORE_TAG.func_199885_a();
            world.func_180501_a(mutable.func_177984_a(), AIR, 2);
            world.func_180501_a((BlockPos)mutable, ICE, 2);
            if (!allOreBlocks.isEmpty() && random.nextFloat() < 0.3f) {
                world.func_180501_a(mutable.func_177977_b(), ((Block)allOreBlocks.toArray()[random.nextInt(allOreBlocks.size())]).func_176223_P(), 2);
            } else {
                world.func_180501_a(mutable.func_177977_b(), STONE, 2);
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                mutable.func_189533_g((Vec3i)position).func_189536_c(direction);
                world.func_180501_a(mutable.func_177984_a(), AIR, 2);
                world.func_180501_a((BlockPos)mutable, ICE, 2);
                mutable.func_189536_c(Direction.DOWN);
                if (!allOreBlocks.isEmpty() && random.nextFloat() < 0.3f) {
                    world.func_180501_a((BlockPos)mutable, ((Block)allOreBlocks.toArray()[random.nextInt(allOreBlocks.size())]).func_176223_P(), 2);
                    continue;
                }
                world.func_180501_a((BlockPos)mutable, STONE, 2);
            }
            mutable.func_189533_g((Vec3i)position);
            for (x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    if (x != -2 && x != 2 && z != -2 && z != 2) continue;
                    world.func_180501_a(mutable.func_177982_a(x, 1, z), SNOW_BLOCK, 2);
                }
            }
            world.func_180501_a(mutable.func_177982_a(2, 1, 0), SNOW, 2);
            world.func_180501_a(mutable.func_177982_a(-2, 1, 0), SNOW, 2);
            world.func_180501_a(mutable.func_177982_a(0, 1, 2), SNOW, 2);
            world.func_180501_a(mutable.func_177982_a(0, 1, -2), SNOW, 2);
            for (x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && z == 0) {
                        world.func_180501_a(mutable.func_177982_a(x, 4, z), SNOW_BLOCK, 2);
                        world.func_180501_a(mutable.func_177982_a(x, 5, z), SNOW, 2);
                        if (!RepurposedStructures.RSWellsConfig.canHaveBells.get().booleanValue() || random.nextInt(100) != 0) continue;
                        world.func_180501_a(mutable.func_177982_a(x, 3, z), BELL, 2);
                        continue;
                    }
                    if (x == 0 || z == 0) {
                        world.func_180501_a(mutable.func_177982_a(x, 4, z), SNOW_BLOCK, 2);
                        continue;
                    }
                    world.func_180501_a(mutable.func_177982_a(x, 4, z), SNOW, 2);
                }
            }
            for (int y = 1; y <= 3; ++y) {
                world.func_180501_a(mutable.func_177982_a(-1, y, -1), SNOW_BLOCK, 2);
                world.func_180501_a(mutable.func_177982_a(-1, y, 1), SNOW_BLOCK, 2);
                world.func_180501_a(mutable.func_177982_a(1, y, -1), SNOW_BLOCK, 2);
                world.func_180501_a(mutable.func_177982_a(1, y, 1), SNOW_BLOCK, 2);
            }
            return true;
        }
        return false;
    }
}

