/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features.structures;

import com.mojang.datafixers.Dynamic;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.world.features.structures.JungleFortressPieces;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class JungleFortressStructure
extends Structure<NoFeatureConfig> {
    public JungleFortressStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51427_1_) {
        super(p_i51427_1_);
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int maxDistance = RepurposedStructures.RSMainConfig.jungleFortressSpawnrate.get();
        int minDistance = (int)((float)maxDistance * 0.75f);
        if (minDistance == 0) {
            minDistance = 1;
        }
        int k = x + maxDistance * spacingOffsetsX;
        int l = z + maxDistance * spacingOffsetsZ;
        int i1 = k < 0 ? k - maxDistance + 1 : k;
        int j1 = l < 0 ? l - maxDistance + 1 : l;
        int targetChunkX = i1 / maxDistance;
        int targetChunkZ = j1 / maxDistance;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), targetChunkX, targetChunkZ, 143525587);
        targetChunkX *= maxDistance;
        targetChunkZ *= maxDistance;
        return new ChunkPos(targetChunkX += random.nextInt(maxDistance - minDistance), targetChunkZ += random.nextInt(maxDistance - minDistance));
    }

    public boolean func_225558_a_(BiomeManager biomeManager, ChunkGenerator<?> chunkGenerator, Random random, int chunkPosX, int chunkPosZ, Biome biome) {
        ChunkPos chunkpos = this.func_211744_a(chunkGenerator, random, chunkPosX, chunkPosZ, 0, 0);
        if (chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b) {
            for (Biome nearbyBiome : chunkGenerator.func_202090_b().func_225530_a_(chunkPosX * 16 + 9, chunkGenerator.func_222530_f(), chunkPosZ * 16 + 9, 32)) {
                if (chunkGenerator.func_202094_a(nearbyBiome, (Structure)this)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return "repurposed_structures:fortress_jungle";
    }

    public int func_202367_b() {
        return 8;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            JungleFortressPieces.Start fortresspieces$start = new JungleFortressPieces.Start((Random)this.field_214631_d, (chunkX << 4) + 2, (chunkZ << 4) + 2);
            this.field_75075_a.add(fortresspieces$start);
            fortresspieces$start.func_74861_a(fortresspieces$start, this.field_75075_a, (Random)this.field_214631_d);
            List<StructurePiece> list = fortresspieces$start.pendingChildren;
            while (!list.isEmpty()) {
                int i = this.field_214631_d.nextInt(list.size());
                StructurePiece structurepiece = list.remove(i);
                structurepiece.func_74861_a((StructurePiece)fortresspieces$start, this.field_75075_a, (Random)this.field_214631_d);
            }
            this.func_202500_a();
            this.func_214626_a((Random)this.field_214631_d, 58, 63);
        }
    }
}

