/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features.structures;

import com.google.common.collect.ImmutableMap;
import com.telepathicgrunt.repurposedstructures.world.features.structures.StructurePieces;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.registries.ForgeRegistries;

public class RSIglooPieces {
    private static final ResourceLocation IGLOO_MIDDLE_RL = new ResourceLocation("igloo/middle");
    private static final ResourceLocation IGLOO_BOTTOM_RL = new ResourceLocation("igloo/bottom");
    private static final Map<ResourceLocation, BlockPos> OFFSET_1 = ImmutableMap.of((Object)new ResourceLocation("repurposed_structures:stone_igloo/top"), (Object)new BlockPos(3, 4, 5), (Object)new ResourceLocation("repurposed_structures:grassy_igloo/top"), (Object)new BlockPos(3, 4, 5), (Object)IGLOO_MIDDLE_RL, (Object)new BlockPos(1, 3, 1), (Object)IGLOO_BOTTOM_RL, (Object)new BlockPos(3, 6, 7));
    private static final Map<ResourceLocation, BlockPos> OFFSET_2 = ImmutableMap.of((Object)new ResourceLocation("repurposed_structures:stone_igloo/top"), (Object)new BlockPos(0, -1, 0), (Object)new ResourceLocation("repurposed_structures:grassy_igloo/top"), (Object)new BlockPos(0, -1, 0), (Object)IGLOO_MIDDLE_RL, (Object)new BlockPos(2, -3, 4), (Object)IGLOO_BOTTOM_RL, (Object)new BlockPos(0, -3, -2));

    public static void func_207617_a(TemplateManager templateManager, ResourceLocation topPieceRL, Block floorBlock, BlockPos position, Rotation rotationIn, List<StructurePiece> p_207617_3_, Random random, NoFeatureConfig p_207617_5_) {
        if (random.nextDouble() < 0.5) {
            int basementY = random.nextInt(8) + 4;
            p_207617_3_.add((StructurePiece)new Piece(templateManager, IGLOO_BOTTOM_RL, position, rotationIn, basementY * 3, null));
            for (int middleY = 0; middleY < basementY - 1; ++middleY) {
                p_207617_3_.add((StructurePiece)new Piece(templateManager, IGLOO_MIDDLE_RL, position, rotationIn, middleY * 3, null));
            }
        }
        p_207617_3_.add((StructurePiece)new Piece(templateManager, topPieceRL, position, rotationIn, 0, floorBlock));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation pieceRL;
        private final Rotation rotation;
        private final Block floorBlock;

        public Piece(TemplateManager templateManager, ResourceLocation pieceRL, BlockPos position, Rotation rotationIn, int heightOffset, Block floorBlockIn) {
            super(StructurePieces.RS_IGLOO_PIECE, 0);
            this.pieceRL = pieceRL;
            BlockPos blockpos = (BlockPos)OFFSET_2.get(pieceRL);
            this.field_186178_c = position.func_177982_a(blockpos.func_177958_n(), blockpos.func_177956_o() - heightOffset, blockpos.func_177952_p());
            this.rotation = rotationIn;
            this.func_207614_a(templateManager);
            this.floorBlock = floorBlockIn;
        }

        public Piece(TemplateManager templateManager, CompoundNBT data) {
            super(StructurePieces.RS_IGLOO_PIECE, data);
            this.pieceRL = new ResourceLocation(data.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)data.func_74779_i("Rot"));
            this.func_207614_a(templateManager);
            this.floorBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(data.func_74779_i("FloorBlock")));
        }

        private void func_207614_a(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.pieceRL);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)OFFSET_1.get(this.pieceRL)).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.pieceRL.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
            tagCompound.func_74778_a("FloorBlock", this.floorBlock == null ? "" : this.floorBlock.getRegistryName().toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("chest".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                TileEntity tileentity = worldIn.func_175625_s(pos.func_177977_b());
                if (tileentity instanceof ChestTileEntity) {
                    ((ChestTileEntity)tileentity).func_189404_a(LootTables.field_186431_m, rand.nextLong());
                }
            }
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkgenerator, Random random, MutableBoundingBox box, ChunkPos chunkPos) {
            BlockPos blockpos3;
            BlockState blockstate;
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)OFFSET_1.get(this.pieceRL)).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            BlockPos blockpos = (BlockPos)OFFSET_2.get(this.pieceRL);
            BlockPos blockpos1 = this.field_186178_c.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)new BlockPos(3 - blockpos.func_177958_n(), 0, 0 - blockpos.func_177952_p())));
            int terrainSurfaceY = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, blockpos1.func_177958_n(), blockpos1.func_177952_p());
            BlockPos blockpos2 = this.field_186178_c;
            this.field_186178_c = this.field_186178_c.func_177982_a(0, terrainSurfaceY - 90 - 1, 0);
            boolean flag = super.func_225577_a_(world, chunkgenerator, random, box, chunkPos);
            if (this.floorBlock != null && (blockstate = world.func_180495_p((blockpos3 = this.field_186178_c.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)new BlockPos(3, 0, 5)))).func_177977_b())).func_177230_c() != Blocks.field_150468_ap) {
                world.func_180501_a(blockpos3.func_177984_a(), this.floorBlock.func_176223_P(), 3);
                world.func_180501_a(blockpos3, this.floorBlock.func_176223_P(), 3);
            }
            this.field_186178_c = blockpos2;
            return flag;
        }
    }
}

