/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features.structures;

import com.google.common.collect.Lists;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.world.features.structures.RSStrongholdStructure;
import com.telepathicgrunt.repurposedstructures.world.features.structures.StructurePieces;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.EndPortalFrameBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTables;

public class RSStrongholdPieces {
    private static final ResourceLocation NETHER_STRONGHOLD_BOOKSHELF_RL = new ResourceLocation("repurposed_structures:nether_stronghold_bookshelves");
    private static final PieceWeight[] PIECE_WEIGHTS = new PieceWeight[]{new PieceWeight(Straight.class, 40, 0), new PieceWeight(Prison.class, 5, 8), new PieceWeight(LeftTurn.class, 20, 0), new PieceWeight(RightTurn.class, 20, 0), new PieceWeight(RoomCrossing.class, 10, 9), new PieceWeight(StairsStraight.class, 5, 7), new PieceWeight(Stairs.class, 5, 7), new PieceWeight(Crossing.class, 5, 7), new PieceWeight(ChestCorridor.class, 5, 16), new PieceWeight(Library.class, 10, 6){

        @Override
        public boolean canSpawnMoreStructures(int distanceFromStart) {
            return super.canSpawnMoreStructures(distanceFromStart) && distanceFromStart > 4;
        }
    }, new PieceWeight(PortalRoom.class, 20, 1){

        @Override
        public boolean canSpawnMoreStructures(int distanceFromStart) {
            return this.instancesSpawned < 1 && distanceFromStart > 5;
        }

        @Override
        public boolean canSpawnMoreStructures() {
            return this.instancesSpawned < 1;
        }
    }};
    private static List<PieceWeight> structurePieceList;
    private static Class<? extends Stronghold> strongComponentType;
    static int totalWeight;
    private static final Map<Block, Block> NETHER_BLOCK_MAP;

    public static void prepareStructurePieces() {
        structurePieceList = Lists.newArrayList();
        for (PieceWeight structurestrongholdpieces$pieceweight : PIECE_WEIGHTS) {
            structurestrongholdpieces$pieceweight.instancesSpawned = 0;
            structurePieceList.add(structurestrongholdpieces$pieceweight);
        }
        strongComponentType = null;
    }

    private static boolean canAddStructurePieces() {
        boolean flag = false;
        totalWeight = 0;
        for (PieceWeight structurestrongholdpieces$pieceweight : structurePieceList) {
            if (structurestrongholdpieces$pieceweight.instancesLimit > 0) {
                String name = structurestrongholdpieces$pieceweight.pieceClass.getSimpleName();
                if (name.equals("PortalRoom")) {
                    if (structurestrongholdpieces$pieceweight.instancesSpawned < 1) {
                        flag = true;
                    }
                } else {
                    int maxLimit = (int)((double)structurestrongholdpieces$pieceweight.instancesLimit * (RepurposedStructures.RSStrongholdsConfig.strongholdSizeSH.get() * 0.01));
                    if (structurestrongholdpieces$pieceweight.instancesSpawned <= maxLimit) {
                        flag = true;
                    }
                }
            }
            totalWeight += structurestrongholdpieces$pieceweight.pieceWeight;
        }
        return flag;
    }

    private static Stronghold findAndCreatePieceFactory(Class<? extends Stronghold> pieceClass, List<StructurePiece> piecesList, Random random, int xStart, int yStart, int zStart, @Nullable Direction direction, int distanceFromStart, RSStrongholdStructure.Type stronghold$type) {
        Stronghold structurestrongholdpieces$stronghold = null;
        if (pieceClass == Straight.class) {
            structurestrongholdpieces$stronghold = Straight.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == Prison.class) {
            structurestrongholdpieces$stronghold = Prison.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == LeftTurn.class) {
            structurestrongholdpieces$stronghold = LeftTurn.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == RightTurn.class) {
            structurestrongholdpieces$stronghold = RightTurn.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == RoomCrossing.class) {
            structurestrongholdpieces$stronghold = RoomCrossing.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == StairsStraight.class) {
            structurestrongholdpieces$stronghold = StairsStraight.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == Stairs.class) {
            structurestrongholdpieces$stronghold = Stairs.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == Crossing.class) {
            structurestrongholdpieces$stronghold = Crossing.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == ChestCorridor.class) {
            structurestrongholdpieces$stronghold = ChestCorridor.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == Library.class) {
            structurestrongholdpieces$stronghold = Library.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        } else if (pieceClass == PortalRoom.class) {
            structurestrongholdpieces$stronghold = PortalRoom.createPiece(piecesList, random, xStart, yStart, zStart, direction, distanceFromStart, stronghold$type);
        }
        return structurestrongholdpieces$stronghold;
    }

    private static Stronghold generatePieceFromSmallDoor(EntranceStairs p_175955_0_, List<StructurePiece> p_175955_1_, Random random, int x, int y, int z, Direction p_175955_6_, int componentType) {
        RSStrongholdStructure.Type stronghold$type = p_175955_0_.strongholdType;
        if (!RSStrongholdPieces.canAddStructurePieces()) {
            return null;
        }
        if (strongComponentType != null) {
            Stronghold structurestrongholdpieces$stronghold = RSStrongholdPieces.findAndCreatePieceFactory(strongComponentType, p_175955_1_, random, x, y, z, p_175955_6_, componentType, stronghold$type);
            strongComponentType = null;
            if (structurestrongholdpieces$stronghold != null) {
                return structurestrongholdpieces$stronghold;
            }
        }
        int j = 0;
        block0: while (j < 5) {
            ++j;
            int randomWeight = random.nextInt(totalWeight);
            for (PieceWeight structurestrongholdpieces$pieceweight : structurePieceList) {
                if ((randomWeight -= structurestrongholdpieces$pieceweight.pieceWeight) >= 0) continue;
                if (!structurestrongholdpieces$pieceweight.canSpawnMoreStructures(componentType) || structurestrongholdpieces$pieceweight == p_175955_0_.strongholdPieceWeight) continue block0;
                Stronghold structurestrongholdpieces$stronghold1 = RSStrongholdPieces.findAndCreatePieceFactory(structurestrongholdpieces$pieceweight.pieceClass, p_175955_1_, random, x, y, z, p_175955_6_, componentType, stronghold$type);
                if (structurestrongholdpieces$stronghold1 == null) continue;
                ++structurestrongholdpieces$pieceweight.instancesSpawned;
                p_175955_0_.strongholdPieceWeight = structurestrongholdpieces$pieceweight;
                if (!structurestrongholdpieces$pieceweight.canSpawnMoreStructures()) {
                    structurePieceList.remove(structurestrongholdpieces$pieceweight);
                }
                return structurestrongholdpieces$stronghold1;
            }
        }
        MutableBoundingBox mutableboundingbox = Corridor.findPieceBox(p_175955_1_, random, x, y, z, p_175955_6_);
        if (mutableboundingbox != null && mutableboundingbox.field_78895_b > 1) {
            return new Corridor(componentType, mutableboundingbox, p_175955_6_, stronghold$type);
        }
        return null;
    }

    private static StructurePiece generateAndAddPiece(EntranceStairs p_175953_0_, List<StructurePiece> p_175953_1_, Random p_175953_2_, int p_175953_3_, int p_175953_4_, int p_175953_5_, @Nullable Direction p_175953_6_, int distanceFromStart) {
        int maxComponents = (int)(50.0 * (RepurposedStructures.RSStrongholdsConfig.strongholdSizeSH.get() * 0.01));
        if (distanceFromStart > maxComponents) {
            return null;
        }
        if (Math.abs(p_175953_3_ - p_175953_0_.func_74874_b().field_78897_a) <= 112 && Math.abs(p_175953_5_ - p_175953_0_.func_74874_b().field_78896_c) <= 112) {
            Stronghold StructurePiece2 = RSStrongholdPieces.generatePieceFromSmallDoor(p_175953_0_, p_175953_1_, p_175953_2_, p_175953_3_, p_175953_4_, p_175953_5_, p_175953_6_, distanceFromStart + 1);
            if (StructurePiece2 != null) {
                p_175953_1_.add(StructurePiece2);
                p_175953_0_.pendingChildren.add(StructurePiece2);
            }
            return StructurePiece2;
        }
        return null;
    }

    static {
        NETHER_BLOCK_MAP = new HashMap<Block, Block>();
        NETHER_BLOCK_MAP.put(Blocks.field_196696_di, Blocks.field_196653_dH);
        NETHER_BLOCK_MAP.put(Blocks.field_196573_bB, Blocks.field_196575_bC);
        NETHER_BLOCK_MAP.put(Blocks.field_150390_bg, Blocks.field_150387_bl);
        NETHER_BLOCK_MAP.put(Blocks.field_150347_e, Blocks.field_150425_aM);
        NETHER_BLOCK_MAP.put(Blocks.field_196659_cl, Blocks.field_222443_lg);
        NETHER_BLOCK_MAP.put(Blocks.field_196646_bz, Blocks.field_222456_lt);
        NETHER_BLOCK_MAP.put(Blocks.field_150333_U, Blocks.field_222456_lt);
        NETHER_BLOCK_MAP.put(Blocks.field_150411_aY, Blocks.field_150386_bk);
        NETHER_BLOCK_MAP.put(Blocks.field_196662_n, Blocks.field_196672_s);
        NETHER_BLOCK_MAP.put(Blocks.field_180407_aO, Blocks.field_180406_aS);
        NETHER_BLOCK_MAP.put(Blocks.field_150355_j, Blocks.field_150353_l);
        NETHER_BLOCK_MAP.put(Blocks.field_196591_bQ, Blocks.field_196677_cy);
        NETHER_BLOCK_MAP.put(Blocks.field_150478_aa, Blocks.field_150429_aA);
    }

    public static abstract class Turn
    extends Stronghold {
        protected Turn(IStructurePieceType pieceType, int componentType, RSStrongholdStructure.Type strongholdType) {
            super(pieceType, componentType, strongholdType);
        }

        public Turn(IStructurePieceType pieceType, CompoundNBT data) {
            super(pieceType, data);
        }
    }

    static abstract class Stronghold
    extends StructurePiece {
        protected Door entryDoor = Door.OPENING;
        protected RSStrongholdStructure.Type strongholdType;

        protected Stronghold(IStructurePieceType pieceType, int componentType, RSStrongholdStructure.Type strongholdType) {
            super(pieceType, componentType);
            this.strongholdType = strongholdType;
        }

        public Stronghold(IStructurePieceType pieceType, CompoundNBT data) {
            super(pieceType, data);
            this.entryDoor = Door.valueOf(data.func_74779_i("EntryDoor"));
            this.strongholdType = RSStrongholdStructure.Type.byId(data.func_74762_e("SHT"));
        }

        protected void func_143011_b(CompoundNBT data) {
            data.func_74778_a("EntryDoor", this.entryDoor.name());
            data.func_74768_a("SHT", this.strongholdType.ordinal());
        }

        protected void placeDoor(IWorld world, Random random, MutableBoundingBox mutableBox, Door spawnDoor, int xStart, int yStart, int zStart) {
            switch (spawnDoor) {
                case OPENING: {
                    this.func_175804_a(world, mutableBox, xStart, yStart, zStart, xStart + 3 - 1, yStart + 3 - 1, zStart, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                    break;
                }
                case WOOD_DOOR: {
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), xStart, yStart, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), xStart, yStart + 1, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), xStart, yStart + 2, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), xStart + 1, yStart + 2, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), xStart + 2, yStart + 2, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), xStart + 2, yStart + 1, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), xStart + 2, yStart, zStart, mutableBox);
                    if (this.strongholdType == RSStrongholdStructure.Type.NETHER) {
                        this.func_175811_a(world, Blocks.field_150386_bk.func_176223_P(), xStart + 1, yStart, zStart, mutableBox);
                        this.func_175811_a(world, Blocks.field_150386_bk.func_176223_P(), xStart + 1, yStart + 1, zStart, mutableBox);
                        break;
                    }
                    this.func_175811_a(world, Blocks.field_180413_ao.func_176223_P(), xStart + 1, yStart, zStart, mutableBox);
                    this.func_175811_a(world, (BlockState)Blocks.field_180413_ao.func_176223_P().func_206870_a((IProperty)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER), xStart + 1, yStart + 1, zStart, mutableBox);
                    break;
                }
                case GRATES: {
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), xStart + 1, yStart, zStart, mutableBox);
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), xStart + 1, yStart + 1, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), xStart, yStart, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), xStart, yStart + 1, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), xStart, yStart + 2, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), xStart + 1, yStart + 2, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), xStart + 2, yStart + 2, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), xStart + 2, yStart + 1, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), xStart + 2, yStart, zStart, mutableBox);
                    break;
                }
                case IRON_DOOR: {
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), xStart, yStart, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), xStart, yStart + 1, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), xStart, yStart + 2, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), xStart + 1, yStart + 2, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), xStart + 2, yStart + 2, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), xStart + 2, yStart + 1, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), xStart + 2, yStart, zStart, mutableBox);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150454_av.func_176223_P()), xStart + 1, yStart, zStart, mutableBox);
                    this.func_175811_a(world, (BlockState)this.getBlockOfCorrectType(Blocks.field_150454_av.func_176223_P()).func_206870_a((IProperty)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER), xStart + 1, yStart + 1, zStart, mutableBox);
                    this.func_175811_a(world, (BlockState)this.getBlockOfCorrectType(Blocks.field_150430_aB.func_176223_P()).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.NORTH), xStart + 2, yStart + 1, zStart + 1, mutableBox);
                    this.func_175811_a(world, (BlockState)this.getBlockOfCorrectType(Blocks.field_150430_aB.func_176223_P()).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.SOUTH), xStart + 2, yStart + 1, zStart - 1, mutableBox);
                }
            }
        }

        protected Door getRandomDoor(Random random) {
            int i = random.nextInt(5);
            switch (i) {
                default: {
                    return Door.OPENING;
                }
                case 2: {
                    return Door.WOOD_DOOR;
                }
                case 3: {
                    return Door.GRATES;
                }
                case 4: 
            }
            return Door.IRON_DOOR;
        }

        protected BlockState getBlockOfCorrectType(BlockState blockstate) {
            if (this.strongholdType == RSStrongholdStructure.Type.NETHER && NETHER_BLOCK_MAP.containsKey(blockstate.func_177230_c())) {
                BlockState newBlockstate = ((Block)NETHER_BLOCK_MAP.get(blockstate.func_177230_c())).func_176223_P();
                if (newBlockstate.func_177230_c() instanceof SlabBlock) {
                    newBlockstate.func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)((SlabType)blockstate.func_177229_b((IProperty)BlockStateProperties.field_208145_at)));
                } else if (newBlockstate.func_177230_c() instanceof DoorBlock) {
                    newBlockstate.func_206870_a((IProperty)DoorBlock.field_176520_a, (Comparable)((Direction)blockstate.func_177229_b((IProperty)HorizontalBlock.field_185512_D)));
                } else if (newBlockstate.func_177230_c() instanceof WallTorchBlock) {
                    newBlockstate.func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)((Direction)blockstate.func_177229_b((IProperty)HorizontalBlock.field_185512_D)));
                }
                return newBlockstate;
            }
            return blockstate;
        }

        protected EntityType<?> getSpawnerEntity() {
            if (this.strongholdType == RSStrongholdStructure.Type.NETHER) {
                return EntityType.field_200792_f;
            }
            return EntityType.field_200740_af;
        }

        protected ResourceLocation getHallwayChestLoot() {
            if (this.strongholdType == RSStrongholdStructure.Type.NETHER) {
                return new ResourceLocation("repurposed_structures:chests/stronghold_nether_hallway");
            }
            return LootTables.field_186428_j;
        }

        protected ResourceLocation getStorageChestLoot() {
            if (this.strongholdType == RSStrongholdStructure.Type.NETHER) {
                return new ResourceLocation("repurposed_structures:chests/stronghold_nether_storage_room");
            }
            return LootTables.field_186427_i;
        }

        @Nullable
        protected StructurePiece getNextComponentNormal(EntranceStairs p_74986_1_, List<StructurePiece> p_74986_2_, Random p_74986_3_, int p_74986_4_, int p_74986_5_) {
            Direction enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    case NORTH: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74986_1_, p_74986_2_, p_74986_3_, this.field_74887_e.field_78897_a + p_74986_4_, this.field_74887_e.field_78895_b + p_74986_5_, this.field_74887_e.field_78896_c - 1, enumfacing, this.func_74877_c());
                    }
                    case SOUTH: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74986_1_, p_74986_2_, p_74986_3_, this.field_74887_e.field_78897_a + p_74986_4_, this.field_74887_e.field_78895_b + p_74986_5_, this.field_74887_e.field_78892_f + 1, enumfacing, this.func_74877_c());
                    }
                    case WEST: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74986_1_, p_74986_2_, p_74986_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74986_5_, this.field_74887_e.field_78896_c + p_74986_4_, enumfacing, this.func_74877_c());
                    }
                    case EAST: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74986_1_, p_74986_2_, p_74986_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74986_5_, this.field_74887_e.field_78896_c + p_74986_4_, enumfacing, this.func_74877_c());
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece getNextComponentX(EntranceStairs p_74989_1_, List<StructurePiece> p_74989_2_, Random p_74989_3_, int p_74989_4_, int p_74989_5_) {
            Direction enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    case NORTH: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74989_1_, p_74989_2_, p_74989_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74989_4_, this.field_74887_e.field_78896_c + p_74989_5_, Direction.WEST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74989_1_, p_74989_2_, p_74989_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74989_4_, this.field_74887_e.field_78896_c + p_74989_5_, Direction.WEST, this.func_74877_c());
                    }
                    case WEST: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74989_1_, p_74989_2_, p_74989_3_, this.field_74887_e.field_78897_a + p_74989_5_, this.field_74887_e.field_78895_b + p_74989_4_, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.func_74877_c());
                    }
                    case EAST: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74989_1_, p_74989_2_, p_74989_3_, this.field_74887_e.field_78897_a + p_74989_5_, this.field_74887_e.field_78895_b + p_74989_4_, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.func_74877_c());
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece getNextComponentZ(EntranceStairs p_74987_1_, List<StructurePiece> p_74987_2_, Random p_74987_3_, int p_74987_4_, int p_74987_5_) {
            Direction enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    case NORTH: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74987_1_, p_74987_2_, p_74987_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74987_4_, this.field_74887_e.field_78896_c + p_74987_5_, Direction.EAST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74987_1_, p_74987_2_, p_74987_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74987_4_, this.field_74887_e.field_78896_c + p_74987_5_, Direction.EAST, this.func_74877_c());
                    }
                    case WEST: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74987_1_, p_74987_2_, p_74987_3_, this.field_74887_e.field_78897_a + p_74987_5_, this.field_74887_e.field_78895_b + p_74987_4_, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.func_74877_c());
                    }
                    case EAST: {
                        return RSStrongholdPieces.generateAndAddPiece(p_74987_1_, p_74987_2_, p_74987_3_, this.field_74887_e.field_78897_a + p_74987_5_, this.field_74887_e.field_78895_b + p_74987_4_, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.func_74877_c());
                    }
                }
            }
            return null;
        }

        protected static boolean canStrongholdGoDeeper(MutableBoundingBox box) {
            return box != null && box.field_78895_b > 10;
        }

        public static enum Door {
            OPENING,
            WOOD_DOOR,
            GRATES,
            IRON_DOOR;

        }
    }

    public static class Straight
    extends Stronghold {
        private boolean expandsX;
        private boolean expandsZ;

        public Straight(int conponentType_, Random random, MutableBoundingBox box, Direction direction, RSStrongholdStructure.Type strongholdType) {
            super(StructurePieces.STRONGHOLD_STRAIGHT, conponentType_, strongholdType);
            this.func_186164_a(direction);
            this.entryDoor = this.getRandomDoor(random);
            this.field_74887_e = box;
            this.expandsX = random.nextInt(2) == 0;
            this.expandsZ = random.nextInt(2) == 0;
        }

        public Straight(TemplateManager template, CompoundNBT data) {
            super(StructurePieces.STRONGHOLD_STRAIGHT, data);
            this.expandsX = data.func_74767_n("Left");
            this.expandsZ = data.func_74767_n("Right");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("Left", this.expandsX);
            tagCompound.func_74757_a("Right", this.expandsZ);
        }

        public void func_74861_a(StructurePiece component, List<StructurePiece> piecesList, Random rand) {
            this.getNextComponentNormal((EntranceStairs)component, piecesList, rand, 1, 1);
            if (this.expandsX) {
                this.getNextComponentX((EntranceStairs)component, piecesList, rand, 1, 2);
            }
            if (this.expandsZ) {
                this.getNextComponentZ((EntranceStairs)component, piecesList, rand, 1, 2);
            }
        }

        public static Straight createPiece(List<StructurePiece> piecesList, Random random, int xStart, int yStart, int zStart, Direction direction, int distanceFromStart, RSStrongholdStructure.Type strongholdType) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)xStart, (int)yStart, (int)zStart, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)7, (Direction)direction);
            return Straight.canStrongholdGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(piecesList, (MutableBoundingBox)mutableboundingbox) == null ? new Straight(distanceFromStart, random, mutableboundingbox, direction, strongholdType) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGenerator, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.func_74882_a(world, structureBoundingBoxIn, 0, 0, 0, 4, 4, 6, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 1, 1, 0);
            this.placeDoor(world, random, structureBoundingBoxIn, Stronghold.Door.OPENING, 1, 1, 6);
            BlockState iblockstate = (BlockState)this.getBlockOfCorrectType(Blocks.field_196591_bQ.func_176223_P()).func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)Direction.EAST);
            BlockState iblockstate1 = (BlockState)this.getBlockOfCorrectType(Blocks.field_196591_bQ.func_176223_P()).func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)Direction.WEST);
            this.func_175809_a(world, structureBoundingBoxIn, random, 0.1f, 1, 2, 1, iblockstate);
            this.func_175809_a(world, structureBoundingBoxIn, random, 0.1f, 3, 2, 1, iblockstate1);
            this.func_175809_a(world, structureBoundingBoxIn, random, 0.1f, 1, 2, 5, iblockstate);
            this.func_175809_a(world, structureBoundingBoxIn, random, 0.1f, 3, 2, 5, iblockstate1);
            if (this.expandsX) {
                this.func_175804_a(world, structureBoundingBoxIn, 0, 1, 2, 0, 3, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            if (this.expandsZ) {
                this.func_175804_a(world, structureBoundingBoxIn, 4, 1, 2, 4, 3, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            return true;
        }
    }

    static class Stones
    extends StructurePiece.BlockSelector {
        private static final Map<BlockState, BlockState> INFESTED_STONE_LOOKUP = new HashMap<BlockState, BlockState>();
        private RSStrongholdStructure.Type type = null;

        private Stones(RSStrongholdStructure.Type type) {
            this.type = type;
        }

        public void func_75062_a(Random rand, int x, int y, int z, boolean notAir) {
            if (notAir) {
                if (this.type == RSStrongholdStructure.Type.NETHER) {
                    float chance = rand.nextFloat();
                    this.field_151562_a = chance < 0.05f ? Blocks.field_196814_hQ.func_176223_P() : (chance < 0.15f ? Blocks.field_196722_fD.func_176223_P() : (chance < 0.35f ? Blocks.field_196817_hS.func_176223_P() : Blocks.field_196653_dH.func_176223_P()));
                } else {
                    float silverfishThreshold;
                    float chance = rand.nextFloat();
                    this.field_151562_a = chance < 0.2f ? Blocks.field_196698_dj.func_176223_P() : (chance < 0.5f ? Blocks.field_196700_dk.func_176223_P() : Blocks.field_196696_di.func_176223_P());
                    chance = rand.nextFloat();
                    if (chance < (silverfishThreshold = (float)(RepurposedStructures.RSStrongholdsConfig.silverfishSpawnrateSH.get() / 100.0))) {
                        this.field_151562_a = INFESTED_STONE_LOOKUP.get(this.field_151562_a);
                    }
                }
            } else {
                this.field_151562_a = Blocks.field_201941_jj.func_176223_P();
            }
        }

        static {
            INFESTED_STONE_LOOKUP.put(Blocks.field_196696_di.func_176223_P(), Blocks.field_196688_de.func_176223_P());
            INFESTED_STONE_LOOKUP.put(Blocks.field_150348_b.func_176223_P(), Blocks.field_196686_dc.func_176223_P());
            INFESTED_STONE_LOOKUP.put(Blocks.field_150341_Y.func_176223_P(), Blocks.field_196690_df.func_176223_P());
            INFESTED_STONE_LOOKUP.put(Blocks.field_196700_dk.func_176223_P(), Blocks.field_196692_dg.func_176223_P());
            INFESTED_STONE_LOOKUP.put(Blocks.field_150347_e.func_176223_P(), Blocks.field_196687_dd.func_176223_P());
            INFESTED_STONE_LOOKUP.put(Blocks.field_196702_dl.func_176223_P(), Blocks.field_196694_dh.func_176223_P());
            INFESTED_STONE_LOOKUP.put(Blocks.field_196698_dj.func_176223_P(), Blocks.field_196698_dj.func_176223_P());
        }
    }

    public static class StairsStraight
    extends Stronghold {
        public StairsStraight(int componentType, Random random, MutableBoundingBox box, Direction direction, RSStrongholdStructure.Type strongholdType) {
            super(StructurePieces.STRONGHOLD_STAIRS_STRAIGHT, componentType, strongholdType);
            this.func_186164_a(direction);
            this.entryDoor = this.getRandomDoor(random);
            this.field_74887_e = box;
        }

        public StairsStraight(TemplateManager tmeplateManager, CompoundNBT data) {
            super(StructurePieces.STRONGHOLD_STAIRS_STRAIGHT, data);
        }

        public void func_74861_a(StructurePiece piece, List<StructurePiece> piecesList, Random random) {
            this.getNextComponentNormal((EntranceStairs)piece, piecesList, random, 1, 1);
        }

        public static StairsStraight createPiece(List<StructurePiece> piecesList, Random random, int x, int y, int z, Direction direction, int componentType, RSStrongholdStructure.Type strongholdType) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)-7, (int)0, (int)5, (int)11, (int)8, (Direction)direction);
            return StairsStraight.canStrongholdGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(piecesList, (MutableBoundingBox)mutableboundingbox) == null ? new StairsStraight(componentType, random, mutableboundingbox, direction, strongholdType) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGenerator, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.func_74882_a(world, structureBoundingBoxIn, 0, 0, 0, 4, 10, 7, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 1, 7, 0);
            this.placeDoor(world, random, structureBoundingBoxIn, Stronghold.Door.OPENING, 1, 1, 7);
            BlockState iblockstate = (BlockState)this.getBlockOfCorrectType(Blocks.field_150390_bg.func_176223_P()).func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH);
            for (int i = 0; i < 6; ++i) {
                this.func_175811_a(world, iblockstate, 1, 6 - i, 1 + i, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate, 2, 6 - i, 1 + i, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate, 3, 6 - i, 1 + i, structureBoundingBoxIn);
                if (i >= 5) continue;
                this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 1, 5 - i, 1 + i, structureBoundingBoxIn);
                this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 2, 5 - i, 1 + i, structureBoundingBoxIn);
                this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 3, 5 - i, 1 + i, structureBoundingBoxIn);
            }
            return true;
        }
    }

    public static class EntranceStairs
    extends Stairs {
        public PieceWeight strongholdPieceWeight;
        @Nullable
        public PortalRoom strongholdPortalRoom;
        public List<StructurePiece> pendingChildren = Lists.newArrayList();

        public EntranceStairs(Random p_i50117_1_, int x, int z, RSStrongholdStructure.Type strongholdType) {
            super(StructurePieces.STRONGHOLD_ENTRANCE_STAIRS, 0, p_i50117_1_, x, z, strongholdType);
        }

        public EntranceStairs(TemplateManager p_i50118_1_, CompoundNBT p_i50118_2_) {
            super(StructurePieces.STRONGHOLD_ENTRANCE_STAIRS, p_i50118_2_);
        }
    }

    public static class Stairs
    extends Stronghold {
        private boolean source;

        public Stairs(IStructurePieceType p_i50120_1_, int componentType, Random p_i50120_3_, int x, int z, RSStrongholdStructure.Type strongholdType) {
            super(p_i50120_1_, componentType, strongholdType);
            this.source = true;
            this.func_186164_a(Direction.Plane.HORIZONTAL.func_179518_a(p_i50120_3_));
            this.entryDoor = Stronghold.Door.OPENING;
            this.field_74887_e = this.func_186165_e().func_176740_k() == Direction.Axis.Z ? new MutableBoundingBox(x, 64, z, x + 5 - 1, 74, z + 5 - 1) : new MutableBoundingBox(x, 64, z, x + 5 - 1, 74, z + 5 - 1);
        }

        public Stairs(int componentType, Random p_i45574_2_, MutableBoundingBox p_i45574_3_, Direction p_i45574_4_, RSStrongholdStructure.Type strongholdType) {
            super(StructurePieces.STRONGHOLD_STAIRS, componentType, strongholdType);
            this.source = false;
            this.func_186164_a(p_i45574_4_);
            this.entryDoor = this.getRandomDoor(p_i45574_2_);
            this.field_74887_e = p_i45574_3_;
        }

        public Stairs(IStructurePieceType p_i50121_1_, CompoundNBT p_i50121_2_) {
            super(p_i50121_1_, p_i50121_2_);
            this.source = p_i50121_2_.func_74767_n("Source");
        }

        public Stairs(TemplateManager templateManager, CompoundNBT data) {
            this(StructurePieces.STRONGHOLD_STAIRS, data);
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("Source", this.source);
        }

        public void func_74861_a(StructurePiece component, List<StructurePiece> piecesList, Random rand) {
            if (this.source) {
                strongComponentType = Crossing.class;
            }
            this.getNextComponentNormal((EntranceStairs)component, piecesList, rand, 1, 1);
        }

        public static Stairs createPiece(List<StructurePiece> p_175863_0_, Random p_175863_1_, int x, int y, int z, Direction p_175863_5_, int componentType, RSStrongholdStructure.Type strongholdType) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)-7, (int)0, (int)5, (int)11, (int)5, (Direction)p_175863_5_);
            return Stairs.canStrongholdGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(p_175863_0_, (MutableBoundingBox)mutableboundingbox) == null ? new Stairs(componentType, p_175863_1_, mutableboundingbox, p_175863_5_, strongholdType) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGenerator, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.func_74882_a(world, structureBoundingBoxIn, 0, 0, 0, 4, 10, 4, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 1, 7, 0);
            this.placeDoor(world, random, structureBoundingBoxIn, Stronghold.Door.OPENING, 1, 1, 4);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 2, 6, 1, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 1, 5, 1, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), 1, 6, 1, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 1, 5, 2, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 1, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), 1, 5, 3, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 2, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 3, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), 3, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 3, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 3, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), 3, 3, 1, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 2, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 1, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), 1, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 1, 1, 2, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), 1, 1, 3, structureBoundingBoxIn);
            return true;
        }
    }

    public static class RoomCrossing
    extends Stronghold {
        protected int roomType;

        public RoomCrossing(int componentType, Random p_i45575_2_, MutableBoundingBox p_i45575_3_, Direction p_i45575_4_, RSStrongholdStructure.Type strongholdType) {
            super(StructurePieces.STRONGHOLD_ROOM_CROSSING, componentType, strongholdType);
            this.func_186164_a(p_i45575_4_);
            this.entryDoor = this.getRandomDoor(p_i45575_2_);
            this.field_74887_e = p_i45575_3_;
            this.roomType = p_i45575_2_.nextInt(5);
        }

        public RoomCrossing(TemplateManager p_i50125_1_, CompoundNBT p_i50125_2_) {
            super(StructurePieces.STRONGHOLD_ROOM_CROSSING, p_i50125_2_);
            this.roomType = p_i50125_2_.func_74762_e("Type");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74768_a("Type", this.roomType);
        }

        public void func_74861_a(StructurePiece component, List<StructurePiece> piecesList, Random rand) {
            this.getNextComponentNormal((EntranceStairs)component, piecesList, rand, 4, 1);
            this.getNextComponentX((EntranceStairs)component, piecesList, rand, 1, 4);
            this.getNextComponentZ((EntranceStairs)component, piecesList, rand, 1, 4);
        }

        public static RoomCrossing createPiece(List<StructurePiece> p_175859_0_, Random p_175859_1_, int x, int y, int z, Direction p_175859_5_, int componentType, RSStrongholdStructure.Type strongholdType) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)11, (int)7, (int)11, (Direction)p_175859_5_);
            return RoomCrossing.canStrongholdGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(p_175859_0_, (MutableBoundingBox)mutableboundingbox) == null ? new RoomCrossing(componentType, p_175859_1_, mutableboundingbox, p_175859_5_, strongholdType) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGenerator, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.func_74882_a(world, structureBoundingBoxIn, 0, 0, 0, 10, 6, 10, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 4, 1, 0);
            this.func_175804_a(world, structureBoundingBoxIn, 4, 1, 10, 6, 3, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 1, 4, 0, 3, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 10, 1, 4, 10, 3, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            switch (this.roomType) {
                case 0: {
                    BlockPos blockpos = new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5));
                    if (structureBoundingBoxIn.func_175898_b((Vec3i)blockpos)) {
                        if (RepurposedStructures.RSStrongholdsConfig.allowExtraSpawnersSH.get().booleanValue()) {
                            world.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                            TileEntity tileentity = world.func_175625_s(blockpos);
                            if (tileentity instanceof MobSpawnerTileEntity) {
                                ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(this.getSpawnerEntity());
                            }
                        } else {
                            world.func_180501_a(blockpos, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 2);
                        }
                    }
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 5, 2, 5, structureBoundingBoxIn);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 5, 3, 5, structureBoundingBoxIn);
                    this.func_175811_a(world, (BlockState)this.getBlockOfCorrectType(Blocks.field_196591_bQ.func_176223_P()).func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)Direction.WEST), 4, 3, 5, structureBoundingBoxIn);
                    this.func_175811_a(world, (BlockState)this.getBlockOfCorrectType(Blocks.field_196591_bQ.func_176223_P()).func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)Direction.EAST), 6, 3, 5, structureBoundingBoxIn);
                    this.func_175811_a(world, (BlockState)this.getBlockOfCorrectType(Blocks.field_196591_bQ.func_176223_P()).func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH), 5, 3, 4, structureBoundingBoxIn);
                    this.func_175811_a(world, (BlockState)this.getBlockOfCorrectType(Blocks.field_196591_bQ.func_176223_P()).func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)Direction.NORTH), 5, 3, 6, structureBoundingBoxIn);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), 4, 1, 4, structureBoundingBoxIn);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), 4, 1, 5, structureBoundingBoxIn);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), 4, 1, 6, structureBoundingBoxIn);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), 6, 1, 4, structureBoundingBoxIn);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), 6, 1, 5, structureBoundingBoxIn);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), 6, 1, 6, structureBoundingBoxIn);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), 5, 1, 4, structureBoundingBoxIn);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), 5, 1, 6, structureBoundingBoxIn);
                    break;
                }
                case 1: {
                    for (int i1 = 0; i1 < 5; ++i1) {
                        this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 3, 1, 3 + i1, structureBoundingBoxIn);
                        this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 7, 1, 3 + i1, structureBoundingBoxIn);
                        this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 3 + i1, 1, 3, structureBoundingBoxIn);
                        this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 3 + i1, 1, 7, structureBoundingBoxIn);
                    }
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 5, 2, 5, structureBoundingBoxIn);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 5, 3, 5, structureBoundingBoxIn);
                    BlockPos blockpos = new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5));
                    if (structureBoundingBoxIn.func_175898_b((Vec3i)blockpos)) {
                        if (RepurposedStructures.RSStrongholdsConfig.allowExtraSpawnersSH.get().booleanValue()) {
                            world.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                            TileEntity tileentity = world.func_175625_s(blockpos);
                            if (tileentity instanceof MobSpawnerTileEntity) {
                                ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(this.getSpawnerEntity());
                            }
                        } else {
                            world.func_180501_a(blockpos, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 2);
                        }
                    }
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150355_j.func_176223_P()), 5, 4, 5, structureBoundingBoxIn);
                    break;
                }
                case 2: 
                case 3: {
                    for (int i = 1; i <= 9; ++i) {
                        this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150347_e.func_176223_P()), 1, 3, i, structureBoundingBoxIn);
                        this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150347_e.func_176223_P()), 9, 3, i, structureBoundingBoxIn);
                    }
                    for (int j = 1; j <= 9; ++j) {
                        this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150347_e.func_176223_P()), j, 3, 1, structureBoundingBoxIn);
                        this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150347_e.func_176223_P()), j, 3, 9, structureBoundingBoxIn);
                    }
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150347_e.func_176223_P()), 5, 1, 4, structureBoundingBoxIn);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150347_e.func_176223_P()), 5, 1, 6, structureBoundingBoxIn);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150347_e.func_176223_P()), 5, 3, 4, structureBoundingBoxIn);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150347_e.func_176223_P()), 5, 3, 6, structureBoundingBoxIn);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150347_e.func_176223_P()), 4, 1, 5, structureBoundingBoxIn);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150347_e.func_176223_P()), 6, 1, 5, structureBoundingBoxIn);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150347_e.func_176223_P()), 4, 3, 5, structureBoundingBoxIn);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150347_e.func_176223_P()), 6, 3, 5, structureBoundingBoxIn);
                    for (int k = 1; k <= 3; ++k) {
                        this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150347_e.func_176223_P()), 4, k, 4, structureBoundingBoxIn);
                        this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150347_e.func_176223_P()), 6, k, 4, structureBoundingBoxIn);
                        this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150347_e.func_176223_P()), 4, k, 6, structureBoundingBoxIn);
                        this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150347_e.func_176223_P()), 6, k, 6, structureBoundingBoxIn);
                    }
                    BlockPos blockpos = new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5));
                    if (structureBoundingBoxIn.func_175898_b((Vec3i)blockpos)) {
                        if (RepurposedStructures.RSStrongholdsConfig.allowExtraSpawnersSH.get().booleanValue()) {
                            world.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                            TileEntity tileentity = world.func_175625_s(blockpos);
                            if (tileentity instanceof MobSpawnerTileEntity) {
                                ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(this.getSpawnerEntity());
                            }
                            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150478_aa.func_176223_P()), 5, 2, 5, structureBoundingBoxIn);
                        } else {
                            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150478_aa.func_176223_P()), 5, 1, 5, structureBoundingBoxIn);
                        }
                    }
                    for (int l = 2; l <= 8; ++l) {
                        this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), 2, 3, l, structureBoundingBoxIn);
                        this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), 3, 3, l, structureBoundingBoxIn);
                        if (l <= 3 || l >= 7) {
                            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), 4, 3, l, structureBoundingBoxIn);
                            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), 5, 3, l, structureBoundingBoxIn);
                            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), 6, 3, l, structureBoundingBoxIn);
                        }
                        this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), 7, 3, l, structureBoundingBoxIn);
                        this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), 8, 3, l, structureBoundingBoxIn);
                    }
                    BlockState iblockstate = (BlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a((IProperty)LadderBlock.field_176382_a, (Comparable)Direction.WEST);
                    this.func_175811_a(world, iblockstate, 9, 1, 3, structureBoundingBoxIn);
                    this.func_175811_a(world, iblockstate, 9, 2, 3, structureBoundingBoxIn);
                    this.func_175811_a(world, iblockstate, 9, 3, 3, structureBoundingBoxIn);
                    if (!RepurposedStructures.RSStrongholdsConfig.lootChestsSH.get().booleanValue()) break;
                    this.func_186167_a(world, structureBoundingBoxIn, random, 3, 4, 8, this.getStorageChestLoot());
                    this.func_186167_a(world, structureBoundingBoxIn, random, 5, 4, 2, this.getStorageChestLoot());
                    this.func_186167_a(world, structureBoundingBoxIn, random, 6, 4, 8, this.getStorageChestLoot());
                    this.func_186167_a(world, structureBoundingBoxIn, random, 8, 4, 4, this.getStorageChestLoot());
                }
            }
            return true;
        }
    }

    public static class RightTurn
    extends Turn {
        public RightTurn(int componentType, Random p_i50127_2_, MutableBoundingBox p_i50127_3_, Direction p_i50127_4_, RSStrongholdStructure.Type strongholdType) {
            super(StructurePieces.STRONGHOLD_RIGHT_TURN, componentType, strongholdType);
            this.func_186164_a(p_i50127_4_);
            this.entryDoor = this.getRandomDoor(p_i50127_2_);
            this.field_74887_e = p_i50127_3_;
        }

        public RightTurn(TemplateManager p_i50128_1_, CompoundNBT p_i50128_2_) {
            super(StructurePieces.STRONGHOLD_RIGHT_TURN, p_i50128_2_);
        }

        public void func_74861_a(StructurePiece component, List<StructurePiece> piecesList, Random rand) {
            Direction enumfacing = this.func_186165_e();
            if (enumfacing != Direction.NORTH && enumfacing != Direction.EAST) {
                this.getNextComponentX((EntranceStairs)component, piecesList, rand, 1, 1);
            } else {
                this.getNextComponentZ((EntranceStairs)component, piecesList, rand, 1, 1);
            }
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGenerator, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.func_74882_a(world, structureBoundingBoxIn, 0, 0, 0, 4, 4, 4, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 1, 1, 0);
            Direction enumfacing = this.func_186165_e();
            if (enumfacing != Direction.NORTH && enumfacing != Direction.EAST) {
                this.func_175804_a(world, structureBoundingBoxIn, 0, 1, 1, 0, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            } else {
                this.func_175804_a(world, structureBoundingBoxIn, 4, 1, 1, 4, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            return true;
        }

        public static RightTurn createPiece(List<StructurePiece> p_214824_0_, Random p_214824_1_, int x, int y, int z, Direction p_214824_5_, int componentType, RSStrongholdStructure.Type strongholdType) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)5, (Direction)p_214824_5_);
            return RightTurn.canStrongholdGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(p_214824_0_, (MutableBoundingBox)mutableboundingbox) == null ? new RightTurn(componentType, p_214824_1_, mutableboundingbox, p_214824_5_, strongholdType) : null;
        }
    }

    public static class Prison
    extends Stronghold {
        public Prison(int componentType, Random p_i45576_2_, MutableBoundingBox p_i45576_3_, Direction p_i45576_4_, RSStrongholdStructure.Type strongholdType) {
            super(StructurePieces.STRONGHOLD_PRISON, componentType, strongholdType);
            this.func_186164_a(p_i45576_4_);
            this.entryDoor = this.getRandomDoor(p_i45576_2_);
            this.field_74887_e = p_i45576_3_;
        }

        public Prison(TemplateManager p_i50130_1_, CompoundNBT p_i50130_2_) {
            super(StructurePieces.STRONGHOLD_PRISON, p_i50130_2_);
        }

        public void func_74861_a(StructurePiece component, List<StructurePiece> piecesList, Random rand) {
            this.getNextComponentNormal((EntranceStairs)component, piecesList, rand, 1, 1);
        }

        public static Prison createPiece(List<StructurePiece> p_175860_0_, Random p_175860_1_, int x, int y, int z, Direction p_175860_5_, int componentType, RSStrongholdStructure.Type strongholdType) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)9, (int)5, (int)11, (Direction)p_175860_5_);
            return Prison.canStrongholdGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(p_175860_0_, (MutableBoundingBox)mutableboundingbox) == null ? new Prison(componentType, p_175860_1_, mutableboundingbox, p_175860_5_, strongholdType) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGenerator, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.func_74882_a(world, structureBoundingBoxIn, 0, 0, 0, 8, 4, 10, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 1, 1, 0);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 1, 10, 3, 3, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_74882_a(world, structureBoundingBoxIn, 4, 1, 1, 4, 3, 1, false, random, randomStrongholdBlocks);
            this.func_74882_a(world, structureBoundingBoxIn, 4, 1, 3, 4, 3, 3, false, random, randomStrongholdBlocks);
            this.func_74882_a(world, structureBoundingBoxIn, 4, 1, 7, 4, 3, 7, false, random, randomStrongholdBlocks);
            this.func_74882_a(world, structureBoundingBoxIn, 4, 1, 9, 4, 3, 9, false, random, randomStrongholdBlocks);
            this.func_175804_a(world, structureBoundingBoxIn, 4, 1, 4, 4, 3, 6, this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), false);
            this.func_175804_a(world, structureBoundingBoxIn, 5, 1, 5, 7, 3, 5, this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), false);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), 4, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), 4, 3, 8, structureBoundingBoxIn);
            BlockState iblockstate = (BlockState)this.getBlockOfCorrectType(Blocks.field_150454_av.func_176223_P()).func_206870_a((IProperty)DoorBlock.field_176520_a, (Comparable)Direction.WEST);
            BlockState iblockstate1 = (BlockState)((BlockState)this.getBlockOfCorrectType(Blocks.field_150454_av.func_176223_P()).func_206870_a((IProperty)DoorBlock.field_176520_a, (Comparable)Direction.WEST)).func_206870_a((IProperty)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER);
            this.func_175811_a(world, iblockstate, 4, 1, 2, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate1, 4, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 4, 1, 8, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate1, 4, 2, 8, structureBoundingBoxIn);
            return true;
        }
    }

    public static class PortalRoom
    extends Stronghold {
        public PortalRoom(int componentType, MutableBoundingBox p_i50131_2_, Direction p_i50131_3_, RSStrongholdStructure.Type strongholdType) {
            super(StructurePieces.STRONGHOLD_PORTAL_ROOM, componentType, strongholdType);
            this.func_186164_a(p_i50131_3_);
            this.field_74887_e = p_i50131_2_;
        }

        public PortalRoom(TemplateManager p_i50132_1_, CompoundNBT p_i50132_2_) {
            super(StructurePieces.STRONGHOLD_PORTAL_ROOM, p_i50132_2_);
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
        }

        public void func_74861_a(StructurePiece component, List<StructurePiece> piecesList, Random rand) {
            if (component != null) {
                ((EntranceStairs)component).strongholdPortalRoom = this;
            }
        }

        public static PortalRoom createPiece(List<StructurePiece> p_175865_0_, Random p_175865_1_, int x, int y, int z, Direction p_175865_5_, int componentType, RSStrongholdStructure.Type strongholdType) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)11, (int)8, (int)16, (Direction)p_175865_5_);
            return PortalRoom.canStrongholdGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(p_175865_0_, (MutableBoundingBox)mutableboundingbox) == null ? new PortalRoom(componentType, mutableboundingbox, p_175865_5_, strongholdType) : null;
        }

        public static PortalRoom createPiece(List<StructurePiece> p_175865_0_, Random p_175865_1_, int x, int y, int z, Direction p_175865_5_, RSStrongholdStructure.Type strongholdType) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)11, (int)8, (int)16, (Direction)p_175865_5_);
            return new PortalRoom(1, mutableboundingbox, p_175865_5_, strongholdType);
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGenerator, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.func_74882_a(world, structureBoundingBoxIn, 0, 0, 0, 10, 7, 15, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, Stronghold.Door.GRATES, 4, 1, 0);
            int i = 6;
            this.func_74882_a(world, structureBoundingBoxIn, 1, i, 1, 1, i, 14, false, random, randomStrongholdBlocks);
            this.func_74882_a(world, structureBoundingBoxIn, 9, i, 1, 9, i, 14, false, random, randomStrongholdBlocks);
            this.func_74882_a(world, structureBoundingBoxIn, 2, i, 1, 8, i, 2, false, random, randomStrongholdBlocks);
            this.func_74882_a(world, structureBoundingBoxIn, 2, i, 14, 8, i, 14, false, random, randomStrongholdBlocks);
            this.func_74882_a(world, structureBoundingBoxIn, 1, 1, 1, 2, 1, 4, false, random, randomStrongholdBlocks);
            this.func_74882_a(world, structureBoundingBoxIn, 8, 1, 1, 9, 1, 4, false, random, randomStrongholdBlocks);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 1, 1, 1, 1, 3, Blocks.field_150353_l.func_176223_P(), Blocks.field_150353_l.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 9, 1, 1, 9, 1, 3, Blocks.field_150353_l.func_176223_P(), Blocks.field_150353_l.func_176223_P(), false);
            this.func_74882_a(world, structureBoundingBoxIn, 3, 1, 8, 7, 1, 12, false, random, randomStrongholdBlocks);
            this.func_175804_a(world, structureBoundingBoxIn, 4, 1, 9, 6, 1, 11, Blocks.field_150353_l.func_176223_P(), Blocks.field_150353_l.func_176223_P(), false);
            for (int j = 3; j < 14; j += 2) {
                this.func_175804_a(world, structureBoundingBoxIn, 0, 3, j, 0, 4, j, this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), false);
                this.func_175804_a(world, structureBoundingBoxIn, 10, 3, j, 10, 4, j, this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), false);
            }
            for (int i1 = 2; i1 < 9; i1 += 2) {
                this.func_175804_a(world, structureBoundingBoxIn, i1, 3, 15, i1, 4, 15, this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_150411_aY.func_176223_P()), false);
            }
            BlockState iblockstate3 = (BlockState)this.getBlockOfCorrectType(Blocks.field_150390_bg.func_176223_P()).func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH);
            this.func_74882_a(world, structureBoundingBoxIn, 4, 1, 5, 6, 1, 7, false, random, randomStrongholdBlocks);
            this.func_74882_a(world, structureBoundingBoxIn, 4, 2, 6, 6, 2, 7, false, random, randomStrongholdBlocks);
            this.func_74882_a(world, structureBoundingBoxIn, 4, 3, 7, 6, 3, 7, false, random, randomStrongholdBlocks);
            for (int k = 4; k <= 6; ++k) {
                this.func_175811_a(world, iblockstate3, k, 1, 4, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate3, k, 2, 5, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate3, k, 3, 6, structureBoundingBoxIn);
            }
            BlockState iblockstate4 = (BlockState)Blocks.field_150378_br.func_176223_P().func_206870_a((IProperty)EndPortalFrameBlock.field_176508_a, (Comparable)Direction.NORTH);
            BlockState iblockstate = (BlockState)Blocks.field_150378_br.func_176223_P().func_206870_a((IProperty)EndPortalFrameBlock.field_176508_a, (Comparable)Direction.SOUTH);
            BlockState iblockstate1 = (BlockState)Blocks.field_150378_br.func_176223_P().func_206870_a((IProperty)EndPortalFrameBlock.field_176508_a, (Comparable)Direction.EAST);
            BlockState iblockstate2 = (BlockState)Blocks.field_150378_br.func_176223_P().func_206870_a((IProperty)EndPortalFrameBlock.field_176508_a, (Comparable)Direction.WEST);
            boolean flag = true;
            boolean[] aboolean = new boolean[12];
            for (int l = 0; l < aboolean.length; ++l) {
                aboolean[l] = random.nextFloat() > 0.9f;
                flag &= aboolean[l];
            }
            this.func_175811_a(world, (BlockState)iblockstate4.func_206870_a((IProperty)EndPortalFrameBlock.field_176507_b, (Comparable)Boolean.valueOf(aboolean[0])), 4, 3, 8, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)iblockstate4.func_206870_a((IProperty)EndPortalFrameBlock.field_176507_b, (Comparable)Boolean.valueOf(aboolean[1])), 5, 3, 8, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)iblockstate4.func_206870_a((IProperty)EndPortalFrameBlock.field_176507_b, (Comparable)Boolean.valueOf(aboolean[2])), 6, 3, 8, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)iblockstate.func_206870_a((IProperty)EndPortalFrameBlock.field_176507_b, (Comparable)Boolean.valueOf(aboolean[3])), 4, 3, 12, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)iblockstate.func_206870_a((IProperty)EndPortalFrameBlock.field_176507_b, (Comparable)Boolean.valueOf(aboolean[4])), 5, 3, 12, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)iblockstate.func_206870_a((IProperty)EndPortalFrameBlock.field_176507_b, (Comparable)Boolean.valueOf(aboolean[5])), 6, 3, 12, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)iblockstate1.func_206870_a((IProperty)EndPortalFrameBlock.field_176507_b, (Comparable)Boolean.valueOf(aboolean[6])), 3, 3, 9, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)iblockstate1.func_206870_a((IProperty)EndPortalFrameBlock.field_176507_b, (Comparable)Boolean.valueOf(aboolean[7])), 3, 3, 10, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)iblockstate1.func_206870_a((IProperty)EndPortalFrameBlock.field_176507_b, (Comparable)Boolean.valueOf(aboolean[8])), 3, 3, 11, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)iblockstate2.func_206870_a((IProperty)EndPortalFrameBlock.field_176507_b, (Comparable)Boolean.valueOf(aboolean[9])), 7, 3, 9, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)iblockstate2.func_206870_a((IProperty)EndPortalFrameBlock.field_176507_b, (Comparable)Boolean.valueOf(aboolean[10])), 7, 3, 10, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)iblockstate2.func_206870_a((IProperty)EndPortalFrameBlock.field_176507_b, (Comparable)Boolean.valueOf(aboolean[11])), 7, 3, 11, structureBoundingBoxIn);
            if (flag) {
                BlockState iblockstate5 = Blocks.field_150384_bq.func_176223_P();
                this.func_175811_a(world, iblockstate5, 4, 3, 9, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate5, 5, 3, 9, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate5, 6, 3, 9, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate5, 4, 3, 10, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate5, 5, 3, 10, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate5, 6, 3, 10, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate5, 4, 3, 11, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate5, 5, 3, 11, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate5, 6, 3, 11, structureBoundingBoxIn);
            }
            i = this.func_74862_a(3);
            BlockPos blockpos = new BlockPos(this.func_74865_a(5, 6), i, this.func_74873_b(5, 6));
            if (structureBoundingBoxIn.func_175898_b((Vec3i)blockpos)) {
                world.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                TileEntity tileentity = world.func_175625_s(blockpos);
                if (tileentity instanceof MobSpawnerTileEntity) {
                    ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(this.getSpawnerEntity());
                }
            }
            return true;
        }
    }

    static class PieceWeight {
        public Class<? extends Stronghold> pieceClass;
        public final int pieceWeight;
        public int instancesSpawned;
        public int instancesLimit;

        public PieceWeight(Class<? extends Stronghold> p_i2076_1_, int p_i2076_2_, int p_i2076_3_) {
            this.pieceClass = p_i2076_1_;
            this.pieceWeight = p_i2076_2_;
            this.instancesLimit = p_i2076_3_;
        }

        public boolean canSpawnMoreStructures(int distanceFromStart) {
            int maxLimit = (int)((double)this.instancesLimit * (RepurposedStructures.RSStrongholdsConfig.strongholdSizeSH.get() * 0.01));
            return this.instancesLimit == 0 || this.instancesSpawned < maxLimit;
        }

        public boolean canSpawnMoreStructures() {
            int maxLimit = (int)((double)this.instancesLimit * (RepurposedStructures.RSStrongholdsConfig.strongholdSizeSH.get() * 0.01));
            return this.instancesLimit == 0 || this.instancesSpawned < maxLimit;
        }
    }

    public static class Library
    extends Stronghold {
        private boolean isLargeRoom;

        public Library(int componentType, Random p_i45578_2_, MutableBoundingBox p_i45578_3_, Direction p_i45578_4_, RSStrongholdStructure.Type strongholdType) {
            super(StructurePieces.STRONGHOLD_LIBRARY, componentType, strongholdType);
            this.func_186164_a(p_i45578_4_);
            this.entryDoor = this.getRandomDoor(p_i45578_2_);
            this.field_74887_e = p_i45578_3_;
            this.isLargeRoom = p_i45578_3_.func_78882_c() > 6;
        }

        public Library(TemplateManager p_i50133_1_, CompoundNBT p_i50133_2_) {
            super(StructurePieces.STRONGHOLD_LIBRARY, p_i50133_2_);
            this.isLargeRoom = p_i50133_2_.func_74767_n("Tall");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("Tall", this.isLargeRoom);
        }

        public static Library createPiece(List<StructurePiece> p_175864_0_, Random p_175864_1_, int x, int y, int z, Direction p_175864_5_, int componentType, RSStrongholdStructure.Type strongholdType) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)14, (int)11, (int)15, (Direction)p_175864_5_);
            if (!(Library.canStrongholdGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(p_175864_0_, (MutableBoundingBox)mutableboundingbox) == null || Library.canStrongholdGoDeeper(mutableboundingbox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)14, (int)6, (int)15, (Direction)p_175864_5_)) && StructurePiece.func_74883_a(p_175864_0_, (MutableBoundingBox)mutableboundingbox) == null)) {
                return null;
            }
            return new Library(componentType, p_175864_1_, mutableboundingbox, p_175864_5_, strongholdType);
        }

        private BlockState pickBookshelfBlock(Random random) {
            Tag BOOKSHELF_TAG;
            Collection allBookshelfBlocks;
            BlockState bookshelfBlock = Blocks.field_150342_X.func_176223_P();
            if (this.strongholdType == RSStrongholdStructure.Type.NETHER && !(allBookshelfBlocks = (BOOKSHELF_TAG = BlockTags.func_199896_a().func_199915_b(NETHER_STRONGHOLD_BOOKSHELF_RL)).func_199885_a()).isEmpty()) {
                bookshelfBlock = ((Block)allBookshelfBlocks.toArray()[random.nextInt(allBookshelfBlocks.size())]).func_176223_P();
            }
            return bookshelfBlock;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGenerator, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            int i = 11;
            if (!this.isLargeRoom) {
                i = 6;
            }
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.func_74882_a(world, structureBoundingBoxIn, 0, 0, 0, 13, i - 1, 14, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 4, 1, 0);
            this.func_189914_a(world, structureBoundingBoxIn, random, 0.07f, 2, 1, 1, 11, 4, 13, Blocks.field_196553_aF.func_176223_P(), Blocks.field_196553_aF.func_176223_P(), false, false);
            for (int l = 1; l <= 13; ++l) {
                if ((l - 1) % 4 == 0) {
                    this.func_175804_a(world, structureBoundingBoxIn, 1, 1, l, 1, 4, l, this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), false);
                    this.func_175804_a(world, structureBoundingBoxIn, 12, 1, l, 12, 4, l, this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), false);
                    this.func_175811_a(world, (BlockState)this.getBlockOfCorrectType(Blocks.field_196591_bQ.func_176223_P()).func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)Direction.EAST), 2, 3, l, structureBoundingBoxIn);
                    this.func_175811_a(world, (BlockState)this.getBlockOfCorrectType(Blocks.field_196591_bQ.func_176223_P()).func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)Direction.WEST), 11, 3, l, structureBoundingBoxIn);
                    if (!this.isLargeRoom) continue;
                    this.func_175804_a(world, structureBoundingBoxIn, 1, 6, l, 1, 9, l, this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), false);
                    this.func_175804_a(world, structureBoundingBoxIn, 12, 6, l, 12, 9, l, this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), false);
                    continue;
                }
                this.func_175804_a(world, structureBoundingBoxIn, 1, 1, l, 1, 4, l, this.pickBookshelfBlock(random), this.pickBookshelfBlock(random), false);
                this.func_175804_a(world, structureBoundingBoxIn, 12, 1, l, 12, 4, l, this.pickBookshelfBlock(random), this.pickBookshelfBlock(random), false);
                if (!this.isLargeRoom) continue;
                this.func_175804_a(world, structureBoundingBoxIn, 1, 6, l, 1, 9, l, this.pickBookshelfBlock(random), this.pickBookshelfBlock(random), false);
                this.func_175804_a(world, structureBoundingBoxIn, 12, 6, l, 12, 9, l, this.pickBookshelfBlock(random), this.pickBookshelfBlock(random), false);
            }
            for (int l1 = 3; l1 < 12; l1 += 2) {
                this.func_175804_a(world, structureBoundingBoxIn, 3, 1, l1, 4, 3, l1, this.pickBookshelfBlock(random), this.pickBookshelfBlock(random), false);
                this.func_175804_a(world, structureBoundingBoxIn, 6, 1, l1, 7, 3, l1, this.pickBookshelfBlock(random), this.pickBookshelfBlock(random), false);
                this.func_175804_a(world, structureBoundingBoxIn, 9, 1, l1, 10, 3, l1, this.pickBookshelfBlock(random), this.pickBookshelfBlock(random), false);
            }
            if (this.isLargeRoom) {
                this.func_175804_a(world, structureBoundingBoxIn, 1, 5, 1, 3, 5, 13, this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), false);
                this.func_175804_a(world, structureBoundingBoxIn, 10, 5, 1, 12, 5, 13, this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), false);
                this.func_175804_a(world, structureBoundingBoxIn, 4, 5, 1, 9, 5, 2, this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), false);
                this.func_175804_a(world, structureBoundingBoxIn, 4, 5, 12, 9, 5, 13, this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), false);
                this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), 9, 5, 11, structureBoundingBoxIn);
                this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), 8, 5, 11, structureBoundingBoxIn);
                this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196662_n.func_176223_P()), 9, 5, 10, structureBoundingBoxIn);
                BlockState iblockstate5 = (BlockState)((BlockState)this.getBlockOfCorrectType(Blocks.field_180407_aO.func_176223_P()).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
                BlockState iblockstate = (BlockState)((BlockState)this.getBlockOfCorrectType(Blocks.field_180407_aO.func_176223_P()).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true));
                this.func_175804_a(world, structureBoundingBoxIn, 3, 6, 3, 3, 6, 11, iblockstate, iblockstate, false);
                this.func_175804_a(world, structureBoundingBoxIn, 10, 6, 3, 10, 6, 9, iblockstate, iblockstate, false);
                this.func_175804_a(world, structureBoundingBoxIn, 4, 6, 2, 9, 6, 2, iblockstate5, iblockstate5, false);
                this.func_175804_a(world, structureBoundingBoxIn, 4, 6, 12, 7, 6, 12, iblockstate5, iblockstate5, false);
                this.func_175811_a(world, (BlockState)((BlockState)this.getBlockOfCorrectType(Blocks.field_180407_aO.func_176223_P()).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), 3, 6, 2, structureBoundingBoxIn);
                this.func_175811_a(world, (BlockState)((BlockState)this.getBlockOfCorrectType(Blocks.field_180407_aO.func_176223_P()).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), 3, 6, 12, structureBoundingBoxIn);
                this.func_175811_a(world, (BlockState)((BlockState)this.getBlockOfCorrectType(Blocks.field_180407_aO.func_176223_P()).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 10, 6, 2, structureBoundingBoxIn);
                for (int i1 = 0; i1 <= 2; ++i1) {
                    this.func_175811_a(world, (BlockState)((BlockState)this.getBlockOfCorrectType(Blocks.field_180407_aO.func_176223_P()).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 8 + i1, 6, 12 - i1, structureBoundingBoxIn);
                    if (i1 == 2) continue;
                    this.func_175811_a(world, (BlockState)((BlockState)this.getBlockOfCorrectType(Blocks.field_180407_aO.func_176223_P()).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), 8 + i1, 6, 11 - i1, structureBoundingBoxIn);
                }
                BlockState iblockstate6 = (BlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a((IProperty)LadderBlock.field_176382_a, (Comparable)Direction.SOUTH);
                this.func_175811_a(world, iblockstate6, 10, 1, 13, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate6, 10, 2, 13, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate6, 10, 3, 13, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate6, 10, 4, 13, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate6, 10, 5, 13, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate6, 10, 6, 13, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate6, 10, 7, 13, structureBoundingBoxIn);
                BlockState iblockstate1 = (BlockState)this.getBlockOfCorrectType(Blocks.field_180407_aO.func_176223_P()).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
                this.func_175811_a(world, iblockstate1, 6, 9, 7, structureBoundingBoxIn);
                BlockState iblockstate2 = (BlockState)this.getBlockOfCorrectType(Blocks.field_180407_aO.func_176223_P()).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true));
                this.func_175811_a(world, iblockstate2, 7, 9, 7, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate1, 6, 8, 7, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate2, 7, 8, 7, structureBoundingBoxIn);
                BlockState iblockstate3 = (BlockState)((BlockState)iblockstate.func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
                this.func_175811_a(world, iblockstate3, 6, 7, 7, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate3, 7, 7, 7, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate1, 5, 7, 7, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate2, 8, 7, 7, structureBoundingBoxIn);
                this.func_175811_a(world, (BlockState)iblockstate1.func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 6, 7, 6, structureBoundingBoxIn);
                this.func_175811_a(world, (BlockState)iblockstate1.func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), 6, 7, 8, structureBoundingBoxIn);
                this.func_175811_a(world, (BlockState)iblockstate2.func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 7, 7, 6, structureBoundingBoxIn);
                this.func_175811_a(world, (BlockState)iblockstate2.func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), 7, 7, 8, structureBoundingBoxIn);
                BlockState iblockstate4 = this.getBlockOfCorrectType(Blocks.field_150478_aa.func_176223_P());
                this.func_175811_a(world, iblockstate4, 5, 8, 7, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate4, 8, 8, 7, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate4, 6, 8, 6, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate4, 6, 8, 8, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate4, 7, 8, 6, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate4, 7, 8, 8, structureBoundingBoxIn);
            }
            if (RepurposedStructures.RSStrongholdsConfig.lootChestsSH.get().booleanValue()) {
                this.func_186167_a(world, structureBoundingBoxIn, random, 3, 3, 5, LootTables.field_186426_h);
            }
            if (this.isLargeRoom) {
                this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 12, 9, 1, structureBoundingBoxIn);
                if (RepurposedStructures.RSStrongholdsConfig.lootChestsSH.get().booleanValue()) {
                    this.func_186167_a(world, structureBoundingBoxIn, random, 12, 8, 1, LootTables.field_186426_h);
                }
            }
            return true;
        }
    }

    public static class LeftTurn
    extends Turn {
        public LeftTurn(int componentType, Random p_i45579_2_, MutableBoundingBox p_i45579_3_, Direction p_i45579_4_, RSStrongholdStructure.Type strongholdType) {
            super(StructurePieces.STRONGHOLD_LEFT_TURN, componentType, strongholdType);
            this.func_186164_a(p_i45579_4_);
            this.entryDoor = this.getRandomDoor(p_i45579_2_);
            this.field_74887_e = p_i45579_3_;
        }

        public LeftTurn(TemplateManager p_i50134_1_, CompoundNBT p_i50134_2_) {
            super(StructurePieces.STRONGHOLD_LEFT_TURN, p_i50134_2_);
        }

        public void func_74861_a(StructurePiece component, List<StructurePiece> piecesList, Random rand) {
            Direction enumfacing = this.func_186165_e();
            if (enumfacing != Direction.NORTH && enumfacing != Direction.EAST) {
                this.getNextComponentZ((EntranceStairs)component, piecesList, rand, 1, 1);
            } else {
                this.getNextComponentX((EntranceStairs)component, piecesList, rand, 1, 1);
            }
        }

        public static LeftTurn createPiece(List<StructurePiece> p_175867_0_, Random p_175867_1_, int x, int y, int z, Direction p_175867_5_, int componentType, RSStrongholdStructure.Type strongholdType) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)5, (Direction)p_175867_5_);
            return LeftTurn.canStrongholdGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(p_175867_0_, (MutableBoundingBox)mutableboundingbox) == null ? new LeftTurn(componentType, p_175867_1_, mutableboundingbox, p_175867_5_, strongholdType) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGenerator, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.func_74882_a(world, structureBoundingBoxIn, 0, 0, 0, 4, 4, 4, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 1, 1, 0);
            Direction enumfacing = this.func_186165_e();
            if (enumfacing != Direction.NORTH && enumfacing != Direction.EAST) {
                this.func_175804_a(world, structureBoundingBoxIn, 4, 1, 1, 4, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            } else {
                this.func_175804_a(world, structureBoundingBoxIn, 0, 1, 1, 0, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            return true;
        }
    }

    public static class Crossing
    extends Stronghold {
        private boolean leftLow;
        private boolean leftHigh;
        private boolean rightLow;
        private boolean rightHigh;

        public Crossing(int componentType, Random p_i45580_2_, MutableBoundingBox p_i45580_3_, Direction p_i45580_4_, RSStrongholdStructure.Type strongholdType) {
            super(StructurePieces.STRONGHOLD_CROSSING, componentType, strongholdType);
            this.func_186164_a(p_i45580_4_);
            this.entryDoor = this.getRandomDoor(p_i45580_2_);
            this.field_74887_e = p_i45580_3_;
            this.leftLow = p_i45580_2_.nextBoolean();
            this.leftHigh = p_i45580_2_.nextBoolean();
            this.rightLow = p_i45580_2_.nextBoolean();
            this.rightHigh = p_i45580_2_.nextInt(3) > 0;
        }

        public Crossing(TemplateManager p_i50136_1_, CompoundNBT p_i50136_2_) {
            super(StructurePieces.STRONGHOLD_CROSSING, p_i50136_2_);
            this.leftLow = p_i50136_2_.func_74767_n("leftLow");
            this.leftHigh = p_i50136_2_.func_74767_n("leftHigh");
            this.rightLow = p_i50136_2_.func_74767_n("rightLow");
            this.rightHigh = p_i50136_2_.func_74767_n("rightHigh");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("leftLow", this.leftLow);
            tagCompound.func_74757_a("leftHigh", this.leftHigh);
            tagCompound.func_74757_a("rightLow", this.rightLow);
            tagCompound.func_74757_a("rightHigh", this.rightHigh);
        }

        public void func_74861_a(StructurePiece component, List<StructurePiece> piecesList, Random rand) {
            int i = 3;
            int j = 5;
            Direction enumfacing = this.func_186165_e();
            if (enumfacing == Direction.WEST || enumfacing == Direction.NORTH) {
                i = 8 - i;
                j = 8 - j;
            }
            this.getNextComponentNormal((EntranceStairs)component, piecesList, rand, 5, 1);
            if (this.leftLow) {
                this.getNextComponentX((EntranceStairs)component, piecesList, rand, i, 1);
            }
            if (this.leftHigh) {
                this.getNextComponentX((EntranceStairs)component, piecesList, rand, j, 7);
            }
            if (this.rightLow) {
                this.getNextComponentZ((EntranceStairs)component, piecesList, rand, i, 1);
            }
            if (this.rightHigh) {
                this.getNextComponentZ((EntranceStairs)component, piecesList, rand, j, 7);
            }
        }

        public static Crossing createPiece(List<StructurePiece> p_175866_0_, Random p_175866_1_, int x, int y, int z, Direction p_175866_5_, int componentType, RSStrongholdStructure.Type strongholdType) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-4, (int)-3, (int)0, (int)10, (int)9, (int)11, (Direction)p_175866_5_);
            return Crossing.canStrongholdGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(p_175866_0_, (MutableBoundingBox)mutableboundingbox) == null ? new Crossing(componentType, p_175866_1_, mutableboundingbox, p_175866_5_, strongholdType) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGenerator, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.func_74882_a(world, structureBoundingBoxIn, 0, 0, 0, 9, 8, 10, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 4, 3, 0);
            if (this.leftLow) {
                this.func_175804_a(world, structureBoundingBoxIn, 0, 3, 1, 0, 5, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            if (this.rightLow) {
                this.func_175804_a(world, structureBoundingBoxIn, 9, 3, 1, 9, 5, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            if (this.leftHigh) {
                this.func_175804_a(world, structureBoundingBoxIn, 0, 5, 7, 0, 7, 9, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            if (this.rightHigh) {
                this.func_175804_a(world, structureBoundingBoxIn, 9, 5, 7, 9, 7, 9, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            this.func_175804_a(world, structureBoundingBoxIn, 5, 1, 10, 7, 3, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_74882_a(world, structureBoundingBoxIn, 1, 2, 1, 8, 2, 6, false, random, randomStrongholdBlocks);
            this.func_74882_a(world, structureBoundingBoxIn, 4, 1, 5, 4, 4, 9, false, random, randomStrongholdBlocks);
            this.func_74882_a(world, structureBoundingBoxIn, 8, 1, 5, 8, 4, 9, false, random, randomStrongholdBlocks);
            this.func_74882_a(world, structureBoundingBoxIn, 1, 4, 7, 3, 4, 9, false, random, randomStrongholdBlocks);
            this.func_74882_a(world, structureBoundingBoxIn, 1, 3, 5, 3, 3, 6, false, random, randomStrongholdBlocks);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 3, 4, 3, 3, 4, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 4, 6, 3, 4, 6, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), false);
            this.func_74882_a(world, structureBoundingBoxIn, 5, 1, 7, 7, 1, 8, false, random, randomStrongholdBlocks);
            this.func_175804_a(world, structureBoundingBoxIn, 5, 1, 9, 7, 1, 9, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), false);
            this.func_175804_a(world, structureBoundingBoxIn, 5, 2, 7, 7, 2, 7, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), false);
            this.func_175804_a(world, structureBoundingBoxIn, 4, 5, 7, 4, 5, 9, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), false);
            this.func_175804_a(world, structureBoundingBoxIn, 8, 5, 7, 8, 5, 9, this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()), false);
            this.func_175804_a(world, structureBoundingBoxIn, 5, 5, 7, 7, 5, 9, (BlockState)this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()).func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE), (BlockState)this.getBlockOfCorrectType(Blocks.field_150333_U.func_176223_P()).func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE), false);
            this.func_175811_a(world, (BlockState)this.getBlockOfCorrectType(Blocks.field_196591_bQ.func_176223_P()).func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH), 6, 5, 6, structureBoundingBoxIn);
            return true;
        }
    }

    public static class Corridor
    extends Stronghold {
        private int steps;

        public Corridor(int componentType, MutableBoundingBox p_i50137_2_, Direction p_i50137_3_, RSStrongholdStructure.Type strongholdType) {
            super(StructurePieces.STRONGHOLD_CORRIDOR, componentType, strongholdType);
            this.func_186164_a(p_i50137_3_);
            this.field_74887_e = p_i50137_2_;
            this.steps = p_i50137_3_ != Direction.NORTH && p_i50137_3_ != Direction.SOUTH ? p_i50137_2_.func_78883_b() : p_i50137_2_.func_78880_d();
        }

        public Corridor(TemplateManager p_i50138_1_, CompoundNBT p_i50138_2_) {
            super(StructurePieces.STRONGHOLD_CORRIDOR, p_i50138_2_);
            this.steps = p_i50138_2_.func_74762_e("Steps");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74768_a("Steps", this.steps);
        }

        public static MutableBoundingBox findPieceBox(List<StructurePiece> p_175869_0_, Random p_175869_1_, int p_175869_2_, int p_175869_3_, int p_175869_4_, Direction p_175869_5_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175869_2_, (int)p_175869_3_, (int)p_175869_4_, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)4, (Direction)p_175869_5_);
            StructurePiece structurePiece = StructurePiece.func_74883_a(p_175869_0_, (MutableBoundingBox)mutableboundingbox);
            if (structurePiece == null) {
                return null;
            }
            if (structurePiece.func_74874_b().field_78895_b == mutableboundingbox.field_78895_b) {
                for (int j = 3; j >= 1; --j) {
                    mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175869_2_, (int)p_175869_3_, (int)p_175869_4_, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)(j - 1), (Direction)p_175869_5_);
                    if (structurePiece.func_74874_b().func_78884_a(mutableboundingbox)) continue;
                    return MutableBoundingBox.func_175897_a((int)p_175869_2_, (int)p_175869_3_, (int)p_175869_4_, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)j, (Direction)p_175869_5_);
                }
            }
            return null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGenerator, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            for (int i = 0; i < this.steps; ++i) {
                this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 0, 0, i, structureBoundingBoxIn);
                this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 1, 0, i, structureBoundingBoxIn);
                this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 2, 0, i, structureBoundingBoxIn);
                this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 3, 0, i, structureBoundingBoxIn);
                this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 4, 0, i, structureBoundingBoxIn);
                for (int j = 1; j <= 3; ++j) {
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 0, j, i, structureBoundingBoxIn);
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 1, j, i, structureBoundingBoxIn);
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, j, i, structureBoundingBoxIn);
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 3, j, i, structureBoundingBoxIn);
                    this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 4, j, i, structureBoundingBoxIn);
                }
                this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 0, 4, i, structureBoundingBoxIn);
                this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 1, 4, i, structureBoundingBoxIn);
                this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 2, 4, i, structureBoundingBoxIn);
                this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 3, 4, i, structureBoundingBoxIn);
                this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), 4, 4, i, structureBoundingBoxIn);
            }
            return true;
        }
    }

    public static class ChestCorridor
    extends Stronghold {
        public ChestCorridor(int componentType, Random p_i45582_2_, MutableBoundingBox p_i45582_3_, Direction p_i45582_4_, RSStrongholdStructure.Type strongholdType) {
            super(StructurePieces.STRONGHOLD_CHEST_CORRIDOR, componentType, strongholdType);
            this.func_186164_a(p_i45582_4_);
            this.entryDoor = this.getRandomDoor(p_i45582_2_);
            this.field_74887_e = p_i45582_3_;
        }

        public ChestCorridor(TemplateManager p_i50140_1_, CompoundNBT p_i50140_2_) {
            super(StructurePieces.STRONGHOLD_CHEST_CORRIDOR, p_i50140_2_);
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
        }

        public void func_74861_a(StructurePiece component, List<StructurePiece> piecesList, Random rand) {
            this.getNextComponentNormal((EntranceStairs)component, piecesList, rand, 1, 1);
        }

        public static ChestCorridor createPiece(List<StructurePiece> p_175868_0_, Random p_175868_1_, int x, int y, int z, Direction p_175868_5_, int componentType, RSStrongholdStructure.Type strongholdType) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)7, (Direction)p_175868_5_);
            return ChestCorridor.canStrongholdGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(p_175868_0_, (MutableBoundingBox)mutableboundingbox) == null ? new ChestCorridor(componentType, p_175868_1_, mutableboundingbox, p_175868_5_, strongholdType) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGenerator, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            Stones randomStrongholdBlocks = new Stones(this.strongholdType);
            this.func_74882_a(world, structureBoundingBoxIn, 0, 0, 0, 4, 4, 6, false, random, randomStrongholdBlocks);
            this.placeDoor(world, random, structureBoundingBoxIn, this.entryDoor, 1, 1, 0);
            this.placeDoor(world, random, structureBoundingBoxIn, Stronghold.Door.OPENING, 1, 1, 6);
            this.func_175804_a(world, structureBoundingBoxIn, 3, 1, 2, 3, 1, 4, this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), this.getBlockOfCorrectType(Blocks.field_196696_di.func_176223_P()), false);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196573_bB.func_176223_P()), 3, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196573_bB.func_176223_P()), 3, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196573_bB.func_176223_P()), 3, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196573_bB.func_176223_P()), 3, 2, 4, structureBoundingBoxIn);
            for (int i = 2; i <= 4; ++i) {
                this.func_175811_a(world, this.getBlockOfCorrectType(Blocks.field_196573_bB.func_176223_P()), 2, 1, i, structureBoundingBoxIn);
            }
            if (structureBoundingBoxIn.func_175898_b((Vec3i)new BlockPos(this.func_74865_a(3, 3), this.func_74862_a(2), this.func_74873_b(3, 3))) && RepurposedStructures.RSStrongholdsConfig.lootChestsSH.get().booleanValue() && random.nextInt(3) == 0) {
                this.func_186167_a(world, structureBoundingBoxIn, random, 3, 2, 3, this.getHallwayChestLoot());
            }
            return true;
        }
    }
}

