/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features.structures;

import com.mojang.datafixers.Dynamic;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.world.features.structures.RSStrongholdPieces;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StrongholdStructure;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class RSStrongholdStructure
extends StrongholdStructure {
    public RSStrongholdStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> config) {
        super(config);
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int maxDistance = RepurposedStructures.RSStrongholdsConfig.strongholdSpawnrate.get();
        int minDistance = (int)((float)maxDistance * 0.75f);
        if (minDistance == 0) {
            minDistance = 1;
        }
        int k = x + maxDistance * spacingOffsetsX;
        int l = z + maxDistance * spacingOffsetsZ;
        int i1 = k < 0 ? k - maxDistance + 1 : k;
        int j1 = l < 0 ? l - maxDistance + 1 : l;
        int targetChunkX = i1 / maxDistance;
        int targetChunkZ = j1 / maxDistance;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), targetChunkX, targetChunkZ, 148523564);
        targetChunkX *= maxDistance;
        targetChunkZ *= maxDistance;
        return new ChunkPos(targetChunkX += random.nextInt(maxDistance - minDistance), targetChunkZ += random.nextInt(maxDistance - minDistance));
    }

    public boolean func_225558_a_(BiomeManager biomeManager, ChunkGenerator<?> chunkGenerator, Random random, int chunkPosX, int chunkPosZ, Biome biome) {
        if (RepurposedStructures.RSStrongholdsConfig.useVanillaStronghold.get().booleanValue()) {
            return super.func_225558_a_(biomeManager, chunkGenerator, random, chunkPosX, chunkPosZ, biome);
        }
        ChunkPos chunkpos = this.func_211744_a(chunkGenerator, random, chunkPosX, chunkPosZ, 0, 0);
        return chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b && chunkGenerator.func_202094_a(biome, (Structure)this);
    }

    public BlockPos func_211405_a(World world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, BlockPos position, int radius, boolean skipExistingChunks) {
        if (RepurposedStructures.RSStrongholdsConfig.useVanillaStronghold.get().booleanValue()) {
            return super.func_211405_a(world, chunkGenerator, position, radius, skipExistingChunks);
        }
        if (!chunkGenerator.func_202090_b().func_205004_a((Structure)this)) {
            return null;
        }
        int chunkX = position.func_177958_n() >> 4;
        int chunkZ = position.func_177952_p() >> 4;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        block0: for (int currentRadius = 0; currentRadius <= radius; ++currentRadius) {
            for (int x = -currentRadius; x <= currentRadius; ++x) {
                boolean validXPos = x == -currentRadius || x == currentRadius;
                for (int z = -currentRadius; z <= currentRadius; ++z) {
                    boolean validZPos;
                    boolean bl = validZPos = z == -currentRadius || z == currentRadius;
                    if (!validXPos && !validZPos) continue;
                    ChunkPos chunkpos = this.func_211744_a(chunkGenerator, (Random)sharedseedrandom, chunkX, chunkZ, x, z);
                    StructureStart structurestart = world.func_217348_a(chunkpos.field_77276_a, chunkpos.field_77275_b, ChunkStatus.field_222606_b).func_201585_a(this.func_143025_a());
                    if (structurestart != null && structurestart.func_75069_d()) {
                        if (skipExistingChunks && structurestart.func_212687_g()) {
                            structurestart.func_212685_h();
                            return structurestart.func_204294_a();
                        }
                        if (!skipExistingChunks) {
                            return structurestart.func_204294_a();
                        }
                    }
                    if (currentRadius == 0) break;
                }
                if (currentRadius == 0) continue block0;
            }
        }
        return null;
    }

    public Structure.IStartFactory func_214557_a() {
        if (RepurposedStructures.RSStrongholdsConfig.useVanillaStronghold.get().booleanValue()) {
            return super.func_214557_a();
        }
        return Start::new;
    }

    public String func_143025_a() {
        return "Stronghold";
    }

    public int func_202367_b() {
        return 8;
    }

    public static enum Type {
        NORMAL,
        NETHER;


        public static Type byId(int id) {
            return id >= 0 && id < Type.values().length ? Type.values()[id] : NORMAL;
        }
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            RSStrongholdPieces.prepareStructurePieces();
            Type type = biomeIn.func_201856_r() == Biome.Category.NETHER && RepurposedStructures.RSStrongholdsConfig.allowNetherStronghold.get() != false ? Type.NETHER : Type.NORMAL;
            RSStrongholdPieces.EntranceStairs strongholdpieces$entrancestairs = new RSStrongholdPieces.EntranceStairs((Random)this.field_214631_d, (chunkX << 4) + 2, (chunkZ << 4) + 2, type);
            this.field_75075_a.add(strongholdpieces$entrancestairs);
            strongholdpieces$entrancestairs.func_74861_a(strongholdpieces$entrancestairs, this.field_75075_a, (Random)this.field_214631_d);
            List<StructurePiece> list = strongholdpieces$entrancestairs.pendingChildren;
            while (!list.isEmpty()) {
                int i = this.field_214631_d.nextInt(list.size());
                StructurePiece structurepiece = list.remove(i);
                structurepiece.func_74861_a((StructurePiece)strongholdpieces$entrancestairs, this.field_75075_a, (Random)this.field_214631_d);
            }
            if (strongholdpieces$entrancestairs.strongholdPortalRoom == null) {
                MutableBoundingBox box = ((StructurePiece)this.field_75075_a.get(this.field_75075_a.size() - 1)).func_74874_b();
                RSStrongholdPieces.PortalRoom portalRoom = RSStrongholdPieces.PortalRoom.createPiece(this.field_75075_a, (Random)this.field_214631_d, box.field_78897_a, box.field_78895_b + 1, box.field_78896_c, Direction.NORTH, type);
                this.field_75075_a.add(portalRoom);
                strongholdpieces$entrancestairs.pendingChildren.add(portalRoom);
                list = strongholdpieces$entrancestairs.pendingChildren;
                while (!list.isEmpty()) {
                    int i = this.field_214631_d.nextInt(list.size());
                    StructurePiece structurepiece = list.remove(i);
                    structurepiece.func_74861_a((StructurePiece)strongholdpieces$entrancestairs, this.field_75075_a, (Random)this.field_214631_d);
                }
            }
            this.func_202500_a();
            int lowestBounds = this.field_75074_b.field_78895_b - 2;
            int maxYConfig = 0;
            int minYConfig = 0;
            if (type == Type.NORMAL) {
                maxYConfig = RepurposedStructures.RSStrongholdsConfig.normalStrongholdMaxHeight.get();
                minYConfig = RepurposedStructures.RSStrongholdsConfig.normalStrongholdMinHeight.get();
            } else if (type == Type.NETHER) {
                maxYConfig = RepurposedStructures.RSStrongholdsConfig.netherStrongholdMaxHeight.get();
                minYConfig = RepurposedStructures.RSStrongholdsConfig.netherStrongholdMinHeight.get();
            }
            int minimum = minYConfig;
            int maximum = Math.max(maxYConfig, minimum) + 1;
            int offset = this.field_214631_d.nextInt(maximum - minimum) + minimum;
            int offset2 = 0;
            this.field_75074_b.func_78886_a(0, offset - lowestBounds, 0);
            if (this.field_75074_b.field_78894_e > maxYConfig) {
                int heightDiff = maxYConfig - this.field_75074_b.field_78894_e;
                offset2 = Math.max(heightDiff, -this.field_75074_b.field_78895_b);
            }
            this.field_75074_b.func_78886_a(0, offset2, 0);
            for (StructurePiece structurepiece : this.field_75075_a) {
                structurepiece.func_181138_a(0, offset + offset2 - lowestBounds, 0);
            }
        }
    }
}

