/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features.structures;

import com.mojang.datafixers.Dynamic;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.structure.VillagePieces;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class VillageBadlandsStructure
extends Structure<NoFeatureConfig> {
    public VillageBadlandsStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> config) {
        super(config);
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int maxDistance = RepurposedStructures.RSVillagesConfig.badlandsVillageSpawnrate.get();
        int minDistance = (int)((float)maxDistance * 0.75f);
        if (minDistance == 0) {
            minDistance = 1;
        }
        int k = x + maxDistance * spacingOffsetsX;
        int l = z + maxDistance * spacingOffsetsZ;
        int i1 = k < 0 ? k - maxDistance + 1 : k;
        int j1 = l < 0 ? l - maxDistance + 1 : l;
        int targetChunkX = i1 / maxDistance;
        int targetChunkZ = j1 / maxDistance;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), targetChunkX, targetChunkZ, 14983233);
        targetChunkX *= maxDistance;
        targetChunkZ *= maxDistance;
        return new ChunkPos(targetChunkX += random.nextInt(maxDistance - minDistance), targetChunkZ += random.nextInt(maxDistance - minDistance));
    }

    public boolean func_225558_a_(BiomeManager biomeManager, ChunkGenerator<?> chunkGenerator, Random random, int chunkPosX, int chunkPosZ, Biome biome) {
        ChunkPos chunkpos = this.func_211744_a(chunkGenerator, random, chunkPosX, chunkPosZ, 0, 0);
        if (chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b && chunkGenerator.func_202094_a(biome, (Structure)this)) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (chunkGenerator.func_202094_a(biomeManager.func_226836_a_(new BlockPos((chunkPosX + x) * 16, 60, (chunkPosZ + z) * 16)), (Structure)this)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return "repurposed_structures:village_badlands";
    }

    public int func_202367_b() {
        return 8;
    }

    public static class Start
    extends MarginedStructureStart {
        public Start(Structure<?> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManager, int chunkX, int chunkZ, Biome biomeIn) {
            BlockPos blockpos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
            VillagePieces.func_214838_a(generator, (TemplateManager)templateManager, (BlockPos)blockpos, (List)this.field_75075_a, (SharedSeedRandom)this.field_214631_d, (VillageConfig)new VillageConfig("repurposed_structures:village/badlands/town_centers", 10));
            this.func_202500_a();
        }
    }
}

