/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.respawnablepets.mixin;

import java.util.Objects;
import java.util.UUID;
import moriyashiine.respawnablepets.client.network.message.SmokePuffMessage;
import moriyashiine.respawnablepets.common.RespawnablePets;
import moriyashiine.respawnablepets.common.world.RPWorldState;
import net.fabricmc.fabric.api.server.PlayerStream;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.minecraft.class_1282;
import net.minecraft.class_1283;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3494;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    private static final class_3494<class_1299<?>> BLACKLIST = TagRegistry.entityType((class_2960)new class_2960("respawnablepets", "blacklisted"));

    @Shadow
    public abstract class_1283 method_6066();

    @Shadow
    public abstract float method_6032();

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    private void toggleRespawn(class_1282 source, float amount, CallbackInfoReturnable<Boolean> callbackInfo) {
        class_1657 player;
        class_1297 attacker;
        if (!this.field_6002.field_9236 && (attacker = source.method_5526()) instanceof class_1657 && (player = (class_1657)attacker).method_6047().method_7909() == RespawnablePets.ETHERIC_GEM) {
            class_2487 stored = this.method_5647(new class_2487());
            if (stored.method_25928("Owner") && player.method_5667().equals(stored.method_25926("Owner"))) {
                if (BLACKLIST.method_15141((Object)this.method_5864())) {
                    player.method_7353((class_2561)new class_2588("message.respawnablepets.blacklisted", new Object[]{this.method_5476()}), true);
                } else {
                    RPWorldState rpWorldState = RPWorldState.get(this.field_6002);
                    if (LivingEntityMixin.isPetRespawnable(rpWorldState, (class_1309)this)) {
                        player.method_7353((class_2561)new class_2588("message.respawnablepets.disable_respawn", new Object[]{this.method_5476()}), true);
                        for (int i = rpWorldState.petsToRespawn.size() - 1; i >= 0; --i) {
                            if (!rpWorldState.petsToRespawn.get(i).equals(this.method_5667())) continue;
                            rpWorldState.petsToRespawn.remove(i);
                            rpWorldState.method_80();
                        }
                    } else {
                        player.method_7353((class_2561)new class_2588("message.respawnablepets.enable_respawn", new Object[]{this.method_5476()}), true);
                        rpWorldState.petsToRespawn.add(this.method_5667());
                        rpWorldState.method_80();
                    }
                }
            } else {
                player.method_7353((class_2561)new class_2588("message.respawnablepets.not_owner", new Object[]{this.method_5476()}), true);
            }
            callbackInfo.cancel();
        }
    }

    @Inject(method={"applyDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void storeToWorld(class_1282 source, float amount, CallbackInfo callbackInfo) {
        if (!this.field_6002.field_9236) {
            RPWorldState rpWorldState = RPWorldState.get(this.field_6002);
            if (this.method_6032() - amount <= 0.0f && LivingEntityMixin.isPetRespawnable(rpWorldState, (class_1309)this)) {
                class_2487 stored = new class_2487();
                this.method_5786(stored);
                rpWorldState.storedPets.add(stored);
                rpWorldState.method_80();
                PlayerStream.watching((class_1297)this).forEach(foundPlayer -> SmokePuffMessage.send(foundPlayer, this.method_5628()));
                this.field_6002.method_8396(null, this.method_24515(), class_3417.field_14879, class_3419.field_15254, 1.0f, 1.0f);
                this.method_5650();
                class_1657 owner = LivingEntityMixin.findPlayer(this.field_6002, stored.method_25926("Owner"));
                if (owner != null && this.field_6002.method_8450().method_8355(class_1928.field_19398)) {
                    owner.method_7353(this.method_6066().method_5548(), false);
                }
                callbackInfo.cancel();
            }
        }
    }

    @Inject(method={"wakeUp"}, at={@At(value="HEAD")})
    private void respawnPets(CallbackInfo callbackInfo) {
        if (!this.field_6002.field_9236) {
            RPWorldState rpWorldState = RPWorldState.get(this.field_6002);
            for (int i = rpWorldState.storedPets.size() - 1; i >= 0; --i) {
                class_1309 pet;
                class_2487 nbt = rpWorldState.storedPets.get(i);
                if (!this.method_5667().equals(nbt.method_25926("Owner")) || (pet = (class_1309)((class_1299)class_2378.field_11145.method_10223(new class_2960(nbt.method_10558("id")))).method_5883(this.field_6002)) == null) continue;
                pet.method_5651(nbt);
                pet.method_5866(this.field_6002);
                pet.method_20620(this.method_23317() + 0.5, this.method_23318() + 0.5, this.method_23321() + 0.5);
                pet.field_5988 = false;
                pet.method_6033(pet.method_6063());
                pet.method_5646();
                pet.method_6012();
                pet.field_6017 = 0.0f;
                this.field_6002.method_8649((class_1297)pet);
                rpWorldState.storedPets.remove(i);
                rpWorldState.method_80();
            }
        }
    }

    private static class_1657 findPlayer(class_1937 world, UUID uuid) {
        for (class_3218 serverWorld : Objects.requireNonNull(world.method_8503()).method_3738()) {
            class_1657 player = serverWorld.method_18470(uuid);
            if (player == null) continue;
            return player;
        }
        return null;
    }

    private static boolean isPetRespawnable(RPWorldState rpWorldState, class_1309 entity) {
        for (UUID uuid : rpWorldState.petsToRespawn) {
            if (!entity.method_5667().equals(uuid)) continue;
            return true;
        }
        return false;
    }
}

