/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.worldgen.BlockBase;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;

public class MetaBlock
extends BlockBase {
    private Block block;
    private int meta;
    private int flag;

    public MetaBlock(Block block) {
        this(block, 0, 2);
    }

    public MetaBlock(Block block, int meta) {
        this(block, meta, 2);
    }

    public MetaBlock(Block block, int meta, int flag) {
        this.block = block;
        this.meta = meta;
        this.flag = flag;
    }

    public MetaBlock(JsonElement data) {
        JsonObject json = (JsonObject)data;
        String name = json.get("name").getAsString();
        this.block = (Block)Block.field_149771_c.func_82594_a(name);
        this.meta = json.has("meta") ? json.get("meta").getAsInt() : 0;
        this.flag = json.has("flag") ? json.get("flag").getAsInt() : 2;
    }

    public MetaBlock(MetaBlock toCopy) {
        this.block = toCopy.block;
        this.meta = toCopy.meta;
        this.flag = toCopy.flag;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setBlockID(Block in) {
        this.block = in;
    }

    public void setMeta(int in) {
        this.meta = in;
    }

    public void setFlag(int in) {
        this.flag = in;
    }

    public boolean set(IWorldEditor editor, Coord pos) {
        return editor.setBlock(pos, this, true, true);
    }

    public Material getMaterial() {
        return this.block.func_149688_o();
    }

    public boolean isOpaqueCube() {
        return this.block.func_149662_c();
    }

    @Override
    public boolean set(IWorldEditor editor, Random rand, Coord pos, boolean fillAir, boolean replaceSolid) {
        return editor.setBlock(pos, this, fillAir, replaceSolid);
    }
}

