/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.dungeon.DungeonGenerator;
import greymerk.roguelike.dungeon.IDungeon;
import greymerk.roguelike.dungeon.settings.ISettings;
import greymerk.roguelike.dungeon.settings.SettingsContainer;
import greymerk.roguelike.dungeon.settings.SettingsResolver;
import greymerk.roguelike.dungeon.settings.SpawnCriteria;
import greymerk.roguelike.treasure.ITreasureChest;
import greymerk.roguelike.treasure.Treasure;
import greymerk.roguelike.treasure.TreasureManager;
import greymerk.roguelike.treasure.loot.Book;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.VanillaStructure;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class Dungeon
implements IDungeon {
    private static final String SETTINGS_DIRECTORY = "config/roguelike_dungeons/settings";
    public static SettingsResolver settingsResolver;
    private DungeonGenerator generator = new DungeonGenerator();
    private Coord pos;
    private IWorldEditor editor;

    public static void initResolver() throws Exception {
        File settingsDir = new File(SETTINGS_DIRECTORY);
        if (settingsDir.exists() && !settingsDir.isDirectory()) {
            throw new Exception("Settings directory is a file");
        }
        if (!settingsDir.exists()) {
            settingsDir.mkdir();
        }
        Object[] settingsFiles = settingsDir.listFiles();
        Arrays.sort(settingsFiles);
        SettingsContainer settings = new SettingsContainer();
        settingsResolver = new SettingsResolver(settings);
        HashMap<String, String> files = new HashMap<String, String>();
        for (File file : Arrays.asList(settingsFiles)) {
            try {
                String content = Files.toString((File)file, (Charset)Charsets.UTF_8);
                files.put(file.getName(), content);
            }
            catch (IOException e) {
                throw new Exception("Error reading file : " + file.getName());
            }
        }
        settings.parseCustomSettings(files);
    }

    public Dungeon(IWorldEditor editor) {
        this.editor = editor;
    }

    public void generateNear(Random rand, int x, int z) {
        if (settingsResolver == null) {
            return;
        }
        int attempts = 50;
        for (int i = 0; i < attempts; ++i) {
            ISettings setting;
            Coord location = Dungeon.getNearbyCoord(rand, x, z, 40, 100);
            if (!this.validLocation(rand, location.getX(), location.getZ())) continue;
            try {
                setting = settingsResolver.getSettings(this.editor, rand, location);
            }
            catch (Exception e) {
                return;
            }
            if (setting == null) {
                return;
            }
            this.generate(setting, location.getX(), location.getZ());
            return;
        }
    }

    @Override
    public void generate(ISettings settings, int inX, int inZ) {
        this.generator.generate(this.editor, settings, inX, inZ);
        this.pos = new Coord(inX, 50, inZ);
        Random rand = Dungeon.getRandom(this.editor, this.pos.getX(), this.pos.getZ());
        TreasureManager treasure = this.editor.getTreasure();
        settings.getLootRules().process(rand, treasure);
        Book book = new Book("Greymerk", "Statistics");
        book.addPage("~Architect's Resource Notes~\n\nStoneBrick: " + this.editor.getStat(Blocks.field_150417_aV) + "\nCobblestone: " + this.editor.getStat(Blocks.field_150347_e) + "\nLogs: " + (this.editor.getStat(Blocks.field_150364_r) + this.editor.getStat(Blocks.field_150363_s)) + "\nIron Bars: " + this.editor.getStat(Blocks.field_150411_aY) + "\nChests: " + (this.editor.getStat((Block)Blocks.field_150486_ae) + this.editor.getStat(Blocks.field_150447_bR)) + "\nMob Spawners: " + this.editor.getStat(Blocks.field_150474_ac) + "\nTNT: " + this.editor.getStat(Blocks.field_150335_W) + "\n\n-Greymerk");
        book.addPage("Roguelike Dungeons v1.7.2\nSept 21 2017\n\nCredits\n\nAuthor: Greymerk\n\nBits: Drainedsoul\n\nIdeas: Eniko @enichan");
        treasure.addItemToAll(rand, Treasure.STARTER, new WeightedChoice<ItemStack>(book.get(), 1), 1);
    }

    public static boolean canSpawnInChunk(int chunkX, int chunkZ, IWorldEditor editor) {
        if (!RogueConfig.getBoolean(RogueConfig.DONATURALSPAWN)) {
            return false;
        }
        int dim = editor.getDimension();
        ArrayList<Integer> wl = new ArrayList<Integer>();
        wl.addAll(RogueConfig.getIntList(RogueConfig.DIMENSIONWL));
        ArrayList<Integer> bl = new ArrayList<Integer>();
        bl.addAll(RogueConfig.getIntList(RogueConfig.DIMENSIONBL));
        if (!SpawnCriteria.isValidDimension(dim, wl, bl)) {
            return false;
        }
        int frequency = RogueConfig.getInt(RogueConfig.SPAWNFREQUENCY);
        int min = 8 * frequency / 10;
        int max = 32 * frequency / 10;
        min = min < 2 ? 2 : min;
        max = max < 8 ? 8 : max;
        int tempX = chunkX < 0 ? chunkX - (max - 1) : chunkX;
        int tempZ = chunkZ < 0 ? chunkZ - (max - 1) : chunkZ;
        int m = tempX / max;
        int n = tempZ / max;
        Random r = editor.getSeededRandom(m, n, 10387312);
        m *= max;
        n *= max;
        return chunkX == (m += r.nextInt(max - min)) && chunkZ == (n += r.nextInt(max - min));
    }

    @Override
    public void spawnInChunk(Random rand, int chunkX, int chunkZ) {
        if (Dungeon.canSpawnInChunk(chunkX, chunkZ, this.editor)) {
            int x = chunkX * 16 + 4;
            int z = chunkZ * 16 + 4;
            this.generateNear(rand, x, z);
        }
    }

    public static int getLevel(int y) {
        if (y < 15) {
            return 4;
        }
        if (y < 25) {
            return 3;
        }
        if (y < 35) {
            return 2;
        }
        if (y < 45) {
            return 1;
        }
        return 0;
    }

    public boolean validLocation(Random rand, int x, int z) {
        double strongholdDistance;
        BiomeDictionary.Type[] invalidBiomes;
        Coord pos = new Coord(x, 0, z);
        Biome biome = this.editor.getBiome(pos);
        for (BiomeDictionary.Type type : invalidBiomes = new BiomeDictionary.Type[]{BiomeDictionary.Type.RIVER, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.OCEAN}) {
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type)) continue;
            return false;
        }
        Coord stronghold = this.editor.findNearestStructure(VanillaStructure.STRONGHOLD, pos);
        if (stronghold != null && (strongholdDistance = pos.distance(stronghold)) < 300.0) {
            return false;
        }
        int upperLimit = RogueConfig.getInt(RogueConfig.UPPERLIMIT);
        int lowerLimit = RogueConfig.getInt(RogueConfig.LOWERLIMIT);
        Coord cursor = new Coord(x, upperLimit, z);
        if (!this.editor.isAirBlock(cursor)) {
            return false;
        }
        while (!this.editor.validGroundBlock(cursor)) {
            cursor.add(Cardinal.DOWN);
            if (cursor.getY() < lowerLimit) {
                return false;
            }
            if (this.editor.getBlock(cursor).func_185904_a() != Material.field_151586_h) continue;
            return false;
        }
        for (Coord c : new RectSolid(new Coord(x - 4, cursor.getY() + 4, z - 4), new Coord(x + 4, cursor.getY() + 4, z + 4))) {
            if (!this.editor.validGroundBlock(c)) continue;
            return false;
        }
        int airCount = 0;
        for (Coord c : new RectSolid(new Coord(x - 4, cursor.getY() - 3, z - 4), new Coord(x + 4, cursor.getY() - 3, z + 4))) {
            if (!this.editor.validGroundBlock(c)) {
                ++airCount;
            }
            if (airCount <= 8) continue;
            return false;
        }
        return true;
    }

    public static Coord getNearbyCoord(Random rand, int x, int z, int min, int max) {
        int distance = min + rand.nextInt(max - min);
        double angle = rand.nextDouble() * 2.0 * Math.PI;
        int xOffset = (int)(Math.cos(angle) * (double)distance);
        int zOffset = (int)(Math.sin(angle) * (double)distance);
        Coord nearby = new Coord(x + xOffset, 0, z + zOffset);
        return nearby;
    }

    public static Random getRandom(IWorldEditor editor, int x, int z) {
        long seed = editor.getSeed() * (long)x * (long)z;
        Random rand = new Random();
        rand.setSeed(seed);
        return rand;
    }

    @Override
    public List<ITreasureChest> getChests() {
        return this.editor.getTreasure().getChests();
    }

    public Coord getPosition() throws Exception {
        if (this.pos == null) {
            throw new Exception("Dungeon not yet generated");
        }
        return this.pos;
    }

    static {
        try {
            RogueConfig.reload(false);
            Dungeon.initResolver();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

