/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon;

import greymerk.roguelike.dungeon.base.IDungeonRoom;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.BoundingBox;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.Random;

public class DungeonNode {
    private Coord pos;
    private IDungeonRoom toGenerate;
    private Cardinal[] entrances;

    public DungeonNode(Cardinal[] entrances, Coord origin) {
        this.entrances = entrances;
        this.pos = new Coord(origin);
    }

    public void setDungeon(IDungeonRoom toGenerate) {
        this.toGenerate = toGenerate;
    }

    public int getSize() {
        if (this.toGenerate == null) {
            return 6;
        }
        return this.toGenerate.getSize();
    }

    public void encase(IWorldEditor editor, Random rand, ITheme theme) {
        IDungeonRoom room = this.getRoom();
        int size = room.getSize();
        Coord s = new Coord(this.getPosition());
        Coord e = new Coord(s);
        s.add(Cardinal.NORTH, size);
        s.add(Cardinal.WEST, size);
        s.add(Cardinal.DOWN, 3);
        e.add(Cardinal.SOUTH, size);
        e.add(Cardinal.EAST, size);
        e.add(Cardinal.UP, 8);
        RectSolid.fill(editor, rand, s, e, theme.getPrimary().getWall());
    }

    public Cardinal[] getEntrances() {
        return this.entrances;
    }

    public Coord getPosition() {
        return new Coord(this.pos);
    }

    public IDungeonRoom getRoom() {
        return this.toGenerate;
    }

    public BoundingBox getBoundingBox() {
        Coord start = new Coord(this.pos);
        Coord end = new Coord(this.pos);
        int size = this.getSize();
        start.add(Cardinal.NORTH, size);
        start.add(Cardinal.WEST, size);
        start.add(Cardinal.DOWN, 1);
        end.add(Cardinal.SOUTH, size);
        end.add(Cardinal.EAST, size);
        end.add(Cardinal.UP, 8);
        return new BoundingBox(start, end);
    }
}

