/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.worldgen.IPositionInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SpawnCriteria {
    int weight = 1;
    List<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
    List<BiomeDictionary.Type> biomeTypes = new ArrayList<BiomeDictionary.Type>();
    boolean everywhere = false;

    public SpawnCriteria() {
    }

    public SpawnCriteria(JsonObject data) {
        this();
        int n = this.weight = data.has("weight") ? data.get("weight").getAsInt() : 1;
        if (data.has("biomes")) {
            JsonArray biomeList = data.get("biomes").getAsJsonArray();
            this.biomes = new ArrayList<ResourceLocation>();
            for (JsonElement e : biomeList) {
                String name = e.getAsString();
                this.biomes.add(new ResourceLocation(name));
            }
        }
        if (data.has("biomeTypes")) {
            JsonArray biomeTypeList = data.get("biomeTypes").getAsJsonArray();
            this.biomeTypes = new ArrayList<BiomeDictionary.Type>();
            for (JsonElement e : biomeTypeList) {
                String type = e.getAsString();
                BiomeDictionary.Type t = BiomeDictionary.Type.getType((String)type, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                if (BiomeDictionary.getBiomes((BiomeDictionary.Type)t).size() <= 0) continue;
                this.biomeTypes.add(t);
            }
        }
        this.everywhere = this.biomes.isEmpty() && this.biomeTypes.isEmpty();
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public void setbiomes(List<ResourceLocation> biomes) {
        this.biomes = biomes;
        this.everywhere = this.biomes.isEmpty() && this.biomeTypes.isEmpty();
    }

    public void setBiomeTypes(List<BiomeDictionary.Type> biomeTypes) {
        this.biomeTypes = biomeTypes;
        this.everywhere = this.biomes.isEmpty() && this.biomeTypes.isEmpty();
    }

    public boolean isValid(IPositionInfo info) {
        if (this.everywhere) {
            return true;
        }
        boolean biomeFound = false;
        Biome biome = info.getBiome();
        if (this.biomes != null && this.biomes.contains(biome.getRegistryName())) {
            biomeFound = true;
        }
        if (this.biomeTypes != null) {
            for (BiomeDictionary.Type type : this.biomeTypes) {
                if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type)) continue;
                biomeFound = true;
            }
        }
        return biomeFound;
    }

    public static boolean isValidDimension(int dim, List<Integer> wl, List<Integer> bl) {
        if (bl.contains(dim)) {
            return false;
        }
        if (wl.isEmpty()) {
            return true;
        }
        return wl.contains(dim);
    }
}

