/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings.builtin;

import greymerk.roguelike.dungeon.base.DungeonFactory;
import greymerk.roguelike.dungeon.base.DungeonRoom;
import greymerk.roguelike.dungeon.base.SecretFactory;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.SpawnCriteria;
import greymerk.roguelike.dungeon.settings.TowerSettings;
import greymerk.roguelike.dungeon.settings.builtin.SettingsBase;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.Theme;
import java.util.ArrayList;
import net.minecraftforge.common.BiomeDictionary;

public class SettingsForestTheme
extends DungeonSettings {
    public static final SettingIdentifier ID = new SettingIdentifier("builtin", "forest");

    public SettingsForestTheme() {
        this.id = ID;
        this.inherit.add(SettingsBase.ID);
        this.criteria = new SpawnCriteria();
        ArrayList<BiomeDictionary.Type> biomes = new ArrayList<BiomeDictionary.Type>();
        biomes.add(BiomeDictionary.Type.FOREST);
        this.criteria.setBiomeTypes(biomes);
        this.towerSettings = new TowerSettings(Tower.HOUSE, Theme.getTheme(Theme.HOUSE));
        for (int i = 0; i < 5; ++i) {
            LevelSettings level = new LevelSettings();
            SecretFactory secrets = new SecretFactory();
            switch (i) {
                case 0: {
                    secrets.addRoom(DungeonRoom.SMITH);
                    break;
                }
                case 1: {
                    DungeonFactory rooms = new DungeonFactory();
                    rooms.addSingle(DungeonRoom.MUSIC);
                    rooms.addSingle(DungeonRoom.PIT);
                    rooms.addSingle(DungeonRoom.MESS);
                    rooms.addSingle(DungeonRoom.LAB);
                    rooms.addRandom(DungeonRoom.CORNER, 10);
                    rooms.addRandom(DungeonRoom.BRICK, 3);
                    level.setRooms(rooms);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            level.setSecrets(secrets);
            this.levels.put(i, level);
        }
    }
}

