/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import greymerk.roguelike.treasure.loot.ILoot;
import greymerk.roguelike.treasure.loot.LootProvider;
import greymerk.roguelike.treasure.loot.LootSettings;
import greymerk.roguelike.treasure.loot.Slot;
import greymerk.roguelike.treasure.loot.provider.ItemArmour;
import greymerk.roguelike.treasure.loot.provider.ItemWeapon;
import greymerk.roguelike.util.TextFormat;
import java.util.Random;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public enum Loot {
    WEAPON,
    ARMOUR,
    BLOCK,
    JUNK,
    ORE,
    TOOL,
    POTION,
    FOOD,
    ENCHANTBOOK,
    ENCHANTBONUS,
    SUPPLY,
    MUSIC,
    SMITHY,
    SPECIAL,
    REWARD,
    STARTER;


    public static ILoot getLoot() {
        LootProvider loot = new LootProvider();
        for (int i = 0; i < 5; ++i) {
            loot.put(i, new LootSettings(i));
        }
        return loot;
    }

    public static ItemStack getEquipmentBySlot(Random rand, EntityEquipmentSlot slot, int level, boolean enchant) {
        if (slot == EntityEquipmentSlot.MAINHAND) {
            return ItemWeapon.getRandom(rand, level, enchant);
        }
        return ItemArmour.getRandom(rand, level, Slot.getSlot(slot), enchant);
    }

    public static ItemStack getEquipmentBySlot(Random rand, Slot slot, int level, boolean enchant) {
        if (slot == Slot.WEAPON) {
            return ItemWeapon.getRandom(rand, level, enchant);
        }
        return ItemArmour.getRandom(rand, level, slot, enchant);
    }

    public static void setItemLore(ItemStack item, String loreText) {
        NBTTagCompound display;
        NBTTagCompound tag = item.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            item.func_77982_d(tag);
        }
        if (!tag.func_74764_b("display")) {
            tag.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        if (!(display = tag.func_74775_l("display")).func_74764_b("Lore")) {
            display.func_74782_a("Lore", (NBTBase)new NBTTagList());
        }
        NBTTagList lore = display.func_150295_c("Lore", 0);
        NBTTagString toAdd = new NBTTagString(loreText);
        lore.func_74742_a((NBTBase)toAdd);
        display.func_74782_a("Lore", (NBTBase)lore);
    }

    public static void setItemLore(ItemStack item, String loreText, TextFormat option) {
        Loot.setItemLore(item, TextFormat.apply(loreText, option));
    }

    public static void setItemName(ItemStack item, String name, TextFormat option) {
        if (option == null) {
            item.func_151001_c(name);
            return;
        }
        item.func_151001_c(TextFormat.apply(name, option));
    }

    public static void setItemName(ItemStack item, String name) {
        Loot.setItemName(item, name, null);
    }
}

