/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.spawners;

import com.google.gson.JsonObject;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.util.JsonNBT;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.spawners.Spawner;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;

public class Spawnable {
    private boolean equip;
    private String name;
    private NBTTagCompound meta;

    public Spawnable(Spawner type) {
        this(Spawner.getName(type));
    }

    public Spawnable(String name) {
        this(true, name, null);
    }

    public Spawnable(String name, NBTTagCompound meta) {
        this(true, name, meta);
    }

    public Spawnable(boolean equip, String name, NBTTagCompound meta) {
        this.equip = equip;
        this.name = name;
        this.meta = meta;
    }

    public Spawnable(JsonObject data) {
        this.name = data.get("name").getAsString();
        boolean bl = this.equip = data.has("equip") ? data.get("equip").getAsBoolean() : true;
        if (!data.has("meta")) {
            return;
        }
        JsonObject metadata = data.get("meta").getAsJsonObject();
        this.meta = JsonNBT.jsonToCompound(metadata);
        if (!this.meta.func_74764_b("id")) {
            this.meta.func_74778_a("id", this.name);
        }
    }

    public void generate(IWorldEditor editor, Random rand, Coord cursor, int level) {
        Coord pos = new Coord(cursor);
        editor.setBlock(pos, new MetaBlock(Blocks.field_150474_ac.func_176223_P()), true, true);
        TileEntity tileentity = editor.getTileEntity(pos);
        if (!(tileentity instanceof TileEntityMobSpawner)) {
            return;
        }
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)tileentity;
        MobSpawnerBaseLogic spawnerLogic = spawner.func_145881_a();
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", pos.getX());
        nbt.func_74768_a("y", pos.getY());
        nbt.func_74768_a("z", pos.getZ());
        if (this.meta == null) {
            NBTTagList potentials = this.getSpawnPotentials(rand, level, this.name);
            NBTTagCompound spawn = potentials.func_150305_b(0);
            nbt.func_74782_a("SpawnPotentials", (NBTBase)potentials);
            nbt.func_74782_a("SpawnData", spawn.func_74781_a("Entity"));
        } else {
            nbt.func_74782_a("SpawnData", (NBTBase)this.meta);
        }
        spawnerLogic.func_98270_a(nbt);
        spawnerLogic.func_98278_g();
        tileentity.func_70296_d();
    }

    private NBTTagList getSpawnPotentials(Random rand, int level, String name) {
        NBTTagList potentials = new NBTTagList();
        if (name.equals(Spawner.getName(Spawner.ZOMBIE))) {
            for (int i = 0; i < 24; ++i) {
                Equipment tool;
                NBTTagCompound mob = new NBTTagCompound();
                mob = this.getRoguelike(level, this.name, mob);
                switch (rand.nextInt(3)) {
                    case 0: {
                        tool = Equipment.SHOVEL;
                        break;
                    }
                    case 1: {
                        tool = Equipment.AXE;
                        break;
                    }
                    case 2: {
                        tool = Equipment.PICK;
                        break;
                    }
                    default: {
                        tool = Equipment.PICK;
                    }
                }
                mob = this.equipHands(mob, Equipment.getName(tool, Quality.getToolQuality(rand, level)), "minecraft:shield");
                mob = this.equipArmour(mob, rand, level);
                potentials.func_74742_a((NBTBase)this.getPotential(mob));
            }
            return potentials;
        }
        if (name.equals(Spawner.getName(Spawner.SKELETON))) {
            for (int i = 0; i < 12; ++i) {
                NBTTagCompound mob = new NBTTagCompound();
                mob = this.getRoguelike(level, this.name, mob);
                mob = this.equipHands(mob, "minecraft:bow", null);
                mob = this.equipArmour(mob, rand, level);
                potentials.func_74742_a((NBTBase)this.getPotential(mob));
            }
            return potentials;
        }
        potentials.func_74742_a((NBTBase)this.getPotential(this.getRoguelike(level, this.name, new NBTTagCompound())));
        return potentials;
    }

    private NBTTagCompound getPotential(NBTTagCompound mob) {
        NBTTagCompound potential = new NBTTagCompound();
        potential.func_74782_a("Entity", (NBTBase)mob);
        potential.func_74768_a("Weight", 1);
        return potential;
    }

    private NBTTagCompound equipHands(NBTTagCompound mob, String weapon, String offhand) {
        NBTTagList hands = new NBTTagList();
        hands.func_74742_a((NBTBase)this.getItem(weapon));
        hands.func_74742_a((NBTBase)this.getItem(offhand));
        mob.func_74782_a("HandItems", (NBTBase)hands);
        return mob;
    }

    private NBTTagCompound equipArmour(NBTTagCompound mob, Random rand, int level) {
        NBTTagList armour = new NBTTagList();
        armour.func_74742_a((NBTBase)this.getItem(Equipment.getName(Equipment.FEET, Quality.getArmourQuality(rand, level))));
        armour.func_74742_a((NBTBase)this.getItem(Equipment.getName(Equipment.LEGS, Quality.getArmourQuality(rand, level))));
        armour.func_74742_a((NBTBase)this.getItem(Equipment.getName(Equipment.CHEST, Quality.getArmourQuality(rand, level))));
        armour.func_74742_a((NBTBase)this.getItem(Equipment.getName(Equipment.HELMET, Quality.getArmourQuality(rand, level))));
        mob.func_74782_a("ArmorItems", (NBTBase)armour);
        return mob;
    }

    private NBTTagCompound getItem(String name) {
        NBTTagCompound item = new NBTTagCompound();
        if (name == null) {
            return item;
        }
        item.func_74778_a("id", name);
        item.func_74768_a("Count", 1);
        return item;
    }

    private NBTTagCompound getRoguelike(int level, String type, NBTTagCompound tag) {
        tag.func_74778_a("id", type);
        if (!RogueConfig.getBoolean(RogueConfig.ROGUESPAWNERS) || !this.equip) {
            return tag;
        }
        NBTTagList activeEffects = new NBTTagList();
        tag.func_74782_a("ActiveEffects", (NBTBase)activeEffects);
        NBTTagCompound buff = new NBTTagCompound();
        activeEffects.func_74742_a((NBTBase)buff);
        buff.func_74774_a("Id", (byte)4);
        buff.func_74774_a("Amplifier", (byte)level);
        buff.func_74768_a("Duration", 10);
        buff.func_74774_a("Ambient", (byte)0);
        return tag;
    }
}

