/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.internal.JsonTreeInput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0014J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lkotlinx/serialization/json/internal/JsonTreeMapInput;", "Lkotlinx/serialization/json/internal/JsonTreeInput;", "json", "Lkotlinx/serialization/json/Json;", "value", "Lkotlinx/serialization/json/JsonObject;", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/JsonObject;)V", "keys", "", "", "position", "", "size", "getValue", "()Lkotlinx/serialization/json/JsonObject;", "currentElement", "Lkotlinx/serialization/json/JsonElement;", "tag", "decodeElementIndex", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "elementName", "desc", "index", "endStructure", "", "kotlinx-serialization-runtime"})
final class JsonTreeMapInput
extends JsonTreeInput {
    private final List<String> keys;
    private final int size;
    private int position;
    @NotNull
    private final JsonObject value;

    @Override
    @NotNull
    public String elementName(@NotNull SerialDescriptor desc, int index) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        int i2 = index / 2;
        return this.keys.get(i2);
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (this.position < this.size - 1) {
            int n = this.position;
            this.position = n + 1;
            return this.position;
        }
        return -1;
    }

    @Override
    @NotNull
    protected JsonElement currentElement(@NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        return this.position % 2 == 0 ? (JsonElement)new JsonLiteral(tag) : (JsonElement)MapsKt.getValue((Map)this.getValue(), (Object)tag);
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
    }

    @Override
    @NotNull
    public JsonObject getValue() {
        return this.value;
    }

    public JsonTreeMapInput(@NotNull Json json, @NotNull JsonObject value) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        super(json, value);
        this.value = value;
        this.keys = CollectionsKt.toList((Iterable)this.getValue().keySet());
        this.size = this.keys.size() * 2;
        this.position = -1;
    }
}

