/*
 * Decompiled with CFR 0.152.
 */
package red.jad.sandbag.client.entity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import red.jad.sandbag.client.entity.model.SandbagEntityModel;
import red.jad.sandbag.client.entity.render.RenderDamageplateEvent;
import red.jad.sandbag.entity.SandbagEntity;

public class SandbagEntityRender
extends MobRenderer<SandbagEntity, SandbagEntityModel> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("sandbag", "textures/sandbag.png");

    public SandbagEntityRender(EntityRendererManager renderManager) {
        super(renderManager, (EntityModel)new SandbagEntityModel(), 0.5f);
    }

    public ResourceLocation getEntityTexture(SandbagEntity entity) {
        return TEXTURE;
    }

    public void render(SandbagEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        String damage = new DecimalFormat("0.00").format(entityIn.getLastDamage());
        RenderDamageplateEvent renderDamageplateEvent = new RenderDamageplateEvent((Entity)entityIn, damage, (EntityRenderer<?>)this, matrixStackIn, bufferIn, packedLightIn);
        MinecraftForge.EVENT_BUS.post((Event)renderDamageplateEvent);
        if (renderDamageplateEvent.getResult() != Event.Result.DENY) {
            this.renderDamage(entityIn, renderDamageplateEvent.getContent(), matrixStackIn, bufferIn, packedLightIn);
        }
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void renderDamage(SandbagEntity entityIn, String displayNameIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        double d0 = this.field_76990_c.func_229099_b_((Entity)entityIn);
        if (!(d0 > 4096.0)) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, (double)(entityIn.func_213302_cg() + 0.5f), 0.0);
            matrixStackIn.func_227863_a_(this.field_76990_c.func_229098_b_());
            matrixStackIn.func_227862_a_(-0.035f, -0.035f, 0.035f);
            Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
            FontRenderer fontrenderer = this.func_76983_a();
            float f2 = -fontrenderer.func_78256_a(displayNameIn) / 2;
            fontrenderer.func_228079_a_(displayNameIn, f2, 0.0f, 0, false, matrix4f, bufferIn, false, -1, packedLightIn);
            fontrenderer.func_228079_a_(displayNameIn, f2, 0.0f, 0, false, matrix4f, bufferIn, false, 0, packedLightIn);
            matrixStackIn.func_227865_b_();
        }
    }

    protected void renderName(SandbagEntity entityIn, String displayNameIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        double d0 = this.field_76990_c.func_229099_b_((Entity)entityIn);
        if (!(d0 > 4096.0)) {
            boolean flag = !entityIn.func_226273_bm_();
            float f = entityIn.func_213302_cg() + 0.8f;
            int i = "deadmau5".equals(displayNameIn) ? -10 : 0;
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, (double)f, 0.0);
            matrixStackIn.func_227863_a_(this.field_76990_c.func_229098_b_());
            matrixStackIn.func_227862_a_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
            Minecraft mc = Minecraft.func_71410_x();
            float f1 = mc.field_71474_y.func_216840_a(0.25f);
            int j = (int)(f1 * 255.0f) << 24;
            FontRenderer fontrenderer = this.func_76983_a();
            float f2 = -fontrenderer.func_78256_a(displayNameIn) / 2;
            fontrenderer.func_228079_a_(displayNameIn, f2, (float)i, 0x20FFFFFF, false, matrix4f, bufferIn, flag, j, packedLightIn);
            if (flag) {
                fontrenderer.func_228079_a_(displayNameIn, f2, (float)i, -1, false, matrix4f, bufferIn, false, 0, packedLightIn);
            }
            matrixStackIn.func_227865_b_();
        }
    }
}

