/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.selectable_painting.elements.items.selectable_painting;

import de.geheimagentnr1.selectable_painting.elements.items.selectable_painting.SelectablePaintingItemStackHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;

class PaintingSelectionHelper {
    private static long painting_count = 0L;
    private static String[] painting_sizes;
    private static ArrayList<ArrayList<String>> painting_names;
    private static ArrayList<ArrayList<PaintingType>> painting_types;

    PaintingSelectionHelper() {
    }

    static void init() {
        if (painting_count != Registry.field_212620_i.func_201756_e().count()) {
            painting_count = Registry.field_212620_i.func_201756_e().count();
            Iterator iterator = Registry.field_212620_i.iterator();
            TreeSet<String> sizes = new TreeSet<String>();
            TreeMap paintingNames = new TreeMap();
            TreeMap<String, TreeSet<PaintingType>> paintingTypes = new TreeMap<String, TreeSet<PaintingType>>();
            while (iterator.hasNext()) {
                PaintingType paintingType = (PaintingType)iterator.next();
                int widthSize = paintingType.func_200834_b() / 16;
                int heightSize = paintingType.func_200832_c() / 16;
                String paintingSize = widthSize + "x" + heightSize;
                if (sizes.add(paintingSize)) {
                    paintingNames.put(paintingSize, new TreeSet());
                    paintingTypes.put(paintingSize, new TreeSet<PaintingType>(Comparator.comparing(paintingType2 -> Objects.requireNonNull(paintingType2.getRegistryName()).func_110623_a())));
                }
                ((TreeSet)paintingNames.get(paintingSize)).add(Objects.requireNonNull(paintingType.getRegistryName()).func_110623_a());
                ((TreeSet)paintingTypes.get(paintingSize)).add(paintingType);
            }
            painting_sizes = sizes.toArray(new String[0]);
            painting_names = new ArrayList();
            for (TreeSet names : paintingNames.values()) {
                painting_names.add(new ArrayList<String>(Arrays.asList(names.toArray(new String[0]))));
            }
            painting_types = new ArrayList();
            for (TreeSet types : paintingTypes.values()) {
                painting_types.add(new ArrayList<PaintingType>(Arrays.asList(types.toArray(new PaintingType[0]))));
            }
        }
    }

    static String nextSize(ItemStack stack) {
        PaintingSelectionHelper.init();
        int size_index = SelectablePaintingItemStackHelper.getSizeIndex(stack) + 1;
        size_index = size_index >= painting_sizes.length ? 0 : size_index;
        SelectablePaintingItemStackHelper.setSizeIndex(stack, size_index);
        SelectablePaintingItemStackHelper.setPaintingIndex(stack, 0);
        return painting_sizes[size_index];
    }

    static TranslationTextComponent nextPainting(ItemStack stack) {
        PaintingSelectionHelper.init();
        int size_index = SelectablePaintingItemStackHelper.getSizeIndex(stack);
        int painting_index = SelectablePaintingItemStackHelper.getPaintingIndex(stack) + 1;
        painting_index = painting_index >= painting_names.get(size_index).size() ? 0 : painting_index;
        SelectablePaintingItemStackHelper.setPaintingIndex(stack, painting_index);
        return PaintingSelectionHelper.getPaintingName(size_index, painting_index);
    }

    static String getSizeName(ItemStack stack) {
        return painting_sizes[SelectablePaintingItemStackHelper.getSizeIndex(stack)];
    }

    static TranslationTextComponent getPaintingName(ItemStack stack) {
        return PaintingSelectionHelper.getPaintingName(SelectablePaintingItemStackHelper.getSizeIndex(stack), SelectablePaintingItemStackHelper.getPaintingIndex(stack));
    }

    private static TranslationTextComponent getPaintingName(int size_index, int painting_index) {
        return new TranslationTextComponent(Util.func_200697_a((String)"painting", (ResourceLocation)painting_types.get(size_index).get(painting_index).getRegistryName()), new Object[0]);
    }

    static PaintingType getPaintingType(ItemStack stack) {
        int size_index = SelectablePaintingItemStackHelper.getSizeIndex(stack);
        int painting_index = SelectablePaintingItemStackHelper.getPaintingIndex(stack);
        return painting_types.get(size_index).get(painting_index);
    }
}

