/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.selectable_painting.elements.items.selectable_painting;

import de.geheimagentnr1.selectable_painting.elements.items.selectable_painting.SelectablePaintingEntity;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class SSpawnSelectablePaintingPacket {
    private final int entityID;
    private final UUID uniqueId;
    private final BlockPos position;
    private final Direction facing;
    private final int title;
    private final int size_index;
    private final int painting_index;

    public SSpawnSelectablePaintingPacket(PacketBuffer buffer) {
        this.entityID = buffer.func_150792_a();
        this.uniqueId = buffer.func_179253_g();
        this.title = buffer.func_150792_a();
        this.position = buffer.func_179259_c();
        this.facing = Direction.func_176731_b((int)buffer.readUnsignedByte());
        this.size_index = buffer.func_150792_a();
        this.painting_index = buffer.func_150792_a();
    }

    SSpawnSelectablePaintingPacket(SelectablePaintingEntity selectablePaintingEntity) {
        this.entityID = selectablePaintingEntity.func_145782_y();
        this.uniqueId = selectablePaintingEntity.func_110124_au();
        this.position = selectablePaintingEntity.func_174857_n();
        this.facing = selectablePaintingEntity.func_174811_aO();
        this.title = Registry.field_212620_i.func_148757_b((Object)selectablePaintingEntity.art);
        this.size_index = selectablePaintingEntity.size_index;
        this.painting_index = selectablePaintingEntity.painting_index;
    }

    private PaintingType getPaintingType() {
        return (PaintingType)Registry.field_212620_i.func_148745_a(this.title);
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.entityID);
        buffer.func_179252_a(this.uniqueId);
        buffer.func_150787_b(this.title);
        buffer.func_179255_a(this.position);
        buffer.writeByte(this.facing.func_176736_b());
        buffer.func_150787_b(this.size_index);
        buffer.func_150787_b(this.painting_index);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(context.get().getDirection().getReceptionSide());
        if (!world.isPresent() || !(world.get() instanceof ClientWorld)) {
            return;
        }
        SelectablePaintingEntity selectablePaintingEntity = new SelectablePaintingEntity((World)world.get(), this.position, this.facing, this.getPaintingType(), this.size_index, this.painting_index);
        selectablePaintingEntity.func_145769_d(this.entityID);
        selectablePaintingEntity.func_184221_a(this.uniqueId);
        Minecraft.func_71410_x().field_71441_e.func_217411_a(this.entityID, (Entity)selectablePaintingEntity);
    }
}

