/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.selectable_painting.elements.items.selectable_painting;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import de.geheimagentnr1.selectable_painting.elements.items.selectable_painting.SelectablePaintingEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.PaintingSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class SelectablePaintingRenderer
extends EntityRenderer<SelectablePaintingEntity> {
    public SelectablePaintingRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void doRender(@Nonnull SelectablePaintingEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.rotatef((float)(180.0f - entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.enableRescaleNormal();
        this.func_180548_c((Entity)entity);
        PaintingType paintingtype = entity.art;
        GlStateManager.scalef((float)0.0625f, (float)0.0625f, (float)0.0625f);
        if (this.field_188301_f) {
            GlStateManager.enableColorMaterial();
            GlStateManager.setupSolidRenderingTextureCombine((int)this.func_188298_c((Entity)entity));
        }
        PaintingSpriteUploader paintingspriteuploader = Minecraft.func_71410_x().func_213263_ao();
        this.renderPainting(entity, paintingtype.func_200834_b(), paintingtype.func_200832_c(), paintingspriteuploader.func_215285_a(paintingtype), paintingspriteuploader.func_215286_b());
        if (this.field_188301_f) {
            GlStateManager.tearDownSolidRenderingTextureCombine();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(@Nonnull SelectablePaintingEntity entity) {
        return AtlasTexture.field_215263_h;
    }

    private void renderPainting(SelectablePaintingEntity entity, int width, int height, TextureAtlasSprite paintingSprite, TextureAtlasSprite backSprite) {
        float width_start = (float)(-width) / 2.0f;
        float height_start = (float)(-height) / 2.0f;
        float minU = backSprite.func_94209_e();
        float maxU = backSprite.func_94212_f();
        float minV = backSprite.func_94206_g();
        float maxV = backSprite.func_94210_h();
        float minU1 = backSprite.func_94209_e();
        float maxU1 = backSprite.func_94212_f();
        float minV1 = backSprite.func_94206_g();
        float interpolatedV = backSprite.func_94207_b(1.0);
        float minU2 = backSprite.func_94209_e();
        float interpolatedU = backSprite.func_94214_a(1.0);
        float minV2 = backSprite.func_94206_g();
        float maxV1 = backSprite.func_94210_h();
        int block_width = width / 16;
        int block_height = height / 16;
        double width_double = 16.0 / (double)block_width;
        double height_double = 16.0 / (double)block_height;
        for (int i = 0; i < block_width; ++i) {
            for (int j = 0; j < block_height; ++j) {
                float width_from = width_start + (float)(i + 1 << 4);
                float width_to = width_start + (float)(i << 4);
                float height_from = height_start + (float)(j + 1 << 4);
                float height_to = height_start + (float)(j << 4);
                this.setLightmap(entity, (width_from + width_to) / 2.0f, (height_from + height_to) / 2.0f);
                float interpolatedU1 = paintingSprite.func_94214_a(width_double * (double)(block_width - i));
                float interpolatedU2 = paintingSprite.func_94214_a(width_double * (double)(block_width - (i + 1)));
                float interpolatedV1 = paintingSprite.func_94207_b(height_double * (double)(block_height - j));
                float interpolatedV2 = paintingSprite.func_94207_b(height_double * (double)(block_height - (j + 1)));
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                bufferbuilder.func_181662_b((double)width_from, (double)height_to, -0.5).func_187315_a((double)interpolatedU2, (double)interpolatedV1).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_to, (double)height_to, -0.5).func_187315_a((double)interpolatedU1, (double)interpolatedV1).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_to, (double)height_from, -0.5).func_187315_a((double)interpolatedU1, (double)interpolatedV2).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_from, (double)height_from, -0.5).func_187315_a((double)interpolatedU2, (double)interpolatedV2).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_from, (double)height_from, 0.5).func_187315_a((double)minU, (double)minV).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_to, (double)height_from, 0.5).func_187315_a((double)maxU, (double)minV).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_to, (double)height_to, 0.5).func_187315_a((double)maxU, (double)maxV).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_from, (double)height_to, 0.5).func_187315_a((double)minU, (double)maxV).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_from, (double)height_from, -0.5).func_187315_a((double)minU1, (double)minV1).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_to, (double)height_from, -0.5).func_187315_a((double)maxU1, (double)minV1).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_to, (double)height_from, 0.5).func_187315_a((double)maxU1, (double)interpolatedV).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_from, (double)height_from, 0.5).func_187315_a((double)minU1, (double)interpolatedV).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_from, (double)height_to, 0.5).func_187315_a((double)minU1, (double)minV1).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_to, (double)height_to, 0.5).func_187315_a((double)maxU1, (double)minV1).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_to, (double)height_to, -0.5).func_187315_a((double)maxU1, (double)interpolatedV).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_from, (double)height_to, -0.5).func_187315_a((double)minU1, (double)interpolatedV).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_from, (double)height_from, 0.5).func_187315_a((double)interpolatedU, (double)minV2).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_from, (double)height_to, 0.5).func_187315_a((double)interpolatedU, (double)maxV1).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_from, (double)height_to, -0.5).func_187315_a((double)minU2, (double)maxV1).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_from, (double)height_from, -0.5).func_187315_a((double)minU2, (double)minV2).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_to, (double)height_from, -0.5).func_187315_a((double)interpolatedU, (double)minV2).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_to, (double)height_to, -0.5).func_187315_a((double)interpolatedU, (double)maxV1).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_to, (double)height_to, 0.5).func_187315_a((double)minU2, (double)maxV1).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)width_to, (double)height_from, 0.5).func_187315_a((double)minU2, (double)minV2).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
            }
        }
    }

    private void setLightmap(SelectablePaintingEntity painting, float width, float height) {
        int x = MathHelper.func_76128_c((double)painting.field_70165_t);
        int y = MathHelper.func_76128_c((double)(painting.field_70163_u + (double)(height / 16.0f)));
        int z = MathHelper.func_76128_c((double)painting.field_70161_v);
        Direction direction = painting.func_174811_aO();
        if (direction == Direction.NORTH) {
            x = MathHelper.func_76128_c((double)(painting.field_70165_t + (double)(width / 16.0f)));
        }
        if (direction == Direction.WEST) {
            z = MathHelper.func_76128_c((double)(painting.field_70161_v - (double)(width / 16.0f)));
        }
        if (direction == Direction.SOUTH) {
            x = MathHelper.func_76128_c((double)(painting.field_70165_t - (double)(width / 16.0f)));
        }
        if (direction == Direction.EAST) {
            z = MathHelper.func_76128_c((double)(painting.field_70161_v + (double)(width / 16.0f)));
        }
        int light_level = this.field_76990_c.field_78722_g.func_217338_b(new BlockPos(x, y, z), 0);
        int level_rest = light_level % 65536;
        int level = light_level / 65536;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)level_rest, (float)level);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }
}

