/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.shatter.common;

import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import us.ichun.mods.ichunutil.common.core.config.ConfigBase;
import us.ichun.mods.ichunutil.common.core.config.ConfigHandler;
import us.ichun.mods.ichunutil.common.core.updateChecker.ModVersionChecker;
import us.ichun.mods.ichunutil.common.core.updateChecker.ModVersionInfo;
import us.ichun.mods.shatter.client.core.TickHandlerClient;
import us.ichun.mods.shatter.client.entity.EntityShattered;
import us.ichun.mods.shatter.client.model.ModelShattered;
import us.ichun.mods.shatter.client.render.RenderShattered;
import us.ichun.mods.shatter.common.core.Config;

@Mod(modid="Shatter", name="Shatter", version="5.0.0", dependencies="required-after:iChunUtil@[5.0.0,)", clientSideOnly=true)
public class Shatter {
    public static final String version = "5.0.0";
    private static final Logger logger = LogManager.getLogger((String)"Shatter");
    @Mod.Instance(value="Shatter")
    public static Shatter instance;
    public static Config config;
    public static TickHandlerClient tickHandlerClient;

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            Shatter.console("You're loading Shatter on a server! This is a client-only mod!", true);
            return;
        }
        config = (Config)ConfigHandler.registerConfig((ConfigBase)new Config(event.getSuggestedConfigurationFile(), new String[0]));
        ModVersionChecker.register_iChunMod((ModVersionInfo)new ModVersionInfo("Shatter", "1.8.0", version, false));
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        tickHandlerClient = new TickHandlerClient();
        FMLCommonHandler.instance().bus().register((Object)tickHandlerClient);
        MinecraftForge.EVENT_BUS.register((Object)instance);
        RenderingRegistry.registerEntityRenderingHandler(EntityShattered.class, (Render)new RenderShattered(new ModelShattered(), 0.0f));
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (Shatter.config.enableBossShatter == 0 && event.entityLiving instanceof IBossDisplayData || Shatter.config.enableChildShatter == 0 && event.entityLiving.func_70631_g_()) {
                return;
            }
            Shatter.tickHandlerClient.shatterTimeout.put(event.entityLiving, 2);
        }
    }

    public static void console(String s, boolean warning) {
        StringBuilder sb = new StringBuilder();
        logger.log(warning ? Level.WARN : Level.INFO, sb.append("[").append(version).append("] ").append(s).toString());
    }
}

