/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.signbutton.button;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gigaherz.signbutton.ModSignButton;
import gigaherz.signbutton.button.TileSignButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSign;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public class BlockSignButton
extends BlockSign {
    private final Map<IBlockState, VoxelShape> cache = Maps.newConcurrentMap();

    public BlockSignButton(Block.Properties properties) {
        super(properties);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208158_K, (Comparable)AttachFace.FLOOR)).func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)EnumFacing.NORTH)).func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)field_204613_a, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208158_K, BlockStateProperties.field_208157_J, BlockStateProperties.field_208194_u, field_204613_a});
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileSignButton();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((IItemProvider)ModSignButton.itemSignButton);
    }

    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return ModSignButton.itemSignButton;
    }

    public int func_149738_a(IWorldReaderBase worldIn) {
        return 30;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader world, BlockPos pos) {
        VoxelShape cached = this.cache.get(state);
        if (cached == null) {
            cached = VoxelShapes.func_197880_a();
            AttachFace face = (AttachFace)state.func_177229_b((IProperty)BlockStateProperties.field_208158_K);
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
            boolean powered = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u);
            float u0 = 0.0f;
            float u1 = 1.0f;
            float offset = 0.02f;
            float v0 = 0.25f;
            float v1 = 0.75f;
            float thick = 0.085f;
            float w0 = (powered ? -0.23f : 0.32f) / 16.0f;
            float w1 = w0 + thick;
            float t1 = 1.0f - w0;
            float t0 = 1.0f - w1;
            if (face == AttachFace.FLOOR) {
                switch (enumfacing) {
                    case NORTH: {
                        cached = VoxelShapes.func_197873_a((double)u0, (double)w0, (double)(v0 + offset), (double)u1, (double)w1, (double)(v1 + offset));
                        break;
                    }
                    case SOUTH: {
                        cached = VoxelShapes.func_197873_a((double)u0, (double)w0, (double)(v0 - offset), (double)u1, (double)w1, (double)(v1 - offset));
                        break;
                    }
                    case EAST: {
                        cached = VoxelShapes.func_197873_a((double)(v0 - offset), (double)w0, (double)u0, (double)(v1 - offset), (double)w1, (double)u1);
                        break;
                    }
                    case WEST: {
                        cached = VoxelShapes.func_197873_a((double)(v0 + offset), (double)w0, (double)u0, (double)(v1 + offset), (double)w1, (double)u1);
                    }
                }
            } else if (face == AttachFace.CEILING) {
                switch (enumfacing) {
                    case NORTH: {
                        cached = VoxelShapes.func_197873_a((double)u0, (double)t0, (double)(v0 - offset), (double)u1, (double)t1, (double)(v1 - offset));
                        break;
                    }
                    case SOUTH: {
                        cached = VoxelShapes.func_197873_a((double)u0, (double)t0, (double)(v0 + offset), (double)u1, (double)t1, (double)(v1 + offset));
                        break;
                    }
                    case EAST: {
                        cached = VoxelShapes.func_197873_a((double)(v0 + offset), (double)t0, (double)u0, (double)(v1 + offset), (double)t1, (double)u1);
                        break;
                    }
                    case WEST: {
                        cached = VoxelShapes.func_197873_a((double)(v0 - offset), (double)t0, (double)u0, (double)(v1 - offset), (double)t1, (double)u1);
                    }
                }
            } else {
                switch (enumfacing) {
                    case EAST: {
                        cached = VoxelShapes.func_197873_a((double)w0, (double)(v0 + offset), (double)u0, (double)w1, (double)(v1 + offset), (double)u1);
                        break;
                    }
                    case WEST: {
                        cached = VoxelShapes.func_197873_a((double)t0, (double)(v0 + offset), (double)u0, (double)t1, (double)(v1 + offset), (double)u1);
                        break;
                    }
                    case SOUTH: {
                        cached = VoxelShapes.func_197873_a((double)u0, (double)(v0 + offset), (double)w0, (double)u1, (double)(v1 + offset), (double)w1);
                        break;
                    }
                    case NORTH: {
                        cached = VoxelShapes.func_197873_a((double)u0, (double)(v0 + offset), (double)t0, (double)u1, (double)(v1 + offset), (double)t1);
                    }
                }
            }
            this.cache.put(state, cached);
        }
        return cached;
    }

    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext context) {
        IBlockState state = this.func_176223_P();
        IFluidState fluid = context.func_195991_k().func_204610_c(context.func_195995_a());
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        EnumFacing clickedFace = context.func_196000_l().func_176734_d();
        ArrayList directions = Lists.newArrayList((Object[])new EnumFacing[]{clickedFace});
        Arrays.stream(context.func_196009_e()).filter(f -> f != clickedFace).forEach(directions::add);
        ModSignButton.logger.warn(directions.stream().map(EnumFacing::toString).collect(Collectors.joining(",")));
        for (int i = 0; i < directions.size(); ++i) {
            EnumFacing facing;
            AttachFace face;
            EnumFacing lookDirection2;
            EnumFacing lookDirection = (EnumFacing)directions.get(i);
            EnumFacing enumFacing = lookDirection2 = i + 1 >= directions.size() ? EnumFacing.NORTH : (EnumFacing)directions.get(i + 1);
            if (lookDirection == EnumFacing.DOWN) {
                face = AttachFace.FLOOR;
                facing = (lookDirection2.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : lookDirection2).func_176734_d();
            } else if (lookDirection == EnumFacing.UP) {
                face = AttachFace.CEILING;
                facing = (lookDirection2.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : lookDirection2).func_176734_d();
            } else {
                face = AttachFace.WALL;
                facing = lookDirection.func_176734_d();
            }
            state = (IBlockState)((IBlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208158_K, (Comparable)face)).func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)facing);
            if (!state.func_196955_c((IWorldReaderBase)world, pos)) continue;
            return (IBlockState)state.func_206870_a((IProperty)field_204613_a, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a));
        }
        return null;
    }

    @Deprecated
    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        EnumFacing enumfacing = this.getEffectiveFacing(state);
        BlockPos otherPos = pos.func_177972_a(enumfacing.func_176734_d());
        IBlockState otherState = worldIn.func_180495_p(otherPos);
        return otherState.func_193401_d((IBlockReader)worldIn, otherPos, enumfacing) == BlockFaceShape.SOLID && !BlockSignButton.func_193382_c((Block)otherState.func_177230_c());
    }

    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u)).booleanValue()) {
            worldIn.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)));
            worldIn.func_175704_b(pos, pos);
            worldIn.func_184133_a(player, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
            this.notifyFacing(state, worldIn, pos);
            worldIn.func_205220_G_().func_205360_a(new BlockPos((Vec3i)pos), (Object)this, this.func_149738_a((IWorldReaderBase)worldIn));
        }
        return true;
    }

    private void notifyFacing(IBlockState state, World worldIn, BlockPos pos) {
        this.notifyNeighbors(worldIn, pos, this.getEffectiveFacing(state).func_176734_d());
    }

    private void notifyNeighbors(World worldIn, BlockPos pos, EnumFacing facing) {
        worldIn.func_195593_d(pos, (Block)this);
        worldIn.func_195593_d(pos.func_177972_a(facing), (Block)this);
    }

    private EnumFacing getEffectiveFacing(IBlockState state) {
        switch ((AttachFace)state.func_177229_b((IProperty)BlockStateProperties.field_208158_K)) {
            case FLOOR: {
                return EnumFacing.UP;
            }
            case CEILING: {
                return EnumFacing.DOWN;
            }
        }
        return (EnumFacing)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
    }

    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.func_176734_d() == this.getEffectiveFacing(stateIn) && !stateIn.func_196955_c((IWorldReaderBase)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            if (((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u)).booleanValue()) {
                this.notifyFacing(state, worldIn, pos);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @Deprecated
    public int func_180656_a(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)BlockStateProperties.field_208194_u) != false ? 15 : 0;
    }

    @Deprecated
    public int func_176211_b(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)BlockStateProperties.field_208194_u) != false && this.getEffectiveFacing(blockState) == side ? 15 : 0;
    }

    @Deprecated
    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @Deprecated
    public void func_196265_a(IBlockState state, World worldIn, BlockPos pos, Random random) {
    }

    @Deprecated
    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u)).booleanValue()) {
            worldIn.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
            this.notifyFacing(state, worldIn, pos);
            worldIn.func_175704_b(pos, pos);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187883_gR, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
    }

    @Deprecated
    public void func_196262_a(IBlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.field_72995_K && !((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u)).booleanValue()) {
            this.checkArrows(state, worldIn, pos);
        }
    }

    private void checkArrows(IBlockState state, World worldIn, BlockPos pos) {
        boolean currentlyPowered;
        List list = worldIn.func_72872_a(EntityArrow.class, state.func_196954_c((IBlockReader)worldIn, pos).func_197752_a().func_186670_a(pos));
        boolean arrowsPresent = !list.isEmpty();
        if (arrowsPresent != (currentlyPowered = ((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u)).booleanValue())) {
            worldIn.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)));
            worldIn.func_175704_b(pos, pos);
            this.notifyFacing(state, worldIn, pos);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
        if (arrowsPresent) {
            worldIn.func_205220_G_().func_205360_a(new BlockPos((Vec3i)pos), (Object)this, this.func_149738_a((IWorldReaderBase)worldIn));
        }
    }
}

