/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.signbutton.button;

import com.mojang.blaze3d.platform.GlStateManager;
import gigaherz.signbutton.ModSignButton;
import gigaherz.signbutton.button.SignButtonTileEntity;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.RenderComponentsUtil;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.model.SignModel;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class SignButtonTileEntityRenderer
extends TileEntityRenderer<SignButtonTileEntity> {
    private static final ResourceLocation acaciaSignTexture = new ResourceLocation("textures/entity/signs/acacia.png");
    private static final ResourceLocation birchSignTexture = new ResourceLocation("textures/entity/signs/birch.png");
    private static final ResourceLocation dark_oakSignTexture = new ResourceLocation("textures/entity/signs/dark_oak.png");
    private static final ResourceLocation jungleSignTexture = new ResourceLocation("textures/entity/signs/jungle.png");
    private static final ResourceLocation oakSignTexture = new ResourceLocation("textures/entity/signs/oak.png");
    private static final ResourceLocation spruceSignTexture = new ResourceLocation("textures/entity/signs/spruce.png");
    private static final ResourceLocation signTexture = ModSignButton.location("textures/entity/sign_button.png");
    private final SignModel model = new SignModel();

    public SignButtonTileEntityRenderer() {
        this.model.func_205064_b().field_78807_k = true;
    }

    public ResourceLocation getSignTexture(Block block) {
        if (block == ModSignButton.Blocks.ACACIA_SIGN_BUTTON) {
            return acaciaSignTexture;
        }
        if (block == ModSignButton.Blocks.BIRCH_SIGN_BUTTON) {
            return birchSignTexture;
        }
        if (block == ModSignButton.Blocks.DARK_OAK_SIGN_BUTTON) {
            return dark_oakSignTexture;
        }
        if (block == ModSignButton.Blocks.JUNGLE_SIGN_BUTTON) {
            return jungleSignTexture;
        }
        if (block == ModSignButton.Blocks.SPRUCE_SIGN_BUTTON) {
            return spruceSignTexture;
        }
        return oakSignTexture;
    }

    public void render(SignButtonTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        GlStateManager.pushMatrix();
        BlockState state = te.func_195044_w();
        boolean powered = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u);
        Direction facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
        AttachFace face = (AttachFace)state.func_177229_b((IProperty)BlockStateProperties.field_208158_K);
        int rotAroundY = 0;
        int rotAroundX = 0;
        switch (face) {
            case CEILING: {
                rotAroundX = 90;
                break;
            }
            case FLOOR: {
                rotAroundX = -90;
            }
        }
        switch (facing) {
            case SOUTH: {
                break;
            }
            case NORTH: {
                rotAroundY = 180;
                break;
            }
            case EAST: {
                rotAroundY = 90;
                break;
            }
            case WEST: {
                rotAroundY = -90;
            }
        }
        GlStateManager.translatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        GlStateManager.rotatef((float)rotAroundY, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)rotAroundX, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translatef((float)0.0f, (float)-0.3125f, (float)(-0.4375f - (powered ? 0.035f : 0.0f)));
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)4.0f, (float)2.0f, (float)1.0f);
            GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.matrixMode((int)5888);
        } else {
            this.func_147499_a(this.getSignTexture(te.func_195044_w().func_177230_c()));
        }
        GlStateManager.enableRescaleNormal();
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)0.6666667f, (float)-0.6666667f, (float)-0.6666667f);
        this.model.func_78164_a();
        if (destroyStage < 0) {
            GlStateManager.enableBlend();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_147499_a(signTexture);
            this.model.func_78164_a();
            GlStateManager.disableBlend();
        }
        GlStateManager.popMatrix();
        FontRenderer fontrenderer = this.func_147498_b();
        float rot = 0.010416667f;
        GlStateManager.translatef((float)0.0f, (float)0.33333334f, (float)0.046666667f);
        GlStateManager.scalef((float)rot, (float)(-rot), (float)rot);
        GlStateManager.normal3f((float)0.0f, (float)0.0f, (float)(-1.0f * rot));
        GlStateManager.depthMask((boolean)false);
        int b0 = 0;
        if (destroyStage < 0) {
            for (int j = 0; j < te.field_145915_a.length; ++j) {
                String s;
                if (te.field_145915_a[j] == null) continue;
                ITextComponent ichatcomponent = te.field_145915_a[j];
                List list = RenderComponentsUtil.func_178908_a((ITextComponent)ichatcomponent, (int)90, (FontRenderer)fontrenderer, (boolean)false, (boolean)true);
                String string = s = list != null && list.size() > 0 ? ((ITextComponent)list.get(0)).func_150254_d() : "";
                if (j == te.field_145918_i) {
                    s = "> " + s + " <";
                }
                fontrenderer.func_211126_b(s, (float)(-fontrenderer.func_78256_a(s) / 2), (float)(j * 10 - te.field_145915_a.length * 5), b0);
            }
        }
        GlStateManager.depthMask((boolean)true);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
        if (destroyStage >= 0) {
            GlStateManager.matrixMode((int)5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
        }
    }
}

