/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.signbutton.button;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import gigaherz.signbutton.button.SignButtonBlock;
import gigaherz.signbutton.button.SignButtonTileEntity;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.RenderComponentsUtil;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.tileentity.SignTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class SignButtonTileEntityRenderer
extends TileEntityRenderer<SignButtonTileEntity> {
    public static final Material SIGN_BUTTON_OVERLAY_MATERIAL = new Material(Atlases.field_228746_e_, new ResourceLocation("signbutton", "entity/sign_button"));
    private final SignTileEntityRenderer.SignModel model = new SignTileEntityRenderer.SignModel();

    public SignButtonTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(SignButtonTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float scale = 0.6666667f;
        matrixStackIn.func_227860_a_();
        BlockState blockstate = tileEntityIn.func_195044_w();
        boolean powered = (Boolean)blockstate.func_177229_b((IProperty)SignButtonBlock.POWERED);
        Direction facing = (Direction)blockstate.func_177229_b(SignButtonBlock.FACING);
        AttachFace face = (AttachFace)blockstate.func_177229_b(SignButtonBlock.FACE);
        int rotAroundX = 0;
        switch (face) {
            case CEILING: {
                rotAroundX = 90;
                break;
            }
            case FLOOR: {
                rotAroundX = -90;
            }
        }
        int rotAroundY = 0;
        switch (facing) {
            case SOUTH: {
                break;
            }
            case NORTH: {
                rotAroundY = 180;
                break;
            }
            case EAST: {
                rotAroundY = 90;
                break;
            }
            case WEST: {
                rotAroundY = -90;
            }
        }
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)rotAroundY));
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)rotAroundX));
        matrixStackIn.func_227861_a_(0.0, -0.3125, -0.4375 - (powered ? 0.035 : 0.0));
        this.model.field_78165_b.field_78806_j = false;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(0.6666667f, -0.6666667f, -0.6666667f);
        Material material = SignTileEntityRenderer.func_228877_a_((Block)blockstate.func_177230_c());
        IVertexBuilder ivertexbuilder = material.func_229311_a_(bufferIn, ButtonRenderTypes::entityTranslucentUnsorted);
        this.model.field_78166_a.func_228308_a_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        this.model.field_78165_b.func_228308_a_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        IVertexBuilder ivertexbuilder2 = SIGN_BUTTON_OVERLAY_MATERIAL.func_229311_a_(bufferIn, ButtonRenderTypes::entityTranslucentUnsorted);
        this.model.field_78166_a.func_228308_a_(matrixStackIn, ivertexbuilder2, combinedLightIn, combinedOverlayIn);
        this.model.field_78165_b.func_228308_a_(matrixStackIn, ivertexbuilder2, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227865_b_();
        FontRenderer fontrenderer = this.field_228858_b_.func_147548_a();
        matrixStackIn.func_227861_a_(0.0, 0.3333333432674408, 0.046666666865348816);
        matrixStackIn.func_227862_a_(0.010416667f, -0.010416667f, 0.010416667f);
        int color = tileEntityIn.func_214066_f().func_218388_g();
        int red = (int)((double)NativeImage.func_227791_b_((int)color) * 0.4);
        int green = (int)((double)NativeImage.func_227793_c_((int)color) * 0.4);
        int blue = (int)((double)NativeImage.func_227795_d_((int)color) * 0.4);
        int adjustedColor = NativeImage.func_227787_a_((int)0, (int)blue, (int)green, (int)red);
        for (int j1 = 0; j1 < 4; ++j1) {
            String s = tileEntityIn.func_212364_a(j1, p_212491_1_ -> {
                List list = RenderComponentsUtil.func_178908_a((ITextComponent)p_212491_1_, (int)90, (FontRenderer)fontrenderer, (boolean)false, (boolean)true);
                return list.isEmpty() ? "" : ((ITextComponent)list.get(0)).func_150254_d();
            });
            if (s == null) continue;
            float f3 = -fontrenderer.func_78256_a(s) / 2;
            fontrenderer.func_228079_a_(s, f3, (float)(j1 * 10 - tileEntityIn.field_145915_a.length * 5), adjustedColor, false, matrixStackIn.func_227866_c_().func_227870_a_(), bufferIn, false, 0, combinedLightIn);
        }
        matrixStackIn.func_227865_b_();
    }

    private static class ButtonRenderTypes
    extends RenderType {
        private ButtonRenderTypes(String p_i225992_1_, VertexFormat p_i225992_2_, int p_i225992_3_, int p_i225992_4_, boolean p_i225992_5_, boolean p_i225992_6_, Runnable p_i225992_7_, Runnable p_i225992_8_) {
            super(p_i225992_1_, p_i225992_2_, p_i225992_3_, p_i225992_4_, p_i225992_5_, p_i225992_6_, p_i225992_7_, p_i225992_8_);
        }

        public static RenderType entityTranslucentUnsorted(ResourceLocation texture, boolean doOverlay) {
            RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228726_a_(field_228515_g_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(doOverlay);
            return ButtonRenderTypes.func_228633_a_((String)"entity_translucent_unsorted", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)rendertype$state);
        }

        public static RenderType entityTranslucentUnsorted(ResourceLocation texture) {
            return ButtonRenderTypes.entityTranslucentUnsorted(texture, true);
        }
    }
}

