/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.signbutton.button;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gigaherz.signbutton.ModSignButton;
import gigaherz.signbutton.button.SignButtonTileEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.WoodType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SignButtonBlock
extends AbstractSignBlock {
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.field_208158_K;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final int TICK_RATE = 30;
    private final Map<BlockState, VoxelShape> cache = Maps.newConcurrentMap();

    public SignButtonBlock(AbstractBlock.Properties properties, WoodType woodType) {
        super(properties, woodType);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(FACE, (Comparable)AttachFace.FLOOR)).func_206870_a(FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_204613_a, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACE, FACING, POWERED, field_204613_a});
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new SignButtonTileEntity();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        VoxelShape cached = this.cache.get(state);
        if (cached == null) {
            cached = VoxelShapes.func_197880_a();
            AttachFace face = (AttachFace)state.func_177229_b(FACE);
            Direction enumfacing = (Direction)state.func_177229_b(FACING);
            boolean powered = (Boolean)state.func_177229_b((Property)POWERED);
            float u0 = 0.0f;
            float u1 = 1.0f;
            float offset = 0.02f;
            float v0 = 0.25f;
            float v1 = 0.75f;
            float thick = 0.085f;
            float w0 = (powered ? -0.23f : 0.32f) / 16.0f;
            float w1 = w0 + thick;
            float t1 = 1.0f - w0;
            float t0 = 1.0f - w1;
            if (face == AttachFace.FLOOR) {
                switch (enumfacing) {
                    case NORTH: {
                        cached = VoxelShapes.func_197873_a((double)u0, (double)w0, (double)(v0 + offset), (double)u1, (double)w1, (double)(v1 + offset));
                        break;
                    }
                    case SOUTH: {
                        cached = VoxelShapes.func_197873_a((double)u0, (double)w0, (double)(v0 - offset), (double)u1, (double)w1, (double)(v1 - offset));
                        break;
                    }
                    case EAST: {
                        cached = VoxelShapes.func_197873_a((double)(v0 - offset), (double)w0, (double)u0, (double)(v1 - offset), (double)w1, (double)u1);
                        break;
                    }
                    case WEST: {
                        cached = VoxelShapes.func_197873_a((double)(v0 + offset), (double)w0, (double)u0, (double)(v1 + offset), (double)w1, (double)u1);
                    }
                }
            } else if (face == AttachFace.CEILING) {
                switch (enumfacing) {
                    case NORTH: {
                        cached = VoxelShapes.func_197873_a((double)u0, (double)t0, (double)(v0 - offset), (double)u1, (double)t1, (double)(v1 - offset));
                        break;
                    }
                    case SOUTH: {
                        cached = VoxelShapes.func_197873_a((double)u0, (double)t0, (double)(v0 + offset), (double)u1, (double)t1, (double)(v1 + offset));
                        break;
                    }
                    case EAST: {
                        cached = VoxelShapes.func_197873_a((double)(v0 + offset), (double)t0, (double)u0, (double)(v1 + offset), (double)t1, (double)u1);
                        break;
                    }
                    case WEST: {
                        cached = VoxelShapes.func_197873_a((double)(v0 - offset), (double)t0, (double)u0, (double)(v1 - offset), (double)t1, (double)u1);
                    }
                }
            } else {
                switch (enumfacing) {
                    case EAST: {
                        cached = VoxelShapes.func_197873_a((double)w0, (double)(v0 + offset), (double)u0, (double)w1, (double)(v1 + offset), (double)u1);
                        break;
                    }
                    case WEST: {
                        cached = VoxelShapes.func_197873_a((double)t0, (double)(v0 + offset), (double)u0, (double)t1, (double)(v1 + offset), (double)u1);
                        break;
                    }
                    case SOUTH: {
                        cached = VoxelShapes.func_197873_a((double)u0, (double)(v0 + offset), (double)w0, (double)u1, (double)(v1 + offset), (double)w1);
                        break;
                    }
                    case NORTH: {
                        cached = VoxelShapes.func_197873_a((double)u0, (double)(v0 + offset), (double)t0, (double)u1, (double)(v1 + offset), (double)t1);
                    }
                }
            }
            this.cache.put(state, cached);
        }
        return cached;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        FluidState fluid = context.func_195991_k().func_204610_c(context.func_195995_a());
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction clickedFace = context.func_196000_l().func_176734_d();
        ArrayList directions = Lists.newArrayList((Object[])new Direction[]{clickedFace});
        Arrays.stream(context.func_196009_e()).filter(f -> f != clickedFace).forEach(directions::add);
        ModSignButton.logger.warn(directions.stream().map(Direction::toString).collect(Collectors.joining(",")));
        for (int i = 0; i < directions.size(); ++i) {
            Direction facing;
            AttachFace face;
            Direction lookDirection2;
            Direction lookDirection = (Direction)directions.get(i);
            Direction direction = lookDirection2 = i + 1 >= directions.size() ? Direction.NORTH : (Direction)directions.get(i + 1);
            if (lookDirection == Direction.DOWN) {
                face = AttachFace.FLOOR;
                facing = (lookDirection2.func_176740_k() == Direction.Axis.Y ? Direction.NORTH : lookDirection2).func_176734_d();
            } else if (lookDirection == Direction.UP) {
                face = AttachFace.CEILING;
                facing = (lookDirection2.func_176740_k() == Direction.Axis.Y ? Direction.NORTH : lookDirection2).func_176734_d();
            } else {
                face = AttachFace.WALL;
                facing = lookDirection.func_176734_d();
            }
            state = (BlockState)((BlockState)state.func_206870_a(FACE, (Comparable)face)).func_206870_a(FACING, (Comparable)facing);
            if (!state.func_196955_c((IWorldReader)world, pos)) continue;
            return (BlockState)state.func_206870_a((Property)field_204613_a, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a));
        }
        return null;
    }

    @Deprecated
    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos.func_177972_a(this.getEffectiveFacing(state).func_176734_d())).func_185904_a().func_76220_a();
    }

    private Direction getEffectiveFacing(BlockState state) {
        switch ((AttachFace)state.func_177229_b(FACE)) {
            case FLOOR: {
                return Direction.UP;
            }
            case CEILING: {
                return Direction.DOWN;
            }
        }
        return (Direction)state.func_177229_b(FACING);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)));
            worldIn.func_184133_a(player, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
            this.notifyFacing(state, worldIn, pos);
            worldIn.func_205220_G_().func_205360_a(new BlockPos((Vector3i)pos), (Object)this, 30);
        }
        return ActionResultType.SUCCESS;
    }

    private void notifyFacing(BlockState state, World worldIn, BlockPos pos) {
        this.notifyNeighbors(worldIn, pos, this.getEffectiveFacing(state).func_176734_d());
    }

    private void notifyNeighbors(World worldIn, BlockPos pos, Direction facing) {
        worldIn.func_195593_d(pos, (Block)this);
        worldIn.func_195593_d(pos.func_177972_a(facing), (Block)this);
    }

    @Deprecated
    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((Property)POWERED) != false ? 15 : 0;
    }

    @Deprecated
    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((Property)POWERED) != false && this.getEffectiveFacing(blockState) == side ? 15 : 0;
    }

    @Deprecated
    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.func_176734_d() == this.getEffectiveFacing(stateIn) && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
                this.notifyFacing(state, worldIn, pos);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @Deprecated
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
    }

    @Deprecated
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            this.notifyFacing(state, (World)worldIn, pos);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187883_gR, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
    }

    @Deprecated
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.field_72995_K && !((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            this.checkArrows(state, worldIn, pos);
        }
    }

    private void checkArrows(BlockState state, World worldIn, BlockPos pos) {
        boolean currentlyPowered;
        List list = worldIn.func_217357_a(AbstractArrowEntity.class, state.func_196954_c((IBlockReader)worldIn, pos).func_197752_a().func_186670_a(pos));
        boolean arrowsPresent = !list.isEmpty();
        if (arrowsPresent != (currentlyPowered = ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue())) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)));
            this.notifyFacing(state, worldIn, pos);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
        if (arrowsPresent) {
            worldIn.func_205220_G_().func_205360_a(new BlockPos((Vector3i)pos), (Object)this, 30);
        }
    }
}

