/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.simpleores;

import mod.alexndr.simplecorelib.loot.ChestLootHandler;
import mod.alexndr.simpleores.config.SimpleOresConfig;
import mod.alexndr.simpleores.generation.OreGeneration;
import mod.alexndr.simpleores.init.ModItems;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="simpleores", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger((String)"simpleores Forge Event Subscriber");

    @SubscribeEvent
    public static void FillBucket(FillBucketEvent event) {
        if (event.getEmptyBucket().func_77973_b() == ModItems.copper_bucket.get() && event.getTarget().func_216346_c() == RayTraceResult.Type.BLOCK) {
            FlowingFluid fluid;
            BlockState blockstate1;
            BlockRayTraceResult rtResult = (BlockRayTraceResult)event.getTarget();
            BlockPos blockpos = rtResult.func_216350_a();
            Direction direction = rtResult.func_216354_b();
            BlockPos blockpos1 = blockpos.func_177972_a(direction);
            if (event.getWorld().func_175660_a(event.getPlayer(), blockpos) && event.getPlayer().func_175151_a(blockpos1, direction, event.getEmptyBucket()) && (blockstate1 = event.getWorld().func_180495_p(blockpos)).func_177230_c() instanceof FlowingFluidBlock && (fluid = ((FlowingFluidBlock)blockstate1.func_177230_c()).getFluid()) != Fluids.field_204541_a && fluid.func_207185_a((ITag)FluidTags.field_206960_b)) {
                Item bucketItem = event.getEmptyBucket().func_77973_b();
                event.getPlayer().func_71029_a(Stats.field_75929_E.func_199076_b((Object)bucketItem));
                SoundEvent soundevent = SoundEvents.field_187659_cY;
                event.getPlayer().func_184185_a(soundevent, 1.0f, 1.0f);
                event.setFilledBucket(ItemStack.field_190927_a);
                event.setResult(Event.Result.ALLOW);
                return;
            }
        }
        event.setResult(Event.Result.DEFAULT);
    }

    @SubscribeEvent
    public static void LootLoad(LootTableLoadEvent event) {
        if (SimpleOresConfig.addModLootToChests) {
            String prefix = "minecraft:chests/";
            String name = event.getName().toString();
            if (name.startsWith(prefix)) {
                String file = name.substring(name.indexOf(prefix) + prefix.length());
                if (file.startsWith("village/village_")) {
                    String village = "village/";
                    file = file.substring(file.indexOf(village) + village.length());
                } else if (file.startsWith("stronghold_")) {
                    file = "stronghold";
                }
                switch (file) {
                    case "simple_dungeon": 
                    case "stronghold": 
                    case "woodland_mansion": 
                    case "shipwreck_supply": 
                    case "shipwreck_map": 
                    case "shipwreck_treasure": 
                    case "buried_treasure": 
                    case "pillager_outpost": 
                    case "underwater_ruin_small": 
                    case "underwater_ruin_big": {
                        LOGGER.debug("Attempting to inject loot pool for " + file);
                        event.getTable().addPool(ChestLootHandler.getInjectPool((String)"simpleores", (String)"simple_dungeon"));
                        break;
                    }
                    case "nether_bridge": {
                        LOGGER.debug("Attempting to inject loot pool for " + file);
                        event.getTable().addPool(ChestLootHandler.getInjectPool((String)"simpleores", (String)"nether"));
                        break;
                    }
                    case "village_weaponsmith": 
                    case "village_toolsmith": 
                    case "village_armorer": 
                    case "village_shepherd": 
                    case "village_mason": 
                    case "village_fletcher": 
                    case "desert_pyramid": 
                    case "abandoned_mineshaft": 
                    case "jungle_temple": 
                    case "spawn_bonus_chest": 
                    case "igloo_chest": {
                        LOGGER.debug("Attempting to inject loot pool for " + file);
                        event.getTable().addPool(ChestLootHandler.getInjectPool((String)"simpleores", (String)file));
                        break;
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBiomeLoading(BiomeLoadingEvent evt) {
        if (!OreGeneration.checkAndInitBiome(evt)) {
            return;
        }
        if (evt.getCategory() == Biome.Category.NETHER) {
            OreGeneration.generateNetherOres(evt);
        } else {
            OreGeneration.generateOverworldOres(evt);
        }
    }
}

