/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.przemyk.simpleplanes.Config;
import xyz.przemyk.simpleplanes.entities.AbstractPlaneEntityType;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRegistries;
import xyz.przemyk.simpleplanes.setup.SimplePlanesSounds;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class PlaneEntity
extends Entity {
    protected static final DataParameter<Integer> FUEL = EntityDataManager.func_187226_a(PlaneEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> MOMENTUM = EntityDataManager.func_187226_a(PlaneEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final EntitySize FLYING_SIZE = EntitySize.func_220314_b((float)2.0f, (float)1.5f);
    public static final EntitySize FLYING_SIZE_EASY = EntitySize.func_220314_b((float)2.0f, (float)2.0f);
    public static final DataParameter<Integer> MOVEMENT_RIGHT = EntityDataManager.func_187226_a(PlaneEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<CompoundNBT> UPGRADES_NBT = EntityDataManager.func_187226_a(PlaneEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    public static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(-1.0, 0.0, -1.0, 1.0, 0.5, 1.0);
    public static final int MAX_PITCH = 20;
    private double lastYd;
    protected int poweredTicks;
    public boolean gravity = true;
    public HashMap<ResourceLocation, Upgrade> upgrades = new HashMap();
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;

    public PlaneEntity(EntityType<? extends PlaneEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public PlaneEntity(EntityType<? extends PlaneEntity> entityTypeIn, World worldIn, double x, double y, double z) {
        this(entityTypeIn, worldIn);
        this.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FUEL, (Object)0);
        this.field_70180_af.func_187214_a(MOMENTUM, (Object)0);
        this.field_70180_af.func_187214_a(MOVEMENT_RIGHT, (Object)0);
        this.field_70180_af.func_187214_a(UPGRADES_NBT, (Object)new CompoundNBT());
    }

    public void addFuel() {
        this.addFuel((Integer)Config.FLY_TICKS_PER_COAL.get());
    }

    public void addFuel(Integer fuel) {
        this.field_70180_af.func_187227_b(FUEL, (Object)Math.max(this.getFuel(), fuel));
    }

    public int getFuel() {
        return (Integer)this.field_70180_af.func_187225_a(FUEL);
    }

    public boolean isPowered() {
        return (Integer)this.field_70180_af.func_187225_a(FUEL) > 0 || this.isCreative();
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (this.tryToAddUpgrade(player, player.func_184586_b(hand))) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_225608_bj_() && player.func_184586_b(hand).func_190926_b()) {
            boolean hasplayer = false;
            for (Entity passenger : this.func_184188_bt()) {
                if (!(passenger instanceof PlayerEntity)) continue;
                hasplayer = true;
                break;
            }
            if (!hasplayer || ((Boolean)Config.THIEF.get()).booleanValue()) {
                this.func_184226_ay();
            }
            return ActionResultType.SUCCESS;
        }
        return !this.field_70170_p.field_72995_K && player.func_184220_m((Entity)this) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    public boolean tryToAddUpgrade(PlayerEntity player, ItemStack itemStack) {
        for (UpgradeType upgradeType : SimplePlanesRegistries.UPGRADE_TYPES.getValues()) {
            if (itemStack.func_77973_b() != upgradeType.getUpgradeItem() || !this.canAddUpgrade(upgradeType)) continue;
            if (!player.func_184812_l_()) {
                itemStack.func_190918_g(1);
            }
            this.upgrades.put(upgradeType.getRegistryName(), upgradeType.instanceSupplier.apply(this));
            this.upgradeChanged();
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!(source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d || !this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g))) {
            for (Upgrade upgrade : this.upgrades.values()) {
                this.func_199703_a((IItemProvider)upgrade.getType().getUpgradeItem());
            }
            this.dropItem();
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.func_70106_y();
            return true;
        }
        return false;
    }

    protected void dropItem() {
        this.func_199701_a_(new ItemStack((IItemProvider)((AbstractPlaneEntityType)this.func_200600_R()).dropItem));
    }

    public Vector2f getHorizontalFrontPos() {
        return new Vector2f(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))));
    }

    public EntitySize func_213305_a(Pose poseIn) {
        if (this.func_184179_bs() instanceof PlayerEntity) {
            return (Boolean)Config.EASY_FLIGHT.get() != false ? FLYING_SIZE_EASY : FLYING_SIZE;
        }
        return super.func_213305_a(poseIn);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isPowered()) {
            if (this.poweredTicks % 50 == 0) {
                this.func_184185_a((SoundEvent)SimplePlanesSounds.PLANE_LOOP.get(), 0.1f, 1.0f);
            }
            ++this.poweredTicks;
        } else {
            this.poweredTicks = 0;
        }
        this.tickLerp();
        Vector3d oldMotion = this.func_213322_ci();
        this.func_213323_x_();
        int fuel = (Integer)this.field_70180_af.func_187225_a(FUEL);
        int momentum = (Integer)this.field_70180_af.func_187225_a(MOMENTUM);
        if (fuel > 0) {
            this.field_70180_af.func_187227_b(FUEL, (Object)(--fuel));
        }
        if (this.field_70122_E) {
            momentum = 0;
            this.field_70180_af.func_187227_b(MOMENTUM, (Object)0);
        }
        this.gravity = true;
        LivingEntity controllingPassenger = (LivingEntity)this.func_184179_bs();
        if (controllingPassenger instanceof PlayerEntity) {
            Vector2f front;
            if (((Boolean)Config.EASY_FLIGHT.get()).booleanValue()) {
                this.field_70143_R = 0.0f;
                controllingPassenger.field_70143_R = 0.0f;
                if (this.isPowered() || momentum > 0 && controllingPassenger.field_191988_bg > 0.0f) {
                    this.gravity = false;
                    front = this.getHorizontalFrontPos();
                    float y = -0.005f;
                    float x = 0.02f;
                    if (controllingPassenger.field_191988_bg > 0.0f) {
                        y = 0.005f;
                        if (controllingPassenger.func_70051_ag() && fuel > 1) {
                            y *= 1.5f;
                            x *= 1.5f;
                            this.field_70180_af.func_187227_b(FUEL, (Object)(fuel - 1));
                        }
                    } else if (controllingPassenger.field_191988_bg < 0.0f) {
                        y = -0.02f;
                        if (this.field_70122_E || this.isAboveWater()) {
                            x = -x;
                        }
                    } else if (this.field_70122_E || this.field_70171_ac) {
                        x = 0.0f;
                    }
                    this.func_213317_d(this.func_213322_ci().func_72441_c((double)(x * front.field_189982_i), (double)y, (double)(x * front.field_189983_j)));
                }
            } else if ((this.isPowered() || momentum > 0) && controllingPassenger.field_191988_bg > 0.0f) {
                front = this.getHorizontalFrontPos();
                this.func_213317_d(this.func_213322_ci().func_72441_c((double)(0.02f * front.field_189982_i), (double)0.005f, (double)(0.02f * front.field_189983_j)));
                this.gravity = false;
            }
            if (this.isAboveWater() || this.field_70122_E) {
                this.field_70180_af.func_187227_b(MOMENTUM, (Object)0);
            }
            if (controllingPassenger.field_191988_bg == 0.0f) {
                this.field_70180_af.func_187227_b(MOMENTUM, (Object)Math.min(++momentum, 600));
            } else if (momentum > 0) {
                this.field_70180_af.func_187227_b(MOMENTUM, (Object)(--momentum));
            }
        }
        int movementRight = (Integer)this.field_70180_af.func_187225_a(MOVEMENT_RIGHT);
        if (controllingPassenger instanceof PlayerEntity) {
            if (controllingPassenger.field_70702_br > 0.0f) {
                if (movementRight < 10) {
                    this.field_70180_af.func_187227_b(MOVEMENT_RIGHT, (Object)(movementRight + 1));
                }
            } else if (controllingPassenger.field_70702_br < 0.0f) {
                if (movementRight > -10) {
                    this.field_70180_af.func_187227_b(MOVEMENT_RIGHT, (Object)(movementRight - 1));
                }
            } else if (movementRight > 0) {
                this.field_70180_af.func_187227_b(MOVEMENT_RIGHT, (Object)(movementRight - 1));
            } else if (movementRight < 0) {
                this.field_70180_af.func_187227_b(MOVEMENT_RIGHT, (Object)(movementRight + 1));
            }
            this.field_70177_z -= (float)(movementRight / 4);
            for (Entity passenger : this.func_184188_bt()) {
                passenger.field_70177_z -= (float)(movementRight / 4);
            }
            Vector3d motion = this.func_213322_ci();
            float d = PlaneEntity.getYaw(motion) - this.field_70177_z;
            if (d > 180.0f) {
                d -= 360.0f;
            }
            if (d < -180.0f) {
                d += 360.0f;
            }
            Vector3d vec = (d = Math.abs(d)) > 120.0f ? Vector3d.field_186680_a : this.getVec(this.field_70177_z, 0.0);
            vec = vec.func_186678_a(0.2);
            vec = this.getVec(PlaneEntity.getYaw(motion.func_178787_e(vec)), PlaneEntity.getPitch(motion));
            vec = vec.func_186678_a(motion.func_72433_c());
            this.func_213317_d(vec);
        }
        HashSet<Upgrade> upgradesToRemove = new HashSet<Upgrade>();
        for (Upgrade upgrade : this.upgrades.values()) {
            if (!upgrade.tick()) continue;
            upgradesToRemove.add(upgrade);
        }
        for (Upgrade upgrade : upgradesToRemove) {
            this.upgrades.remove(upgrade.getType().getRegistryName());
        }
        if (this.gravity && !this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        }
        if (this.isPowered() && this.field_70146_Z.nextInt(4) == 0 && !this.field_70170_p.field_72995_K) {
            this.spawnParticles(fuel);
        }
        double l = 0.02;
        if (oldMotion.func_72433_c() >= this.func_213322_ci().func_72433_c() && oldMotion.func_72433_c() < l) {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        if (!this.field_70122_E || PlaneEntity.func_213296_b((Vector3d)this.func_213322_ci()) > (double)1.0E-5f || (this.field_70173_aa + this.func_145782_y()) % 4 == 0) {
            if (this.func_213322_ci().func_72433_c() > 0.0) {
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            }
            float f = 0.98f;
            if (this.field_70122_E) {
                BlockPos pos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_());
                f = this.field_70170_p.func_180495_p(pos).getSlipperiness((IWorldReader)this.field_70170_p, pos, (Entity)this) * 0.98f;
                f = Math.max(f, 0.9f);
            }
            this.func_213317_d(this.func_213322_ci().func_216372_d((double)f, 0.98, (double)f));
            if (this.field_70122_E) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, -0.25, 1.0));
            }
        }
        float pitch = this.field_70122_E ? (this.isLarge() ? 10.0f : 15.0f) : Math.min(Math.max(PlaneEntity.getPitch(this.func_213322_ci()), -20.0f), 20.0f);
        this.field_70125_A = 0.95f * this.field_70125_A + 0.05f * pitch;
    }

    public static float getPitch(Vector3d motion) {
        double y = motion.field_72448_b;
        return (float)Math.toDegrees(Math.atan2(y, Math.sqrt(motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c)));
    }

    public static float getYaw(Vector3d motion) {
        return (float)Math.toDegrees(Math.atan2(-motion.field_72450_a, motion.field_72449_c));
    }

    public Vector3d getVec(double yaw, double pitch) {
        yaw = Math.toRadians(yaw);
        pitch = Math.toRadians(pitch);
        double xzLen = Math.cos(pitch);
        double x = -xzLen * Math.sin(yaw);
        double y = Math.sin(pitch);
        double z = xzLen * Math.cos(-yaw);
        return new Vector3d(x, y, z);
    }

    protected void spawnParticles(int fuel) {
        Vector2f front = this.getHorizontalFrontPos();
        ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
        serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197594_E, this.func_226277_ct_() - (double)front.field_189982_i, this.func_226278_cu_() + 1.0, this.func_226281_cx_() - (double)front.field_189983_j, 0, 0.0, 0.0, 0.0, 0.0);
        if (fuel > 4 && fuel < 100) {
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197594_E, this.func_226277_ct_() + (double)front.field_189982_i, this.func_226278_cu_() + 1.5, this.func_226281_cx_() + (double)front.field_189983_j, 5, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.field_70180_af.func_187227_b(FUEL, (Object)compound.func_74762_e("Fuel"));
        CompoundNBT upgradesNBT = compound.func_74775_l("upgrades");
        this.field_70180_af.func_187227_b(UPGRADES_NBT, (Object)upgradesNBT);
        this.deserializeUpgrades(upgradesNBT);
    }

    private void deserializeUpgrades(CompoundNBT upgradesNBT) {
        for (String key : upgradesNBT.func_150296_c()) {
            ResourceLocation resourceLocation = new ResourceLocation(key);
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.getValue(resourceLocation);
            if (upgradeType == null) continue;
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            upgrade.deserializeNBT(upgradesNBT.func_74775_l(key));
            this.upgrades.put(resourceLocation, upgrade);
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Fuel", ((Integer)this.field_70180_af.func_187225_a(FUEL)).intValue());
        compound.func_218657_a("upgrades", (INBT)this.getUpgradesNBT());
    }

    private CompoundNBT getUpgradesNBT() {
        CompoundNBT upgradesNBT = new CompoundNBT();
        for (Upgrade upgrade : this.upgrades.values()) {
            upgradesNBT.func_218657_a(upgrade.getType().getRegistryName().toString(), (INBT)upgrade.serializeNBT());
        }
        return upgradesNBT;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return true;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return this.upgrades.containsKey(SimplePlanesUpgrades.FLOATING.getId());
    }

    public boolean func_70067_L() {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return COLLISION_AABB.func_191194_a(this.func_213303_ch());
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return COLLISION_AABB.func_191194_a(this.func_213303_ch());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (UPGRADES_NBT.equals(key) && this.field_70170_p.func_201670_d()) {
            this.deserializeUpgrades((CompoundNBT)this.field_70180_af.func_187225_a(UPGRADES_NBT));
        }
    }

    public double func_70042_X() {
        return 0.375;
    }

    public boolean func_180431_b(DamageSource source) {
        if (source.func_76346_g() != null && source.func_76346_g().func_184223_x((Entity)this)) {
            return true;
        }
        return super.func_180431_b(source);
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (onGroundIn && !this.isCreative() && ((Boolean)Config.PLANE_CRUSH.get()).booleanValue()) {
            if (PlaneEntity.getPitch(this.func_213322_ci()) < -20.0f && this.lastYd < -0.5) {
                this.func_225503_b_(10.0f, 1.0f);
                if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                    if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                        this.dropItem();
                    }
                    this.func_70106_y();
                }
            }
            this.field_70143_R = 0.0f;
        }
        this.lastYd = this.func_213322_ci().field_72448_b;
    }

    public boolean isCreative() {
        return this.func_184179_bs() instanceof PlayerEntity && ((PlayerEntity)this.func_184179_bs()).func_184812_l_();
    }

    public boolean getOnGround() {
        return this.field_70122_E;
    }

    public boolean isAboveWater() {
        return this.field_70170_p.func_180495_p(new BlockPos(this.func_213303_ch().func_72441_c(0.0, 0.4, 0.0))).func_177230_c() == Blocks.field_150355_j;
    }

    public boolean canAddUpgrade(UpgradeType upgradeType) {
        return !this.upgrades.containsKey(upgradeType.getRegistryName()) && !upgradeType.occupyBackSeat && upgradeType.isPlaneApplicable.test(this);
    }

    public boolean isLarge() {
        return false;
    }

    public Vector3d func_230268_c_(LivingEntity livingEntity) {
        this.func_70634_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        Vector3d vector3d = PlaneEntity.func_233559_a_((double)(this.func_213311_cf() * MathHelper.field_180189_a), (double)livingEntity.func_213311_cf(), (float)this.field_70177_z);
        double d0 = this.func_226277_ct_() + vector3d.field_72450_a;
        double d1 = this.func_226281_cx_() + vector3d.field_72449_c;
        BlockPos blockpos = new BlockPos(d0, this.func_174813_aQ().field_72337_e, d1);
        BlockPos blockpos1 = blockpos.func_177977_b();
        if (!this.field_70170_p.func_201671_F(blockpos1)) {
            for (Pose pose : livingEntity.func_230297_ef_()) {
                Vector3d vector3d2;
                Vector3d vector3d1;
                AxisAlignedBB axisalignedbb = livingEntity.func_233648_f_(pose);
                double d2 = this.field_70170_p.func_234936_m_(blockpos);
                if (TransportationHelper.func_234630_a_((double)d2) && TransportationHelper.func_234631_a_((World)this.field_70170_p, (LivingEntity)livingEntity, (AxisAlignedBB)axisalignedbb.func_191194_a(vector3d1 = new Vector3d(d0, (double)blockpos.func_177956_o() + d2, d1)))) {
                    livingEntity.func_213301_b(pose);
                    return vector3d1;
                }
                double d3 = this.field_70170_p.func_234936_m_(blockpos1);
                if (!TransportationHelper.func_234630_a_((double)d3) || !TransportationHelper.func_234631_a_((World)this.field_70170_p, (LivingEntity)livingEntity, (AxisAlignedBB)axisalignedbb.func_191194_a(vector3d2 = new Vector3d(d0, (double)blockpos1.func_177956_o() + d3, d1)))) continue;
                livingEntity.func_213301_b(pose);
                return vector3d2;
            }
        }
        return super.func_230268_c_(livingEntity);
    }

    private void tickLerp() {
        if (this.func_184186_bw()) {
            this.lerpSteps = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.func_226277_ct_() + (this.lerpX - this.func_226277_ct_()) / (double)this.lerpSteps;
            double d1 = this.func_226278_cu_() + (this.lerpY - this.func_226278_cu_()) / (double)this.lerpSteps;
            double d2 = this.func_226281_cx_() + (this.lerpZ - this.func_226281_cx_()) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 10;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.func_70080_a(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYaw, (float)this.lerpPitch);
        }
    }

    public PlayerEntity getPlayer() {
        if (this.func_184179_bs() instanceof PlayerEntity) {
            return (PlayerEntity)this.func_184179_bs();
        }
        return null;
    }

    public void upgradeChanged() {
        this.field_70180_af.func_187227_b(UPGRADES_NBT, (Object)this.getUpgradesNBT());
    }
}

