/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.floating;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.floating.FloatingModel;
import xyz.przemyk.simpleplanes.upgrades.floating.LargeFloatingModel;

public class FloatingUpgrade
extends Upgrade {
    public static final ResourceLocation TEXTURE = new ResourceLocation("simpleplanes", "textures/plane_upgrades/floating.png");
    public static final ResourceLocation LARGE_TEXTURE = new ResourceLocation("simpleplanes", "textures/plane_upgrades/floating_large.png");

    public FloatingUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.FLOATING.get(), planeEntity);
    }

    @Override
    public boolean tick() {
        if (this.planeEntity.isAboveWater()) {
            Vector3d motion = this.planeEntity.func_213322_ci();
            if (motion.func_72433_c() < 0.01) {
                motion = Vector3d.field_186680_a;
            }
            this.planeEntity.func_213293_j(motion.field_72450_a * 0.9, Math.max(motion.field_72448_b, 0.0), motion.field_72449_c * 0.9);
            this.planeEntity.gravity = false;
            if (this.planeEntity.func_208600_a((ITag)FluidTags.field_206959_a) || this.planeEntity.func_226278_cu_() % 1.0 < 0.5) {
                this.planeEntity.func_213293_j(motion.field_72450_a * 0.9, Math.max(motion.field_72448_b, 0.01), motion.field_72449_c * 0.9);
            }
        }
        return false;
    }

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        if (this.planeEntity.isLarge()) {
            LargeFloatingModel.INSTANCE.func_225598_a_(matrixStack, buffer.getBuffer(LargeFloatingModel.INSTANCE.func_228282_a_(LARGE_TEXTURE)), packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            FloatingModel.INSTANCE.func_225598_a_(matrixStack, buffer.getBuffer(FloatingModel.INSTANCE.func_228282_a_(TEXTURE)), packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

