/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.shooter;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.AbstractFireballEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.shooter.IShooterBehavior;
import xyz.przemyk.simpleplanes.upgrades.shooter.ShooterModel;

public class ShooterUpgrade
extends Upgrade {
    public static final ResourceLocation TEXTURE = new ResourceLocation("simpleplanes", "textures/plane_upgrades/shooter.png");
    private static final Map<Item, IShooterBehavior> SHOOTER_BEHAVIOR_MAP = (Map)Util.func_200696_a((Object)new Object2ObjectOpenHashMap(), p_212564_0_ -> p_212564_0_.defaultReturnValue((Object)new IShooterBehavior(){

        @Override
        public void shoot(PlaneEntity planeEntity, ItemStack itemStack) {
        }
    }));
    private boolean shootSide = false;

    public ShooterUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.SHOOTER.get(), planeEntity);
    }

    @Override
    public boolean onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        ArrowEntity arrowentity;
        PlayerEntity player = event.getPlayer();
        ItemStack itemStack = player.func_184586_b(event.getHand());
        Vector3d motion = this.planeEntity.func_213322_ci();
        World world = event.getWorld();
        Random random = world.field_73012_v;
        Vector2f front = this.planeEntity.getHorizontalFrontPos();
        float pitch = PlaneEntity.getPitch(motion);
        motion = this.planeEntity.getVec(this.planeEntity.field_70177_z, pitch).func_186678_a(Math.max(0.25, motion.func_72433_c()));
        double x = this.planeEntity.func_226277_ct_() + (double)(1.0f * front.field_189982_i);
        double z = this.planeEntity.func_226281_cx_() + (double)(1.0f * front.field_189983_j);
        double y = this.planeEntity.func_226278_cu_() + 0.5;
        if (this.shootSide) {
            z += (double)(1.0f * front.field_189982_i);
            x += (double)(1.0f * front.field_189983_j);
        } else {
            z -= (double)(1.0f * front.field_189982_i);
            x -= (double)(1.0f * front.field_189983_j);
        }
        this.shootSide = !this.shootSide;
        Item item = itemStack.func_77973_b();
        if (item.equals(Items.field_196152_dE)) {
            this.shootSide = !this.shootSide;
            FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(world, itemStack, x, y, z, true);
            fireworkrocketentity.func_70186_c(-motion.field_72450_a, -motion.field_72448_b, -motion.field_72449_c, -((float)Math.max(0.5, motion.func_72433_c() * 1.5)), 1.0f);
            world.func_217376_c((Entity)fireworkrocketentity);
            if (!player.func_184812_l_()) {
                itemStack.func_190918_g(1);
            }
        }
        if (item.equals(Items.field_151059_bz)) {
            double d3 = random.nextGaussian() * 0.05 + 2.0 * motion.field_72450_a;
            double d4 = random.nextGaussian() * 0.05;
            double d5 = random.nextGaussian() * 0.05 + 2.0 * motion.field_72449_c;
            AbstractFireballEntity fireBallEntity = (AbstractFireballEntity)Util.func_200696_a((Object)new SmallFireballEntity(world, (LivingEntity)player, d3, d4, d5), p_229425_1_ -> p_229425_1_.func_213898_b(itemStack));
            fireBallEntity.func_226286_f_(x, y, z);
            fireBallEntity.func_213317_d(motion.func_186678_a(2.0));
            world.func_217376_c((Entity)fireBallEntity);
        }
        if (item.equals(Items.field_151032_g)) {
            arrowentity = new ArrowEntity(world, x, y, z);
            arrowentity.func_212361_a((Entity)player);
            arrowentity.func_213317_d(motion.func_186678_a(Math.max(motion.func_72433_c() * 1.5, 3.0) / motion.func_72433_c()));
            if (!player.func_184812_l_()) {
                itemStack.func_190918_g(1);
                arrowentity.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
            }
            world.func_217376_c((Entity)arrowentity);
        }
        if (item.equals(Items.field_185167_i)) {
            arrowentity = new ArrowEntity(world, x, y, z);
            arrowentity.func_212361_a((Entity)player);
            arrowentity.func_184555_a(itemStack);
            arrowentity.func_213317_d(motion.func_186678_a(Math.max(motion.func_72433_c() * 1.5, 3.0) / motion.func_72433_c()));
            if (!player.func_184812_l_()) {
                itemStack.func_190918_g(1);
                arrowentity.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
            }
            world.func_217376_c((Entity)arrowentity);
        }
        if (item.equals(Items.field_185166_h)) {
            arrowentity = new SpectralArrowEntity(world, x, y, z);
            arrowentity.func_212361_a((Entity)player);
            arrowentity.func_213317_d(motion.func_186678_a(Math.max(motion.func_72433_c() * 1.5, 3.0) / motion.func_72433_c()));
            if (!player.func_184812_l_()) {
                itemStack.func_190918_g(1);
                arrowentity.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
            }
            world.func_217376_c((Entity)arrowentity);
        }
        return false;
    }

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        IVertexBuilder ivertexbuilder = buffer.getBuffer(ShooterModel.INSTANCE.func_228282_a_(TEXTURE));
        ShooterModel.INSTANCE.func_225598_a_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

