/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.sprayer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.sprayer.LargeSprayerModel;
import xyz.przemyk.simpleplanes.upgrades.sprayer.SprayerModel;

public class SprayerUpgrade
extends Upgrade {
    public static final ResourceLocation TEXTURE = new ResourceLocation("simpleplanes", "textures/plane_upgrades/sprayer.png");
    public static final AxisAlignedBB AFFECT_ENTITIES = new AxisAlignedBB(-3.0, -3.0, -3.0, 3.0, 0.0, 3.0);
    private int fluid = 0;
    private Effect effect = null;

    public SprayerUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.SPRAYER.get(), planeEntity);
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74768_a("fluid", this.fluid);
        compoundNBT.func_74778_a("effect", this.effect == null ? "empty" : this.effect.getRegistryName().toString());
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundNBT compoundNBT) {
        this.fluid = compoundNBT.func_74762_e("fluid");
        String effectName = compoundNBT.func_74779_i("effect");
        this.effect = effectName.equals("empty") ? null : (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(effectName));
    }

    @Override
    public boolean tick() {
        if (this.fluid > 0) {
            --this.fluid;
            if (!this.planeEntity.field_70170_p.func_201670_d() && this.planeEntity.field_70173_aa % 5 == 0) {
                ((ServerWorld)this.planeEntity.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197613_f, this.planeEntity.func_226277_ct_() - (double)MathHelper.func_76126_a((float)((this.planeEntity.field_70177_z - 50.0f) * ((float)Math.PI / 180))), this.planeEntity.func_226278_cu_() + 0.5, this.planeEntity.func_226281_cx_() + (double)MathHelper.func_76134_b((float)((this.planeEntity.field_70177_z - 50.0f) * ((float)Math.PI / 180))), 0, 0.0, 0.0, 0.0, 0.0);
                ((ServerWorld)this.planeEntity.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197613_f, this.planeEntity.func_226277_ct_() - (double)MathHelper.func_76126_a((float)((this.planeEntity.field_70177_z + 50.0f) * ((float)Math.PI / 180))), this.planeEntity.func_226278_cu_() + 0.5, this.planeEntity.func_226281_cx_() + (double)MathHelper.func_76134_b((float)((this.planeEntity.field_70177_z + 50.0f) * ((float)Math.PI / 180))), 0, 0.0, 0.0, 0.0, 0.0);
                ((ServerWorld)this.planeEntity.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197613_f, this.planeEntity.func_226277_ct_() - (double)(2.0f * MathHelper.func_76126_a((float)((this.planeEntity.field_70177_z - 80.0f) * ((float)Math.PI / 180)))), this.planeEntity.func_226278_cu_() + 0.5, this.planeEntity.func_226281_cx_() + (double)(2.0f * MathHelper.func_76134_b((float)((this.planeEntity.field_70177_z - 80.0f) * ((float)Math.PI / 180)))), 0, 0.0, 0.0, 0.0, 0.0);
                ((ServerWorld)this.planeEntity.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197613_f, this.planeEntity.func_226277_ct_() - (double)(2.0f * MathHelper.func_76126_a((float)((this.planeEntity.field_70177_z + 80.0f) * ((float)Math.PI / 180)))), this.planeEntity.func_226278_cu_() + 0.5, this.planeEntity.func_226281_cx_() + (double)(2.0f * MathHelper.func_76134_b((float)((this.planeEntity.field_70177_z + 80.0f) * ((float)Math.PI / 180)))), 0, 0.0, 0.0, 0.0, 0.0);
                BlockPos.Mutable blockPos = new BlockPos.Mutable();
                blockPos.func_189532_c(this.planeEntity.func_226282_d_(3.0), this.planeEntity.func_226278_cu_(), this.planeEntity.func_226287_g_(3.0));
                for (int j = 0; j < 3; ++j) {
                    BlockState blockState = this.planeEntity.field_70170_p.func_180495_p((BlockPos)blockPos);
                    Block block = blockState.func_177230_c();
                    if (block instanceof IGrowable) {
                        ((IGrowable)block).func_225535_a_((ServerWorld)this.planeEntity.field_70170_p, this.planeEntity.field_70170_p.field_73012_v, (BlockPos)blockPos, blockState);
                        break;
                    }
                    blockPos.func_189536_c(Direction.DOWN);
                }
                if (this.effect != null) {
                    for (LivingEntity entity : this.planeEntity.field_70170_p.func_217357_a(LivingEntity.class, AFFECT_ENTITIES.func_191194_a(this.planeEntity.func_213303_ch()))) {
                        entity.func_195064_c(new EffectInstance(this.effect, 100));
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack itemStack = event.getPlayer().func_184586_b(event.getHand());
        if (itemStack.func_77973_b() == Items.field_151068_bn && this.fluid < 20) {
            this.planeEntity.upgradeChanged();
            this.fluid = 60;
            List effectInstances = PotionUtils.func_185189_a((ItemStack)itemStack);
            this.effect = effectInstances.size() == 0 ? null : ((EffectInstance)effectInstances.get(0)).func_188419_a();
            if (!event.getPlayer().func_184812_l_()) {
                event.getPlayer().func_184611_a(event.getHand(), new ItemStack((IItemProvider)Items.field_151069_bo));
            }
        }
        return false;
    }

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        IVertexBuilder ivertexbuilder = buffer.getBuffer(SprayerModel.INSTANCE.func_228282_a_(TEXTURE));
        if (this.planeEntity.isLarge()) {
            LargeSprayerModel.INSTANCE.func_225598_a_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            SprayerModel.INSTANCE.func_225598_a_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

