/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.sit;

import bl4ckscor3.mod.sit.SitEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class SitUtil {
    private static final Map<ResourceLocation, Map<BlockPos, Pair<SitEntity, BlockPos>>> OCCUPIED = new HashMap<ResourceLocation, Map<BlockPos, Pair<SitEntity, BlockPos>>>();

    public static boolean addSitEntity(Level level, BlockPos blockPos, SitEntity entity, BlockPos playerPos) {
        if (!level.f_46443_) {
            ResourceLocation id = SitUtil.getDimensionTypeId(level);
            if (!OCCUPIED.containsKey(id)) {
                OCCUPIED.put(id, new HashMap());
            }
            OCCUPIED.get(id).put(blockPos, (Pair<SitEntity, BlockPos>)Pair.of((Object)((Object)entity), (Object)playerPos));
            return true;
        }
        return false;
    }

    public static boolean removeSitEntity(Level level, BlockPos pos) {
        ResourceLocation id;
        if (!level.f_46443_ && OCCUPIED.containsKey(id = SitUtil.getDimensionTypeId(level))) {
            OCCUPIED.get(id).remove(pos);
            return true;
        }
        return false;
    }

    public static SitEntity getSitEntity(Level level, BlockPos pos) {
        ResourceLocation id;
        if (!level.f_46443_ && OCCUPIED.containsKey(id = SitUtil.getDimensionTypeId(level)) && OCCUPIED.get(id).containsKey(pos)) {
            return (SitEntity)((Object)OCCUPIED.get(id).get(pos).getLeft());
        }
        return null;
    }

    public static BlockPos getPreviousPlayerPosition(Player player, SitEntity sitEntity) {
        ResourceLocation id;
        if (!player.f_19853_.f_46443_ && OCCUPIED.containsKey(id = SitUtil.getDimensionTypeId(player.f_19853_))) {
            for (Pair<SitEntity, BlockPos> pair : OCCUPIED.get(id).values()) {
                if (pair.getLeft() != sitEntity) continue;
                return (BlockPos)pair.getRight();
            }
        }
        return null;
    }

    public static boolean isOccupied(Level level, BlockPos pos) {
        ResourceLocation id = SitUtil.getDimensionTypeId(level);
        return OCCUPIED.containsKey(id) && OCCUPIED.get(id).containsKey(pos);
    }

    public static boolean isPlayerSitting(Player player) {
        for (ResourceLocation i : OCCUPIED.keySet()) {
            for (Pair<SitEntity, BlockPos> pair : OCCUPIED.get(i).values()) {
                if (!((SitEntity)((Object)pair.getLeft())).m_20363_((Entity)player)) continue;
                return true;
            }
        }
        return false;
    }

    private static ResourceLocation getDimensionTypeId(Level level) {
        return level.m_46472_().m_135782_();
    }
}

