/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.sit;

import bl4ckscor3.mod.sit.Configuration;
import bl4ckscor3.mod.sit.SitEntity;
import bl4ckscor3.mod.sit.SitUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sit")
public class SitHandler {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block block;
        BlockState state;
        BlockPos pos;
        Level world;
        Player player = event.getEntity();
        if (!event.getLevel().f_46443_ && event.getFace() == Direction.UP && !SitUtil.isPlayerSitting(player) && !player.m_6144_() && SitHandler.isValidBlock(world = event.getLevel(), pos = event.getPos(), state = world.m_8055_(pos), block = world.m_8055_(pos).m_60734_()) && SitHandler.isPlayerInRange(player, pos) && !SitUtil.isOccupied(world, pos) && player.m_21205_().m_41619_() && world.m_8055_(pos.m_7494_()).m_60795_()) {
            if (block instanceof SlabBlock && (!state.m_61138_((Property)SlabBlock.f_56353_) || state.m_61143_((Property)SlabBlock.f_56353_) != SlabType.BOTTOM)) {
                return;
            }
            if (block instanceof StairBlock && (!state.m_61138_((Property)StairBlock.f_56842_) || state.m_61143_((Property)StairBlock.f_56842_) != Half.BOTTOM)) {
                return;
            }
            SitEntity sit = new SitEntity(world, pos);
            if (SitUtil.addSitEntity(world, pos, sit, player.m_20183_())) {
                world.m_7967_((Entity)sit);
                player.m_20329_((Entity)sit);
            }
        }
    }

    @SubscribeEvent
    public static void onBreak(BlockEvent.BreakEvent event) {
        SitEntity entity;
        if (!event.getLevel().m_5776_() && (entity = SitUtil.getSitEntity((Level)event.getLevel(), event.getPos())) != null) {
            SitUtil.removeSitEntity((Level)event.getLevel(), event.getPos());
            entity.m_20153_();
        }
    }

    private static boolean isValidBlock(Level world, BlockPos pos, BlockState state, Block block) {
        boolean isValid;
        boolean bl = isValid = block instanceof SlabBlock || block instanceof StairBlock || SitHandler.isModBlock(block);
        if (!isValid && block instanceof BedBlock && !((state = world.m_8055_(pos.m_121945_(state.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD ? ((Direction)state.m_61143_((Property)BedBlock.f_54117_)).m_122424_() : (Direction)state.m_61143_((Property)BedBlock.f_54117_)))).m_60734_() instanceof BedBlock)) {
            isValid = true;
        }
        return isValid;
    }

    private static boolean isModBlock(Block block) {
        return false;
    }

    private static boolean isPlayerInRange(Player player, BlockPos pos) {
        BlockPos playerPos = player.m_20183_();
        int blockReachDistance = (Integer)Configuration.CONFIG.blockReachDistance.get();
        if (blockReachDistance == 0) {
            return playerPos.m_123342_() - pos.m_123342_() <= 1 && playerPos.m_123341_() - pos.m_123341_() == 0 && playerPos.m_123343_() - pos.m_123343_() == 0;
        }
        pos = pos.m_7637_(0.5, 0.5, 0.5);
        AABB range = new AABB((double)(pos.m_123341_() + blockReachDistance), (double)(pos.m_123342_() + blockReachDistance), (double)(pos.m_123343_() + blockReachDistance), (double)(pos.m_123341_() - blockReachDistance), (double)(pos.m_123342_() - blockReachDistance), (double)(pos.m_123343_() - blockReachDistance));
        return range.f_82288_ <= (double)(playerPos = playerPos.m_7637_(0.5, 0.5, 0.5)).m_123341_() && range.f_82289_ <= (double)playerPos.m_123342_() && range.f_82290_ <= (double)playerPos.m_123343_() && range.f_82291_ >= (double)playerPos.m_123341_() && range.f_82292_ >= (double)playerPos.m_123342_() && range.f_82293_ >= (double)playerPos.m_123343_();
    }
}

