/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.sit;

import bl4ckscor3.mod.sit.SitEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class SitUtil {
    private static final Map<ResourceLocation, Map<BlockPos, Pair<SitEntity, BlockPos>>> OCCUPIED = new HashMap<ResourceLocation, Map<BlockPos, Pair<SitEntity, BlockPos>>>();

    public static boolean addSitEntity(World world, BlockPos blockPos, SitEntity entity, BlockPos playerPos) {
        if (!world.field_72995_K) {
            ResourceLocation id = SitUtil.getDimensionTypeId(world);
            if (!OCCUPIED.containsKey(id)) {
                OCCUPIED.put(id, new HashMap());
            }
            OCCUPIED.get(id).put(blockPos, (Pair<SitEntity, BlockPos>)Pair.of((Object)((Object)entity), (Object)playerPos));
            return true;
        }
        return false;
    }

    public static boolean removeSitEntity(World world, BlockPos pos) {
        ResourceLocation id;
        if (!world.field_72995_K && OCCUPIED.containsKey(id = SitUtil.getDimensionTypeId(world))) {
            OCCUPIED.get(id).remove(pos);
            return true;
        }
        return false;
    }

    public static SitEntity getSitEntity(World world, BlockPos pos) {
        ResourceLocation id;
        if (!world.field_72995_K && OCCUPIED.containsKey(id = SitUtil.getDimensionTypeId(world)) && OCCUPIED.get(id).containsKey(pos)) {
            return (SitEntity)((Object)OCCUPIED.get(id).get(pos).getLeft());
        }
        return null;
    }

    public static BlockPos getPreviousPlayerPosition(PlayerEntity player, SitEntity sitEntity) {
        ResourceLocation id;
        if (!player.field_70170_p.field_72995_K && OCCUPIED.containsKey(id = SitUtil.getDimensionTypeId(player.field_70170_p))) {
            for (Pair<SitEntity, BlockPos> pair : OCCUPIED.get(id).values()) {
                if (pair.getLeft() != sitEntity) continue;
                return (BlockPos)pair.getRight();
            }
        }
        return null;
    }

    public static boolean isOccupied(World world, BlockPos pos) {
        ResourceLocation id = SitUtil.getDimensionTypeId(world);
        return OCCUPIED.containsKey(id) && OCCUPIED.get(id).containsKey(pos);
    }

    public static boolean isPlayerSitting(PlayerEntity player) {
        for (ResourceLocation i : OCCUPIED.keySet()) {
            for (Pair<SitEntity, BlockPos> pair : OCCUPIED.get(i).values()) {
                if (!((SitEntity)((Object)pair.getLeft())).func_184196_w((Entity)player)) continue;
                return true;
            }
        }
        return false;
    }

    private static ResourceLocation getDimensionTypeId(World world) {
        return world.func_234922_V_().func_240901_a_();
    }
}

